/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.ssl;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.ssl.TeamCityTrustedSslCertificate;
import jetbrains.buildServer.util.FileUtil;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrustStoreIO {
    private static final Logger LOG = Logger.getInstance((String)TrustStoreIO.class.getName());
    private static final String STORE_TYPE = "JKS";
    public static final String ZERO_HASH = EncryptUtil.md5("");

    private TrustStoreIO() {
        throw new IllegalStateException();
    }

    @NotNull
    public static File[] certificateFiles(@NotNull String certDirectory) {
        File[] files;
        if (certDirectory == null) {
            TrustStoreIO.$$$reportNull$$$0(0);
        }
        File[] fileArray = (files = new File(certDirectory).listFiles()) == null ? new File[]{} : files;
        if (fileArray == null) {
            TrustStoreIO.$$$reportNull$$$0(1);
        }
        return fileArray;
    }

    @Nullable
    public static KeyStore readTrustStoreFromDirectory(@NotNull String certDirectory) {
        if (certDirectory == null) {
            TrustStoreIO.$$$reportNull$$$0(2);
        }
        TeamCityTrustedSslCertificate[] data = TrustStoreIO.certificatesData(certDirectory);
        try {
            return TrustStoreIO.constructFromData(data);
        }
        catch (Exception e) {
            LOG.warnAndDebugDetails("Can't generate trust store from directory " + certDirectory, (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static String pemContentFromDirectory(@NotNull String certDirectory) {
        if (certDirectory == null) {
            TrustStoreIO.$$$reportNull$$$0(3);
        }
        TeamCityTrustedSslCertificate[] data = TrustStoreIO.certificatesData(certDirectory);
        String string = TrustStoreIO.pemContentFromData(data);
        if (string == null) {
            TrustStoreIO.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static KeyStore constructTrustStoreFromData(@NotNull TeamCityTrustedSslCertificate[] data) {
        if (data == null) {
            TrustStoreIO.$$$reportNull$$$0(5);
        }
        try {
            return TrustStoreIO.constructFromData(data);
        }
        catch (Exception e) {
            LOG.warnAndDebugDetails("Can't construct trust store", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static KeyStore constructFromData(@NotNull TeamCityTrustedSslCertificate[] data) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        if (data == null) {
            TrustStoreIO.$$$reportNull$$$0(6);
        }
        if (data.length == 0) {
            return null;
        }
        KeyStore trustStore = KeyStore.getInstance(STORE_TYPE);
        trustStore.load(null, null);
        for (TeamCityTrustedSslCertificate dat : data) {
            String alias = dat.getName();
            try {
                Certificate cert = TrustStoreIO.parseCertificate(dat.getPemData());
                if (cert == null) continue;
                trustStore.setCertificateEntry(alias, cert);
            }
            catch (Exception e) {
                LOG.warnAndDebugDetails("Unable to parse the trusted certificate " + dat, (Throwable)e);
            }
        }
        return trustStore;
    }

    @NotNull
    private static String pemContentFromData(@NotNull TeamCityTrustedSslCertificate[] data) {
        if (data == null) {
            TrustStoreIO.$$$reportNull$$$0(7);
        }
        if (data.length == 0) {
            if ("" == null) {
                TrustStoreIO.$$$reportNull$$$0(8);
            }
            return "";
        }
        StringBuilder result = new StringBuilder();
        Base64 base64 = new Base64(64);
        for (TeamCityTrustedSslCertificate dat : data) {
            try {
                Certificate cert = TrustStoreIO.parseCertificate(dat.getPemData());
                if (cert == null) continue;
                result.append("-----BEGIN CERTIFICATE-----\n");
                result.append(base64.encodeAsString(cert.getEncoded()));
                result.append("-----END CERTIFICATE-----\n");
            }
            catch (Exception e) {
                LOG.warnAndDebugDetails("Unable to parse the trusted certificate " + dat, (Throwable)e);
            }
        }
        String string = result.toString();
        if (string == null) {
            TrustStoreIO.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String hash(@NotNull TeamCityTrustedSslCertificate[] data) {
        if (data == null) {
            TrustStoreIO.$$$reportNull$$$0(10);
        }
        if (data.length == 0) {
            String string = ZERO_HASH;
            if (string == null) {
                TrustStoreIO.$$$reportNull$$$0(11);
            }
            return string;
        }
        Arrays.sort(data, new Comparator<TeamCityTrustedSslCertificate>(){

            @Override
            public int compare(TeamCityTrustedSslCertificate t1, TeamCityTrustedSslCertificate t2) {
                return t1.compareTo(t2);
            }
        });
        StringBuilder string = new StringBuilder();
        for (TeamCityTrustedSslCertificate dat : data) {
            string.append(dat.getName()).append("|").append(EncryptUtil.toHex(dat.getPemData())).append("_");
        }
        String string2 = EncryptUtil.md5(string.toString());
        if (string2 == null) {
            TrustStoreIO.$$$reportNull$$$0(12);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Certificate parseCertificate(@NotNull byte[] data) throws CertificateException {
        ByteArrayInputStream is;
        block3: {
            Certificate certificate;
            if (data == null) {
                TrustStoreIO.$$$reportNull$$$0(13);
            }
            is = null;
            try {
                is = new ByteArrayInputStream(data);
                Collection<? extends Certificate> certificates = CertificateFactory.getInstance("X.509").generateCertificates(is);
                if (certificates == null || certificates.size() <= 0) break block3;
                certificate = certificates.iterator().next();
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                throw throwable;
            }
            FileUtil.close(is);
            return certificate;
        }
        FileUtil.close(is);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static TeamCityTrustedSslCertificate[] certificatesData(@NotNull String certDirectory) {
        File[] files;
        if (certDirectory == null) {
            TrustStoreIO.$$$reportNull$$$0(14);
        }
        if ((files = TrustStoreIO.certificateFiles(certDirectory)).length == 0) {
            TeamCityTrustedSslCertificate[] teamCityTrustedSslCertificateArray = new TeamCityTrustedSslCertificate[]{};
            if (teamCityTrustedSslCertificateArray == null) {
                TrustStoreIO.$$$reportNull$$$0(15);
            }
            return teamCityTrustedSslCertificateArray;
        }
        TeamCityTrustedSslCertificate[] result = new TeamCityTrustedSslCertificate[files.length];
        int i = 0;
        for (File file : files) {
            String alias = file.getName();
            FileInputStream is = null;
            ByteArrayOutputStream os = null;
            try {
                is = new FileInputStream(file);
                os = new ByteArrayOutputStream();
                FileUtil.copy(is, os);
                byte[] bytes = os.toByteArray();
                result[i++] = new TeamCityTrustedSslCertificate(alias, bytes);
            }
            catch (Exception e) {
                try {
                    LOG.info("Can't read trust certificate " + file);
                }
                catch (Throwable throwable) {
                    FileUtil.close(is);
                    FileUtil.close(os);
                    throw throwable;
                }
                FileUtil.close(is);
                FileUtil.close(os);
                continue;
            }
            FileUtil.close(is);
            FileUtil.close(os);
        }
        if (result == null) {
            TrustStoreIO.$$$reportNull$$$0(16);
        }
        return result;
    }

    public static String writeCertificate(@NotNull String alias, @NotNull byte[] data, @NotNull String certDirectory) {
        if (alias == null) {
            TrustStoreIO.$$$reportNull$$$0(17);
        }
        if (data == null) {
            TrustStoreIO.$$$reportNull$$$0(18);
        }
        if (certDirectory == null) {
            TrustStoreIO.$$$reportNull$$$0(19);
        }
        try {
            FileUtil.writeToFile((File)new File(certDirectory, alias), (byte[])data);
        }
        catch (IOException e) {
            LOG.warnAndDebugDetails("Unable to write the certificate file " + alias, (Throwable)e);
            return "Unable to save the certificate file " + alias + ": " + e.getMessage();
        }
        return null;
    }

    public static void removeCertificate(String alias, String certDirectory) {
        FileUtil.delete(new File(certDirectory, alias));
    }

    public static String isInvalidCertificate(@NotNull byte[] data) {
        if (data == null) {
            TrustStoreIO.$$$reportNull$$$0(20);
        }
        try {
            Certificate certificate = TrustStoreIO.parseCertificate(data);
            if (certificate == null) {
                return "The list of certificates is empty";
            }
        }
        catch (Exception e) {
            LOG.warnAndDebugDetails("Unable to parse the trusted certificate", (Throwable)e);
            return "Unable to parse the trusted certificate: " + e.getMessage();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certDirectory";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/ssl/TrustStoreIO";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/ssl/TrustStoreIO";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "certificateFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pemContentFromDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "pemContentFromData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "hash";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "certificatesData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "certificateFiles";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readTrustStoreFromDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pemContentFromDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "constructTrustStoreFromData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constructFromData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pemContentFromData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hash";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseCertificate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "certificatesData";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writeCertificate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidCertificate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

