/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.vcs.FileRule;
import jetbrains.buildServer.vcs.FileRuleSet;
import jetbrains.buildServer.vcs.IncludeRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckoutRules
extends FileRuleSet<IncludeRule, FileRule> {
    public static final CheckoutRules DEFAULT = new CheckoutRules("");
    public static final String INCLUDE_SEP = "=>";

    public CheckoutRules(@NotNull List<String> lines) {
        if (lines == null) {
            CheckoutRules.$$$reportNull$$$0(0);
        }
        super(lines);
    }

    public CheckoutRules(@NotNull String body) {
        if (body == null) {
            CheckoutRules.$$$reportNull$$$0(1);
        }
        super(body);
    }

    public CheckoutRules(@NotNull List<IncludeRule> includeRules, @NotNull List<FileRule> excludeRules) {
        if (includeRules == null) {
            CheckoutRules.$$$reportNull$$$0(2);
        }
        if (excludeRules == null) {
            CheckoutRules.$$$reportNull$$$0(3);
        }
        super(includeRules, excludeRules);
    }

    @NotNull
    public Collection<String> map(@NotNull Collection<String> paths) {
        if (paths == null) {
            CheckoutRules.$$$reportNull$$$0(4);
        }
        List<String> list = CollectionsUtil.convertAndFilterNulls(paths, new Converter<String, String>(){

            @Override
            public String createFrom(@NotNull String sourcePath) {
                if (sourcePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                return CheckoutRules.this.map(sourcePath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "jetbrains/buildServer/vcs/CheckoutRules$1", "createFrom"));
            }
        });
        if (list == null) {
            CheckoutRules.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public String map(String path) {
        IncludeRule rule;
        boolean includeAll = this.isIncludeAll();
        if (!includeAll && !this.shouldInclude(path)) {
            return null;
        }
        path = this.preparePath(path);
        if (this.isEmpty() || this.containsWildcards()) {
            return path;
        }
        IncludeRule includeRule = rule = includeAll ? (IncludeRule)this.getIncludeRules().get(0) : (IncludeRule)CheckoutRules.findMostSpecific(path, this.getIncludeRules());
        if (rule != null) {
            return rule.mapPreparedPath(path);
        }
        throw new RuntimeException("Cannot map file path '" + path + "; : include rule not found " + this.toString());
    }

    public boolean isIncludeAll() {
        List includeRules = this.getIncludeRules();
        List excludeRules = this.getExcludeRules();
        if (!excludeRules.isEmpty()) {
            return false;
        }
        for (IncludeRule include : includeRules) {
            if (include.getFrom().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean includesAny(@NotNull Collection<String> paths) {
        if (paths == null) {
            CheckoutRules.$$$reportNull$$$0(6);
        }
        if (this.isIncludeAll()) {
            return true;
        }
        if (this.containsWildcards()) {
            return true;
        }
        List includeRules = this.getIncludeRules();
        List<FileRule> excludeRules = this.getExcludeRules();
        for (String path : paths) {
            if (!this.shouldInclude(path, includeRules, excludeRules)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldInclude(String path) {
        return this.containsWildcards() || super.shouldInclude(path);
    }

    @Override
    public boolean shouldInclude(String path, Map<String, String> props) {
        return this.containsWildcards() || super.shouldInclude(path, props);
    }

    @Override
    protected boolean shouldInclude(String path, @NotNull Filter<FileRule> includeExcludeRulesFilter) {
        if (includeExcludeRulesFilter == null) {
            CheckoutRules.$$$reportNull$$$0(7);
        }
        return this.containsWildcards() || super.shouldInclude(path, includeExcludeRulesFilter);
    }

    @Override
    public boolean shouldInclude(String path, @NotNull IncludeRule rule) {
        if (rule == null) {
            CheckoutRules.$$$reportNull$$$0(8);
        }
        return this.containsWildcards() || super.shouldInclude(path, rule);
    }

    @NotNull
    public static CheckoutRules createCommonRule(@NotNull List<CheckoutRules> ruleses) {
        if (ruleses == null) {
            CheckoutRules.$$$reportNull$$$0(9);
        }
        HashSet<CheckoutRules> ruleSet = new HashSet<CheckoutRules>(ruleses);
        boolean ignoreCase = false;
        for (CheckoutRules rules : ruleSet) {
            ignoreCase = ignoreCase || rules.isIgnoreCase();
        }
        Collection<IncludeRule> includes = CheckoutRules.buildIncludeUnion(ruleSet);
        List<FileRule> excludes = CheckoutRules.buildExcludeIntersection(ruleSet);
        ArrayList<FileRule> allRules = new ArrayList<FileRule>();
        allRules.addAll(includes);
        allRules.addAll(excludes);
        CheckoutRules.sortByFrom(allRules, true);
        CheckoutRules.processIncludes(allRules);
        CheckoutRules.processExcludes(allRules);
        CheckoutRules.replaceIncludeToPart(allRules);
        CheckoutRules checkoutRules = new CheckoutRules(CheckoutRules.toRuleLines(allRules, ignoreCase));
        if (checkoutRules == null) {
            CheckoutRules.$$$reportNull$$$0(10);
        }
        return checkoutRules;
    }

    private static void replaceIncludeToPart(@NotNull List<FileRule> allRules) {
        if (allRules == null) {
            CheckoutRules.$$$reportNull$$$0(11);
        }
        for (int i = 0; i < allRules.size(); ++i) {
            FileRule rule = allRules.get(i);
            if (!(rule instanceof IncludeRule)) continue;
            IncludeRule includeRule = (IncludeRule)rule;
            IncludeRule newRule = new IncludeRule(includeRule.getFrom(), includeRule.getFrom(), (CheckoutRules)includeRule.getParentRules());
            allRules.set(i, newRule);
        }
    }

    private static void processExcludes(@NotNull List<FileRule> allRules) {
        if (allRules == null) {
            CheckoutRules.$$$reportNull$$$0(12);
        }
        String prevFrom = null;
        for (int i = 0; i < allRules.size(); ++i) {
            FileRule rule = allRules.get(i);
            if (rule == null) continue;
            if (rule.isIsInclude()) {
                prevFrom = null;
                continue;
            }
            if (prevFrom != null && CheckoutRules.isSubDir(prevFrom, rule.getFrom())) {
                allRules.set(i, null);
                continue;
            }
            prevFrom = rule.getFrom();
        }
    }

    private static void processIncludes(@NotNull List<FileRule> allRules) {
        if (allRules == null) {
            CheckoutRules.$$$reportNull$$$0(13);
        }
        String prevFrom = null;
        for (int i = allRules.size() - 1; i >= 0; --i) {
            FileRule rule = allRules.get(i);
            if (!(rule instanceof IncludeRule)) {
                prevFrom = null;
                continue;
            }
            if (prevFrom != null && CheckoutRules.isSubDir(rule.getFrom(), prevFrom)) {
                allRules.set(i, null);
                continue;
            }
            prevFrom = rule.getFrom();
        }
    }

    @NotNull
    private static List<FileRule> buildExcludeIntersection(@NotNull Collection<CheckoutRules> ruleses) {
        if (ruleses == null) {
            CheckoutRules.$$$reportNull$$$0(14);
        }
        LinkedHashMap<String, CheckoutRules> selectedPaths = new LinkedHashMap<String, CheckoutRules>();
        for (CheckoutRules rules : ruleses) {
            for (FileRule excludeRule : rules.getExcludeRules()) {
                String from = excludeRule.getFrom().trim();
                boolean included = true;
                for (CheckoutRules otherRules : ruleses) {
                    if (rules == otherRules || CheckoutRules.isSubDirInExcludes(from, otherRules)) continue;
                    included = false;
                    break;
                }
                if (included && !excludeRule.isRoot()) {
                    block3: for (CheckoutRules otherRules : ruleses) {
                        if (rules == otherRules) continue;
                        for (FileRule fr : otherRules.getIncludeRules()) {
                            if (fr.isRoot() || !CheckoutRules.isSubDir(from, fr.getFrom().trim())) continue;
                            included = false;
                            continue block3;
                        }
                    }
                }
                if (!included) continue;
                selectedPaths.put(from, rules);
            }
        }
        ArrayList<FileRule> result = new ArrayList<FileRule>();
        for (Map.Entry e : selectedPaths.entrySet()) {
            result.add(new FileRule<FileRuleSet>((String)e.getKey(), (FileRuleSet)e.getValue(), false));
        }
        ArrayList<FileRule> arrayList = result;
        if (arrayList == null) {
            CheckoutRules.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static boolean isSubDirInExcludes(@NotNull String path, @NotNull CheckoutRules parents) {
        List excludeRules;
        if (path == null) {
            CheckoutRules.$$$reportNull$$$0(16);
        }
        if (parents == null) {
            CheckoutRules.$$$reportNull$$$0(17);
        }
        if ((excludeRules = parents.getExcludeRules()).isEmpty()) {
            return false;
        }
        for (FileRule parent : excludeRules) {
            if (!CheckoutRules.isSubDir(path, parent.getFrom().trim())) continue;
            return true;
        }
        return false;
    }

    private static List<String> toRuleLines(@NotNull List<FileRule> rules, boolean ignoreCase) {
        if (rules == null) {
            CheckoutRules.$$$reportNull$$$0(18);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (ignoreCase) {
            result.add("##teamcity ignore-case");
        }
        for (FileRule rule : rules) {
            if (rule == null) continue;
            result.add(rule.toString());
        }
        return result;
    }

    @NotNull
    private static Collection<IncludeRule> buildIncludeUnion(@NotNull Collection<CheckoutRules> checkoutRuleses) {
        if (checkoutRuleses == null) {
            CheckoutRules.$$$reportNull$$$0(19);
        }
        LinkedHashSet<IncludeRule> result = new LinkedHashSet<IncludeRule>();
        for (CheckoutRules checkoutRules : checkoutRuleses) {
            result.addAll(checkoutRules.getIncludeRules());
        }
        LinkedHashSet<IncludeRule> linkedHashSet = result;
        if (linkedHashSet == null) {
            CheckoutRules.$$$reportNull$$$0(20);
        }
        return linkedHashSet;
    }

    @NotNull
    public String toString() {
        String string = this.asString();
        if (string == null) {
            CheckoutRules.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String getAsString() {
        StringBuilder result = new StringBuilder();
        for (String line : this.getBody()) {
            if (line.length() <= 0) continue;
            result.append(line);
            if (line.endsWith("\n")) continue;
            result.append('\n');
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) == '\n') {
            result.deleteCharAt(result.length() - 1);
        }
        String string = result.toString();
        if (string == null) {
            CheckoutRules.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private String asString() {
        StringBuilder result = new StringBuilder();
        if (this.isIgnoreCase()) {
            result.append("##teamcity ignore-case").append('\n');
        }
        for (IncludeRule includeRule : this.getIncludeRules()) {
            result.append(includeRule.toString()).append('\n');
        }
        for (FileRule excludeRule : this.getExcludeRules()) {
            result.append(excludeRule.toString()).append('\n');
        }
        String string = result.toString();
        if (string == null) {
            CheckoutRules.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static boolean isCorrect(@NotNull String line) {
        String trimmed;
        if (line == null) {
            CheckoutRules.$$$reportNull$$$0(24);
        }
        if ((trimmed = line.trim()).length() == 0) {
            return true;
        }
        if (trimmed.startsWith(":")) {
            return false;
        }
        if (trimmed.startsWith("-:") && line.contains(INCLUDE_SEP)) {
            return false;
        }
        return !trimmed.equals("+:") && !trimmed.equals("-:") && !trimmed.equals(INCLUDE_SEP);
    }

    public List<IncludeRule> getRootIncludeRules() {
        ArrayList<IncludeRule> result = new ArrayList<IncludeRule>(this.getIncludeRules());
        CheckoutRules.sortByFrom(result, false);
        HashSet<IncludeRule> processedRules = new HashSet<IncludeRule>();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            IncludeRule includeRule = (IncludeRule)iterator.next();
            if (!this.shouldInclude(includeRule.getFrom())) {
                iterator.remove();
                continue;
            }
            if (!StringUtil.isEmpty((String)includeRule.getTo()) && !includeRule.getTo().equals(includeRule.getFrom())) continue;
            for (IncludeRule processed : processedRules) {
                if (!CheckoutRules.isSubDir(includeRule.getFrom(), processed.getFrom())) continue;
                iterator.remove();
                break;
            }
            processedRules.add(includeRule);
        }
        return result;
    }

    @NotNull
    public CheckoutRules createNewRulesForPrefix(@NotNull String prefixPath) {
        if (prefixPath == null) {
            CheckoutRules.$$$reportNull$$$0(25);
        }
        if (prefixPath.length() == 0) {
            CheckoutRules checkoutRules = this;
            if (checkoutRules == null) {
                CheckoutRules.$$$reportNull$$$0(26);
            }
            return checkoutRules;
        }
        ArrayList<String> rules = new ArrayList<String>();
        for (IncludeRule includeRule : this.getIncludeRules()) {
            String to = includeRule.getTo();
            if (to.length() == 0) {
                to = ".";
            }
            if (includeRule.getFrom().length() == 0) {
                rules.add(prefixPath + INCLUDE_SEP + to);
                continue;
            }
            rules.add(prefixPath + "/" + includeRule.getFrom() + INCLUDE_SEP + to);
        }
        for (FileRule excludeRule : this.getExcludeRules()) {
            if (excludeRule.getFrom().length() == 0) {
                rules.add("-:" + prefixPath);
                continue;
            }
            rules.add("-:" + prefixPath + "/" + excludeRule.getFrom());
        }
        CheckoutRules checkoutRules = new CheckoutRules(rules);
        if (checkoutRules == null) {
            CheckoutRules.$$$reportNull$$$0(27);
        }
        return checkoutRules;
    }

    @Override
    protected void postProcessCreatedRules(List<IncludeRule> includeRules, List<FileRule> excludeRules) {
        super.postProcessCreatedRules(includeRules, excludeRules);
        for (IncludeRule includeRule : includeRules) {
            Iterator<FileRule> iterator = excludeRules.iterator();
            while (iterator.hasNext()) {
                FileRule excludeRule = iterator.next();
                if (!excludeRule.getFrom().equals(includeRule.getFrom())) continue;
                iterator.remove();
            }
        }
    }

    @Override
    protected void doPostInitProcess(@NotNull List<IncludeRule> includeRules, @NotNull List<FileRule> excludeRules) {
        if (includeRules == null) {
            CheckoutRules.$$$reportNull$$$0(28);
        }
        if (excludeRules == null) {
            CheckoutRules.$$$reportNull$$$0(29);
        }
        CheckoutRules.sortByFrom(includeRules, true);
        CheckoutRules.sortByFrom(excludeRules, true);
    }

    @Override
    protected IncludeRule createNewIncludeRule(String rule) {
        int sepIndex = rule.indexOf(INCLUDE_SEP);
        if (sepIndex < 0) {
            return new IncludeRule(rule, rule, this);
        }
        String from = rule.substring(0, sepIndex).trim();
        String to = rule.substring(sepIndex + INCLUDE_SEP.length()).trim();
        return new IncludeRule(from, to, this);
    }

    @Override
    protected FileRule createNewExcludeRule(String line) {
        return new FileRule<CheckoutRules>(line, this, false);
    }

    @Override
    protected IncludeRule createNewIncludeRule(IncludeRule includeRule) {
        return new IncludeRule(includeRule.getFrom(), includeRule.getTo(), this);
    }

    @Override
    protected FileRule createNewExcludeRule(FileRule rule) {
        return new FileRule<CheckoutRules>(rule.getFrom(), this, false);
    }

    public static CheckoutRules createOn(String ruleStr) {
        return StringUtil.isEmptyOrSpaces((String)ruleStr) ? DEFAULT : new CheckoutRules(ruleStr);
    }

    public boolean containsWildcards() {
        for (IncludeRule includeRule : this.getIncludeRules()) {
            if (includeRule.getFrom().contains("*")) {
                return true;
            }
            if (!includeRule.getTo().contains("*")) continue;
            return true;
        }
        for (FileRule fileRule : this.getExcludeRules()) {
            if (!fileRule.getFrom().contains("*")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 2: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeRules";
                break;
            }
            case 3: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeRules";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/CheckoutRules";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeExcludeRulesFilter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleses";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRules";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkoutRuleses";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/CheckoutRules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommonRule";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExcludeIntersection";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildIncludeUnion";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsString";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewRulesForPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "includesAny";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldInclude";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCommonRule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceIncludeToPart";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processExcludes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processIncludes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildExcludeIntersection";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSubDirInExcludes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "toRuleLines";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildIncludeUnion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isCorrect";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createNewRulesForPrefix";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doPostInitProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

