/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.IncludeRule;
import jetbrains.buildServer.vcs.VcsRootEntry;
import org.jetbrains.annotations.NotNull;

public class CheckoutRulesIntersectionCalculator {
    @NotNull
    private final Iterable<VcsRootEntry> myVcsRootEntries;

    public CheckoutRulesIntersectionCalculator(@NotNull Iterable<VcsRootEntry> vcsRootEntries) {
        if (vcsRootEntries == null) {
            CheckoutRulesIntersectionCalculator.$$$reportNull$$$0(0);
        }
        this.myVcsRootEntries = vcsRootEntries;
    }

    public boolean isIncludeRulesIntersect() {
        HashMap<Long, Set<IncludeRule>> includeRules = new HashMap<Long, Set<IncludeRule>>();
        for (VcsRootEntry entry : this.myVcsRootEntries) {
            CheckoutRules rules = entry.getCheckoutRules();
            for (IncludeRule rule : rules.getIncludeRules()) {
                HashSet<IncludeRule> vcsRootMappedPaths = (HashSet<IncludeRule>)includeRules.get(entry.getVcsRoot().getId());
                if (vcsRootMappedPaths == null) {
                    vcsRootMappedPaths = new HashSet<IncludeRule>();
                    includeRules.put(entry.getVcsRoot().getId(), vcsRootMappedPaths);
                }
                vcsRootMappedPaths.add(rule);
            }
        }
        return this.includeRulesIntersect(includeRules);
    }

    private boolean includeRulesIntersect(Map<Long, Set<IncludeRule>> includeRules) {
        for (Long vcsRootId : includeRules.keySet()) {
            Set<IncludeRule> currentRules = includeRules.get(vcsRootId);
            for (IncludeRule rule : currentRules) {
                if (!this.includeRuleIntersects(vcsRootId, rule, includeRules)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean includeRuleIntersects(Long vcsRootId, IncludeRule ruleToCheck, Map<Long, Set<IncludeRule>> includeRulesMap) {
        for (Map.Entry<Long, Set<IncludeRule>> entry : includeRulesMap.entrySet()) {
            if (entry.getKey().equals(vcsRootId)) continue;
            Set<IncludeRule> includeRules = entry.getValue();
            for (IncludeRule rule : includeRules) {
                if (!ruleToCheck.intersects(rule)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRootEntries", "jetbrains/buildServer/vcs/CheckoutRulesIntersectionCalculator", "<init>"));
    }
}

