/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStringUtil;
import jetbrains.buildServer.vcs.FileRuleSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRule<ParentRules extends FileRuleSet> {
    protected final String myFromPath;
    protected final String myFromFull;
    private final ParentRules myParentRules;
    private final boolean myUsePattern;
    private final boolean myAbsolute;
    private Pattern myPattern;
    private final boolean myIsInclude;
    private static final String STANDARD_TAIL = "(\\/.*)*";
    private Map<String, String> myAdditionalProperties;

    public FileRule(@NotNull String from, ParentRules parentRules, boolean isInclude) {
        if (from == null) {
            FileRule.$$$reportNull$$$0(0);
        }
        this(from, parentRules, isInclude, true);
    }

    public FileRule(@NotNull String from, ParentRules parentRules, boolean isInclude, boolean usePattern) {
        if (from == null) {
            FileRule.$$$reportNull$$$0(1);
        }
        this.myParentRules = parentRules;
        this.myIsInclude = isInclude;
        this.myFromFull = StringUtil.emptyIfNull(from);
        if (from.startsWith("+:") || from.startsWith("-:")) {
            from = from.substring(2);
        }
        if (from.contains(":")) {
            from = this.readAdditionalProperties(from).trim();
        }
        this.myAbsolute = from.startsWith("/");
        String fromPath = this.preparePathWithLowercase(from);
        if (fromPath.equals(this.myFromFull)) {
            fromPath = this.myFromFull;
        }
        this.myFromPath = StringUtil.emptyIfNull(fromPath);
        this.myUsePattern = usePattern;
    }

    public FileRule(@NotNull String fromPath, @Nullable String additionalProperties, ParentRules parentRules, boolean isInclude) {
        if (fromPath == null) {
            FileRule.$$$reportNull$$$0(2);
        }
        this.myParentRules = parentRules;
        this.myIsInclude = isInclude;
        this.myFromPath = this.preparePathWithLowercase(fromPath);
        this.myAbsolute = fromPath.trim().startsWith("/");
        this.myFromFull = fromPath + (additionalProperties == null ? "" : ":" + additionalProperties);
        this.myUsePattern = true;
    }

    @Nullable
    private Pattern compilePattern() {
        int regexpFlags;
        int n = regexpFlags = ((FileRuleSet)this.myParentRules).isIgnoreCase() ? 2 : 0;
        if (this.myFromPath.endsWith("*") || this.myFromPath.endsWith("**")) {
            return Pattern.compile(this.createPatternString(this.myFromPath), regexpFlags);
        }
        if (this.myFromPath.length() == 0) {
            return null;
        }
        return Pattern.compile(this.createPatternString(this.myFromPath) + STANDARD_TAIL, regexpFlags);
    }

    @Nullable
    protected Pattern getPattern() {
        if (!this.myUsePattern) {
            return null;
        }
        if (this.myPattern == null) {
            this.myPattern = this.compilePattern();
        }
        return this.myPattern;
    }

    @NotNull
    private String readAdditionalProperties(@NotNull String from) {
        if (from == null) {
            FileRule.$$$reportNull$$$0(3);
        }
        int lastSeparator = from.lastIndexOf(":");
        String properties = from.substring(0, lastSeparator);
        this.myAdditionalProperties = TCStringUtil.readProperties(properties, ";", "=");
        String string = this.myAdditionalProperties.size() > 0 ? from.substring(lastSeparator + 1) : from;
        if (string == null) {
            FileRule.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String createPatternString(@NotNull String from) {
        if (from == null) {
            FileRule.$$$reportNull$$$0(5);
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < from.length(); ++i) {
            char nextChar = from.charAt(i);
            if (nextChar == '\\') {
                result.append("\\/");
                continue;
            }
            if (nextChar == '?') {
                result.append(".");
                continue;
            }
            if (nextChar == '$' || nextChar == '(' || nextChar == '{' || nextChar == ')' || nextChar == '}' || nextChar == '[' || nextChar == ']' || nextChar == '/' || nextChar == '.' || nextChar == '+') {
                result.append("\\").append(nextChar);
                continue;
            }
            if (nextChar == '*') {
                if (i < from.length() - 1 && from.charAt(i + 1) == '*') {
                    result.append("(.*)");
                    ++i;
                    continue;
                }
                result.append("([^/]*)");
                continue;
            }
            result.append(nextChar);
        }
        String string = result.toString();
        if (string == null) {
            FileRule.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String getFrom() {
        return this.myFromPath;
    }

    public ParentRules getParentRules() {
        return this.myParentRules;
    }

    public boolean isIsInclude() {
        return this.myIsInclude;
    }

    public String toString() {
        if (this.myIsInclude) {
            return this.myFromFull;
        }
        return "-:" + this.myFromFull;
    }

    @Nullable
    public String getMatchedHead(@NotNull String path) {
        Pattern pattern;
        if (path == null) {
            FileRule.$$$reportNull$$$0(7);
        }
        if ((pattern = this.getPattern()) == null) {
            return "";
        }
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            int groupCount = matcher.groupCount();
            String lastGroup = matcher.group(groupCount);
            if (lastGroup != null) {
                return this.preparePathWithLowercase(path.substring(0, path.length() - lastGroup.length()));
            }
            return this.preparePathWithLowercase(path);
        }
        return null;
    }

    @Nullable
    public String getProperty(String propName) {
        if (this.myAdditionalProperties == null) {
            return null;
        }
        return this.myAdditionalProperties.get(propName);
    }

    public boolean propertiesMatch(Map<String, String> props) {
        if (this.myAdditionalProperties == null) {
            return true;
        }
        for (String name : this.myAdditionalProperties.keySet()) {
            String expectedProp = this.myAdditionalProperties.get(name);
            String actualProp = props.get(name);
            if (expectedProp == null || expectedProp.equals(actualProp)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Map<String, String> getAdditionalProperties() {
        return this.myAdditionalProperties;
    }

    public boolean isAbsolutePath() {
        return this.myAbsolute;
    }

    public boolean isRoot() {
        return StringUtil.isEmpty((String)this.myFromPath) && (this.myAdditionalProperties == null || this.myAdditionalProperties.isEmpty());
    }

    @NotNull
    protected String preparePathWithLowercase(@Nullable String path) {
        String string = this.preparePath(path, true);
        if (string == null) {
            FileRule.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    String preparePath(@Nullable String path, boolean lowerCaseIfNeeded) {
        ParentRules parentRules = this.getParentRules();
        String string = parentRules == null ? FileRule.prepareRulePath(path) : (lowerCaseIfNeeded ? ((FileRuleSet)parentRules).preparePathWithLowercase(path) : ((FileRuleSet)parentRules).preparePath(path));
        if (string == null) {
            FileRule.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String prepareRulePath(@Nullable String path) {
        if (path == null || path.length() == 0) {
            if ("" == null) {
                FileRule.$$$reportNull$$$0(10);
            }
            return "";
        }
        String string = FileUtil.normalizeRelativePath(path);
        if (string == null) {
            FileRule.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPath";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/FileRule";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/FileRule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readAdditionalProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePathWithLowercase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readAdditionalProperties";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPatternString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedHead";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

