/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.PropertiesUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.filters.FilterUtil;
import jetbrains.buildServer.vcs.FileRule;
import jetbrains.buildServer.vcs.IncludeRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileRuleSet<IncludeRuleClass extends FileRule, ExcludeRuleClass extends FileRule>
implements Loggable {
    public static final String INCLUDE_PREFIX = "+:";
    public static final String EXCLUDE_PREFIX = "-:";
    public static final String IGNORE_CASE_MARK = "##teamcity ignore-case";
    private final byte[] myLineMarkers;
    private final String[] myBody;
    private final ArrayList<IncludeRuleClass> myIncludeRules;
    private final ArrayList<ExcludeRuleClass> myExcludeRules;
    private final int myHashCode;
    private boolean myIgnoreCase;

    public FileRuleSet(@NotNull List<String> lines) {
        if (lines == null) {
            FileRuleSet.$$$reportNull$$$0(0);
        }
        List<String> preparedLines = this.removeEmptyLinesAndLineEndings(lines);
        this.myLineMarkers = new byte[preparedLines.size()];
        this.myBody = new String[preparedLines.size()];
        this.myHashCode = preparedLines.hashCode();
        this.myIncludeRules = new ArrayList(0);
        this.myExcludeRules = new ArrayList(0);
        this.init(preparedLines);
    }

    public FileRuleSet(@NotNull String body) {
        if (body == null) {
            FileRuleSet.$$$reportNull$$$0(1);
        }
        this(FileRuleSet.convertToLines(body));
    }

    @NotNull
    public static List<String> convertToLines(@NotNull String body) {
        if (body == null) {
            FileRuleSet.$$$reportNull$$$0(2);
        }
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> used = new HashSet<String>();
        for (String line : FileRuleSet.readLines(body)) {
            String trimmed = line.trim();
            if (trimmed.length() <= 0 || !used.add(trimmed)) continue;
            result.add(trimmed);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            FileRuleSet.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private List<String> removeEmptyLinesAndLineEndings(@NotNull List<String> lines) {
        if (lines == null) {
            FileRuleSet.$$$reportNull$$$0(4);
        }
        ArrayList<String> copy = new ArrayList<String>();
        HashSet<String> used = new HashSet<String>();
        for (String l : lines) {
            for (String prepared : StringUtil.split(l, true, '\n', '\r')) {
                if (!used.add(prepared)) continue;
                copy.add(prepared);
            }
        }
        ArrayList<String> arrayList = copy;
        if (arrayList == null) {
            FileRuleSet.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> readLines(@NotNull String body) {
        if (body == null) {
            FileRuleSet.$$$reportNull$$$0(6);
        }
        List<String> list = StringUtil.split(body, true, '\n', '\r');
        if (list == null) {
            FileRuleSet.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public String preparePath(@Nullable String path) {
        if (path == null || path.length() == 0) {
            if ("" == null) {
                FileRuleSet.$$$reportNull$$$0(8);
            }
            return "";
        }
        String string = FileUtil.normalizeRelativePath(path);
        if (string == null) {
            FileRuleSet.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    String preparePathWithLowercase(String path) {
        String string = this.lowercaseIfNeeded(this.preparePath(path));
        if (string == null) {
            FileRuleSet.$$$reportNull$$$0(10);
        }
        return string;
    }

    private void init(@NotNull List<String> lines) {
        if (lines == null) {
            FileRuleSet.$$$reportNull$$$0(11);
        }
        boolean hasExcludeAll = false;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.startsWith("#")) {
                this.myBody[i] = line;
                this.myLineMarkers[i] = 0;
                if (!line.startsWith(IGNORE_CASE_MARK)) continue;
                this.setIgnoreCase(true);
                continue;
            }
            if (line.startsWith(EXCLUDE_PREFIX)) {
                String excludeLine = line.substring(2);
                this.myLineMarkers[i] = 1;
                this.myBody[i] = excludeLine;
                String newExcludeRule = this.createNewExcludeRule((ExcludeRuleClass)excludeLine);
                this.myExcludeRules.add(newExcludeRule);
                if (!((FileRule)((Object)newExcludeRule)).isRoot()) continue;
                hasExcludeAll = true;
                continue;
            }
            String includeLine = line;
            if (includeLine.startsWith(INCLUDE_PREFIX)) {
                includeLine = includeLine.substring(2).trim();
                this.myLineMarkers[i] = 2;
            } else {
                this.myLineMarkers[i] = 0;
            }
            this.myBody[i] = includeLine;
            this.myIncludeRules.add(this.createNewIncludeRule((IncludeRuleClass)includeLine));
        }
        this.postProcessCreatedRules(this.myIncludeRules, this.myExcludeRules);
        if (this.myIncludeRules.isEmpty() && !hasExcludeAll) {
            this.myIncludeRules.add(this.createNewIncludeRule((IncludeRuleClass)""));
        }
        this.doPostInitProcess(this.myIncludeRules, this.myExcludeRules);
        this.myIncludeRules.trimToSize();
        this.myExcludeRules.trimToSize();
    }

    protected void postProcessCreatedRules(List<IncludeRuleClass> includeRules, List<ExcludeRuleClass> excludeRules) {
    }

    protected abstract void doPostInitProcess(@NotNull List<IncludeRuleClass> var1, @NotNull List<ExcludeRuleClass> var2);

    protected abstract IncludeRuleClass createNewIncludeRule(String var1);

    protected abstract ExcludeRuleClass createNewExcludeRule(String var1);

    protected static void sortByFrom(@NotNull List<? extends FileRule> rules, boolean reverse) {
        if (rules == null) {
            FileRuleSet.$$$reportNull$$$0(12);
        }
        int k = reverse ? -1 : 1;
        rules.sort((o1, o2) -> {
            int res = o1.getFrom().compareTo(o2.getFrom());
            if (res == 0) {
                return k * FileRuleSet.compareProperties(o1, o2);
            }
            return k * res;
        });
    }

    private static int compareProperties(FileRule o1, FileRule o2) {
        Map<String, String> props1 = o1.getAdditionalProperties();
        Map<String, String> props2 = o2.getAdditionalProperties();
        if (props1 == null && props2 == null) {
            return 0;
        }
        if (props1 == null) {
            return -1;
        }
        if (props2 == null) {
            return 1;
        }
        return PropertiesUtil.compareProperties(props1, props2);
    }

    @NotNull
    public List<IncludeRuleClass> getIncludeRules() {
        List<IncludeRuleClass> list = Collections.unmodifiableList(this.myIncludeRules);
        if (list == null) {
            FileRuleSet.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<ExcludeRuleClass> getExcludeRules() {
        List<ExcludeRuleClass> list = Collections.unmodifiableList(this.myExcludeRules);
        if (list == null) {
            FileRuleSet.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public List<String> getBody() {
        ArrayList<String> res = new ArrayList<String>();
        block5: for (int i = 0; i < this.myLineMarkers.length; ++i) {
            switch (this.myLineMarkers[i]) {
                case 0: {
                    res.add(this.myBody[i]);
                    continue block5;
                }
                case 1: {
                    if (this.myBody[i].startsWith(EXCLUDE_PREFIX)) {
                        res.add(this.myBody[i]);
                        continue block5;
                    }
                    res.add(EXCLUDE_PREFIX + this.myBody[i]);
                    continue block5;
                }
                case 2: {
                    if (this.myBody[i].startsWith(INCLUDE_PREFIX)) {
                        res.add(this.myBody[i]);
                        continue block5;
                    }
                    res.add(INCLUDE_PREFIX + this.myBody[i]);
                }
            }
        }
        ArrayList<String> arrayList = res;
        if (arrayList == null) {
            FileRuleSet.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public FileRuleSet(@NotNull List<IncludeRuleClass> includeRules, @NotNull List<ExcludeRuleClass> excludeRules) {
        if (includeRules == null) {
            FileRuleSet.$$$reportNull$$$0(16);
        }
        if (excludeRules == null) {
            FileRuleSet.$$$reportNull$$$0(17);
        }
        this.myIncludeRules = new ArrayList(includeRules.size());
        this.myExcludeRules = new ArrayList(excludeRules.size());
        for (FileRule includeRule : includeRules) {
            this.myIncludeRules.add(this.createNewIncludeRule(includeRule));
            this.myIgnoreCase |= includeRule.getParentRules() != null && ((FileRuleSet)includeRule.getParentRules()).isIgnoreCase();
        }
        for (FileRule excludeRule : excludeRules) {
            this.myExcludeRules.add(this.createNewExcludeRule(excludeRule));
        }
        FileRuleSet.sortByFrom(this.myIncludeRules, true);
        FileRuleSet.sortByFrom(this.myExcludeRules, true);
        int numLines = includeRules.size() + excludeRules.size() + (this.myIgnoreCase ? 1 : 0);
        this.myLineMarkers = new byte[numLines];
        this.myBody = new String[numLines];
        int pos = 0;
        if (this.myIgnoreCase) {
            this.myBody[pos++] = IGNORE_CASE_MARK;
        }
        for (FileRule includeRule : includeRules) {
            this.myBody[pos++] = includeRule.toString();
        }
        for (FileRule excludeRule : excludeRules) {
            this.myBody[pos++] = excludeRule.toString();
        }
        this.myHashCode = Arrays.asList(this.myBody).hashCode();
    }

    protected abstract IncludeRuleClass createNewIncludeRule(@NotNull IncludeRuleClass var1);

    protected abstract ExcludeRuleClass createNewExcludeRule(@NotNull ExcludeRuleClass var1);

    public boolean shouldInclude(String path, Map<String, String> props) {
        return this.shouldInclude(path, this.createPropertiesFilter(props));
    }

    protected boolean shouldInclude(String path, @NotNull Filter<FileRule> includeExcludeRulesFilter) {
        if (includeExcludeRulesFilter == null) {
            FileRuleSet.$$$reportNull$$$0(18);
        }
        return this.shouldInclude(path, this.getIncludeRules(includeExcludeRulesFilter), this.getExcludeRules(includeExcludeRulesFilter));
    }

    protected boolean shouldInclude(String path, @NotNull List<IncludeRuleClass> includeRules, @NotNull List<FileRule> excludeRules) {
        IncludeRuleClass inc;
        if (includeRules == null) {
            FileRuleSet.$$$reportNull$$$0(19);
        }
        if (excludeRules == null) {
            FileRuleSet.$$$reportNull$$$0(20);
        }
        if ((inc = FileRuleSet.findMostSpecific(path = this.preparePath(path), includeRules)) == null) {
            return false;
        }
        FileRule excl = FileRuleSet.findMostSpecific(path, excludeRules);
        if (excl == null) {
            return true;
        }
        String from1 = ((FileRule)inc).getMatchedHead(path);
        String from2 = excl.getMatchedHead(path);
        if (from1 == null || from2 == null) {
            return false;
        }
        if (from1.equals(from2)) {
            return FileRuleSet.compareProperties(inc, excl) > 0;
        }
        return FileRuleSet.isSubDir(from1, from2);
    }

    @NotNull
    protected List<FileRule> getExcludeRules(Filter<FileRule> filter) {
        List list = FilterUtil.filterCollection(new ArrayList<ExcludeRuleClass>(this.myExcludeRules), filter);
        if (list == null) {
            FileRuleSet.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    protected List<IncludeRuleClass> getIncludeRules(Filter<FileRule> filter) {
        List list = FilterUtil.filterCollection(new ArrayList<IncludeRuleClass>(this.myIncludeRules), filter);
        if (list == null) {
            FileRuleSet.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    protected Filter<FileRule> createPropertiesFilter(Map<String, String> props) {
        Filter<FileRule> filter = rule -> rule.propertiesMatch(props);
        if (filter == null) {
            FileRuleSet.$$$reportNull$$$0(23);
        }
        return filter;
    }

    public boolean shouldInclude(String path) {
        return this.shouldInclude(path, Collections.emptyMap());
    }

    public boolean shouldInclude(@Nullable String path, @NotNull IncludeRule rule) {
        IncludeRuleClass inc;
        if (rule == null) {
            FileRuleSet.$$$reportNull$$$0(24);
        }
        if ((inc = FileRuleSet.findMostSpecific(path = this.preparePath(path), this.getIncludeRules())) == null) {
            return false;
        }
        ExcludeRuleClass excl = FileRuleSet.findMostSpecific(path, this.getExcludeRules());
        return (excl == null || FileRuleSet.isSubDir(((FileRule)inc).getFrom(), ((FileRule)excl).getFrom())) && rule.equals(inc);
    }

    @Nullable
    public IncludeRuleClass getIncludeRuleFor(String path) {
        IncludeRuleClass inc = FileRuleSet.findMostSpecific(path = this.preparePathWithLowercase(path), this.getIncludeRules());
        if (inc == null) {
            return null;
        }
        ExcludeRuleClass excl = FileRuleSet.findMostSpecific(path, this.getExcludeRules());
        if (excl != null && !FileRuleSet.isSubDir(((FileRule)inc).getFrom(), ((FileRule)excl).getFrom())) {
            return null;
        }
        return inc;
    }

    private String lowercaseIfNeeded(@NotNull String s) {
        if (s == null) {
            FileRuleSet.$$$reportNull$$$0(25);
        }
        return this.myIgnoreCase ? s.toLowerCase() : s;
    }

    public boolean isUnder(String parentPath) {
        String path = StringUtil.removeLeadingAndTailingSlash(parentPath);
        List<IncludeRuleClass> includeRules = this.getIncludeRules();
        for (FileRule includeRule : includeRules) {
            if (FileRuleSet.isSubDir(includeRule.getFrom(), path)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubDir(String child, String parent) {
        return parent.equals(child) || parent.length() == 0 || child.startsWith(parent + "/");
    }

    @Nullable
    public IncludeRuleClass getIncludeRuleMerged() {
        List<IncludeRuleClass> rules = this.getIncludeRules();
        if (rules.size() == 0) {
            return null;
        }
        if (rules.size() == 1) {
            return (IncludeRuleClass)((FileRule)rules.get(0));
        }
        String commonPath = this.withSlash(((FileRule)rules.get(0)).getFrom());
        for (FileRule rule : rules) {
            commonPath = StringUtil.commonPrefix((String)commonPath, (String)this.withSlash(rule.getFrom()));
        }
        int lastSlash = commonPath.lastIndexOf(47);
        commonPath = lastSlash >= 0 ? commonPath.substring(0, lastSlash) : "";
        return (IncludeRuleClass)this.createNewIncludeRule((IncludeRuleClass)commonPath);
    }

    private String withSlash(String from) {
        if ("".equals(from) || from.endsWith("/")) {
            return from;
        }
        return from + "/";
    }

    @Nullable
    protected static <T extends FileRule> T findMostSpecific(String path, List<T> rules) {
        FileRule result = null;
        String resultFrom = "";
        for (FileRule rule : rules) {
            String from = rule.getMatchedHead(path);
            if (from == null) continue;
            if (result == null) {
                result = rule;
                resultFrom = from;
                continue;
            }
            if (resultFrom.length() >= from.length()) continue;
            result = rule;
            resultFrom = from;
        }
        return (T)result;
    }

    public boolean isIgnoreCase() {
        return this.myIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.myIgnoreCase = ignoreCase;
    }

    public boolean isEmpty() {
        return this.myBody.length == 0;
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        StringBuilder result = new StringBuilder();
        for (String line : this.getBody()) {
            result.append("; ").append(StringUtil.replaceNewLines(line, "//"));
        }
        int l = "; ".length();
        String string = result.length() > l ? result.substring(l) : result.toString();
        if (string == null) {
            FileRuleSet.$$$reportNull$$$0(26);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileRuleSet that = (FileRuleSet)o;
        if (!Arrays.equals(this.myLineMarkers, that.myLineMarkers)) {
            return false;
        }
        return Arrays.equals(this.myBody, that.myBody);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/FileRuleSet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeRules";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeRules";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeExcludeRulesFilter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/FileRuleSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToLines";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEmptyLinesAndLineEndings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readLines";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePathWithLowercase";
                break;
            }
            case 13: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeRules";
                break;
            }
            case 14: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRules";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertiesFilter";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertToLines";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyLinesAndLineEndings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readLines";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sortByFrom";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "shouldInclude";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lowercaseIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

