/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.FileRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeRule
extends FileRule<CheckoutRules> {
    private final String myTo;
    private final boolean myAbsolutePath;

    public IncludeRule(@NotNull String from, @NotNull String to, CheckoutRules parentRules) {
        if (from == null) {
            IncludeRule.$$$reportNull$$$0(0);
        }
        if (to == null) {
            IncludeRule.$$$reportNull$$$0(1);
        }
        super(from, parentRules, true, false);
        String toPath = this.preparePath(to, false);
        if (toPath.equals(this.myFromPath)) {
            toPath = this.myFromPath;
        }
        this.myTo = toPath;
        this.myAbsolutePath = to.startsWith("/");
    }

    public String getTo() {
        return this.myTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludeRule that = (IncludeRule)o;
        if (!this.myFromPath.equals(that.myFromPath)) {
            return false;
        }
        return this.myTo.equals(that.myTo);
    }

    public int hashCode() {
        int result = this.myFromPath.hashCode();
        result = 31 * result + this.myTo.hashCode();
        return result;
    }

    @Override
    @Nullable
    public String getMatchedHead(@Nullable String path) {
        String rulePath = this.preparePathWithLowercase(path);
        if (this.myFromPath.length() == 0 || rulePath.equals(this.myFromPath) || rulePath.startsWith(this.myFromPath + "/")) {
            return this.myFromPath;
        }
        return null;
    }

    public static IncludeRule createDefaultInstance() {
        return (IncludeRule)CheckoutRules.DEFAULT.getIncludeRules().get(0);
    }

    @Override
    public String toString() {
        String fromPath = this.getFrom();
        if (fromPath.length() > 0 && fromPath.charAt(0) == '#') {
            fromPath = "+:" + fromPath;
        }
        return fromPath + "=>" + this.getTo();
    }

    public String toDescriptiveString() {
        return (this.myFromFull.length() == 0 ? "." : this.myFromFull) + "=>" + (this.myTo.length() == 0 ? "." : this.myTo);
    }

    @Nullable
    public String map(String path) {
        return this.mapPreparedPath(this.preparePath(path, false));
    }

    @Nullable
    String mapPreparedPath(@NotNull String preparedPath) {
        if (preparedPath == null) {
            IncludeRule.$$$reportNull$$$0(2);
        }
        String to = IncludeRule.trimSlashes(this.getTo());
        String from = this.getMatchedHead(preparedPath);
        if (from == null) {
            return null;
        }
        from = IncludeRule.trimSlashes(from);
        String barePath = IncludeRule.trimSlashes(preparedPath.length() == from.length() ? "" : preparedPath.substring(from.length()));
        if (to.length() > 0) {
            if (barePath.length() > 0) {
                return to + "/" + barePath;
            }
            return to;
        }
        return barePath;
    }

    private static String trimSlashes(String string) {
        int start;
        if (string.length() == 0) {
            return string;
        }
        int end = string.length() - 1;
        for (start = 0; start < string.length() && string.charAt(start) == '/'; ++start) {
        }
        while (end >= start && string.charAt(end) == '/') {
            --end;
        }
        return string.substring(start, end + 1);
    }

    public String createFullPath(String relativeFileName) {
        if (this.myFromPath.length() == 0 || this.myFromPath.equals(".")) {
            return relativeFileName;
        }
        if (relativeFileName.length() == 0 || relativeFileName.equals(".")) {
            return this.myFromPath;
        }
        if (relativeFileName.startsWith("/") || relativeFileName.startsWith("\\")) {
            return this.myFromPath + relativeFileName;
        }
        return this.myFromPath + "/" + relativeFileName;
    }

    public boolean intersects(IncludeRule rule) {
        if (this.myTo.length() == 0 || rule.getTo().length() == 0) {
            return false;
        }
        return CheckoutRules.isSubDir(this.myTo, rule.getTo()) || CheckoutRules.isSubDir(rule.getTo(), this.myTo);
    }

    public boolean isAbsolutePathTo() {
        return this.myAbsolutePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preparedPath";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/vcs/IncludeRule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mapPreparedPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

