/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.vcs.AbstractPatchBuilder;
import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.IncludeRule;
import jetbrains.buildServer.vcs.patches.PatchBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchBuilderFileNamesCorrector
extends AbstractPatchBuilder {
    private final FilePathConverter myDefaultMode;
    private FilePathConverter myMode;
    private final PatchBuilder myOriginal;

    public PatchBuilderFileNamesCorrector(PatchBuilder original) {
        this.myMode = this.myDefaultMode = new FilePathConverter(){

            @Override
            public File convertRelativeFile(@NotNull File file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PatchBuilderFileNamesCorrector.this.getPathInCurrentWorkingDirectory(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector$1", "convertRelativeFile"));
            }
        };
        this.myOriginal = original;
    }

    @Override
    public void deleteFile(@NotNull File file, boolean deleteParentDirectoryIfEmpty) throws IOException {
        File converted;
        if (file == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(0);
        }
        if ((converted = this.myMode.convertRelativeFile(file)) != null) {
            this.myOriginal.deleteFile(converted, deleteParentDirectoryIfEmpty);
        }
    }

    @Override
    public void setLastModified(@NotNull File currentRelativeFile, long time) throws IOException {
        File converted;
        if (currentRelativeFile == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(1);
        }
        if ((converted = this.myMode.convertRelativeFile(currentRelativeFile)) != null) {
            this.myOriginal.setLastModified(converted, time);
        }
    }

    @Override
    public void deleteDirectory(@NotNull File file, boolean deleteParentDirectoryIfEmpty) throws IOException {
        File converted;
        if (file == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(2);
        }
        if ((converted = this.myMode.convertRelativeFile(file)) != null) {
            this.myOriginal.deleteDirectory(converted, deleteParentDirectoryIfEmpty);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void changeOrCreateTextFile(@NotNull File localFile, String fileMode, @NotNull InputStream input, long length, byte[] byArray) throws IOException {
        File converted;
        if (localFile == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(3);
        }
        if (input == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(4);
        }
        if ((converted = this.myMode.convertRelativeFile(localFile)) != null) {
            void lineSeparator;
            this.myOriginal.changeOrCreateTextFile(converted, fileMode, input, length, (byte[])lineSeparator);
        } else {
            TCStreamUtil.skip(input, length);
        }
    }

    @Override
    public void changeOrCreateBinaryFile(@NotNull File file, String fileMode, @NotNull InputStream input, long length) throws IOException {
        File converted;
        if (file == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(5);
        }
        if (input == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(6);
        }
        if ((converted = this.myMode.convertRelativeFile(file)) != null) {
            this.myOriginal.changeOrCreateBinaryFile(converted, fileMode, input, length);
        } else {
            TCStreamUtil.skip(input, length);
        }
    }

    @Override
    public void createDirectory(@NotNull File file) throws IOException {
        File converted;
        if (file == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(7);
        }
        if ((converted = this.myMode.convertRelativeFile(file)) != null) {
            this.myOriginal.createDirectory(converted);
        }
    }

    @Override
    public void createBinaryFile(@NotNull File file, String fileMode, @NotNull InputStream input, long length) throws IOException {
        File converted;
        if (file == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(8);
        }
        if (input == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(9);
        }
        if ((converted = this.myMode.convertRelativeFile(file)) != null) {
            this.myOriginal.createBinaryFile(converted, fileMode, input, length);
        } else {
            TCStreamUtil.skip(input, length);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createTextFile(@NotNull File file, String fileMode, @NotNull InputStream input, long length, byte[] byArray) throws IOException {
        File converted;
        if (file == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(10);
        }
        if (input == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(11);
        }
        if ((converted = this.myMode.convertRelativeFile(file)) != null) {
            void lineSeparator;
            this.myOriginal.createTextFile(converted, fileMode, input, length, (byte[])lineSeparator);
        } else {
            TCStreamUtil.skip(input, length);
        }
    }

    @Override
    public void renameFile(@NotNull File file, @NotNull File newFile, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(12);
        }
        if (newFile == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(13);
        }
        File converted = this.myMode.convertRelativeFile(file);
        File newFileConverted = this.myMode.convertRelativeFile(newFile);
        if (converted != null && newFileConverted == null) {
            this.myOriginal.deleteFile(converted, deleteParentDirectoryIfEmpty);
        } else if (converted != null) {
            this.myOriginal.renameFile(converted, newFileConverted, deleteParentDirectoryIfEmpty);
        }
    }

    @Override
    public void renameDirectory(@NotNull File file, @NotNull File newFile, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(14);
        }
        if (newFile == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(15);
        }
        File converted = this.myMode.convertRelativeFile(file);
        File newFileConverted = this.myMode.convertRelativeFile(newFile);
        if (converted != null && newFileConverted == null) {
            this.myOriginal.deleteDirectory(converted, deleteParentDirectoryIfEmpty);
        } else if (converted != null) {
            this.myOriginal.renameDirectory(converted, newFileConverted, deleteParentDirectoryIfEmpty);
        }
    }

    public void setWorkingMode_WithIncludeRule(final @NotNull IncludeRule includeRule) {
        if (includeRule == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(16);
        }
        this.myMode = new FilePathConverter(){

            @Override
            public File convertRelativeFile(@NotNull File file) {
                String fullPath;
                String resultPath;
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (resultPath = PatchBuilderFileNamesCorrector.convertRelativePath(fullPath = includeRule.createFullPath(PatchBuilderFileNamesCorrector.this.getPathInCurrentWorkingDirectory(file).getPath()), (CheckoutRules)includeRule.getParentRules())) == null ? null : new File(resultPath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector$2", "convertRelativeFile"));
            }
        };
    }

    public void setWorkingMode_WithCheckoutRules(final @NotNull CheckoutRules checkoutRules) {
        if (checkoutRules == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(17);
        }
        this.myMode = new FilePathConverter(){

            @Override
            public File convertRelativeFile(@NotNull File file) throws IOException {
                String pathname;
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (pathname = PatchBuilderFileNamesCorrector.convertRelativePath(PatchBuilderFileNamesCorrector.this.getPathInCurrentWorkingDirectory(file).getPath(), checkoutRules)) == null ? null : new File(pathname);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector$3", "convertRelativeFile"));
            }
        };
    }

    @Nullable
    private static String convertRelativePath(@NotNull String fullRepoPath, @NotNull CheckoutRules checkoutRules) {
        IncludeRule mostSpecRule;
        if (fullRepoPath == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(18);
        }
        if (checkoutRules == null) {
            PatchBuilderFileNamesCorrector.$$$reportNull$$$0(19);
        }
        if ((mostSpecRule = (IncludeRule)checkoutRules.getIncludeRuleFor(fullRepoPath)) == null) {
            return null;
        }
        return mostSpecRule.map(fullRepoPath);
    }

    public void setWorkingMode_Default() {
        this.myMode = this.myDefaultMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRelativeFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeRule";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkoutRules";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullRepoPath";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setLastModified";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "changeOrCreateTextFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "changeOrCreateBinaryFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createBinaryFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createTextFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "renameFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "renameDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "setWorkingMode_WithIncludeRule";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "setWorkingMode_WithCheckoutRules";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "convertRelativePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface FilePathConverter {
        @Nullable
        public File convertRelativeFile(@NotNull File var1) throws IOException;
    }
}

