/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.buildServer.util.StringPool;
import jetbrains.buildServer.vcs.VcsChangeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsChange
implements VcsChangeInfo {
    @Nullable
    private final String myChangeTypeName;
    @NotNull
    private final String myFileName;
    @NotNull
    private final String myRelativeFileName;
    @NotNull
    private final VcsChangeInfo.Type myType;
    @Nullable
    private final String myBeforeChangeRevisionNumber;
    @Nullable
    private final String myAfterChangeRevisionNumber;
    private boolean myFileNameIsTruncated;

    public VcsChange(@NotNull VcsChangeInfo.Type type, @Nullable String changeName, @NotNull String fileName, @NotNull String relativeFileName, @Nullable String beforeNum, @Nullable String afterNum) {
        if (type == null) {
            VcsChange.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            VcsChange.$$$reportNull$$$0(1);
        }
        if (relativeFileName == null) {
            VcsChange.$$$reportNull$$$0(2);
        }
        this.myFileNameIsTruncated = true;
        this.myChangeTypeName = changeName != null && !changeName.equals(type.getDescription()) ? changeName : null;
        this.myRelativeFileName = StringPool.reuse(relativeFileName);
        if (relativeFileName.length() > 0) {
            int pos = fileName.lastIndexOf(relativeFileName);
            if (pos == -1 || pos + relativeFileName.length() != fileName.length()) {
                this.myFileName = StringPool.reuse(fileName);
                this.myFileNameIsTruncated = false;
            } else if (pos == 0) {
                this.myFileName = this.myRelativeFileName;
                this.myFileNameIsTruncated = false;
            } else {
                this.myFileName = StringPool.reuse(fileName.substring(0, pos));
            }
        } else {
            this.myFileName = StringPool.reuse(fileName);
        }
        this.myType = type;
        this.myBeforeChangeRevisionNumber = beforeNum;
        this.myAfterChangeRevisionNumber = afterNum;
    }

    public VcsChange(@NotNull VcsChangeInfo.Type type, @NotNull String fileName, @NotNull String relativeFileName, @Nullable String beforeNum, @Nullable String afterNum) {
        if (type == null) {
            VcsChange.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            VcsChange.$$$reportNull$$$0(4);
        }
        if (relativeFileName == null) {
            VcsChange.$$$reportNull$$$0(5);
        }
        this(type, null, fileName, relativeFileName, beforeNum, afterNum);
    }

    protected VcsChange(@NotNull VcsChangeInfo source) {
        if (source == null) {
            VcsChange.$$$reportNull$$$0(6);
        }
        this(source.getType(), source.getChangeTypeName(), source.getFileName(), source.getRelativeFileName(), source.getBeforeChangeRevisionNumber(), source.getAfterChangeRevisionNumber());
    }

    public static List<VcsChange> createList(@Nullable Collection<? extends VcsChangeInfo> source) {
        if (source == null) {
            return null;
        }
        ArrayList<VcsChange> result = new ArrayList<VcsChange>();
        for (VcsChangeInfo vcsChangeInfo : source) {
            result.add(new VcsChange(vcsChangeInfo));
        }
        return result;
    }

    public static VcsChange forTest() {
        return new VcsChange(VcsChangeInfo.Type.CHANGED, "changed", "svn:/path/file.txt", "path/file.txt", "1", "2");
    }

    @Override
    @Nullable
    public String getChangeTypeName() {
        return this.myChangeTypeName == null ? this.myType.getDescription() : this.myChangeTypeName;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.myFileNameIsTruncated ? this.myFileName + this.getRelativeFileName() : this.myFileName;
        if (string == null) {
            VcsChange.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getRelativeFileName() {
        String string = this.myRelativeFileName;
        if (string == null) {
            VcsChange.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public VcsChangeInfo.Type getType() {
        VcsChangeInfo.Type type = this.myType;
        if (type == null) {
            VcsChange.$$$reportNull$$$0(9);
        }
        return type;
    }

    @Override
    @Nullable
    public String getBeforeChangeRevisionNumber() {
        return this.myBeforeChangeRevisionNumber;
    }

    @Override
    @Nullable
    public String getAfterChangeRevisionNumber() {
        return this.myAfterChangeRevisionNumber;
    }

    public int hashCode() {
        int result = this.myChangeTypeName != null ? this.myChangeTypeName.hashCode() : 0;
        result = 31 * result + this.myFileName.hashCode();
        result = 31 * result + this.myRelativeFileName.hashCode();
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + (this.myBeforeChangeRevisionNumber != null ? this.myBeforeChangeRevisionNumber.hashCode() : 0);
        result = 31 * result + (this.myAfterChangeRevisionNumber != null ? this.myAfterChangeRevisionNumber.hashCode() : 0);
        result = 31 * result + (this.myFileNameIsTruncated ? 0 : 1);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsChange vcsChange = (VcsChange)o;
        if (this.myFileNameIsTruncated == !vcsChange.myFileNameIsTruncated) {
            return false;
        }
        if (this.myAfterChangeRevisionNumber != null ? !this.myAfterChangeRevisionNumber.equals(vcsChange.myAfterChangeRevisionNumber) : vcsChange.myAfterChangeRevisionNumber != null) {
            return false;
        }
        if (this.myBeforeChangeRevisionNumber != null ? !this.myBeforeChangeRevisionNumber.equals(vcsChange.myBeforeChangeRevisionNumber) : vcsChange.myBeforeChangeRevisionNumber != null) {
            return false;
        }
        if (this.myChangeTypeName != null ? !this.myChangeTypeName.equals(vcsChange.myChangeTypeName) : vcsChange.myChangeTypeName != null) {
            return false;
        }
        if (!this.myFileName.equals(vcsChange.myFileName)) {
            return false;
        }
        if (!this.myRelativeFileName.equals(vcsChange.myRelativeFileName)) {
            return false;
        }
        return this.myType == vcsChange.myType;
    }

    public String toString() {
        return "VcsChange{myChangeTypeName='" + this.myChangeTypeName + '\'' + ", myFileName='" + this.myFileName + '\'' + ", myRelativeFileName=" + this.myRelativeFileName + ", myType=" + (Object)((Object)this.myType) + ", myBeforeChangeRevisionNumber='" + this.myBeforeChangeRevisionNumber + '\'' + ", myAfterChangeRevisionNumber='" + this.myAfterChangeRevisionNumber + '\'' + ", myFileNameIsTruncated=" + this.myFileNameIsTruncated + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/VcsChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/VcsChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeFileName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

