/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.IncludeRule;
import jetbrains.buildServer.vcs.VcsException;
import org.jetbrains.annotations.Nullable;

public class VcsIncludeRulesException
extends VcsException {
    private final Map<IncludeRule, VcsException> myBadRules = new HashMap<IncludeRule, VcsException>();

    public VcsIncludeRulesException(IncludeRule includeRule, VcsException e) {
        super(e);
        this.addProblem(includeRule, e);
    }

    public void addProblem(IncludeRule rule, VcsException e) {
        this.myBadRules.put(rule, e);
    }

    public Collection<IncludeRule> getBadIncludeRules() {
        return this.myBadRules.keySet();
    }

    @Nullable
    public VcsException getProblemFor(CheckoutRules rule) {
        Set<IncludeRule> badRules = this.myBadRules.keySet();
        for (IncludeRule includeRule : rule.getIncludeRules()) {
            for (IncludeRule badRule : badRules) {
                if (badRule.map(includeRule.getFrom()) == null) continue;
                return this.myBadRules.get(badRule);
            }
        }
        return null;
    }
}

