/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.util.Hash;
import jetbrains.buildServer.util.StringUtils;
import jetbrains.buildServer.vcs.Function;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.impl.VcsRootImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUtil {
    @NonNls
    public static final String VCS_NAME_PROP = "vcs";
    @NonNls
    public static final String VCS_ROOT_NAME_PROP = "teamcity:vcsRootName";
    @NonNls
    public static final String BRANCH_SPEC_PROP = "teamcity:branchSpec";
    @NonNls
    public static final String CHECKOUT_ROOT = "checkout-root";

    public static boolean areEquivalentRoots(@Nullable VcsRoot root1, @Nullable VcsRoot root2) {
        if (root1 == root2) {
            return true;
        }
        if (root1 == null || root2 == null) {
            return false;
        }
        if (!root1.getVcsName().equals(root2.getVcsName())) {
            return false;
        }
        return root1.getProperties().equals(root2.getProperties());
    }

    @NotNull
    public static Map<String, String> getVcsRootPublicProperties(@NotNull VcsRoot root) {
        if (root == null) {
            VcsUtil.$$$reportNull$$$0(0);
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, String> prop : root.getProperties().entrySet()) {
            String propName = prop.getKey();
            String propValue = prop.getValue();
            if (VcsUtil.isSecureProperty(propName)) continue;
            result.put(propName, propValue);
        }
        TreeMap<String, String> treeMap = result;
        if (treeMap == null) {
            VcsUtil.$$$reportNull$$$0(1);
        }
        return treeMap;
    }

    public static long getVcsRootPropertiesHash(@NotNull VcsRoot root) {
        if (root == null) {
            VcsUtil.$$$reportNull$$$0(2);
        }
        Map<String, String> propsCopy = root.getProperties();
        propsCopy.remove(VCS_NAME_PROP);
        propsCopy.remove(VCS_ROOT_NAME_PROP);
        propsCopy.remove(BRANCH_SPEC_PROP);
        return Hash.calc(VcsUtil.propertiesToString(propsCopy));
    }

    @NotNull
    public static String getVcsRootPropertiesAsPresentableString(@NotNull VcsRoot root) {
        if (root == null) {
            VcsUtil.$$$reportNull$$$0(3);
        }
        Map<String, String> properties = VcsUtil.createFullVcsPropertiesMap(root);
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(key);
            builder.append('=');
            if (VcsUtil.isSecureProperty(key)) {
                builder.append("*****");
            } else {
                builder.append(properties.get(key));
            }
            builder.append("; ");
        }
        String string = builder.toString();
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String convertVcsRootToString(@NotNull VcsRoot root) {
        if (root == null) {
            VcsUtil.$$$reportNull$$$0(5);
        }
        String string = VcsUtil.propertiesToStringSecure(VcsUtil.createFullVcsPropertiesMap(root));
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String convertVcsRootToString(@NotNull VcsRoot root, Function<String, String> encode) {
        if (root == null) {
            VcsUtil.$$$reportNull$$$0(7);
        }
        String string = VcsUtil.propertiesToStringSecure(VcsUtil.createFullVcsPropertiesMap(root), encode);
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static VcsRoot convertStringToVcsRoot(long id, @NotNull String string) {
        void serialized;
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(9);
        }
        VcsRootImpl vcsRootImpl = new VcsRootImpl(id, VcsUtil.stringToProperties((String)serialized));
        if (vcsRootImpl == null) {
            VcsUtil.$$$reportNull$$$0(10);
        }
        return vcsRootImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static VcsRoot convertStringToVcsRoot(long id, @NotNull String serialized, Function<String, String> function) {
        void decode;
        if (serialized == null) {
            VcsUtil.$$$reportNull$$$0(11);
        }
        VcsRootImpl vcsRootImpl = new VcsRootImpl(id, VcsUtil.stringToPropertiesSecure(serialized, (Function<String, String>)decode));
        if (vcsRootImpl == null) {
            VcsUtil.$$$reportNull$$$0(12);
        }
        return vcsRootImpl;
    }

    @NotNull
    private static Map<String, String> createFullVcsPropertiesMap(@NotNull VcsRoot root) {
        if (root == null) {
            VcsUtil.$$$reportNull$$$0(13);
        }
        TreeMap<String, String> properties = new TreeMap<String, String>(root.getProperties());
        properties.put(VCS_NAME_PROP, root.getVcsName());
        properties.put(VCS_ROOT_NAME_PROP, root.getName());
        TreeMap<String, String> treeMap = properties;
        if (treeMap == null) {
            VcsUtil.$$$reportNull$$$0(14);
        }
        return treeMap;
    }

    @NotNull
    public static String getSimplifiedName(@NotNull VcsRoot vcsRoot) {
        if (vcsRoot == null) {
            VcsUtil.$$$reportNull$$$0(15);
        }
        String string = StringUtils.replaceNonAlphaNumericChars(vcsRoot.getName(), '_');
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static boolean isSecureProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            VcsUtil.$$$reportNull$$$0(17);
        }
        return propertyName.startsWith("secure:");
    }

    @NotNull
    public static String propertiesToStringSecure(@NotNull Map<String, String> properties) {
        if (properties == null) {
            VcsUtil.$$$reportNull$$$0(18);
        }
        String string = VcsUtil.propertiesToStringSecure(properties, new Function<String, String>(){

            @Override
            public String apply(String s) {
                return EncryptUtil.scramble(s);
            }
        });
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String propertiesToString(@NotNull Map<String, String> properties, boolean scrambleSecureProps) {
        if (properties == null) {
            VcsUtil.$$$reportNull$$$0(20);
        }
        String string = scrambleSecureProps ? VcsUtil.propertiesToStringSecure(properties) : VcsUtil.propertiesToString(properties);
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String propertiesToString(@NotNull Map<String, String> properties) {
        if (properties == null) {
            VcsUtil.$$$reportNull$$$0(22);
        }
        String string = VcsUtil.propertiesToStringSecure(properties, new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s;
            }
        });
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    private static String escapeStr(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int finalCount = VcsUtil.calcFinalEscapedStringCount(str);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 45;
                continue;
            }
            if (c == '\\') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 92;
                continue;
            }
            if (c == '=') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 95;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(@NotNull String name) {
        if (name == null) {
            VcsUtil.$$$reportNull$$$0(24);
        }
        int result = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\n') {
                result += 2;
                continue;
            }
            if (c == '\\') {
                result += 2;
                continue;
            }
            if (c == '=') {
                result += 2;
                continue;
            }
            ++result;
        }
        return result;
    }

    @NotNull
    public static Map<String, String> stringToProperties(String string) {
        Map<String, String> map = VcsUtil.stringToPropertiesSecure(string, new Function<String, String>(){

            @Override
            public String apply(String s) {
                return EncryptUtil.unscramble(s);
            }
        });
        if (map == null) {
            VcsUtil.$$$reportNull$$$0(25);
        }
        return map;
    }

    @NotNull
    public static Map<String, String> stringToProperties(String string, boolean unscrambleSecureProps) {
        Map<String, String> map = unscrambleSecureProps ? VcsUtil.stringToProperties(string) : VcsUtil.stringToPropertiesAsIs(string);
        if (map == null) {
            VcsUtil.$$$reportNull$$$0(26);
        }
        return map;
    }

    @NotNull
    public static Map<String, String> stringToPropertiesAsIs(String string) {
        Map<String, String> map = VcsUtil.stringToPropertiesSecure(string, new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s;
            }
        });
        if (map == null) {
            VcsUtil.$$$reportNull$$$0(27);
        }
        return map;
    }

    @NotNull
    private static String propertiesToStringSecure(@NotNull Map<String, String> properties, Function<String, String> secure) {
        if (properties == null) {
            VcsUtil.$$$reportNull$$$0(28);
        }
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(VcsUtil.escapeStr(key));
            builder.append('=');
            String value = properties.get(key);
            if (VcsUtil.isSecureProperty(key)) {
                value = secure.apply(value);
            }
            builder.append(VcsUtil.escapeStr(value));
            builder.append('\n');
        }
        String string = builder.toString();
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static Map<String, String> stringToPropertiesSecure(String string, Function<String, String> decript) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(string, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            int sepIndex = s.indexOf(61);
            if (sepIndex < 0) continue;
            String propName = VcsUtil.unescapeStr(s.substring(0, sepIndex));
            String propValue = VcsUtil.unescapeStr(s.substring(sepIndex + 1));
            if (VcsUtil.isSecureProperty(propName)) {
                try {
                    propValue = decript.apply(propValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            result.put(propName, propValue);
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            VcsUtil.$$$reportNull$$$0(30);
        }
        return hashMap;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    private static String unescapeStr(@Nullable String name) {
        if (name == null) {
            return null;
        }
        int finalCount = VcsUtil.calcFinalUnescapedStringCount(name);
        int len = name.length();
        if (len == finalCount) {
            return name;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < len; ++i) {
            int c = name.charAt(i);
            if (c == 92 && i < len - 1) {
                char nextChar = name.charAt(i + 1);
                if (nextChar == '-') {
                    c = 10;
                    ++i;
                } else if (nextChar == '\\') {
                    c = 92;
                    ++i;
                } else if (nextChar == '_') {
                    c = 61;
                    ++i;
                }
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect unescaping for '" + name + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalUnescapedStringCount(@NotNull String name) {
        if (name == null) {
            VcsUtil.$$$reportNull$$$0(31);
        }
        int result = 0;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char nextChar;
            char c = name.charAt(i);
            if (c == '\\' && i < len - 1 && ((nextChar = name.charAt(i + 1)) == '-' || nextChar == '_' || nextChar == '\\')) {
                ++i;
            }
            ++result;
        }
        return result;
    }

    public static boolean isSet(@NotNull VcsRoot root, String propertyName) {
        if (root == null) {
            VcsUtil.$$$reportNull$$$0(32);
        }
        return Boolean.parseBoolean(root.getProperty(propertyName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/VcsUtil";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/VcsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsRootPublicProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsRootPropertiesAsPresentableString";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertVcsRootToString";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertStringToVcsRoot";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFullVcsPropertiesMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimplifiedName";
                break;
            }
            case 19: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "propertiesToStringSecure";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "propertiesToString";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "stringToProperties";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "stringToPropertiesAsIs";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "stringToPropertiesSecure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootPublicProperties";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootPropertiesHash";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootPropertiesAsPresentableString";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertVcsRootToString";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertStringToVcsRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFullVcsPropertiesMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSimplifiedName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSecureProperty";
                break;
            }
            case 18: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "propertiesToStringSecure";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "propertiesToString";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calcFinalEscapedStringCount";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "calcFinalUnescapedStringCount";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

