/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VcsRootImpl
implements VcsRoot {
    public static final String UNKNOWN_ROOT_NAME = "unknown";
    private final long myId;
    private volatile String myName;
    private volatile String myVcsName;
    private final AtomicReference<Map<String, String>> myPropertiesRef;
    @Deprecated
    @NonNls
    public static final String VCS_NAME_PROP = "vcs";
    @Deprecated
    @NonNls
    public static final String VCS_ROOT_NAME_PROP = "teamcity:vcsRootName";
    @Deprecated
    @NonNls
    public static final String BRANCH_SPEC_PROP = "teamcity:branchSpec";
    @Deprecated
    @NonNls
    protected static final String CHECKOUT_ROOT = "checkout-root";

    /*
     * WARNING - void declaration
     */
    public VcsRootImpl(long id, @NotNull String vcsName, @NotNull Map<String, String> map) {
        void properties;
        if (vcsName == null) {
            VcsRootImpl.$$$reportNull$$$0(0);
        }
        if (map == null) {
            VcsRootImpl.$$$reportNull$$$0(1);
        }
        this.myPropertiesRef = new AtomicReference();
        this.myId = id;
        this.myVcsName = vcsName;
        this.myName = (String)properties.get(VCS_ROOT_NAME_PROP);
        if (this.myName == null) {
            this.myName = UNKNOWN_ROOT_NAME;
        }
        HashMap<String, String> propsCopy = new HashMap<String, String>((Map<String, String>)properties);
        propsCopy.remove(CHECKOUT_ROOT);
        propsCopy.remove(VCS_ROOT_NAME_PROP);
        propsCopy.remove(VCS_NAME_PROP);
        this.doSetProperties(propsCopy);
    }

    public VcsRootImpl(long id, String vcsName) {
        this(id, vcsName, Collections.emptyMap());
        this.myName = UNKNOWN_ROOT_NAME;
    }

    public VcsRootImpl(long id, Map<String, String> properties) {
        this(id, properties.get(VCS_NAME_PROP) == null ? UNKNOWN_ROOT_NAME : properties.get(VCS_NAME_PROP), properties);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            VcsRootImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public long getId() {
        return this.myId;
    }

    public void addProperty(String propertyName, String propertyValue) {
        if (propertyName == null) {
            return;
        }
        Map<String, String> origMap = this.myPropertiesRef.get();
        HashMap<String, String> newMap = new HashMap<String, String>(origMap);
        if (propertyValue != null) {
            newMap.put(propertyName, propertyValue);
        } else {
            newMap.remove(propertyName);
        }
        if (!this.myPropertiesRef.compareAndSet(origMap, newMap)) {
            this.addProperty(propertyName, propertyValue);
        }
    }

    public void setProperties(@NotNull Map<String, String> map) {
        if (map == null) {
            VcsRootImpl.$$$reportNull$$$0(3);
        }
        this.doSetProperties(map);
    }

    private void doSetProperties(Map<String, String> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (e.getValue() == null) continue;
            newMap.put(e.getKey(), e.getValue());
        }
        this.myPropertiesRef.set(newMap);
    }

    @Override
    @NotNull
    public String getVcsName() {
        String string = this.myVcsName;
        if (string == null) {
            VcsRootImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public String getProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            VcsRootImpl.$$$reportNull$$$0(5);
        }
        return this.myPropertiesRef.get().get(propertyName);
    }

    @Override
    public String getProperty(@NotNull String propertyName, String defaultValue) {
        String result;
        if (propertyName == null) {
            VcsRootImpl.$$$reportNull$$$0(6);
        }
        if ((result = this.getProperty(propertyName)) == null) {
            return defaultValue;
        }
        return result;
    }

    @Override
    @NotNull
    public Map<String, String> getProperties() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(this.myPropertiesRef.get());
        if (treeMap == null) {
            VcsRootImpl.$$$reportNull$$$0(7);
        }
        return treeMap;
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        String basicDescriptionStart = "\"" + this.getName() + "\" {internal id=" + this.getId();
        if (verbose) {
            String string = basicDescriptionStart + ", properties: [" + VcsUtil.getVcsRootPropertiesAsPresentableString(this) + "]}";
            if (string == null) {
                VcsRootImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = basicDescriptionStart + "}";
        if (string == null) {
            VcsRootImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            VcsRootImpl.$$$reportNull$$$0(10);
        }
        this.myName = name;
    }

    public void setVcsName(@NotNull String vcsName) {
        if (vcsName == null) {
            VcsRootImpl.$$$reportNull$$$0(11);
        }
        this.myVcsName = vcsName;
    }

    @Deprecated
    public static boolean isEquivalentRoots(VcsRoot root1, VcsRoot root2) {
        return VcsUtil.areEquivalentRoots(root1, root2);
    }

    public String toString() {
        return this.getName() + " {internal id=" + this.getId() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRootImpl vcsRoot = (VcsRootImpl)o;
        return this.myId == vcsRoot.myId;
    }

    public int hashCode() {
        return (int)(this.myId ^ this.myId >>> 32);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/impl/VcsRootImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/impl/VcsRootImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setVcsName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

