/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.version;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import jetbrains.buildServer.DevelopmentMode;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.version.ServerVersionInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ServerVersionHolder {
    @NonNls
    private static final String SERVER_VERSION_PROPERTIES_DIST_XML = "serverVersion.properties-dist.xml";
    @NonNls
    private static final String SERVER_VERSION_PROPERTIES_XML = "serverVersion.properties.xml";
    @NonNls
    private static final String FULL_VERSION_FOR_PLUGIN = "Server_Version";
    @NonNls
    private static final String DISPLAY_VERSION = "Display_Version";
    @NonNls
    private static final String BUILD_NUMBER = "Build_Number";
    @NonNls
    private static final String BUILD_DATE = "Build_Date";
    @NonNls
    private static final String PROJECT_CONFIG_VERSION = "Project_Config_Version";
    @NonNls
    private static final String DISPLAY_VERSION_MAJOR = "Display_Version_Major";
    @NonNls
    private static final String DISPLAY_VERSION_MINOR = "Display_Version_Minor";
    private static final String BUILD_DATE_FORMAT = "dd/MM/yyyy";
    private static ServerVersionInfo ourInstance = null;

    @NotNull
    public static ServerVersionInfo getVersion() {
        if (ourInstance == null) {
            ClassLoader loader = ServerVersionHolder.class.getClassLoader();
            try {
                InputStream stream = loader.getResourceAsStream(SERVER_VERSION_PROPERTIES_XML);
                if (stream == null) {
                    stream = loader.getResourceAsStream(SERVER_VERSION_PROPERTIES_DIST_XML);
                }
                ourInstance = ServerVersionHolder.loadDataFromStream(stream);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ServerVersionInfo serverVersionInfo = ourInstance;
        if (serverVersionInfo == null) {
            ServerVersionHolder.$$$reportNull$$$0(0);
        }
        return serverVersionInfo;
    }

    private ServerVersionHolder() {
    }

    private static ServerVersionInfo fromProperties(@NotNull Properties properties) {
        if (properties == null) {
            ServerVersionHolder.$$$reportNull$$$0(1);
        }
        String protocol = properties.getProperty(FULL_VERSION_FOR_PLUGIN, "NA");
        String display = properties.getProperty(DISPLAY_VERSION, "NA");
        String build = properties.getProperty(BUILD_NUMBER, "NA");
        String projectConfigVersion = properties.getProperty(PROJECT_CONFIG_VERSION, "NA");
        Date buildDate = null;
        String buildDateStr = properties.getProperty(BUILD_DATE);
        if (buildDateStr != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(BUILD_DATE_FORMAT);
            buildDate = sdf.parse(buildDateStr, new ParsePosition(0));
        }
        if (buildDate == null) {
            if (!DevelopmentMode.isEnabled && !LogInitializer.isUnitTest()) {
                throw new RuntimeException("Failed to load build date from serverVersion.properties.xml file, BUILD_DATE=" + buildDateStr);
            }
            buildDate = new Date();
        }
        buildDate = Dates.truncateTime(buildDate);
        int major = Integer.valueOf(properties.getProperty(DISPLAY_VERSION_MAJOR, "0"));
        int minor = Integer.valueOf(properties.getProperty(DISPLAY_VERSION_MINOR, "0"));
        return new ServerVersionInfo(protocol, display, projectConfigVersion, build, buildDate, major, minor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerVersionInfo loadDataFromStream(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null stream");
        }
        try {
            Properties props = new Properties();
            props.loadFromXML(stream);
            ServerVersionInfo serverVersionInfo = ServerVersionHolder.fromProperties(props);
            return serverVersionInfo;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/version/ServerVersionHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/version/ServerVersionHolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

