/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xmlrpc.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.Vector;
import jetbrains.buildServer.xmlrpc.AbstractXmlRpcTarget;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;
import jetbrains.buildServer.xmlrpc.impl.MyXmlRpcTransport;
import jetbrains.buildServer.xmlrpc.ssl.SSLContextUtil;
import jetbrains.buildServer.xmlrpc.ssl.UserSecureProtocolSocketFactory;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.TCXmlRpcClient;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcTransport;

public class CommonsXmlRpcTargetImpl
extends AbstractXmlRpcTarget {
    protected final URL myServerRpcURL;
    private final int myConnectionTimeout;
    private final Object mySingleExecuteLock = new Object();
    private MyXmlRpcTransport myTransport;
    protected HttpState myState;
    private ProxyHost myProxyHost;
    private Credentials myProxyCredentials;
    private AuthScopeBuilder myAuthScopeBuilder;
    private HttpMethodRetryHandler myRetryHandler;
    private final boolean myKeepAlive;
    private XmlRpcTarget.XmlRpcCredentialsProvider myCredentialsProvider;
    private KeyStore myTrustStore;
    private String myOwnerNodeId;

    public CommonsXmlRpcTargetImpl(CommonsXmlRpcTargetImpl source, int connectionTimeout) throws MalformedURLException {
        this(source.getServerURL(), source.getUserAgent(), source.myConnectionTimeout, source.myKeepAlive);
    }

    public CommonsXmlRpcTargetImpl(String serverURL, String userAgent, int connectionTimeout, boolean keepAlive) throws MalformedURLException {
        super(serverURL, userAgent);
        this.myKeepAlive = keepAlive;
        this.myServerRpcURL = new URL(CommonsXmlRpcTargetImpl.rpcUrl(serverURL));
        this.myConnectionTimeout = connectionTimeout;
    }

    public void setOwnerNodeId(String ownerNodeId) {
        this.myOwnerNodeId = ownerNodeId;
    }

    private static String rpcUrl(String serverURL) {
        return serverURL + "/RPC2";
    }

    public XmlRpcClient getClient() {
        return new TCXmlRpcClient(this.myServerRpcURL, this.getUserAgent(), this.myConnectionTimeout, this.myTrustStore){

            public Object execute(XmlRpcClientRequest request) throws XmlRpcException, IOException {
                Object object = CommonsXmlRpcTargetImpl.this.mySingleExecuteLock;
                synchronized (object) {
                    MyXmlRpcTransport transport = CommonsXmlRpcTargetImpl.this.getOrCreateTransport();
                    try {
                        transport.beginClientRequest(request);
                        return super.execute(request, (XmlRpcTransport)transport);
                    }
                    catch (XmlRpcException e) {
                        if (e.getMessage().contains("MissingServerResponsibilityException")) {
                            transport.forgetRedirectUrls();
                        }
                        throw e;
                    }
                }
            }

            public void executeAsync(String method, Vector params, AsyncCallback callback) {
                throw new UnsupportedOperationException("executeAsync is not supported");
            }

            public void executeAsync(XmlRpcClientRequest request, AsyncCallback callback) {
                throw new UnsupportedOperationException("executeAsync is not supported");
            }

            public void executeAsync(XmlRpcClientRequest request, AsyncCallback callback, XmlRpcTransport transport) {
                throw new UnsupportedOperationException("executeAsync is not supported");
            }
        };
    }

    protected MyXmlRpcTransport getOrCreateTransport() {
        if (this.myTransport == null) {
            HttpClient client = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager());
            if (this.myProxyHost != null) {
                client.getHostConfiguration().setProxyHost(this.myProxyHost);
            }
            HttpConnectionManagerParams params = client.getHttpConnectionManager().getParams();
            params.setConnectionTimeout(this.myConnectionTimeout);
            params.setSoTimeout(2 * this.myConnectionTimeout);
            this.myState = new HttpState();
            if (this.myProxyCredentials != null && this.myAuthScopeBuilder != null) {
                this.myState.setProxyCredentials(this.myAuthScopeBuilder.createAuthScope(), this.myProxyCredentials);
            }
            client.setState(this.myState);
            if (this.myTrustStore != null) {
                Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new UserSecureProtocolSocketFactory(SSLContextUtil.createUserSSLContext(this.myTrustStore)), 443));
            }
            this.myTransport = new MyXmlRpcTransport(this.myServerRpcURL, this.getUserAgent(), client, this.myRetryHandler, this.myCredentialsProvider, this.myKeepAlive, this.myOwnerNodeId);
        }
        return this.myTransport;
    }

    public void disposeConnections() {
        MyXmlRpcTransport transport = this.myTransport;
        if (transport == null) {
            return;
        }
        transport.disposeConnections();
    }

    public void setCredentialsProvider(XmlRpcTarget.XmlRpcCredentialsProvider provider) {
        this.myCredentialsProvider = provider;
        this.resetTransport();
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.myProxyHost = new ProxyHost(proxyHost, proxyPort);
    }

    public void setProxyCredentials(String username, String password) {
        this.myProxyCredentials = new UsernamePasswordCredentials(username, password);
        this.myAuthScopeBuilder = new AuthScopeBuilder(){

            public AuthScope createAuthScope() {
                return new AuthScope(CommonsXmlRpcTargetImpl.this.myProxyHost.getHostName(), CommonsXmlRpcTargetImpl.this.myProxyHost.getPort());
            }
        };
        this.resetTransport();
    }

    public void setProxyCredentials(final String domain, String username, String password) {
        this.myProxyCredentials = new NTCredentials(username, password, CommonsXmlRpcTargetImpl.getHostname(), domain);
        this.myAuthScopeBuilder = new AuthScopeBuilder(){

            public AuthScope createAuthScope() {
                return new AuthScope(CommonsXmlRpcTargetImpl.this.myProxyHost.getHostName(), CommonsXmlRpcTargetImpl.this.myProxyHost.getPort(), domain);
            }
        };
        this.resetTransport();
    }

    public void setRetryHandler(HttpMethodRetryHandler handler) {
        this.myRetryHandler = handler;
        this.resetTransport();
    }

    public void setTrustStore(KeyStore trustStore) {
        this.myTrustStore = trustStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTransport() {
        Object object = this.mySingleExecuteLock;
        synchronized (object) {
            this.disposeConnections();
            this.myTransport = null;
        }
    }

    private static String getHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private static interface AuthScopeBuilder {
        public AuthScope createAuthScope();
    }
}

