/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xmlrpc.impl;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import jetbrains.buildServer.xmlrpc.XmlRpcConstants;
import jetbrains.buildServer.xmlrpc.XmlRpcLogger;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;
import jetbrains.buildServer.xmlrpc.impl.NodeNotAvailableException;
import jetbrains.buildServer.xmlrpc.impl.RedirectProcessingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcTransport;
import org.jetbrains.annotations.Nullable;

public class MyXmlRpcTransport
implements XmlRpcTransport {
    public static final String METHOD_NAME_HEADER = "TeamCity-Rpc-Method";
    private static final String MAIN_SERVER_ID = "MAIN_SERVER";
    private PostMethod myMethod;
    private final URL myUrl;
    private final String myUserAgent;
    private final boolean myKeepAlive;
    private final HttpClient myClient;
    private final HttpMethodRetryHandler myRetryHandler;
    private final XmlRpcTarget.XmlRpcCredentialsProvider myCredentialsProvider;
    private final String myOwnerNodeId;
    private final Logger myLogger = XmlRpcLogger.getLogger();
    private final Map<String, String> myMethod2URLMap = new HashMap<String, String>();
    @Nullable
    private String myRequestMethod;
    private final AtomicReference<Cookie> myCookie = new AtomicReference();

    public MyXmlRpcTransport(URL url, String userAgent, HttpClient client, HttpMethodRetryHandler retryHandler, XmlRpcTarget.XmlRpcCredentialsProvider credentialsProvider, boolean keepAlive, String ownerNodeId) {
        this.myUrl = url;
        this.myClient = client;
        this.myUserAgent = userAgent;
        this.myKeepAlive = keepAlive;
        this.myRetryHandler = retryHandler == null ? new DefaultHttpMethodRetryHandler(0, false) : retryHandler;
        this.myCredentialsProvider = credentialsProvider;
        this.myOwnerNodeId = ownerNodeId == null ? MAIN_SERVER_ID : ownerNodeId;
    }

    public void endClientRequest() {
        this.releaseMethodInstance();
        this.myRequestMethod = null;
    }

    public void beginClientRequest(XmlRpcClientRequest request) {
        this.myRequestMethod = request.getMethodName();
    }

    public InputStream sendXmlRpc(byte[] request) throws IOException, XmlRpcClientException {
        int status;
        try {
            try {
                status = this.executeRequest(request);
                String redirectUrl = this.getRedirectUrl();
                if (redirectUrl != null) {
                    this.myLogger.info("Got redirect for XML-RPC method '" + this.myRequestMethod + "' to: " + redirectUrl);
                    this.myMethod2URLMap.put(this.myRequestMethod, redirectUrl);
                    status = this.executeRequest(request);
                    String newRedirectUrl = this.getRedirectUrl();
                    if (newRedirectUrl != null) {
                        this.removeRedirectUrl();
                        throw new XmlRpcClientException("Got double redirect from the server for method '" + this.myRequestMethod + "', first URL: '" + redirectUrl + "', second URL: '" + newRedirectUrl + "'", null);
                    }
                }
                Object var6_8 = null;
            }
            catch (IOException e) {
                this.myLogger.debug("Error during xml-rpc communication, clearing redirect URL if any", (Throwable)e);
                String failedRedirectUrl = this.removeRedirectUrl();
                if (failedRedirectUrl != null) {
                    throw new RedirectProcessingException("Error while communicating with the server via redirect URL '" + failedRedirectUrl + "' for method '" + this.myRequestMethod + "'. Error:  " + e.getMessage());
                }
                if (this.externalProxyMode()) {
                    this.myLogger.warnAndDebugDetails("Node " + this.myOwnerNodeId + " is not available for " + this.myRequestMethod + " due to IOException", (Throwable)e);
                    throw new NodeNotAvailableException(this.myOwnerNodeId);
                }
                throw e;
            }
            catch (RemoteCallException e) {
                if (this.externalProxyMode()) {
                    this.myLogger.warnAndDebugDetails("Node " + this.myOwnerNodeId + " is not available for " + this.myRequestMethod + " due to RemoteCallException", (Throwable)e);
                    throw new NodeNotAvailableException(this.myOwnerNodeId);
                }
                throw e;
            }
            this.processCookieState();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.processCookieState();
            throw throwable;
        }
        LazyResponseStream responseStream = new LazyResponseStreamFromMethod(this.myMethod);
        if (this.myLogger.isDebugEnabled()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InputStream is = responseStream.getResponseStream();
            int data = is.read();
            while (data != -1) {
                bos.write(data);
                data = is.read();
            }
            this.myLogger.debug("<<< XML-RPC response with status " + status);
            this.myLogger.debug(bos.toString("UTF-8"));
            responseStream = new LazyResponseStreamFromByteArray(bos.toByteArray());
        }
        this.processErrorStatus(status);
        return responseStream.getResponseStream();
    }

    private void processCookieState() {
        Cookie[] cookies;
        if (XmlRpcConstants.SECONDARY_NODE_SUPPORTED_RPC_METHODS.contains(this.myRequestMethod) && (cookies = this.myClient.getState().getCookies()) != null && cookies.length != 0) {
            for (Cookie c : cookies) {
                if (!"X-TeamCity-Node-Id-Cookie".equals(c.getName())) continue;
                if (this.myCookie.get() != null) {
                    Cookie cur = this.myCookie.get();
                    if (cur.getValue() == null || c.getValue() == null || !cur.getValue().equals(c.getValue())) {
                        this.myLogger.debug("Received new value for cookie: " + this.describe(this.myCookie.get()) + " -> " + this.describe(c));
                        this.myCookie.set(c);
                        break;
                    }
                    this.myLogger.debug("Received the same cookie: " + this.describe(c) + " for " + this.myRequestMethod);
                    this.myCookie.set(c);
                    continue;
                }
                this.myLogger.debug("Received new cookie: " + this.describe(c) + " for " + this.myRequestMethod);
                this.myCookie.set(c);
            }
        }
    }

    private String describe(Cookie cookie) {
        if (cookie == null) {
            return "empty cookie";
        }
        return "(" + cookie.getValue() + "|" + cookie.getExpiryDate() + ")";
    }

    private void processErrorStatus(int status) throws IOException, XmlRpcClientException {
        if (status != 200) {
            String redirectUrl = this.removeRedirectUrl();
            if (redirectUrl != null) {
                this.myLogger.warn("Unexpected status code " + status + " during XML-RPC communication, clearing redirect URL for XML-RPC method '" + this.myRequestMethod + "', redirect URL: " + redirectUrl);
            }
            if (this.externalProxyMode()) {
                throw new NodeNotAvailableException(this.myOwnerNodeId);
            }
            if (status == 503) {
                throw new IOException("Server returned status " + status + ", try later");
            }
            StatusLine statusLine = this.myMethod.getStatusLine();
            if (statusLine != null) {
                String message = "Server returned incorrect status code: " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase();
                throw new XmlRpcClientException(message, null);
            }
        }
    }

    private boolean externalProxyMode() {
        return XmlRpcConstants.SECONDARY_NODE_SUPPORTED_RPC_METHODS.contains(this.myRequestMethod) && this.myCookie.get() != null && !MAIN_SERVER_ID.equals(this.myCookie.get().getValue());
    }

    private void releaseMethodInstance() {
        if (this.myMethod != null) {
            this.myMethod.releaseConnection();
            this.myMethod = null;
        }
    }

    private String removeRedirectUrl() {
        return this.myMethod2URLMap.remove(this.myRequestMethod);
    }

    public void forgetRedirectUrls() {
        this.myMethod2URLMap.clear();
    }

    @Nullable
    private String getRedirectUrl() {
        Header[] locationHeaders;
        int statusCode = this.myMethod.getStatusCode();
        if (statusCode > 300 && statusCode < 400 && (locationHeaders = this.myMethod.getResponseHeaders("Location")) != null && locationHeaders.length > 0) {
            return locationHeaders[0].getValue();
        }
        return null;
    }

    private int executeRequest(byte[] request) throws IOException {
        this.releaseMethodInstance();
        if (this.myLogger.isDebugEnabled()) {
            this.myLogger.debug(">>> XML-RPC request to " + this.getUrl());
            this.myLogger.debug(new String(request, "UTF-8"));
        }
        this.myMethod = new PostMethod(this.getUrl());
        this.myMethod.addRequestHeader("User-Agent", this.myUserAgent);
        if (this.hasRedirectUrl()) {
            this.myMethod.addRequestHeader("X-TeamCity-Redirected-By-Node", this.myUrl.toString());
        }
        if (XmlRpcConstants.SECONDARY_NODE_SUPPORTED_RPC_METHODS.contains(this.myRequestMethod)) {
            if (this.myCookie.get() == null) {
                Cookie cookie = new Cookie(this.myUrl.getHost(), "X-TeamCity-Node-Id-Cookie", this.myOwnerNodeId, "/", 60, false);
                this.myCookie.set(cookie);
                this.myMethod.addRequestHeader("X-TeamCity-Redirected-By-Node", this.myUrl.toString());
            }
            this.myLogger.debug("Using cookie " + this.describe(this.myCookie.get()) + " for method " + this.myRequestMethod + " and URL " + this.getUrl());
            this.setCookie(this.myCookie.get());
        } else {
            this.setCookie(null);
        }
        this.myMethod.getParams().setVersion(this.myKeepAlive ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0);
        this.myMethod.getParams().setParameter("http.method.retry-handler", (Object)this.myRetryHandler);
        if (this.myRequestMethod != null) {
            UsernamePasswordCredentials cre;
            this.myMethod.addRequestHeader(METHOD_NAME_HEADER, this.myRequestMethod);
            if (this.myCredentialsProvider != null && (cre = this.myCredentialsProvider.getCredentials(this.myRequestMethod)) != null) {
                String crePair = cre.getUserName() + ":" + cre.getPassword();
                String encoded = new String(Base64.encodeBase64((byte[])crePair.getBytes("US-ASCII")), "US-ASCII");
                this.myMethod.addRequestHeader("Authorization", "Basic " + encoded);
            }
        }
        this.myMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(request, "text/xml"));
        return this.myClient.executeMethod((HttpMethod)this.myMethod);
    }

    private void setCookie(@Nullable Cookie cookie) {
        Cookie[] cookies = this.myClient.getState().getCookies();
        this.myClient.getState().clearCookies();
        for (Cookie c : cookies) {
            if ("X-TeamCity-Node-Id-Cookie".equals(c.getName())) continue;
            this.myClient.getState().addCookie(c);
        }
        if (cookie != null) {
            this.myClient.getState().addCookie(cookie);
        }
    }

    private String getUrl() {
        if (this.myRequestMethod == null) {
            return this.myUrl.toString();
        }
        String url = this.myMethod2URLMap.get(this.myRequestMethod);
        if (url == null) {
            url = this.myUrl.toString();
        }
        return url;
    }

    private boolean hasRedirectUrl() {
        return this.myMethod2URLMap.containsKey(this.myRequestMethod);
    }

    public void disposeConnections() {
        HttpConnectionManager cm = this.myClient.getHttpConnectionManager();
        if (cm == null) {
            return;
        }
        cm.closeIdleConnections(0L);
    }

    private static class LazyResponseStreamFromMethod
    implements LazyResponseStream {
        private final PostMethod myMethod;

        LazyResponseStreamFromMethod(PostMethod method) {
            this.myMethod = method;
        }

        public InputStream getResponseStream() throws IOException {
            String lValue;
            boolean lgzipo = false;
            Header lHeader = this.myMethod.getResponseHeader("Content-Encoding");
            if (lHeader != null && (lValue = lHeader.getValue()) != null) {
                lgzipo = lValue.contains("gzip");
            }
            if (lgzipo) {
                return new GZIPInputStream(this.myMethod.getResponseBodyAsStream());
            }
            return this.myMethod.getResponseBodyAsStream();
        }
    }

    private static class LazyResponseStreamFromByteArray
    implements LazyResponseStream {
        private final byte[] myBytes;

        LazyResponseStreamFromByteArray(byte[] bytes) {
            this.myBytes = bytes;
        }

        public InputStream getResponseStream() {
            return new ByteArrayInputStream(this.myBytes);
        }
    }

    private static interface LazyResponseStream {
        public InputStream getResponseStream() throws IOException;
    }
}

