/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xmlrpc.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLContextUtil {
    private SSLContextUtil() {
        throw new IllegalStateException();
    }

    public static SSLContext createUserSSLContext(KeyStore trustStore) {
        try {
            X509TrustManager defaultTrustManager = SSLContextUtil.createTrustManager(SSLContextUtil.getDefaultTrustStore());
            X509TrustManager trustManager = trustStore == null ? defaultTrustManager : new AggregateSSLTrustManager(defaultTrustManager, SSLContextUtil.createTrustManager(trustStore));
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(SSLContextUtil.getKeyManagers(), new TrustManager[]{trustManager}, new SecureRandom());
            return context;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    private static X509TrustManager createTrustManager(KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory manager = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        manager.init(trustStore);
        return (X509TrustManager)manager.getTrustManagers()[0];
    }

    private static KeyManager[] getKeyManagers() {
        String password = System.getProperty("javax.net.ssl.keyStorePassword");
        try {
            KeyStore ks = SSLContextUtil.getStore(System.getProperty("javax.net.ssl.keyStore"), password, System.getProperty("javax.net.ssl.keyStoreType"));
            if (ks == null) {
                return null;
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(ks, password != null ? password.toCharArray() : null);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyStore getDefaultTrustStore() {
        try {
            return SSLContextUtil.getStore(System.getProperty("javax.net.ssl.trustStore"), System.getProperty("javax.net.ssl.trustStorePassword"), System.getProperty("javax.net.ssl.trustStoreType"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getStore(String store, String password, String type) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        if (store == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance(type != null ? type : KeyStore.getDefaultType());
        FileInputStream stream = new FileInputStream(store);
        try {
            ks.load(stream, password != null ? password.toCharArray() : null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            stream.close();
            throw throwable;
        }
        stream.close();
        return ks;
    }

    private static class AggregateSSLTrustManager
    implements X509TrustManager {
        private final X509TrustManager defaultManager;
        private final X509TrustManager customManager;

        AggregateSSLTrustManager(X509TrustManager defaultManager, X509TrustManager customManager) {
            this.defaultManager = defaultManager;
            this.customManager = customManager;
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            try {
                this.defaultManager.checkClientTrusted(x509Certificates, s);
            }
            catch (CertificateException e) {
                this.customManager.checkClientTrusted(x509Certificates, s);
            }
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            try {
                this.defaultManager.checkServerTrusted(x509Certificates, s);
            }
            catch (CertificateException e) {
                this.customManager.checkServerTrusted(x509Certificates, s);
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] defaultIssuers = this.defaultManager.getAcceptedIssuers();
            int l1 = defaultIssuers.length;
            X509Certificate[] customIssuers = this.customManager.getAcceptedIssuers();
            int l2 = customIssuers.length;
            X509Certificate[] result = new X509Certificate[l1 + l2];
            System.arraycopy(defaultIssuers, 0, result, 0, l1);
            System.arraycopy(customIssuers, 0, result, l1, l2);
            return result;
        }
    }
}

