/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xmlrpc.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class UserSecureProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLContext sslContext;

    public UserSecureProtocolSocketFactory(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.sslContext.getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localAddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteAddr = new InetSocketAddress(host, port);
        socket.bind(localAddr);
        socket.connect(remoteAddr, timeout);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }
}

