/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xstream;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jetbrains.buildServer.messages.XStreamHolder;
import jetbrains.buildServer.util.StringUtil;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XStreamWrapper {
    private XStreamWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> List<T> deserializeObjects(@NotNull Collection objectsXml, @NotNull XStreamHolder holder) {
        if (objectsXml == null) {
            XStreamWrapper.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(1);
        }
        ArrayList<Object> messages = new ArrayList<Object>();
        XStream xStream = holder.getXStream();
        try {
            for (Object nodeObj : objectsXml) {
                if (!(nodeObj instanceof String)) continue;
                String messageXml = (String)nodeObj;
                try {
                    messages.add(XStreamWrapper.fromXML(xStream, messageXml));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            holder.releaseXStream(xStream);
        }
        ArrayList<Object> arrayList = messages;
        if (arrayList == null) {
            XStreamWrapper.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> List<T> deserializeObjects(@NotNull Class<T> clazz, @NotNull ClassLoader classLoader, @NotNull Collection objectsXml, @NotNull XStreamHolder holder) {
        if (clazz == null) {
            XStreamWrapper.$$$reportNull$$$0(3);
        }
        if (classLoader == null) {
            XStreamWrapper.$$$reportNull$$$0(4);
        }
        if (objectsXml == null) {
            XStreamWrapper.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(6);
        }
        ArrayList<T> messages = new ArrayList<T>();
        XStream xStream = holder.getXStream(classLoader);
        try {
            for (Object nodeObj : objectsXml) {
                if (!(nodeObj instanceof String)) continue;
                String messageXml = (String)nodeObj;
                try {
                    messages.add(clazz.cast(XStreamWrapper.fromXML(xStream, messageXml)));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            holder.releaseXStream(xStream);
        }
        ArrayList<T> arrayList = messages;
        if (arrayList == null) {
            XStreamWrapper.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static Object fromXML(@NotNull XStream xStream, @NotNull @Language(value="XML") String messageXml) {
        if (xStream == null) {
            XStreamWrapper.$$$reportNull$$$0(8);
        }
        if (messageXml == null) {
            XStreamWrapper.$$$reportNull$$$0(9);
        }
        return xStream.fromXML(messageXml);
    }

    public static <T> Vector serializeObjects(@NotNull List<T> list, @NotNull XStreamHolder holder) {
        if (list == null) {
            XStreamWrapper.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(11);
        }
        return XStreamWrapper.serializeObjectsInternal(list, holder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Vector serializeObjectsInternal(@NotNull List<T> list, @NotNull XStreamHolder holder, @Nullable ClassLoader classLoader) {
        if (list == null) {
            XStreamWrapper.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(13);
        }
        Vector<String> result = new Vector<String>();
        XStream xStream = holder.getXStream(classLoader);
        try {
            for (T buildMessage : list) {
                result.add(XStreamWrapper.toXML(buildMessage, xStream));
            }
        }
        finally {
            holder.releaseXStream(xStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String serializeObject(@Nullable Object obj, @NotNull XStreamHolder holder) {
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(14);
        }
        if (obj != null) {
            XStream xStream = holder.getXStream(obj.getClass().getClassLoader());
            String string = XStreamWrapper.toXML(obj, xStream);
            String string2 = string;
            if (string2 == null) {
                XStreamWrapper.$$$reportNull$$$0(15);
            }
            return string2;
            finally {
                holder.releaseXStream(xStream);
            }
        }
        if ("" == null) {
            XStreamWrapper.$$$reportNull$$$0(16);
        }
        return "";
    }

    @NotNull
    public static String toXML(@NotNull Object obj, @NotNull XStream xStream) {
        String string;
        block9: {
            if (obj == null) {
                XStreamWrapper.$$$reportNull$$$0(17);
            }
            if (xStream == null) {
                XStreamWrapper.$$$reportNull$$$0(18);
            }
            try {
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    xStream.toXML(obj, (OutputStream)out);
                }
                string = new String(out.toByteArray(), "UTF-8");
                if (string != null) break block9;
            }
            catch (IOException e) {
                e.printStackTrace();
                String string2 = xStream.toXML(obj);
                if (string2 == null) {
                    XStreamWrapper.$$$reportNull$$$0(20);
                }
                return string2;
            }
            XStreamWrapper.$$$reportNull$$$0(19);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] serializeAndZipObject(@Nullable Object obj, @NotNull XStreamHolder holder) throws IOException {
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(21);
        }
        if (obj != null) {
            byte[] byArray;
            XStream xStream;
            block10: {
                xStream = holder.getXStream(obj.getClass().getClassLoader());
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new GZIPOutputStream(buffer), "UTF-8");){
                    xStream.toXML(obj, (Writer)out);
                }
                byArray = buffer.toByteArray();
                if (byArray != null) break block10;
                XStreamWrapper.$$$reportNull$$$0(22);
            }
            return byArray;
            finally {
                holder.releaseXStream(xStream);
            }
        }
        byte[] byArray = new byte[]{};
        if (byArray == null) {
            XStreamWrapper.$$$reportNull$$$0(23);
        }
        return byArray;
    }

    @Contract(value="null,_->null")
    @Nullable
    public static <T> T deserializeObject(@Nullable @Language(value="XML") String xml, @NotNull XStreamHolder holder) {
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(24);
        }
        return XStreamWrapper.deserializeObjectInternal(xml, holder, null);
    }

    @Contract(value="_,null,_->null")
    @Nullable
    public static <T> T deserializeObject(@NotNull ClassLoader classLoader, @Nullable @Language(value="XML") String xml, @NotNull XStreamHolder holder) {
        if (classLoader == null) {
            XStreamWrapper.$$$reportNull$$$0(25);
        }
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(26);
        }
        return XStreamWrapper.deserializeObjectInternal(xml, holder, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null,_,_->null")
    @Nullable
    private static <T> T deserializeObjectInternal(@Nullable @Language(value="XML") String xml, @NotNull XStreamHolder holder, @Nullable ClassLoader classloader) {
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(27);
        }
        if (StringUtil.isNotEmpty((String)xml)) {
            XStream xStream = holder.getXStream(classloader);
            try {
                Object object = XStreamWrapper.fromXML(xStream, xml);
                return (T)object;
            }
            finally {
                holder.releaseXStream(xStream);
            }
        }
        return null;
    }

    @Contract(value="null,_->null")
    @Nullable
    public static <T> T unzipAndDeserializeObject(@Nullable byte[] zipped, @NotNull XStreamHolder holder) throws IOException {
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(28);
        }
        return XStreamWrapper.unzipAndDeserializedObjectInternal(zipped, holder, null);
    }

    @Contract(value="_,null,_->null")
    @Nullable
    public static <T> T unzipAndDeserializeObject(@NotNull ClassLoader classLoader, @Nullable byte[] zipped, @NotNull XStreamHolder holder) throws IOException {
        if (classLoader == null) {
            XStreamWrapper.$$$reportNull$$$0(29);
        }
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(30);
        }
        return XStreamWrapper.unzipAndDeserializedObjectInternal(zipped, holder, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null,_,_->null")
    @Nullable
    private static <T> T unzipAndDeserializedObjectInternal(@Nullable byte[] zipped, @NotNull XStreamHolder holder, @Nullable ClassLoader classLoader) throws IOException {
        if (holder == null) {
            XStreamWrapper.$$$reportNull$$$0(31);
        }
        if (zipped != null && zipped.length > 0) {
            XStream xStream = holder.getXStream(classLoader);
            try {
                Object object;
                ByteArrayInputStream inBuffer = new ByteArrayInputStream(zipped);
                GZIPInputStream zipIn = new GZIPInputStream(inBuffer);
                InputStreamReader reader = new InputStreamReader((InputStream)zipIn, "UTF-8");
                try {
                    object = xStream.fromXML((Reader)reader);
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return (T)object;
            }
            finally {
                holder.releaseXStream(xStream);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectsXml";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/xstream/XStreamWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xStream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageXml";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/xstream/XStreamWrapper";
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeObjects";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeObject";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toXML";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeAndZipObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserializeObjects";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromXML";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serializeObjects";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "serializeObjectsInternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serializeObject";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "toXML";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "serializeAndZipObject";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "deserializeObject";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "deserializeObjectInternal";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unzipAndDeserializeObject";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unzipAndDeserializedObjectInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

