/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.TimeZone;
import org.apache.xmlrpc.TCTypeFactory;
import org.apache.xmlrpc.TCXmlRpcClientRequestProcessor;
import org.apache.xmlrpc.TCXmlRpcResponseProcessor;
import org.apache.xmlrpc.TypeFactory;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClientRequestProcessor;
import org.apache.xmlrpc.XmlRpcClientResponseProcessor;
import org.apache.xmlrpc.XmlRpcRequestProcessor;
import org.apache.xmlrpc.XmlRpcResponseProcessor;

public class TCProcessorFactory {
    public static final String XMLRPC_TYPE_FACTORY = TypeFactory.class.getName();

    public static XmlRpcClientRequestProcessor createClientRequestProcessor(TimeZone tz) {
        return new TCXmlRpcClientRequestProcessor(tz);
    }

    public static XmlRpcResponseProcessor createResponseProcessor() {
        return new TCXmlRpcResponseProcessor();
    }

    public static XmlRpcRequestProcessor createRequestProcessor() {
        TCXmlRpcRequestProcessor processor = new TCXmlRpcRequestProcessor();
        try {
            TCProcessorFactory.setTypeFactory((XmlRpc)processor);
        }
        catch (Exception e) {
            TCProcessorFactory.logFailedToSetFactory(e);
            processor = TCProcessorFactory.createRequestProcessorWithFactory();
        }
        return processor;
    }

    private static void logFailedToSetFactory(Exception e) {
        System.err.println("Failed to set TCTypeFactory via reflection: " + e + ", will use system property");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized XmlRpcRequestProcessor createRequestProcessorWithFactory() {
        TCXmlRpcRequestProcessor tCXmlRpcRequestProcessor;
        String oldFactory = TCProcessorFactory.setNewFactory();
        try {
            tCXmlRpcRequestProcessor = new TCXmlRpcRequestProcessor();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            TCProcessorFactory.restoreOldFactory(oldFactory);
            throw throwable;
        }
        TCProcessorFactory.restoreOldFactory(oldFactory);
        return tCXmlRpcRequestProcessor;
    }

    public static XmlRpcClientResponseProcessor createClientResponseProcessor(TimeZone timeZone) {
        XmlRpcClientResponseProcessor processor = new XmlRpcClientResponseProcessor(timeZone);
        try {
            TCProcessorFactory.setTypeFactory((XmlRpc)processor);
        }
        catch (Exception e) {
            TCProcessorFactory.logFailedToSetFactory(e);
            processor = TCProcessorFactory.createClientResponseProcessorWithFactory(timeZone);
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized XmlRpcClientResponseProcessor createClientResponseProcessorWithFactory(TimeZone timeZone) {
        XmlRpcClientResponseProcessor xmlRpcClientResponseProcessor;
        String oldFactory = TCProcessorFactory.setNewFactory();
        try {
            xmlRpcClientResponseProcessor = new XmlRpcClientResponseProcessor(timeZone);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            TCProcessorFactory.restoreOldFactory(oldFactory);
            throw throwable;
        }
        TCProcessorFactory.restoreOldFactory(oldFactory);
        return xmlRpcClientResponseProcessor;
    }

    private static String setNewFactory() {
        return System.setProperty(XMLRPC_TYPE_FACTORY, "org.apache.xmlrpc.TCTypeFactory");
    }

    private static void restoreOldFactory(String oldFactoryClass) {
        if (oldFactoryClass == null) {
            System.getProperties().remove(XMLRPC_TYPE_FACTORY);
        } else {
            System.setProperty(XMLRPC_TYPE_FACTORY, oldFactoryClass);
        }
    }

    private static void setTypeFactory(XmlRpc xmlRpc) throws NoSuchFieldException, IllegalAccessException {
        Field field = XmlRpc.class.getDeclaredField("typeFactory");
        field.setAccessible(true);
        field.set(xmlRpc, (Object)new TCTypeFactory());
    }

    private static class TCXmlRpcRequestProcessor
    extends XmlRpcRequestProcessor {
        private TCXmlRpcRequestProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void parse(InputStream is) throws Exception {
            try {
                super.parse(is);
                Object var3_2 = null;
                if (this.cdata != null && this.cdata.capacity() > 512) {
                    this.cdata = null;
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.cdata != null && this.cdata.capacity() > 512) {
                    this.cdata = null;
                }
                throw throwable;
            }
        }
    }
}

