/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.xmlrpc.TCDateTool;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlWriter;

public class TCXmlWriter
extends XmlWriter {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private final char[] myBuf = new char[1024];

    public TCXmlWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        super(out, enc);
        this.dateTool = new TCDateTool();
    }

    protected void chardata(String text) throws XmlRpcException, IOException {
        String textCopy = this.replaceInvalidEntities(text);
        int index = 0;
        while (index < textCopy.length()) {
            char nextChar;
            int i;
            int dataSize = Math.min(textCopy.length() - index, this.myBuf.length);
            int numBrackets = 0;
            for (i = 0; i < dataSize && ((nextChar = textCopy.charAt(index)) != '>' || numBrackets <= 0); ++i) {
                this.myBuf[i] = nextChar;
                ++index;
                if (nextChar == ']') {
                    ++numBrackets;
                    continue;
                }
                numBrackets = 0;
            }
            this.write(CDATA_START);
            this.write(this.myBuf, 0, i);
            this.write(CDATA_END);
        }
    }

    private String replaceInvalidEntities(String text) {
        StringBuffer textCopy = new StringBuffer();
        StringBuffer entity = new StringBuffer();
        int length = text.length();
        boolean isCharRef = false;
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                char next;
                if (isCharRef) {
                    textCopy.append('&');
                    if (entity.length() > 0) {
                        textCopy.append(entity);
                    }
                }
                entity.setLength(0);
                isCharRef = false;
                if (i + 1 < length && (next = text.charAt(i + 1)) == '#') {
                    isCharRef = true;
                }
                if (isCharRef) continue;
                textCopy.append('&');
                continue;
            }
            if (isCharRef) {
                if (c != ';') {
                    this.add(entity, c);
                    continue;
                }
                isCharRef = false;
                int entityLength = entity.length();
                if (entityLength > 1 && entity.charAt(0) == '#') {
                    String code;
                    int radix;
                    if (entity.charAt(1) == 'x') {
                        if (entityLength == 2) {
                            this.appendEntity(textCopy, entity);
                            continue;
                        }
                        radix = 16;
                        code = entity.substring(2);
                    } else {
                        radix = 10;
                        code = entity.substring(1);
                    }
                    boolean valid = true;
                    try {
                        int parsed = Integer.parseInt(code, radix);
                        valid = TCXmlWriter.isValidXMLChar((char)parsed);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (valid) {
                        this.appendEntity(textCopy, entity);
                        continue;
                    }
                    textCopy.append(' ');
                    continue;
                }
                this.appendEntity(textCopy, entity);
                continue;
            }
            this.add(textCopy, c);
        }
        if (isCharRef) {
            textCopy.append('&');
            if (entity.length() > 0) {
                textCopy.append(entity.toString());
            }
        }
        return textCopy.toString();
    }

    private void add(StringBuffer textCopy, char c) {
        if (TCXmlWriter.isValidXMLChar(c)) {
            textCopy.append(c);
        } else {
            textCopy.append(' ');
        }
    }

    private void appendEntity(StringBuffer textCopy, StringBuffer entity) {
        textCopy.append('&');
        textCopy.append(entity.toString());
        textCopy.append(';');
    }

    private static boolean isValidXMLChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return ' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd' || '\u10000' <= c && c <= '\u10ffff';
    }
}

