/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.alpn;

import io.undertow.UndertowLogger;
import io.undertow.protocols.alpn.ALPNProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class JDK9AlpnProvider
implements ALPNProvider {
    public static final JDK9ALPNMethods JDK_9_ALPN_METHODS = AccessController.doPrivileged(new PrivilegedAction<JDK9ALPNMethods>(){

        @Override
        public JDK9ALPNMethods run() {
            try {
                Method setApplicationProtocols = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
                Method getApplicationProtocol = SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
                UndertowLogger.ROOT_LOGGER.debug("Using JDK9 ALPN");
                return new JDK9ALPNMethods(setApplicationProtocols, getApplicationProtocol);
            }
            catch (Exception e) {
                UndertowLogger.ROOT_LOGGER.debug("JDK9 ALPN not supported");
                return null;
            }
        }
    });

    @Override
    public boolean isEnabled(SSLEngine sslEngine) {
        return JDK_9_ALPN_METHODS != null;
    }

    @Override
    public SSLEngine setProtocols(SSLEngine engine, String[] protocols) {
        SSLParameters sslParameters = engine.getSSLParameters();
        try {
            JDK_9_ALPN_METHODS.setApplicationProtocols().invoke((Object)sslParameters, new Object[]{protocols});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        engine.setSSLParameters(sslParameters);
        return engine;
    }

    @Override
    public String getSelectedProtocol(SSLEngine engine) {
        try {
            return (String)JDK_9_ALPN_METHODS.getApplicationProtocol().invoke((Object)engine, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getPriority() {
        return 300;
    }

    public String toString() {
        return "JDK9AlpnProvider";
    }

    public static class JDK9ALPNMethods {
        private final Method setApplicationProtocols;
        private final Method getApplicationProtocol;

        JDK9ALPNMethods(Method setApplicationProtocols, Method getApplicationProtocol) {
            this.setApplicationProtocols = setApplicationProtocols;
            this.getApplicationProtocol = getApplicationProtocol;
        }

        public Method getApplicationProtocol() {
            return this.getApplicationProtocol;
        }

        public Method setApplicationProtocols() {
            return this.setApplicationProtocols;
        }
    }
}

