package client;

import java.util.Hashtable;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import javax.transaction.UserTransaction;

import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.RemoteUserTransaction;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;


import com.test.usertransaction.ControllerRemote;

public class TestUserTransaction {


	private String host = "localhost";
	private Integer port = 8080;
	private String username = "ejbuser";
	private String password = "redhat1!";

	public TestUserTransaction() {
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception{
		TestUserTransaction tAPI = new TestUserTransaction();
		if(args.length <= 0 || Integer.parseInt(args[0]) == 1)
			tAPI.testTransaction();
		else if (Integer.parseInt(args[0]) == 2)
			tAPI.testTransaction2();
	}

	private void testTransaction() throws Exception {	
    	
		System.out.println("Running testTransaction() with UserTransaction");
	
		for(int i=1; i< 500000; i++) {
			if(i % 1000 == 0)
				System.out.println("Starting process " + i);

      // get the UserTransaction and EJB Proxy
			Context ctx = getInitialContext(host, port, username, password);
      UserTransaction tx = getUserTransaction(ctx);
			ControllerRemote cr = (ControllerRemote) ctx.lookup("Controller/Controller" + "!com.test.usertransaction.ControllerRemote");
		
			try {
				tx.begin();
			}
			catch(Exception ex1) {
				ex1.printStackTrace();
			}
			//System.out.println("user transaction started");
				
			for(int j=0; j<5; j++)
				cr.mainCall();

			try {
				tx.commit();;
			}
			catch(Exception ex1) {
				ex1.printStackTrace();
				throw ex1;
			}
			//System.out.println("commited user transaction");

			if(ctx != null)
				ctx.close();
		}

		while( promptYesNo("Exit", false) != true);
		System.out.printf("Finished, shutting down JVM");
	}


	private void testTransaction2() throws Exception {	
		System.out.println("Running testTransaction2() with RemoteTransactionContext.getInstance().getUserTransaction()");

    		RemoteUserTransaction tx = RemoteTransactionContext.getInstance().getUserTransaction();
    	
		for(int i=1; i< 500000; i++) {
			System.out.println("Starting process " + i);

      // get the EJB Proxy
			Context ctx = getInitialContext(host, port, username, password);
			ControllerRemote cr = (ControllerRemote) ctx.lookup("Controller/Controller" + "!com.test.usertransaction.ControllerRemote");
		
			try {
				tx.begin();
			}
			catch(Exception ex1) {
				ex1.printStackTrace();
			}
			//System.out.println("user transaction started");
				
			cr.mainCall();

			try {
				tx.commit();;
			}
			catch(Exception ex1) {
				ex1.printStackTrace();
				throw ex1;
			}
			//System.out.println("commited user transaction");

			if(ctx != null)
				ctx.close();
		}
	}

  public UserTransaction getUserTransaction(Context ctx) throws NamingException {
    return (UserTransaction) ctx.lookup("txn:UserTransaction");
  }

  public static Context getInitialContext(String host, Integer port, String username, String password) throws NamingException {
     Properties props = new Properties();
     props.put(Context.INITIAL_CONTEXT_FACTORY,  "org.wildfly.naming.client.WildFlyInitialContextFactory");
     props.put(Context.PROVIDER_URL, String.format("%s://%s:%d", "remote+http", host, port));
     props.put(Context.SECURITY_PRINCIPAL, username);
     props.put(Context.SECURITY_CREDENTIALS, password);
     return new InitialContext(props);
  }

	public static boolean promptYesNo(String messageFormat, Boolean defaultResponse, Object...args) {
		return promptYesNo(String.format(messageFormat, args), defaultResponse);
	}


	public static boolean promptYesNo(String message, Boolean defaultResponse) {
		Boolean yesNo = null;
		while(yesNo == null) {

		  // put the default answer first
		  if(defaultResponse == true)
			  System.out.print(message + " (Y/N)");
		  else
			  System.out.print(message + " (N/Y)");

		  try {
			  String string = (new BufferedReader(new InputStreamReader(System.in))).readLine();
			  // if length == 0, then use defaultResponse if not null, else prompt again
			  if(string.length() != 0) {
				  if(string.substring(0, 1).equalsIgnoreCase("Y"))
					  yesNo = true;
				  else if(string.substring(0, 1).equalsIgnoreCase("N"))
					  yesNo = false;
				  else {
					  yesNo = null;
					  System.out.println("read: '" + yesNo +"'");
				  }
			  } else { // length == 0, check defaultResponse, return if not null, else reprompt
				  if(defaultResponse != null)
					  return defaultResponse;
				  yesNo = null;
			  }
		  } catch(IOException ioe) {
			  System.err.println(ioe.getClass().getName() + ": " + ioe.getMessage());
			  yesNo = null;
		  }
		}
		return yesNo;
	}


}
