/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.gui.filepanel.FilePanelDataModel2;
import wjhk.jupload2.gui.filepanel.FilePanelJTable;
import wjhk.jupload2.policies.UploadPolicy;

public class FilePanelTableImp
extends JPanel
implements FilePanel,
ComponentListener {
    private static final long serialVersionUID = -8273990467324350526L;
    private FilePanelJTable jtable;
    private FilePanelDataModel2 model;
    private UploadPolicy uploadPolicy = null;
    private JUploadPanel juploadPanel = null;
    private JScrollPane scrollPane = null;

    public FilePanelTableImp(JUploadPanel juploadPanel, UploadPolicy uploadPolicy) {
        this.juploadPanel = juploadPanel;
        this.uploadPolicy = uploadPolicy;
        this.setLayout(new BorderLayout());
        this.addMouseListener(juploadPanel.getMouseListener());
        this.setTransferHandler(juploadPanel.getTransferHandler());
        this.jtable = new FilePanelJTable(juploadPanel, uploadPolicy);
        this.model = new FilePanelDataModel2(uploadPolicy);
        this.jtable.setModel(this.model);
        this.scrollPane = new JScrollPane(this.jtable);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.addMouseListener(juploadPanel.getMouseListener());
        this.scrollPane.getViewport().addComponentListener(this);
    }

    public final void addFiles(File[] f, File root) {
        if (null == f) {
            throw new IllegalArgumentException("FilePanelTableImpl: filesToUpload may not be null)");
        }
        try {
            for (int i = 0; i < f.length; ++i) {
                this.addDirectoryFiles(f[i], root);
            }
        }
        catch (JUploadExceptionStopAddingFiles e) {
            this.uploadPolicy.displayWarn(this.getClass().getName() + ".addFiles() [" + e.getClass().getName() + "]: " + e.getMessage());
        }
        this.juploadPanel.updateButtonState();
    }

    private final void addDirectoryFiles(File f, File root) throws JUploadExceptionStopAddingFiles {
        if (!f.isDirectory()) {
            this.addFileOnly(f, root);
        } else {
            File[] dirFiles = f.listFiles();
            for (int i = 0; i < dirFiles.length; ++i) {
                if (dirFiles[i].isDirectory()) {
                    this.addDirectoryFiles(dirFiles[i], root);
                    continue;
                }
                this.addFileOnly(dirFiles[i], root);
            }
        }
    }

    private final void addFileOnly(File f, File root) throws JUploadExceptionStopAddingFiles {
        if (!this.model.contains(f)) {
            this.model.addFile(f, root);
        }
    }

    public final FileData[] getFiles() {
        FileData[] files = new FileData[this.getFilesLength()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = this.model.getFileDataAt(i);
        }
        return files;
    }

    public final int getFilesLength() {
        return this.jtable.getRowCount();
    }

    public final void removeSelected() {
        int[] rows = this.jtable.getSelectedRows();
        for (int i = rows.length - 1; 0 <= i; --i) {
            this.model.removeRow(rows[i]);
        }
    }

    public final void removeAll() {
        for (int i = this.getFilesLength() - 1; 0 <= i; --i) {
            this.model.removeRow(i);
        }
    }

    public final void remove(FileData fileData) {
        this.model.removeRow(fileData);
    }

    public final void clearSelection() {
        this.jtable.clearSelection();
    }

    public final void focusTable() {
        if (0 < this.jtable.getRowCount()) {
            this.jtable.requestFocus();
        }
    }

    public FileData getFileDataAt(Point point) {
        int row = this.jtable.rowAtPoint(point);
        return this.model.getFileDataAt(row);
    }

    public Component getDropComponent() {
        return this;
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentResized(ComponentEvent arg0) {
        if (this.getWidth() > 0) {
            TableColumnModel colModel = this.jtable.getColumnModel();
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                colModel.getColumn(i).setPreferredWidth(this.model.getColumnSizePercentage(i) * this.scrollPane.getViewport().getWidth() / 100);
            }
        }
    }

    public void componentShown(ComponentEvent arg0) {
    }

    public void setGridBorderColor(Color color) {
        this.jtable.setGridColor(color);
    }

    public void setTableHeaderBackColor(Color color) {
        this.jtable.getTableHeader().setBackground(color);
    }

    public void setTableHeaderFont(Font font) {
        this.jtable.getTableHeader().setFont(font);
    }

    public void setTableHeaderTextColor(Color color) {
        this.jtable.getTableHeader().setForeground(color);
    }
}

