/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload.helper;

import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.HttpConnect;

public class HttpProtocolFinderThread
extends Thread {
    UploadPolicy uploadPolicy;
    String givenServerProtocol;

    public static void computeServerProtocol(UploadPolicy uploadPolicy, String givenServerProtocol) {
        new HttpProtocolFinderThread(uploadPolicy, givenServerProtocol).start();
    }

    public HttpProtocolFinderThread(UploadPolicy uploadPolicy, String givenServerProtocol) {
        super("HttpProtocolFinderThread");
        this.uploadPolicy = uploadPolicy;
        this.givenServerProtocol = givenServerProtocol;
    }

    public void run() {
        String computedProtocol = null;
        String postURL = this.uploadPolicy.getPostURL();
        if (null == this.givenServerProtocol || this.givenServerProtocol.equals("")) {
            if (null == postURL || postURL.equals("")) {
                this.uploadPolicy.displayErr("postURL not set");
                computedProtocol = "HTTP/1.1";
            } else if (postURL.substring(0, 3).equals("ftp")) {
                computedProtocol = "ftp";
            } else {
                try {
                    this.uploadPolicy.displayDebug("Getting serverProtocol from HEAD request", 30);
                    this.uploadPolicy.setServerProtocol("HTTP/1.1");
                    computedProtocol = new HttpConnect(this.uploadPolicy).getProtocol();
                }
                catch (Exception e) {
                    this.uploadPolicy.displayErr("Unable to access to the postURL: '" + postURL + "'", e);
                    computedProtocol = "HTTP/1.1";
                }
            }
        } else if (this.givenServerProtocol.startsWith("HTTP")) {
            try {
                this.uploadPolicy.displayDebug("Checking any redirect, from HEAD request", 30);
                this.uploadPolicy.setServerProtocol("HTTP/1.1");
                computedProtocol = new HttpConnect(this.uploadPolicy).getProtocol();
            }
            catch (Exception e) {
                this.uploadPolicy.displayErr("Unknown to get protocol in the given postURL (" + this.uploadPolicy.getPostURL() + "), due to error: " + e.getMessage(), e);
            }
        }
        this.uploadPolicy.setServerProtocol(computedProtocol);
    }
}

