/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.dataflow.server.batch;

import org.springframework.batch.core.JobExecution;

/**
 * Supports the base {@link JobExecution} attributes along with a step count.
 * @author Glenn Renfro
 *
 * @since 2.0
 */
public class JobExecutionWithStepCount extends JobExecution {

	private int stepCount;

	public JobExecutionWithStepCount(JobExecution original, int stepCount) {
		super(original);
		this.stepCount = stepCount;
	}

	public int getStepCount() {
		return stepCount;
	}

	public void setStepCount(int stepCount) {
		this.stepCount = stepCount;
	}
}
