<?php
defined( 'ABSPATH' ) || exit;

add_filter( 'ultp_addons_config', 'ultp_chatgpt_config' );
/**
 * ChatGPT Addon Config
 *
 * @param array $config Addon Config.
 * @return array
 */
function ultp_chatgpt_config( $config ) {
	$configuration          = array(
		'name'     => __( 'ChatGPT', 'ultimate-post' ),
		'desc'     => __( 'PostX brings the ChatGPT into the WordPress Dashboard to let you generate content effortlessly. ', 'ultimate-post' ),
		'img'      => ULTP_URL . 'assets/img/addons/ChatGPT.svg',
		'docs'     => 'https://wpxpo.com/docs/postx/add-on/chatgpt-addon/',
		'live'     => 'https://www.wpxpo.com/postx-chatgpt-wordpress-ai-content-generator/live_demo_args',
		'video'    => 'https://www.youtube.com/watch?v=NE4BPw4OTAA',
		'is_pro'   => false,
		'position' => 6
	);
	$config['ultp_chatgpt'] = $configuration;
	return $config;
}

add_action( 'init', 'ultp_chatgpt_init' );
function ultp_chatgpt_init() {
	$settings = isset( $GLOBALS['ultp_settings'] ) ? $GLOBALS['ultp_settings'] : array();
	if ( isset( $settings['ultp_chatgpt'] ) ) {
		add_filter( 'ultp_settings', 'get_chatgpt_settings', 10, 1 );
	}
}

function get_chatgpt_settings( $config ) {
	$arr = array(
		'ultp_chatgpt' => array(
			'label' => __( 'ChatGPT', 'ultimate-post' ),
			'attr'  => array(
				'chatgpt_heading'    => array(
					'type'  => 'heading',
					'label' => __( 'ChatGPT Settings', 'ultimate-post' ),
				),
				'chatgpt_secret_key' => array(
					'type'  => 'text',
					'label' => __( 'OpenAI API Secret Key', 'ultimate-post' ),
					'desc'  => __( 'For using ChatGPT addon, you have to add your OpenAI secret key.', 'ultimate-post' ),
					'link'  => __( 'https://platform.openai.com/account/api-keys' ),
					'linkText'  => __( 'Get key.', 'ultimate-post' ),
				),
				'chatgpt_model' => array(
                    'type'    => 'select',
                    'label'   => __( 'OpenAI Model', 'ultimate-post' ),
                    'desc'    => __( 'Choose your preferable OpenAI model', 'ultimate-post' ),
                    'options' => array(
                        'gpt-3.5-turbo' => 'gpt-3.5-turbo',
                        'text-davinci-002' => 'text-davinci-002',
                        'text-davinci-003' => 'text-davinci-003',
                        'gpt-4' => 'gpt-4',
                    ),
					'default' => 'gpt-3.5-turbo'
                ),
				'chatgpt_response_time' => array(
                    'type'     => 'number',
                    'label'   => __( 'Response Time', 'ultimate-post' ),
                    'desc'    => __( 'Choose your preferable OpenAI response time', 'ultimate-post' ),
                    'default' => 60
                ),
				'chatgpt_max_tokens' => array(
                    'type'     => 'number',
                    'label'   => __( 'Max Tokens', 'ultimate-post' ),
                    'desc'    => __( 'Choose your preferable OpenAI max Number of Tokens to be generated by ChatGPT', 'ultimate-post' ),
                    'default' => 400
                ),
			),
		),
	);
	return array_merge( $config, $arr );
}