#include <stdlib.h>
#include <stdio.h>

/*

  2013/04: d04.c, compiled with Borland C 2.0 in a DOS window.

  This program generates the 64 kB binary image for the D04
  CRT\LCD controller 27512 control ROM.

  A 15 Bit counter feeds the ROM address lines,
  the ROM then generates display address
  and sync/control signals.

  50 Hz vertical, 15.625 kHz horizontal sync.

  The program is sort of a crude hack, sorry for this.
  But I don't have the _time_ to clean up this mess now.


  BTW:
   One line to be displayed has 64 clock cycles (1 us each) per line.
   The number of characters displayed per line is a multiple of 8.
   The lookup table starts with the first visibe character on the screen.
  Else, D04 won't work !

  Good luck.

*/

int main(void)
{
  FILE *outstream;

  long ra,x,y;
  long zeile,spalte;
  long block,adr;
  long i;
  char ctl;

  int hsync,vsync,sync,de,rc,vs1;

  outstream=fopen("d04.bin","wb");
  if(outstream==0) return(-1);

//  clrscr();
  printf("\n");

  // lower 32 kB block in the ROM: display address

  ra=0; zeile=0; spalte=0; adr=0; block=0;
  for(i=0;i<0x08000;i++)
  {
    fputc((char)adr,outstream);
    if(spalte<40)
    {
      if(zeile<25*8)
      {
	if((spalte&7)==7) adr++;
      }
    }

    spalte++;
    if(spalte>=64)
    {
      spalte=0;
      zeile++;
      ra++;
      if(ra>=8)
      {
	ra=0; block=adr;
      }
      else
      {
	adr=block;
      }
    }
  }

  printf("\n\n");

  // upper 32 kB block in the ROM: sync/control signals

  ra=0; zeile=0; spalte=0; vs1=0;
  for(i=0;i<0x08000;i++)
  {
    hsync=0; vsync=0; sync=0; de=0; rc=0;

    if(zeile==0) vsync=-1;

    if((spalte>=48)&&(spalte<=48+5))
    {
      sync=-1;
      if((zeile>=256)&&(zeile<=256+5)) {vs1=-1;} else {vs1=0;}
    }
    if((zeile<240)&&((spalte>=48)&&(spalte<=48+5))) hsync=-1;

    if((zeile<240)&&(spalte<40)) de=-1;

    if((zeile==311)&&(spalte==63)) rc=-1;
    if(zeile>=312) rc=-1;

    ctl=ra&7;
    ctl|=0x08 & de;
    ctl|=0x10 & (sync|vs1);
    ctl|=0x20 & hsync;
    ctl|=0x40 & vsync;
    ctl|=0x80 & rc;

     fputc(ctl,outstream);

    spalte++;
    if(spalte>=64)
    {
      spalte=0;
      zeile++;
      ra++;
      if(ra>=8)
      {
	ra=0;
      }
    }
  }

  fclose(outstream);
  return(0);
}
