#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*---------------------------------------------------------------------*
 * (c) Dieter Mueller 2003                                             *
 *---------------------------------------------------------------------*/

int main(void);

int main(void)
{
 unsigned long i,j;
 char string[40];

 FILE *instream;
 FILE *outstream_C;
 FILE *outstream_X;
 FILE *outstream_H;
 FILE *outstream_M;
 FILE *outstream_L;


 printf("\nMicrocode splitter for M1 CPU");
 printf("\n m1_*.bin   -> m1code.bin");
 printf("\n m1code.bin -> m1l.bin m1m.bin m1h.bin m1x.bin");

 /*-------------------------------------------------------------------*/

 sprintf(string,"m1code.bin");
 printf("\nOpening Output File '%s'", string);
 outstream_C = fopen(string, "wb");

 if(outstream_H == NULL)
 {
	printf(" Error.\n");
	exit(1);
 }

 for(i=0; i<8; i++)
 {
	sprintf(string,"m1_%c.bin",0x30+i);
	printf("\nOpening Input  File '%s'", string);
	instream = fopen(string, "rb");

	if(instream == NULL)
	{
	  printf(" Error.\n");
	  exit(1);
	}

	for(j=0; j<32768; j++)
	{
	  fputc(fgetc(instream),outstream_C);
	}

	fclose(instream);
	printf("done.");
 }

 fclose(outstream_C);
 printf("\n\nMicrocode completed.");
 printf("\nNow to break it into ROM files.");
 printf("\n\n");

 /*-------------------------------------------------------------------*/

 sprintf(string,"m1code.bin");
 printf("\nOpening Input  File '%s'", string);
 instream = fopen(string, "rb");

 if(instream == NULL)
 {
	printf(" Error.\n");
	exit(1);
 }

 sprintf(string,"m1X.bin");
 printf("\nOpening Output File '%s'", string);
 outstream_X = fopen(string, "wb");

 if(outstream_X == NULL)
 {
	printf(" Error.\n");
	exit(1);
 }

 sprintf(string,"m1H.bin");
 printf("\nOpening Output File '%s'", string);
 outstream_H = fopen(string, "wb");

 if(outstream_H == NULL)
 {
	printf(" Error.\n");
	exit(1);
 }

 sprintf(string,"m1M.bin");
 printf("\nOpening Output File '%s'", string);
 outstream_M = fopen(string, "wb");

 if(outstream_M == NULL)
 {
	printf(" Error.\n");
	exit(1);
 }

 sprintf(string,"m1L.bin");
 printf("\nOpening Output File '%s'", string);
 outstream_L = fopen(string, "wb");

 if(outstream_L == NULL)
 {
	printf(" Error.\n");
	exit(1);
 }

 for(j=0; j<0x10000; j++)
 {
        fputc(fgetc(instream), outstream_X);
	fputc(fgetc(instream), outstream_H);
	fputc(fgetc(instream), outstream_M);
	fputc(fgetc(instream), outstream_L);
 }


 fclose(instream);
 fclose(outstream_X);
 fclose(outstream_H);
 fclose(outstream_M);
 fclose(outstream_L);

 printf("\nDone.\n");

 return(0);
}

