;============================================================================
;                         |
; m1code.asm    V1.13     | free for hobby use, but not free of errors.
;                         | 
; microcode for M01,M02.  | EXPERIMENTAL and not well documented.
;                         | NO WARRANTY on whatsoever.
; (c) Dieter Mueller      | you have been warned, so don't complain.
;                         | DO NOT USE it for commercial/military/LiveSupport
; 2002,2003               | applications WITHOUT MY WRITTEN PERMISSION.
;                         |
;============================================================================
;
;11/2003: fixed bug in NMI: push PCH
;
;08/2003: removed the long list of fixed bugs.
;08/2003: removed the boring story about why I started this project.
;
;you may need the AS MacroAssembler from Alfred Arnold to generate binaries.
;
;the AS assembler can only generate 32 kBytes *.bin files.
;so we compile it 8 times with diferent switches
;and put the result together... later.
;
;============================================================================
;Registers
;
;
;   23       15       7      0
;   .        .        .      .
;   .        .        .      .
;   .        .        --------
;   .        .       |NV-BDIZC|  Flags
;   .        .        --------
;   .        .
;   .        .        --------
;   .        .       |   X    |  Index Register X
;   .        .        --------
;   .        .       |   Y    |  Index Register Y
;   .        -------- --------
;   .       |   B    |   A    |  Accumulator (two, 8 Bit each.)
;   .        -------- --------
;   .                  
;   .        -------- --------
;   .       |   DH   |   00   |  Direct Register
;   .        -------- --------
;   .       |   01   |   SPL  |  Stack Pointer
;   .        -------- --------
;   .       |   PCH  |   PCL  |  Program Counter
;   .        -------- --------
;   .
;   --------
;  |   PBR  |                    Program Bank Register
;   --------
;  |   DBR  |                    Data    Bank Register
;   --------
;
;
;----------------------------------------------------------------------------
;List of OPcodes

;  0123456789ABCDEF

;0 **R#+**#***#+**#
;1 **+#+**#**+#+**#
;2 **##***#***#***#
;3 **+#+**#**+#+**#
;4 **R#M**#***#***#
;5 **+#M**#**+##**#
;6 **##+**#***#***#
;7 **+#+**#**+#+**#
;8 **##***#*+*#***#
;9 **+#***#***#+**#
;A ***#***#***#***#
;B **+#***#***#***#
;C **##***#***M***#
;D **+##**#**+M#**#
;E **##***#***#***#
;F **+##**#**+R#**#

 
;* = 6502
;+ = 65C02
;# = 65C816
;R = 65C816 reserved: COP, WDM, XCE cause a BRK

;M = M02    $44: LTB Z: load Byte (X:Y:A) into Z
;M = M02    $54: ATB Z: add  Byte (X:Y:A) to Z with Carry
;M = M01    $CB: DYB:   decrement Y, branch if not zero
;M = M01    $DB: DXB:   decrement X, branch if not zero

;255 OPcodes used.
;----------------------------------------------------------------------------


;ADC #
;ADC ABS
;ADC ABSl       [65C816]
;ADC ABS,X
;ADC ABS,Y
;ADC ABSl,X     [65C816]
;ADC d,S        [65C816]
;ADC (d,S),Y    [65C816]
;ADC (IND)      [65C02]
;ADC (IND,X)
;ADC (IND),Y
;ADC [IND]      [65C816]
;ADC [IND],Y    [65C816]
;ADC Z
;ADC Z,X

;AND #
;AND ABS
;AND ABSl       [65C816]
;AND ABS,X
;AND ABS,Y
;AND ABSl,X     [65C816]
;AND d,S        [65C816]
;AND (d,S),Y    [65C816]
;AND (IND)      [65C02]
;AND (IND,X)
;AND (IND),Y
;AND [IND]      [65C816]
;AND [IND],Y    [65C816]
;AND Z
;AND Z,X

;ASL A
;ASL ABS
;ASL ABS,X
;ASL Z
;ASL Z,X

;BCC   
;BCS    
;BEQ   

;BIT #          [65C02]
;BIT ABS
;BIT ABS,X      [65C02]
;BIT Z
;BIT Z,X        [65C02]

;BMI   
;BNE  
;BPL   
;BRK
;BRA            [65C02]
;BRL            [65C816]
;BVC
;BVS    

;CLC
;CLD
;CLI
;CLV

;CMP #
;CMP ABS
;CMP ABSl       [65C816]
;CMP ABS,X
;CMP ABS,Y
;CMP ABSl,X     [65C816]
;CMP d,S        [65C816]
;CMP (d,S),Y    [65C816]
;CMP (IND)      [65C02]
;CMP (IND,X)
;CMP (IND),Y
;CMP [IND]      [65C816]
;CMP [IND],Y    [65C816]
;CMP Z
;CMP Z,X

;CPX #
;CPX ABS
;CPX Z

;CPY #
;CPY ABS
;CPY Z

;DEC A          [65C02]
;DEC ABS
;DEC ABS,X
;DEC Z
;DEC Z,X
;DEX
;DEY
;DXB            [M01]  ;decrement X and branch if not zero (2 Bytes OPcode)
;DYB            [M01]  ;decrement Y and branch if not zero (2 Bytes OPcode)

;EOR #
;EOR ABS
;EOR ABSl       [65C816]
;EOR ABS,X
;EOR ABS,Y
;EOR ABSl,X     [65C816]
;EOR d,S        [65C816]
;EOR (d,S),Y    [65C816]
;EOR (IND)      [65C02]
;EOR (IND,X)
;EOR (IND),Y
;EOR [IND]      [65C816]
;EOR [IND],Y    [65C816]
;EOR Z
;EOR Z,X

;INC A          [65C02]
;INC ABS
;INC ABS,X
;INC Z
;INC Z,X
;INX
;INY

;JML ABSL
;JML (ABSL)
;JMP ABS
;JMP (ABS)
;JMP (ABS,X)    [65C02]
;JSL ABSL
;JSR ABS
;JSR (ABS,X)    [65C816]

;LDA #
;LDA ABS
;LDA ABSl       [65C816]
;LDA ABS,X
;LDA ABS,Y
;LDA ABSl,X     [65C816]
;LDA d,S        [65C816]
;LDA (d,S),Y    [65C816]
;LDA (IND)      [65C02]
;LDA (IND,X)
;LDA (IND),Y
;LDA [IND]      [65C816]
;LDA [IND],Y    [65C816]
;LDA Z
;LDA ABS,Y

;LDX #
;LDX ABS
;LDX ABS,Y
;LDX Z
;LDX Z,Y

;LDY #
;LDY ABS
;LDY ABS,X
;LDY Z
;LDY Z,X

;LSR A
;LSR ABS
;LSR ABS,X
;LSR Z
;LSR Z,X

;ATB Z          [M02]
;LTB Z          [M02]

;NOP

;ORA #
;ORA ABS
;ORA ABSl       [65C816]
;ORA ABS,X
;ORA ABS,Y
;ORA ABSl,X     [65C816]
;ORA d,S        [65C816]
;ORA (d,S),Y    [65C816]
;ORA (IND)      [65C02]
;ORA (IND,X)
;ORA (IND),Y
;ORA [IND]      [65C816]
;ORA [IND],Y    [65C816]
;ORA Z
;ORA Z,X

;PEA            [65C816]
;PEI            [65C816]
;PER            [65C816]
;PHA
;PHB            [65C816]
;PHK            [65C816]
;PHP
;PHX            [65C02]
;PHY            [65C02]
;PLA
;PLB            [65C816]
;PLX            [65C02]
;PLY            [65C02]       
;PLP

;REP            [65C816]

;ROL A
;ROL ABS
;ROL ABS,X
;ROL Z
;ROL Z,X

;ROR A
;ROR ABS
;ROR ABS,X
;ROR Z
;ROR Z,X

;RTI
;RTL            [65C816]
;RTS

;SBC #
;SBC ABS
;SBC ABSl       [65C816]
;SBC ABS,X
;SBC ABS,Y
;SBC ABSl,X     [65C816]
;SBC d,S        [65C816]
;SBC (d,S),Y    [65C816]
;SBC (IND)      [65C02]
;SBC (IND,X)
;SBC (IND),Y
;SBC [IND]      [65C816]
;SBC [IND],Y    [65C816]
;SBC Z
;SBC Z,X

;SEC
;SED
;SEI
;SEP            [65C816]

;STA ABS
;STA ABSl       [65C816]
;STA ABS,Y
;STA ABS,X
;STA ABSl,X     [65C816]
;STA d,S        [65C816]
;STA (d,S),Y    [65C816]
;STA (IND)      [65C02]
;STA (IND,X)
;STA (IND),Y
;STA [IND]      [65C816]
;STA [IND],Y    [65C816]
;STA Z
;STA Z,X

;STX Z
;STX ABS
;STX Z,Y

;STY Z
;STY ABS
;STY Z,X

;STZ ABS        [65C02]
;STZ ABS,X      [65C02]
;STZ Z          [65C02]
;STZ Z,X        [65C02]

;TAX
;TAY
;TCD            [65C816]
;TCS            [65C816]
;TDC            [65C816]

;TRB Z          [65C02]
;TRB ABS        [65C02]
;TSB Z          [65C02]
;TSB ABS        [65C02]

;TSC            [65C816]
;TSX
;TXA
;TXS
;TXY            [65C816]
;TYA
;TYX            [65C816]

;XBA            [65C816]


;============================================================================
;and now to start the synapses firing...

;abused a 68000 MacroAssembler, build the entire thing with DC.L and macros.
;Assembler used: AS from Alfred Arnold.
;============================================================================


        CPU     68000 ;because DC.L is used to build the Microcode.


;----------------------------------------------------------------------------
;load Buffers from/to ext. Bus

WE              EQU     $00000000 ;write ext. Data Bus
RD              EQU     $00200000 ;read  ext. Data Bus
AS              EQU     $00400000 ;valid Address on ext. Address Bus

LD_AL           EQU     $00010000 ;load addr. Buffer 0..7  (74LS373)
LD_AH           EQU     $00020000 ;load addr. Buffer 8..15 (74LS373)
LD_D            EQU     $00040000 ;load data Buffer (r/w: 74LS373)

LD_TC           EQU     $00002000 ;load carry from previous addition into temp.carry

LD_CMD          EQU     $00800000 ;load next OpCode into MicrocodeSequencer

LD_PBR          EQU     $01000000 ;load Program Bank Register
LD_0BR          EQU     $02000000 ;load Data    Bank Register
LD_TBR          EQU     $04000000 ;load Temp    Bank Register

OE_PBR          EQU     $28000000 ;A16..23 = PBR
OE_0BR          EQU     $18000000 ;A16..23 = DBR
OE_TBR          EQU     $38000000 ;A16..23 = TBR

;----------------------------------------------------------------------------
;registers, one Input (ID) of the ALU

;WARNING: thou shalt not use the registers TMP and TMPH at the same time...
;         because they have the same address.

;Bit 2^15 = 01 -> Load Flag Register (74LS374)

;read registers

RR_NULL         EQU     $000000 ;/dev/null. used, if you don't want to read.
RR_ACC          EQU     $000001 ;Accu           A
RR_BETA         EQU     $000002 ;Accu           B
RR_XR           EQU     $000003 ;Index Register X
RR_YR           EQU     $000004 ;Index Register Y
RR_SP           EQU     $000005 ;Stack Pointer  SP
RR_PCL          EQU     $000006 ;ProgramCounter PCL Bit 0..7
RR_PCH          EQU     $000007 ;ProgramCounter PCH Bit 8..15
RR_DRH          EQU     $000008 ;Direct Register H
RR_TMPL         EQU     $000009 ;Temp. Addr.        Bit 0..7
RR_TMPH         EQU     $00000A ;Temp. Addr.        Bit 8..15
RR_TMP          EQU     $00000A ;Temp. Data
RR_TPIL         EQU     $00000B ;Temp. Addr.        Bit 0..7  (IND,X)/(IND),Y
RR_TPIH         EQU     $00000C ;Temp. Addr.        Bit 8..15 (IND,X)/(IND),Y
RR_DBR          EQU     $00000D ;Program Bank Register
RR_PBR          EQU     $00000E ;Data    Bank Register
RR_FLAG         EQU     $00000F ;Flags

;write registers

WR_NULL         EQU     $008000 ;/dev/null. used, if you don't want to write.
WR_ACC          EQU     $008010 ;Accu           A
WR_BETA         EQU     $008020 ;Accu           B
WR_XR           EQU     $008030 ;Index Register X
WR_YR           EQU     $008040 ;Index Register Y
WR_SP           EQU     $008050 ;Stack Pointer  SP
WR_PCL          EQU     $008060 ;ProgramCounter PCL Bit 0..7
WR_PCH          EQU     $008070 ;ProgramCounter PCH Bit 8..15
WR_DRH          EQU     $008080 ;Direct Register H
WR_TMPL         EQU     $008090 ;Temp. Addr.        Bit 0..7
WR_TMPH         EQU     $0080A0 ;Temp. Addr.        Bit 8..15
WR_TMP          EQU     $0080A0 ;Temp. Data
WR_TPIL         EQU     $0080B0 ;Temp. Addr.        Bit 0..7  (IND,X)/(IND),Y
WR_TPIH         EQU     $0080C0 ;Temp. Addr.        Bit 8..15 (IND,X)/(IND),Y
WR_DBR          EQU     $0080D0 ;Program Bank Register
WR_PBR          EQU     $0080E0 ;Data    Bank Register
WR_FLAG         EQU     $0000F0 ;write into RAM and load Flag register.

;----------------------------------------------------------------------------
;ALU commands

;2^19 = 0:  feed Byte from ext. DataBus Buffer into ALU (IX)
;2^20 = 0:  read Sign extended value, generated  from IX.7 of prev. cycle
;
;2^19 = 1,  2^20 = 1: read temp flags from prev. cycle result
;
;2^19 = 0.  2^20 = 0: illegal. makes two 74LS.. work against each other.

;2^15 = 01: load Flag register

;2^14 = 1:  clear temp. carry from prev. cycle

;2^13 = 1:  load carry from previous addition into temp carry
;           (used for address calculations)


OE_TF           EQU     $180000 ;IX = temp.flags

;
ALU_NOP         EQU     $100000 ;pass register trough

;pass
ALU_PASS_ID     EQU     $100000 ;pass (register)RAM data trough ALU
ALU_PASS_IX     EQU     $100100 ;pass ext. DataBus read Buffer trough ALU
ALU_PASS_SX     EQU     $080100 ;pass ext. DataBus sign extend trough ALU

;arithmetic 
ALU_ADC         EQU     $100200
ALU_SBC         EQU     $100300 ;also used for CMP
ALU_INC         EQU     $100400
ALU_DEC         EQU     $100500

;address calculation
ALU_ADDA        EQU     $104600 ;add without previous carry 
ALU_ADDAC       EQU     $100600 | LD_TC ;add with    previous carry
ALU_ADDAX       EQU     $080600 | LD_TC ;add sign ext. value + prev. carry
ALU_ADD0C       EQU     $100700 | LD_TC ;add 0 plus  previous carry 
ALU_ADD0NC      EQU     $100700 

;shift
ALU_ASL         EQU     $100800
ALU_LSR         EQU     $100900
ALU_ROL         EQU     $100A00
ALU_ROR         EQU     $100B00

;logic
ALU_AND         EQU     $100C00
ALU_OR          EQU     $100D00
ALU_XOR         EQU     $100E00
ALU_XORX        EQU     $080E00 ;used by TRB ;XOR with sign ext.
ALU_BIT         EQU     $100F00

;constants (for address generation)
;inputs of the ALU are unimportant... reading ext. DataBus as default.
ALU_C_00        EQU     $101000
ALU_C_01        EQU     $101100
ALU_C_FA        EQU     $101200
ALU_C_FC        EQU     $101300
ALU_C_FE        EQU     $101400
ALU_C_FF        EQU     $101500

;set/clear Flags (yes, the Flag register IS a register like all the others.)
;IX-Input of the ALU is unimportant... reading ext. DataBus as default.
ALU_CLC         EQU     $101600 ;clear C
ALU_SEC         EQU     $101700 ;set   C
ALU_CLICLB      EQU     $101800 ;clear I, clear B
ALU_SEICLB      EQU     $101900 ;set   I, clear B
ALU_CLD         EQU     $101A00 ;clear D
ALU_SED         EQU     $101B00 ;set   D
ALU_SEB         EQU     $101C00 ;set   B (BRK command)
ALU_CLV         EQU     $101D00 ;clear V

;modify Flags, according to the result of the previous operation
;also feed the Temp Flags into the ALU (IX), 2^19 = 0 and 2^20 = 0
ALU_MNZC        EQU     $181E00 ;modify N,Z,C   (logic op. feeds C trough ALU)
ALU_MNZCV       EQU     $181F00 ;modify N,Z,C,V 


;----------------------------------------------------------------------------

;reset CPU
;
M_RES   macro

 ;reset Bank Registers (A16..23)
 DC.L    OE_0BR | RD | ALU_C_00    | RR_NULL | WR_PBR  | LD_PBR             
 DC.L    OE_PBR | RD | ALU_C_00    | RR_NULL | WR_DBR  | LD_TBR             

 ;init flags (we use Bit 2^4, to set Bit 2^5)                        
 DC.L    OE_PBR | RD | ALU_C_00    | RR_NULL | WR_FLAG | LD_0BR ;clear flags
 DC.L    OE_PBR | RD | ALU_SEB     | RR_FLAG | WR_FLAG                      
 DC.L    OE_PBR | RD | ALU_INC     | RR_FLAG | WR_FLAG         

 ;reset Direct Register
 DC.L    OE_PBR | RD | ALU_C_00    | RR_NULL | WR_DRH                       

 ;read vector
 DC.L    OE_PBR | RD | ALU_C_FC    | RR_NULL | WR_TMPL | LD_AL       ;vector LO
 DC.L    OE_PBR | RD | ALU_C_FF    | RR_NULL | WR_TMPH | LD_AH       ;vector HI       
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_PCL                ;set PCL
 DC.L    OE_PBR | RD | ALU_INC     | RR_TMPL | WR_TMPL | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_TMPH | WR_TMPH | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read HI
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_PCH                ;set PCH

 DC.L    OE_PBR | RD | ALU_SEICLB  | RR_NULL | WR_FLAG          ;disable IRQ

 ;jump
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_AL
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm
;


;NMI
;
M_NMI   macro

 ;stack      
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 ;push PBR
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PBR  | WR_NULL | LD_D        ;PBR
 DC.L    OE_0BR | WE | ALU_C_00    | RR_NULL | WR_PBR  | LD_PBR | AS ;PBR=0

 ;push PCH
 DC.L    OE_0BR | RD | ALU_DEC     | RR_SP   | WR_SP   | LD_AL      ;SP--
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_D       ;PCH
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL |         AS ;PCH

 ;push PCL                 
 DC.L    OE_0BR | RD | ALU_DEC     | RR_SP   | WR_SP   | LD_AL      ;SP--
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_D       ;PCL
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL |         AS ;PCL

 ;push flags                        
 DC.L    OE_0BR | RD | ALU_DEC     | RR_SP   | WR_SP   | LD_AL      ;SP--
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_FLAG | WR_NULL | LD_D       ;FLAG
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--

 ;read vector, jump, disable IRQ
 DC.L    OE_0BR | RD | ALU_C_FA    | RR_NULL | WR_TMPL | LD_AL       ;vector LO
 DC.L    OE_0BR | RD | ALU_C_FF    | RR_NULL | WR_TMPH | LD_AH       ;vector HI       
 DC.L    OE_0BR | RD | ALU_SEICLB  | RR_FLAG | WR_FLAG | LD_D   | AS ;read LO
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCL                ;set PCL
 DC.L    OE_0BR | RD | ALU_INC     | RR_TMPL | WR_TMPL | LD_AL
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read HI
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCH  | LD_AH       ;set PCH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_AL

 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm
;


;
;IRQ
;
M_IRQ   macro

 ;stack      
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 ;push PBR
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PBR  | WR_NULL | LD_D        ;PBR
 DC.L    OE_0BR | WE | ALU_C_00    | RR_NULL | WR_PBR  | LD_PBR | AS ;PBR=0

 ;push PCH               
 DC.L    OE_0BR | RD | ALU_DEC     | RR_SP   | WR_SP   | LD_AL      ;SP--
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_D       ;PCH
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL |         AS ;PCH

 ;push PCL
 DC.L    OE_0BR | RD | ALU_DEC     | RR_SP   | WR_SP   | LD_AL      ;SP--
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_D       ;PCL
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL |         AS ;PCL

 ;push flags with B-Flag = 0
 DC.L    OE_0BR | RD | ALU_DEC     | RR_SP   | WR_SP   | LD_AL      ;SP--
 DC.L    OE_0BR | WE | ALU_CLICLB  | RR_FLAG | WR_NULL | LD_D       ;FLAG
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--

 ;read vector, jump,disable IRQ
 DC.L    OE_0BR | RD | ALU_C_FE    | RR_NULL | WR_TMPL | LD_AL       ;vector LO
 DC.L    OE_0BR | RD | ALU_C_FF    | RR_NULL | WR_TMPH | LD_AH       ;vector HI       
 DC.L    OE_0BR | RD | ALU_SEICLB  | RR_FLAG | WR_FLAG | LD_D   | AS ;read LO
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCL                ;set PCL
 DC.L    OE_0BR | RD | ALU_INC     | RR_TMPL | WR_TMPL | LD_AL
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read HI
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCH  | LD_AH       ;set PCH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_AL

 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm
;


;BRK
;
M_BRK   macro

 ;PC++
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL
 DC.L    OE_0BR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH
 ;PC++
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL
 DC.L    OE_0BR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH
 ;push PBR  
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PBR  | WR_NULL | LD_D        ;PBR
 DC.L    OE_0BR | WE | ALU_C_00    | RR_NULL | WR_PBR  | LD_PBR | AS ;PBR=0

 ;push PCH                
 DC.L    OE_0BR | RD | ALU_DEC     | RR_SP   | WR_SP   | LD_AL      ;SP--
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_D       ;PCH
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL |         AS ;PCH

 ;push PCL
 DC.L    OE_0BR | RD | ALU_DEC     | RR_SP   | WR_SP   | LD_AL      ;SP--
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_D       ;PCL
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL |         AS ;PCL

 ;push flags with B-Flag = 1
 DC.L    OE_0BR | RD | ALU_DEC     | RR_SP   | WR_SP   | LD_AL      ;SP--
 DC.L    OE_0BR | WE | ALU_SEB     | RR_FLAG | WR_NULL | LD_D       ;FLAG
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--

 ;read vector, jump
 DC.L    OE_0BR | RD | ALU_C_FE    | RR_NULL | WR_TMPL | LD_AL       ;vector LO
 DC.L    OE_0BR | RD | ALU_C_FF    | RR_NULL | WR_TMPH | LD_AH       ;vector HI       
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCL                ;set PCL
 DC.L    OE_0BR | RD | ALU_INC     | RR_TMPL | WR_TMPL | LD_AL
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read HI
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCH  | LD_AH       ;set PCH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_AL

 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm
;


;RTI
;
M_RTI   macro

 ;pop flags
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;FLAG
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_FLAG

 ;pop PCL
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;PCL 
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCL 

 ;pop PCH
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;PCH 
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCH 

 ;pop PBR
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;PBR 
 ;load address latch
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PBR  | LD_PBR
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_AH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_AL
 ;get next OPcode
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm
;


;RTS
;
M_RTS   macro

 ;pop PCL
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_C_00    | RR_NULL | WR_TMP  | LD_D  | AS ;PCL
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCL         

 ;pop PCH
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_D  | AS ;PCL++, PCH
 DC.L    OE_0BR | RD | ALU_ADDAC   | RR_TMP  | WR_PCH  | LD_AH      ;inc PCH ?
 ;jump          
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm
;

;RTL
;
M_RTL   macro

 ;pop PCL
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_C_00    | RR_NULL | WR_TMP  | LD_D  | AS ;PCL
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCL         

 ;pop PCH
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_D  | AS ;PCL++, PCH
 DC.L    OE_0BR | RD | ALU_ADDAC   | RR_TMP  | WR_PCH               ;inc PCH ?

 ;pop PBR
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;PCL++, PCH
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PBR  | LD_PBR     ;inc PCH ?

 ;jump
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_AH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_AL
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm
;

M_JSR   macro

 ;get dest.Addr. into TMPL,TMPH, push PCL,PCH

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read LO
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read HI
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;HI Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH

 ;//optimized for speed
 ;push PCH
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_D       ;   
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--
 ;push PCL
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_D       ;   
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--

 ;set new PC
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_TMPH | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_TMPL | WR_PCL  | LD_AL

 ;fetch OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode    

        endm
;

M_JSRL  macro

 ;get dest.Addr. into TMPL,TMPH, push PCL,PCH

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read LO
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read HI
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;HI Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Bank
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;Bank   
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TPIH           

 ;//optimized for speed
 ;push PCH
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PBR  | WR_NULL | LD_D       ;   
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--
 ;push PCH
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_D       ;   
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--
 ;push PCL
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_D       ;   
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--

 ;set new PC
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_TPIH | WR_PBR  | LD_PBR
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_TMPH | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_TMPL | WR_PCL  | LD_AL

 ;fetch OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode    

        endm
;

;----------------------------------------------------------------------------

;jump $6C, 'near'
;
M_JMPI  macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read LO
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TBR ;LO Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read HI
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;HI Byte

 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH | LD_AH       ;set addr
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

 ;TMPL, TMPH, ADL, ADH already set.

 ;read LO Byte
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCL                ;temp    

 ;Pointer ++
 DC.L    OE_0BR | RD | ALU_INC     | RR_TMPL | WR_NULL | LD_AL
 DC.L    OE_0BR | RD | ALU_ADD0C   | RR_TMPH | WR_NULL | LD_AH

 ;read HI Byte
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCH  | LD_AH       ;temp    

 ;set PC LOW ADDRESS
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_AL

 ;fetch OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode    

        endm


;jump $DC, 'far'
;
M_JMPIL macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read LO
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read HI
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;HI Byte

 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH | LD_AH       ;set addr
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

 ;TMPL, TMPH, ADL, ADH already set.

 ;read LO Byte
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCL                ;temp    

 ;Pointer ++
 DC.L    OE_0BR | RD | ALU_INC     | RR_TMPL | WR_NULL | LD_AL
 DC.L    OE_0BR | RD | ALU_ADD0C   | RR_TMPH | WR_NULL | LD_AH

 ;read HI Byte
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PCH                ;temp    

 ;Pointer ++
 DC.L    OE_0BR | RD | ALU_INC     | RR_TMPL | WR_NULL | LD_AL
 DC.L    OE_0BR | RD | ALU_ADD0C   | RR_TMPH | WR_NULL | LD_AH

 ;read Bank        
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_PBR  | LD_PBR      ;temp    

 ;set PC               
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_AH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_AL

 ;fetch OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode    

        endm


;jump/load PC, 'near'
;
M_JMP   macro

 ;PC++         
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

 ;read LO Byte
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL               ;temp    

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

 ;read HI Byte
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read HI
 ;set PCH
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_PCH  | LD_AH       ;set PCH
 ;set PCL
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_TMPL | WR_PCL  | LD_AL       ;set PCH

 ;fetch OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode    

        endm


;jump/load PC, 'far'
;
M_JMPL  macro

 ;PC++         
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

 ;read LO Byte
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL               ;temp    

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

 ;read HI Byte
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read LO
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH               ;temp    

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

 ;read Bank     
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read HI
 ;set Bank
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_PBR  | LD_PBR    
 ;set PCH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_TMPH | WR_PCH  | LD_AH       ;set PCH
 ;set PCL
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_TMPL | WR_PCL  | LD_AL       ;set PCH

 ;fetch OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode    

        endm


;PC++, fetch next OpCode
;
M_NEXT  macro bank   

 DC.L    bank   | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm

;PC++
;
M_INCPC macro

 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

        endm


;get OP, modify flags
;
M_GTOPF macro   alucmd

 DC.L    OE_PBR | RD | alucmd      | RR_FLAG | WR_FLAG | LD_CMD | AS ;OpCode

        endm
;


;load temp and address Bus latches with
;ABS
;
M_ABS   macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read LO
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TBR ;LO Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read HI
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;HI Byte

 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;ABSL
;
M_ABSL  macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read LO
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read HI
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;HI Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Bank
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;Bank   

 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_NULL | LD_TBR      ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPH | WR_NULL | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;Z  
;
M_Z     macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Byte
 DC.L    OE_PBR | RD | ALU_C_00    | RR_NULL | WR_NULL | LD_D   | AS | LD_TBR ;Byte

 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DRH  | WR_TMPH | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL | LD_AL

        endm


;load temp and address Bus latches with
;ABS,X
;
M_ABSX  macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;fetch LO-Byte
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 ;take care, LO_Byte still in latch.

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;address points to HI-Byte
 ;take care, LO_Byte still in latch.

 ;calculate TMPL addr.
 DC.L    OE_PBR | RD | ALU_ADDA    | RR_XR   | WR_TMPL      
 ;and latch temp. carry of this addition with the next cycle
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TC | LD_TBR
 ;read HI-Byte from Bus
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH               | LD_TC

 ;now to calculate the TMPH addr.
 DC.L    OE_TBR | RD | ALU_ADD0C   | RR_TMPH | WR_TMPH | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;ABSXL
;
M_ABSXL macro             

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;fetch LO-Byte
 DC.L    OE_PBR | RD | ALU_C_00    | RR_NULL | WR_TPIH | LD_D   | AS ;LO Byte
 ;take care, LO_Byte still in latch.

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;address points to HI-Byte
 ;take care, LO_Byte still in latch.

 ;calculate TMPL addr.
 DC.L    OE_PBR | RD | ALU_ADDA    | RR_XR   | WR_TMPL      
 ;and latch temp. carry of this addition with the next cycle
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS | LD_TC
 ;read HI-Byte from Bus
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH              
 DC.L    OE_PBR | RD | ALU_ADD0NC  | RR_TMPH | WR_TMPH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_TC ;architecture.
 DC.L    OE_PBR | RD | ALU_ADD0NC  | RR_TPIH | WR_TPIH

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;Bank
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte

 ;now to calculate the Bank      
 DC.L    OE_PBR | RD | ALU_ADDA    | RR_TPIH | WR_TPIH | LD_TBR      ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPH | WR_NULL | LD_AH
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;ABS,Y
;
M_ABSY  macro

 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 ;take care, LO_Byte still in latch.

 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;address points to HI-Byte
 ;take care, LO_Byte still in latch.

 ;calculate TMPL addr.
 DC.L    OE_PBR | RD | ALU_ADDA    | RR_YR   | WR_TMPL      
 ;and latch temp. carry of this addition with the next cycle
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TC | LD_TBR
 ;read HI-Byte from Bus
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH               | LD_TC

 ;now to calculate the TMPH addr.
 DC.L    OE_TBR | RD | ALU_ADD0C   | RR_TMPH | WR_TMPH | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;dS 
;
M_dS    macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Byte
 DC.L    OE_PBR | RD | ALU_C_00    | RR_NULL | WR_NULL | LD_D   | AS | LD_TBR ;Byte

 DC.L    OE_PBR | RD | ALU_C_01    | RR_NULL | WR_TMPH | LD_AH
 DC.L    OE_TBR | RD | ALU_ADDA    | RR_SP   | WR_TMPL | LD_AL  ;add offset

        endm

;load temp and address Bus latches with
;Z,X
;
M_ZX    macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Byte
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TBR ;Byte

 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DRH  | WR_TMPH | LD_AH
 DC.L    OE_TBR | RD | ALU_ADDA    | RR_XR   | WR_TMPL | LD_AL

        endm


;load temp and address Bus latches with
;Z,Y
;
M_ZY    macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Byte
 DC.L    OE_PBR | RD | ALU_C_00    | RR_NULL | WR_NULL | LD_D   | AS | LD_TBR ;Byte

 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DRH  | WR_TMPH | LD_AH
 DC.L    OE_TBR | RD | ALU_ADDA    | RR_YR   | WR_TMPL | LD_AL

        endm


;load temp and address Bus latches with
;(IND)
;
M_IND   macro

 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;Byte

 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TPIL | LD_AL  
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_DRH  | WR_TPIH | LD_AH                  

 ;TPIL, TPIH describes the memory location,
 ;that will be used now as pointer.

 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 DC.L    OE_0BR | RD | ALU_INC     | RR_TPIL | WR_NULL | LD_AL
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TBR ;HI Byte

 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;
M_INDL  macro

 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;Byte

 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TPIL | LD_AL  
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_DRH  | WR_TPIH | LD_AH                  

 ;TPIL, TPIH describes the memory location,
 ;that will be used now as pointer.

 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 DC.L    OE_0BR | RD | ALU_INC     | RR_TPIL | WR_TPIL | LD_AL
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;HI Byte
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH

 DC.L    OE_0BR | RD | ALU_INC     | RR_TPIL | WR_NULL | LD_AL
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;Bank   

 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TPIH | LD_TBR      ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPH | WR_NULL | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;(d,S),Y
;
M_dSY   macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Byte
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TBR ;Byte

 ;Pointer in Stack        
 DC.L    OE_PBR | RD | ALU_ADDA    | RR_SP   | WR_TPIL | LD_AL  
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_TPIH | LD_AH                  

 ;TPIL, TPIH describes the memory location,
 ;that will be used now as pointer.

 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 ;take care, LO-Byte still in latch.

 ;stack is limited to 01xx, so we don't have to increment the HI-Byte.
 DC.L    OE_0BR | RD | ALU_INC     | RR_TPIL | WR_NULL | LD_AL

 ;address points to HI-Byte
 ;take care, LO-Byte still in latch.

 ;calculate TMPL addr.
 DC.L    OE_0BR | RD | ALU_ADDA    | RR_YR   | WR_TMPL      
 ;and latch temp. carry of this addition with the next cycle
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS | LD_TC
 ;read HI-Byte from Bus
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH               | LD_TC
 ;
 DC.L    OE_TBR | RD | ALU_ADD0C   | RR_TMPH | WR_TMPH | LD_AH
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;(IND),Y
;
M_INDY  macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Byte
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TBR ;Byte

 ;Pointer in Zeropage
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TPIL | LD_AL  
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_DRH  | WR_TPIH | LD_AH                  

 ;TPIL, TPIH describes the memory location,
 ;that will be used now as pointer.

 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 ;take care, LO_Byte still in latch.

 DC.L    OE_0BR | RD | ALU_INC     | RR_TPIL | WR_NULL | LD_AL
 ;address points to HI-Byte
 ;take care, LO_Byte still in latch.

 ;calculate TMPL addr.
 DC.L    OE_0BR | RD | ALU_ADDA    | RR_YR   | WR_TMPL      
 ;and latch temp. carry of this addition with the next cycle
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TC | LD_TBR
 ;read HI-Byte from Bus
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH               | LD_TC

 ;now to calculate the TMPH addr.
 DC.L    OE_TBR | RD | ALU_ADD0C   | RR_TMPH | WR_TMPH | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;
M_INDYL macro ;WARNING: TMP = TMPH.

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Byte
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;Byte

 ;Pointer in Zeropage
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TPIL | LD_AL  
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_DRH  | WR_TPIH | LD_AH                  

 ;TPIL, TPIH describes the memory location,
 ;that will be used now as pointer.

 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 ;take care, LO_Byte still in latch.

 DC.L    OE_0BR | RD | ALU_INC     | RR_TPIL | WR_TPIL | LD_AL
 ;address points to HI-Byte
 ;take care, LO_Byte still in latch.

 ;calculate TMPL addr.
 DC.L    OE_0BR | RD | ALU_ADDA    | RR_YR   | WR_TMPL      
 ;and latch temp. carry of this addition with the next cycle
 DC.L    OE_0BR | RD | ALU_C_00    | RR_NULL | WR_TPIH | LD_D   | AS | LD_TC ;HI Byte
 ;read HI-Byte from Bus
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH         

 DC.L    OE_0BR | RD | ALU_ADD0NC  | RR_TMPH | WR_TMPH                        
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_TC ;architecture.
 DC.L    OE_0BR | RD | ALU_ADD0NC  | RR_TPIH | WR_TPIH

 DC.L    OE_0BR | RD | ALU_INC     | RR_TPIL | WR_NULL | LD_AL
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS

 ;read Bank, set Addr.
 DC.L    OE_0BR | RD | ALU_ADDA    | RR_TPIH | WR_TPIH | LD_TBR
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPH | WR_NULL | LD_AH
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL

        endm


;load temp and address Bus latches with
;(IND,X)
;
M_INDX  macro

 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_DRH  | WR_TPIH | LD_D   | AS ;Byte

 DC.L    OE_PBR | RD | ALU_ADDA    | RR_XR   | WR_TPIL | LD_AL
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_TPIH | WR_TPIH | LD_AH

 ;TPIL, TPIH describes the memory location,
 ;that will be used now as pointer.

 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;LO Byte
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 DC.L    OE_0BR | RD | ALU_INC     | RR_TPIL | WR_NULL | LD_AL
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_DBR  | WR_NULL | LD_D   | AS | LD_TBR ;HI Byte

 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH | LD_AH       ;set addr

        endm

;immediate. advance PC to # value.
;
M_IMM   macro

 ;set Bank Register
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PBR  | WR_NULL | LD_TBR
 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

        endm



;----------------------------------------------------------------------------

;push to stack
;
M_PHS   macro reg

 ;push reg
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | reg     | WR_NULL | LD_D       ;   
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--

        endm

;push 0 to stack
;
M_PH0   macro reg

 ;push reg
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_C_00    | RR_NULL | WR_NULL | LD_D       ;   
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--

        endm


;pull from stack
;
M_PLS   macro reg

 ;pop reg
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_INC     | RR_SP   | WR_SP   | LD_AL      ;SP LO, SP++
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;value
 DC.L    OE_0BR | RD | ALU_PASS_IX | RR_NULL | reg    

        endm
;

;PER
;
M_PER   macro

 ;get LO-Byte into IX-Latch
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS

 ;set PC to HI-Byte
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

 ;add
 DC.L    OE_PBR | RD | ALU_ADDA    | RR_PCL  | WR_TMPL
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS | LD_TC
 DC.L    OE_PBR | RD | ALU_ADDAC   | RR_PCH  | WR_TMPH

 ;+1, the beginning of the next OPcode
 DC.L    OE_PBR | RD | ALU_INC     | RR_TMPL | WR_TMPL           
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_TMPH | WR_TMPH         

 ;push HI 
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_TMPH | WR_NULL | LD_D       ;   
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--
 ;push LO 
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_D       ;   
 DC.L    OE_0BR | WE | ALU_DEC     | RR_SP   | WR_SP   |         AS ;SP--

 ;get next OPcode
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode
      
        endm


;----------------------------------------------------------------------------

;write 0 to Data Bus 
;
M_WR0   macro 

 ;write       
 DC.L    OE_TBR | WE | ALU_C_00    | RR_NULL | WR_NULL | LD_D       
 DC.L    OE_TBR | WE | ALU_NOP     | RR_NULL | WR_NULL |         AS 

        endm

;write to Data Bus
;
M_WRD   macro reg

 ;write       
 DC.L    OE_TBR | WE | ALU_PASS_ID | reg     | WR_NULL | LD_D       
 DC.L    OE_TBR | WE | ALU_NOP     | RR_NULL | WR_NULL |         AS 

        endm

;read from Data Bus 
;
M_RRD   macro reg

 ;read        
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | reg     

        endm

;----------------------------------------------------------------------------


M_SEP   macro

 ;read
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS
 ;
 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;set flags, get next OPcode
 DC.L    OE_PBR | RD | ALU_OR      | RR_FLAG | WR_FLAG | LD_CMD | AS

        endm
;


M_REP   macro

 DC.L    OE_PBR | RD | ALU_C_FF    | RR_NULL | WR_TMP  | LD_D  | AS
 DC.L    OE_PBR | RD | ALU_XOR     | RR_TMP  | WR_TMP
 ;workaround;write on stack
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_NULL | LD_AH      ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL      ;SP LO
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_TMP  | WR_NULL | LD_D        
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL         | AS
 ;
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS
 ;PC++
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;set flags, get next OPcode
 DC.L    OE_PBR | RD | ALU_AND     | RR_FLAG | WR_FLAG | LD_CMD | AS

        endm
;


M_TSB   macro; TMPL,TMPH points to memory
        ;18 cycles

 ;problem: there is no ALU_MZ. we have to work around this.
 ;clear Z-Flag
 DC.L    OE_TBR | RD | ALU_SEICLB  | RR_FLAG | WR_NULL ;Temp.flags:Z=0
 DC.L    OE_TBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG ;set Flags, Z=0
 ;
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL  
 ;
 DC.L    OE_TBR | WE | ALU_OR      | RR_ACC  | WR_NULL | LD_D        ;write
 DC.L    OE_TBR | WE | ALU_MNZC    | RR_TMP  | WR_TMP  |          AS ;get Z-Flag
 ;
 ;set pointer to stack, use stack as scratchpad
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_TPIL | LD_AH       ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL       ;SP LO
 ;and write $02 on Stack
 DC.L    OE_0BR | WE | ALU_INC     | RR_TPIL | WR_NULL | LD_D         
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL          | AS
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read back
 ;we have now $02 in the IX latch
 DC.L    OE_0BR | RD | ALU_AND     | RR_TMP  | WR_TMP  ;mask mew Z-Flag
 ;write new Z-Flag on stack
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_TMP  | WR_NULL | LD_D         
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL          | AS
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read back

 ;PC++
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;
 ;set flags, get next OPcode
 DC.L    OE_PBR | RD | ALU_OR      | RR_FLAG | WR_FLAG | LD_CMD | AS ;set flags

        endm
;


M_TRB   macro; TMPL,TMPH points to memory
        ;21 cycles

 ;problem: there is no ALU_MZ. we have to work around this.
 ;clear Z-Flag
 DC.L    OE_TBR | RD | ALU_SEICLB  | RR_FLAG | WR_NULL ;Temp.flags:Z=0
 DC.L    OE_TBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG ;set Flags, Z=0
 ;
 DC.L    OE_TBR | RD | ALU_C_FF    | RR_NULL | WR_NULL ;Temp.flags:N=1
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | OE_TF ; load SignExt.
 DC.L    OE_TBR | RD | ALU_XORX    | RR_ACC  | WR_TPIL
 ;
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL  
 ;
 DC.L    OE_TBR | WE | ALU_AND     | RR_TPIL | WR_NULL | LD_D        ;write
 DC.L    OE_TBR | WE | ALU_MNZC    | RR_TMP  | WR_TMP  |          AS ;get Z-Flag
 ;
 ;set pointer to stack, use stack as scratchpad
 DC.L    OE_0BR | RD | ALU_C_01    | RR_NULL | WR_TPIL | LD_AH       ;SP HI
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_SP   | WR_NULL | LD_AL       ;SP LO
 ;and write $02 on Stack
 DC.L    OE_0BR | WE | ALU_INC     | RR_TPIL | WR_NULL | LD_D         
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL          | AS
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read back
 ;we have now $02 in the IX latch
 DC.L    OE_0BR | RD | ALU_AND     | RR_TMP  | WR_TMP  ;mask mew Z-Flag
 ;write new Z-Flag on stack
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_TMP  | WR_NULL | LD_D        
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL          | AS
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;read back

 ;PC++
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;
 ;set flags, get next OPcode
 DC.L    OE_PBR | RD | ALU_OR      | RR_FLAG | WR_FLAG | LD_CMD | AS ;set flags

        endm
;

M_LTB   macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Byte
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_XR   | WR_NULL | LD_D   | AS | LD_TBR ;Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 ;read from table
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_YR   | WR_NULL | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_ACC  | WR_NULL | LD_AL
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH

 ;set Zero Page Address
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_DRH  | WR_NULL | LD_AH 
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL
 ;write Byte
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_TMPH | WR_NULL | LD_D   
 DC.L    OE_0BR | WE | ALU_MNZC    | RR_FLAG | WR_FLAG          | AS

 ;PC++
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;
 ;get next OPcode
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;set flags

        endm
;

M_ATB   macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;read Byte
 DC.L    OE_PBR | RD | ALU_PASS_ID | RR_XR   | WR_NULL | LD_D   | AS | LD_TBR ;Byte
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPL

 ;read from table
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_YR   | WR_NULL | LD_AH       ;set addr
 DC.L    OE_TBR | RD | ALU_PASS_ID | RR_ACC  | WR_NULL | LD_AL
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMPH

 ;set Zero Page Address
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_DRH  | WR_NULL | LD_AH 
 DC.L    OE_0BR | RD | ALU_PASS_ID | RR_TMPL | WR_NULL | LD_AL
 ;read Byte
 DC.L    OE_0BR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS
 DC.L    OE_0BR | RD | ALU_ADC     | RR_TMPH | WR_TMPH
 DC.L    OE_0BR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG                 
 ;write Byte
 DC.L    OE_0BR | WE | ALU_PASS_ID | RR_TMPH | WR_NULL | LD_D
 DC.L    OE_0BR | WE | ALU_NOP     | RR_NULL | WR_NULL          | AS

 ;PC++
 DC.L    OE_0BR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;
 ;get next OPcode
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;set flags

        endm

;----------------------------------------------------------------------------


;modify flags
;
M_FLAGS macro bank,alucmd

 DC.L    bank   | RD | alucmd      | RR_FLAG | WR_FLAG              ;set flags

        endm
;


;pass register trough
;
M_PASSI macro regr,regw

 DC.L    OE_PBR | RD | ALU_PASS_ID | regr    | regw

        endm
;


;TAX etc.
;
M_TRR8  macro regr,regw

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;move
 DC.L    OE_PBR | RD | ALU_PASS_ID | regr    | regw   
 ;set flags
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS

        endm
;


;LDA,LDX,LDY
;
M_LDREG macro regw

 ;read      
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS 
 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;move
 DC.L    OE_PBR | RD | ALU_PASS_IX | RR_NULL | regw   
 ;set flags
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS
        
        endm
;


;ADC
;
M_ADC_  macro regr,regw

 ;read      
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS 
 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;or
 DC.L    OE_PBR | RD | ALU_ADC     | regr    | regw   
 ;set flags
 DC.L    OE_PBR | RD | ALU_MNZCV   | RR_FLAG | WR_FLAG | LD_CMD | AS
        
        endm
;


;SBC                  
;
M_SBC_  macro regr,regw

 ;read      
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS
 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;sub
 DC.L    OE_PBR | RD | ALU_SBC     | regr    | regw  
 ;set flags
 DC.L    OE_PBR | RD | ALU_MNZCV   | RR_FLAG | WR_FLAG | LD_CMD | AS
        
        endm
;


;CMP ;yes, the 65C02 datasheet indeed says, that V isn't modified !
;
M_CMP_  macro regr

 ;read      
 DC.L    OE_TBR | RD | ALU_SEC     | RR_FLAG | WR_FLAG | LD_D  | AS ;set C
 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;sub
 DC.L    OE_PBR | RD | ALU_SBC     | regr    | WR_NULL      
 ;set flags
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS
        
        endm
;


;ORA                  
;
M_ORA_  macro regr,regw

 ;read      
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS 
 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;or
 DC.L    OE_PBR | RD | ALU_OR      | regr    | regw  
 ;set flags
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS
        
        endm
;


;AND                  
;
M_AND_  macro regr,regw

 ;read      
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS 
 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;and
 DC.L    OE_PBR | RD | ALU_AND     | regr    | regw           
 ;set flags
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS
        
        endm
;


;EOR                  
;
M_EOR_  macro regr,regw

 ;read      
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS 
 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;eor
 DC.L    OE_PBR | RD | ALU_XOR     | regr    | regw   
 ;set flags
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS
        
        endm
;


;BIT                  
;
M_BIT_  macro regr

 ;read      
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS 
 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;or
 DC.L    OE_PBR | RD | ALU_BIT     | regr    | WR_NULL      
 ;set flags
 DC.L    OE_PBR | RD | ALU_MNZCV   | RR_FLAG | WR_FLAG | LD_CMD | AS
        
        endm
;


;inc register
;
M_INC_R macro regr,regw

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;modify
 DC.L    OE_PBR | RD | ALU_INC     | regr    | regw
 ;get text OP
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS

        endm
;


;inc memory  
;
M_INC_M macro 

 ;read
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;value
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMP
 ;modify
 DC.L    OE_TBR | WE | ALU_INC     | RR_TMP  | WR_NULL | LD_D
 ;set flags
 DC.L    OE_TBR | WE | ALU_MNZC    | RR_FLAG | WR_FLAG         | AS ;write back

 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;get text OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS

        endm
;


;dec register
;
M_DEC_R macro regr,regw

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;modify
 DC.L    OE_PBR | RD | ALU_DEC     | regr    | regw
 ;get text OP
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS

        endm
;


;dec memory  
;
M_DEC_M macro 

 ;read
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;value
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMP
 ;modify
 DC.L    OE_TBR | WE | ALU_DEC     | RR_TMP  | WR_NULL | LD_D
 ;set flags
 DC.L    OE_TBR | WE | ALU_MNZC    | RR_FLAG | WR_FLAG         | AS ;write back

 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;get text OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS

        endm
;


;shift register left
;
M_ASL_R macro regr,regw

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;modify
 DC.L    OE_PBR | RD | ALU_ASL     | regr    | regw
 ;get text OP
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS

        endm
;


;shift memory left 
;
M_ASL_M macro 

 ;read
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;value
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMP
 ;modify
 DC.L    OE_TBR | WE | ALU_ASL     | RR_TMP  | WR_NULL | LD_D
 ;set flags
 DC.L    OE_TBR | WE | ALU_MNZC    | RR_FLAG | WR_FLAG         | AS ;write back

 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;get text OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS

        endm
;


;shift register right
;
M_LSR_R macro regr,regw

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;modify
 DC.L    OE_PBR | RD | ALU_LSR     | regr    | regw
 ;get text OP
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS

        endm
;


;shift memory right
;
M_LSR_M macro 

 ;read
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;value
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMP
 ;modify  
 DC.L    OE_TBR | WE | ALU_LSR     | RR_TMP  | WR_NULL | LD_D
 ;set flags
 DC.L    OE_TBR | WE | ALU_MNZC    | RR_FLAG | WR_FLAG         | AS ;write back

 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;get text OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS

        endm
;


;rotate register left
;
M_ROL_R macro regr,regw

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;modify
 DC.L    OE_PBR | RD | ALU_ROL     | regr    | regw
 ;get text OP
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS

        endm
;


;rotate memory left 
;
M_ROL_M macro 

 ;read
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;value
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMP
 ;modify
 DC.L    OE_TBR | WE | ALU_ROL     | RR_TMP  | WR_NULL | LD_D
 ;set flags
 DC.L    OE_TBR | WE | ALU_MNZC    | RR_FLAG | WR_FLAG         | AS ;write back

 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;get text OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS

        endm
;


;rotate register right
;
M_ROR_R macro regr,regw

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;modify
 DC.L    OE_PBR | RD | ALU_ROR     | regr    | regw
 ;get text OP
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG | LD_CMD | AS

        endm
;


;rotate memory right
;
M_ROR_M macro 

 ;read
 DC.L    OE_TBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D  | AS ;value
 DC.L    OE_TBR | RD | ALU_PASS_IX | RR_NULL | WR_TMP
 ;modify
 DC.L    OE_TBR | WE | ALU_ROR     | RR_TMP  | WR_NULL | LD_D
 ;set flags
 DC.L    OE_TBR | WE | ALU_MNZC    | RR_FLAG | WR_FLAG         | AS ;write back

 ;PC++
 DC.L    OE_TBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;get text OP
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS

        endm
;

;----------------------------------------------------------------------------

;dec register,jump if not zero
;
M_DBNZ  macro regr,regw ;OPcode has to be $C0..$FF for Z-Flag !

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;modify
 DC.L    OE_PBR | RD | ALU_DEC     | regr    | regw    | LD_D   | AS
 ;set Flags  
 DC.L    OE_PBR | RD | ALU_MNZC    | RR_FLAG | WR_FLAG 

 ;PC++, points to next OpCode
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

  IFDEF FLAG_LO             ;Flag encoded by hardware

 ;now add the value.
 DC.L    OE_PBR | RD | ALU_ADDA    | RR_PCL  | WR_PCL  | LD_AL   ;add  offset
 DC.L    OE_PBR | RD | ALU_ADDAX   | RR_PCH  | WR_PCH  | LD_AH   ;sign extend

  ENDIF

 ;take next Opcode
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm
;


;not take branch
;
M_NTBR   macro

 ;PC++, step over distance
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

 ;PC++, points to next OpCode
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

 ;take next Opcode
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm


;take branch
;
M_TBR  macro

 ;PC++, get distance
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;Byte
 ;take care, Byte is still in latch

 ;PC++, points to next OpCode
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH

 ;now add the value.
 DC.L    OE_PBR | RD | ALU_ADDA    | RR_PCL  | WR_PCL  | LD_AL   ;add  offset
 DC.L    OE_PBR | RD | ALU_ADDAX   | RR_PCH  | WR_PCH  | LD_AH   ;sign extend

 ;take next Opcode
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm


;take long branch
;
M_TBRL  macro

 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_TMP  | LD_AH
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS ;Byte
 ;
 ;PC++, LO-Byte still in IX-Latch !
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_PCH  | LD_AH
 ;
 DC.L    OE_PBR | RD | ALU_ADDA    | RR_PCL  | WR_PCL                ;add L
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_D   | AS | LD_TC
 DC.L    OE_PBR | RD | ALU_ADDAC   | RR_PCH  | WR_PCH
 ;
 ;PC++
 DC.L    OE_PBR | RD | ALU_INC     | RR_PCL  | WR_PCL  | LD_AL
 DC.L    OE_PBR | RD | ALU_ADD0C   | RR_PCH  | WR_TMP  | LD_AH

 ;take next Opcode
 DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

        endm

;============================================================================
;Some people insist in having a secret message. Here we go.
;
;------------------------------------------------------------
;
;Zehn kleine Bastler fein, die loeten Teile ein.
;Doch ploetzlich gab's nur SMD, da war'n es nur noch neun.
;
;Neun kleine Bastler fein, viel Einsamkeit verbracht.
;Und einer hat geheiratet, da war'n es nur noch acht.
;
;Acht kleine Bastler fein, und wo ist DOS geblieben ?
;Seit es nur bunte Fenster gab, da war'n es nur noch sieben.
;
;Sieben kleine Bastler fein, und Schaltungen komplex.
;Dabei ist einer abgedreht, da war'n es nur noch sechs.
;
;Sechs kleine Bastler fein, verdrehten sich die Ruempfe.
;Die Bandscheiben verhakten sich, da war'n es nur noch fuenfe.
;
;Fuenf kleine Bastler fein, das Internet war hier.
;Sie trafen falsche Freundlichkeit, da war'n es nur noch vier.
;
;Vier kleine Bastler fein, verkabeln allerlei.
;Und einer hat nicht aufgepasst, da war'n es nur noch drei
;
;Drei kleine Bastler fein, bei HF gleich dabei.
;Doch einen krallte sich die Post, da war'n es nur noch zwei.
;
;Zwei kleine Baster fein, geaergert wie sonst keiner.
;Den einen traf der Herzinfarkt, und uebrig bleibt nur einer.
;
;Ein kleiner Bastler fein, das Studium vollbracht,
;hat seit er auf der Arbeit baut, Zuhaus nichts mehr gemacht.
;
;------------------------------------------------------------
;Ein   klein, zwei   klein, drei klein, vier klein, fuenf klein Bastler fein.
;Sechs klein, sieben klein, acht klein, neun klein, zehn  klein Bastler fein.
;
;============================================================================
;----------------------------------------------------------------------------
;Ezadla baggmers.
;============================================================================
;the opcodes.
;there are no illegal opcodes.
;everything undefined causes a BRK... and can be emulated by software.
;
;and take care, that the total length of all !"$%&ing macros of one command
;DOES NOT EXCEED 32 * DC.L !!!
;


 IFNDEF IRQ
  IFNDEF NMI
   IFNDEF RES

     IFDEF FLAG_LO
      MESSAGE "[Flag_Bit = 0]"
     ENDIF

     IFDEF FLAG_HI
      MESSAGE "[Flag_Bit = 1]"
     ENDIF


;----------------------------------------------------------------------------
;BRK
;
        ORG     $00 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_BRK

;----------------------------------------------------------------------------
;ORA (IND,X)
;
        ORG     $01 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDX                ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;undefined
;
        ORG     $02 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_BRK

;----------------------------------------------------------------------------
;ORA d,S  [65C816]
;
        ORG     $03 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_dS                  ;immediate
        M_ORA_  RR_ACC,WR_ACC ;add with carry, set Flags

;----------------------------------------------------------------------------
;TSB Z  [65C02]
;
        ORG     $04 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z     
        M_TSB   

;----------------------------------------------------------------------------
;ORA Z
        ORG     $05 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_Z                   ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;ASL Z
;
        ORG     $06 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_ASL_M             ;shift memory left

;---------------------------------------------------------------------------- 
;ORA (INDL)  [65C816]
;
        ORG     $07 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDL                ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;PHP
;
        ORG     $08 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PHS   RR_FLAG     ;push flags
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;ORA #
        ORG     $09 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IMM                 ;immediate
        M_ORA_  RR_ACC,WR_ACC ;add with carry, set Flags

;----------------------------------------------------------------------------
;ASL A
        ORG     $0A * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ASL_R RR_ACC,WR_ACC ;shift A left, set Flags

;----------------------------------------------------------------------------
;PHD    [65C816]      
;
        ORG     $0B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PHS   RR_DRH
        M_PH0
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;TSB ABS  [65C02]
;
        ORG     $0C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS   
        M_TSB   

;----------------------------------------------------------------------------
;ORA ABS
;
        ORG     $0D * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABS                 ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;add with carry, set Flags

;----------------------------------------------------------------------------
;ASL ABS
;
        ORG     $0E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_ASL_M             ;shift memory left, set Flags

;----------------------------------------------------------------------------
;ORA ABSL  [65C816]
;
        ORG     $0F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSL                ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;add with carry, set Flags

;----------------------------------------------------------------------------
;BPL    branch, if N=0
;
        ORG     $10 * 32 *4 ;*4 because DC.L has 4 Bytes

  IFDEF FLAG_LO             ;Flag encoded by hardware
        M_TBR               ;take branch
  ELSEIF
        M_NTBR              ;take branch
  ENDIF

;----------------------------------------------------------------------------
;ORA (IND),Y
;
        ORG     $11 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDY                ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;ORA (IND)  [65C02]
;
        ORG     $12 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IND                 ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;ORA (d,S),Y  [65C816]
;
        ORG     $13 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_dSY                 ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;TRB Z  [65C02]
;
        ORG     $14 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z     
        M_TRB   

;----------------------------------------------------------------------------
;ORA Z,X
;
        ORG     $15 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ZX                  ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;shift memory left

;----------------------------------------------------------------------------
;ASL Z,X
;
        ORG     $16 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_ASL_M             ;shift memory left, set Flags

;----------------------------------------------------------------------------
;ORA (INDL),Y  [65C816]
;
        ORG     $17 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDYL               ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;CLC
;
        ORG     $18 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INCPC             ;PC++
        M_GTOPF ALU_CLC     ;clear C-Flag ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;ORA ABS,Y
;
        ORG     $19 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSY                ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;INC A  [65C02]
;
        ORG     $1A * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INC_R RR_ACC,WR_ACC ;inc, set Flags

;----------------------------------------------------------------------------
;TCS    [65C816]          
;
        ORG     $1B * 32 *4  ;*4 because DC.L has 4 Bytes
        M_PASSI RR_ACC,WR_SP ;transfer without changing flags        
        M_NEXT  OE_PBR       ;done. fetch next OpCode.


;----------------------------------------------------------------------------
;TRB ABS  [65C02]
;
        ORG     $1C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS
        M_TRB

;----------------------------------------------------------------------------
;ORA ABS,X
;
        ORG     $1D * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSX                ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;ASL ABS,X
;
        ORG     $1E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_ASL_M             ;shift memory left, set Flags

;----------------------------------------------------------------------------
;ORA ABSL,X  [65C816]
;
        ORG     $1F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSXL               ;calculate address
        M_ORA_  RR_ACC,WR_ACC ;or to A, set Flags

;----------------------------------------------------------------------------
;JSR        
;
        ORG     $20 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_JSR

;----------------------------------------------------------------------------
;AND (IND,X)
;
        ORG     $21 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDX                ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;JSL  [65C816] the far call
;

        ORG     $22 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_JSRL

;----------------------------------------------------------------------------
;AND d,s  [65C816]
;
        ORG     $23 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ds                  ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;BIT Z
;
        ORG     $24 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_BIT_  RR_ACC      ;BIT with A, set Flags

;----------------------------------------------------------------------------
;AND Z
;
        ORG     $25 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_Z                   ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;ROL Z
;
        ORG     $26 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_ROL_M             ;rotate memory left

;----------------------------------------------------------------------------
;AND (INDL)  [65C816]
;
        ORG     $27 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDL                ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;PLP
;
        ORG     $28 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PLS   WR_FLAG     ;pop Flags
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;AND #
;
        ORG     $29 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IMM                 ;immediate
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;ROL A
;
        ORG     $2A * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ROL_R RR_ACC,WR_ACC ;rotate A left, set Flags

;----------------------------------------------------------------------------
;PLD    [65C816]             
;
        ORG     $2B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PLS   WR_NULL
        M_PLS   WR_DRH
        M_NEXT  OE_0BR      

;----------------------------------------------------------------------------
;BIT ABS
;
        ORG     $2C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_BIT_  RR_ACC      ;BIT with A, set Flags

;----------------------------------------------------------------------------
;AND ABS
;
        ORG     $2D * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABS                 ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;ROL ABS
;
        ORG     $2E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_ROL_M             ;rotate memory left

;----------------------------------------------------------------------------
;AND ABSL  [65C816]
;
        ORG     $2F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSL                ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;BMI    branch, if N=1
;
        ORG     $30 * 32 *4 ;*4 because DC.L has 4 Bytes

  IFDEF FLAG_LO             ;Flag encoded by hardware
        M_NTBR              ;take branch
  ELSEIF
        M_TBR               ;take branch
  ENDIF

;----------------------------------------------------------------------------
;AND (IND),Y
;
        ORG     $31 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDY                ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;AND (IND)  [65C02]
;
        ORG     $32 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IND                 ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;AND(d,S),Y  [65C816]
;
        ORG     $33 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_dSY                 ;calculate address
        M_AND_  RR_ACC,WR_ACC ;BIT with A, set Flags

;----------------------------------------------------------------------------
;BIT Z,X  [65C02]
;
        ORG     $34 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_BIT_  RR_ACC      ;BIT with A, set Flags

;----------------------------------------------------------------------------
;AND Z,X
;
        ORG     $35 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ZX                  ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;ROL Z,X
;
        ORG     $36 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_ROL_M             ;rotate memory left

;----------------------------------------------------------------------------
;AND (INDL),Y
;
        ORG     $37 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDYL               ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;SEC
;
        ORG     $38 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INCPC               ;PC++
        M_GTOPF ALU_SEC       ;set C-Flag ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;AND ABS,Y
;
        ORG     $39 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSY                ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;DEC A  [65C02]
;
        ORG     $3A * 32 *4   ;*4 because DC.L has 4 Bytes
        M_DEC_R RR_ACC,WR_ACC ;dec, set Flags

;----------------------------------------------------------------------------
;TSC    [65C816]            
;
        ORG     $3B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INCPC
        M_PASSI RR_SP,WR_ACC
        DC.L    OE_PBR | RD | ALU_C_01    | RR_NULL | WR_BETA
        M_GTOPF ALU_MNZC      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;BIT ABS,X  [65C02]
;
        ORG     $3C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_BIT_  RR_ACC      ;BIT with A, set Flags

;----------------------------------------------------------------------------
;AND ABS,X
;
        ORG     $3D * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSX                ;calculate address
        M_AND_  RR_ACC,WR_ACC ;and to A, set Flags

;----------------------------------------------------------------------------
;ROL ABS,X
;
        ORG     $3E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_ROL_M             ;rotate memory left

;----------------------------------------------------------------------------
;AND ABSL,X  [65C816]
;
        ORG     $3F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSXL             ;calculate address
        M_ROL_M             ;rotate memory left

;----------------------------------------------------------------------------
;RTI
;
        ORG     $40 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RTI

;----------------------------------------------------------------------------
;EOR (IND,X)
;
        ORG     $41 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDX                ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;undefined
;
        ORG     $42 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_BRK

;----------------------------------------------------------------------------
;EOR d,S  [65C816]
;
        ORG     $43 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_dS                  ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;LTB  [M02]
;
        ORG     $44 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_LTB

;----------------------------------------------------------------------------
;EOR Z
;
        ORG     $45 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_Z                   ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;LSR Z
;
        ORG     $46 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_LSR_M             ;shift memory right, set Flags

;----------------------------------------------------------------------------
;EOR (INDL)  [65C816]
;
        ORG     $47 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDL                ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;PHA
;
        ORG     $48 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PHS   RR_ACC      ;push A
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;EOR #
; 
        ORG     $49 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IMM                 ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;LSR A
;
        ORG     $4A * 32 *4   ;*4 because DC.L has 4 Bytes
        M_LSR_R RR_ACC,WR_ACC ;shift A right, set Flags

;----------------------------------------------------------------------------
;PHK  [65C816]
;
        ORG     $4B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PHS   RR_PBR      ;push Program Bank Register
        M_NEXT  OE_0BR

;----------------------------------------------------------------------------
;JMP
;
        ORG     $4C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_JMP

;----------------------------------------------------------------------------
;EOR ABS
;
        ORG     $4D * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABS                 ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;LSR ABS
;
        ORG     $4E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_LSR_M             ;shift memory right, set Flags

;----------------------------------------------------------------------------
;EOR ABSL  [65C816]
;
        ORG     $4F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSL                ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;BVC    branch, if V=0
;
        ORG     $50 * 32 *4 ;*4 because DC.L has 4 Bytes

  IFDEF FLAG_LO             ;Flag encoded by hardware
        M_TBR               ;take branch
  ELSEIF
        M_NTBR              ;take branch
  ENDIF

;----------------------------------------------------------------------------
;EOR (IND),Y
;
        ORG     $51 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDY                ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;EOR (IND)  [65C02]
;
        ORG     $52 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IND                 ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;EOR (d,S),Y  [65C816]
;
        ORG     $53 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_dSY                 ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;ATB  [M02]
;
        ORG     $54 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ATB

;----------------------------------------------------------------------------
;EOR Z,X
;
        ORG     $55 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ZX                  ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;LSR Z,X
;
        ORG     $56 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_LSR_M             ;shift memory right, set Flags

;----------------------------------------------------------------------------
;EOR (INDL),Y  [65C816]
;
        ORG     $57 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDYL               ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;CLI
;
        ORG     $58 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INCPC             ;PC++
        M_GTOPF ALU_CLICLB  ;clear I-Flag, B-Flag ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;EOR ABS,Y
;
        ORG     $59 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSY                ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;PHY  [65C02]
;
        ORG     $5A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PHS   RR_YR       ;push Y
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;TCD  [65C816]     
;
        ORG     $5B * 32 *4    ;*4 because DC.L has 4 Bytes
        M_TRR8  RR_BETA,WR_DRH ;transfer B to DRH

;----------------------------------------------------------------------------
;JML ABS  [65C816]
;
        ORG     $5C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_JMPL

;----------------------------------------------------------------------------
;EOR ABS,X
;
        ORG     $5D * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSX                ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;LSR ABS,X
;
        ORG     $5E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_LSR_M             ;shift memory right, set Flags

;----------------------------------------------------------------------------
;EOR ABSL,X  [65C816]
;
        ORG     $5F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSXL               ;calculate address
        M_EOR_  RR_ACC,WR_ACC ;eor to A, set Flags

;----------------------------------------------------------------------------
;RTS
;
        ORG     $60 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RTS

;----------------------------------------------------------------------------
;ADC (IND,X)
;
        ORG     $61 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDX                ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;PER  [65C816]
;
        ORG     $62 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PER

;----------------------------------------------------------------------------
;ADC d,s  [65C816]
;
        ORG     $63 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_dS                  ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;STZ Z  [65C02]
;
        ORG     $64 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_WR0               ;write 0 
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;ADC Z
;
        ORG     $65 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_Z                   ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;ROR Z
        ORG     $66 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_ROR_M             ;rotate memory right

;----------------------------------------------------------------------------
;ADC (INDL)  [65C816]
;
        ORG     $67 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDL                ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;PLA
;
        ORG     $68 * 32 *4     ;*4 because DC.L has 4 Bytes
        M_PLS   WR_ACC          ;pull A
        M_FLAGS OE_0BR,ALU_MNZC ;set Flags
        M_NEXT  OE_PBR          ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;ADC #
;
        ORG     $69 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IMM                 ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;ROR A
;
        ORG     $6A * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ROR_R RR_ACC,WR_ACC ;rotate A right, set Flags

;----------------------------------------------------------------------------
;RTL  [65C816]
;
        ORG     $6B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RTL

;----------------------------------------------------------------------------
;JMP (ABS)
;
        ORG     $6C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_JMPI              ;jump

;----------------------------------------------------------------------------
;ADC ABS
;
        ORG     $6D * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABS                 ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;ROR ABS
;
        ORG     $6E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_ROR_M             ;rotate memory right

;----------------------------------------------------------------------------
;ADC ABSL  [65C816]
;
        ORG     $6F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSL                ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;BVS    branch, if V=1
;
        ORG     $70 * 32 *4 ;*4 because DC.L has 4 Bytes

  IFDEF FLAG_LO             ;Flag encoded by hardware
        M_NTBR              ;take branch
  ELSEIF
        M_TBR               ;take branch
  ENDIF

;----------------------------------------------------------------------------
;ADC (IND),Y
;
        ORG     $71 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDY                ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;ADC (IND)  [65C02]
;
        ORG     $72 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IND                 ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;ADC (d,S),Y  [65C816]
;
        ORG     $73 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_dSY                 ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;STZ Z,X  [65C02]
;
        ORG     $74 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_WR0               ;write 0 
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;ADC Z,X
;
        ORG     $75 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ZX                  ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;ROR Z,X
;
        ORG     $76 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_ROR_M             ;rotate memory right

;----------------------------------------------------------------------------
;ADC (INDL),Y  [65C816]
;
        ORG     $77 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDYL               ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;SEI
;
        ORG     $78 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INCPC             ;PC++
        M_GTOPF ALU_SEICLB  ;set I-Flag, clear B-Flag ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;ADC ABS,Y
;
        ORG     $79 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSY                ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;PLY  [65C02]       
;
        ORG     $7A * 32 *4     ;*4 because DC.L has 4 Bytes
        M_PLS   WR_YR           ;pull Y
        M_FLAGS OE_0BR,ALU_MNZC    
        M_NEXT  OE_PBR          ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;TDC  [65C816]          
;
        ORG     $7B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INCPC             ;PC++
        DC.L    OE_PBR | RD | ALU_C_00    | RR_NULL | WR_ACC
        M_PASSI RR_DRH,WR_BETA
        M_GTOPF ALU_MNZC    ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;JMP (IND,X)  [65C02]
;
        ORG     $7C * 32 *4 ;*4 because DC.L has 4 Bytes

        M_ABSX

        ;Bank 0
        DC.L    OE_0BR | RD | ALU_C_00    | RR_NULL | WR_NULL | LD_TBR

        ;get LO-Byte
        M_RRD   WR_PCL 

        ;TMP++
        DC.L    OE_TBR | RD | ALU_INC     | RR_TMPL | WR_NULL | LD_AL
        DC.L    OE_TBR | RD | ALU_ADD0C   | RR_TMPH | WR_NULL | LD_AH

        ;get HI-Byte
        M_RRD   WR_PCH 

        ;jump
        DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCL  | WR_NULL | LD_AL
        DC.L    OE_PBR | RD | ALU_PASS_ID | RR_PCH  | WR_NULL | LD_AH
        DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode

;----------------------------------------------------------------------------
;ADC ABS,X
;
        ORG     $7D * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSX                ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;ROR ABS,X
;
        ORG     $7E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_ROR_M             ;rotate memory right

;----------------------------------------------------------------------------
;ADC ABSL,X  [65C816]
;

        ORG     $7F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSXL               ;calculate address
        M_ADC_  RR_ACC,WR_ACC ;add to A, set Flags

;----------------------------------------------------------------------------
;BRA  [65C02]
;

        ORG     $80 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_TBR               ;take branch

;----------------------------------------------------------------------------
;STA (IND,X)
;
        ORG     $81 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDX              ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;BRL  [65C816]
;
        ORG     $82 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_TBRL

;----------------------------------------------------------------------------
;STA d,S  [65C816]
;
        ORG     $83 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_dS                ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STY Z
;
        ORG     $84 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_WRD   RR_YR       ;write Y
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA Z
;
        ORG     $85 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STX Z
;
        ORG     $86 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_WRD   RR_XR       ;write X
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA (INDL)  [65C816]
;
        ORG     $87 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDL              ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;DEY
;
        ORG     $88 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_DEC_R RR_YR,WR_YR ;dec Y

;----------------------------------------------------------------------------
;BIT #  [65C02]
;
        ORG     $89 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IMM               ;calculate address
        M_BIT_  RR_ACC      ;BIT with A, set Flags

;----------------------------------------------------------------------------
;TXA
;
        ORG     $8A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_TRR8  RR_XR,WR_ACC

;----------------------------------------------------------------------------
;PHB    [65C816]          
;
        ORG     $8B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PHS   RR_DBR      ;push Data Bank Register
        M_NEXT  OE_0BR

;----------------------------------------------------------------------------
;STY ABS
;
        ORG     $8C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_WRD   RR_YR       ;write Y
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA ABS
;
        ORG     $8D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STX ABS
;
        ORG     $8E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_WRD   RR_XR       ;write X
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA ABSL  [65C816]
;
        ORG     $8F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSL              ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;BCC    branch, if C=0
;
        ORG     $90 * 32 *4 ;*4 because DC.L has 4 Bytes

  IFDEF FLAG_LO             ;Flag encoded by hardware
        M_TBR               ;take branch
  ELSEIF
        M_NTBR              ;take branch
  ENDIF


;----------------------------------------------------------------------------
;STA (IND),Y
;
        ORG     $91 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDY              ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA (IND)  [65C02]
;
        ORG     $92 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IND               ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA (d,S),Y  [65C816]
;
        ORG     $93 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_dSY               ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STY Z,X
;
        ORG     $94 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_WRD   RR_YR       ;write Y
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA Z,X
;
        ORG     $95 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STX Z,Y
;
        ORG     $96 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZY                ;calculate address
        M_WRD   RR_XR       ;write X
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA (INDL),Y  [65C816]
;
        ORG     $97 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDYL             ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;TYA
;
        ORG     $98 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_TRR8  RR_YR,WR_ACC

;----------------------------------------------------------------------------
;STA ABS,Y
;
        ORG     $99 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSY              ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;TXS
;
        ORG     $9A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PASSI RR_XR,WR_SP         
        M_NEXT  OE_PBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;TXY  [65C816]
;
        ORG     $9B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INCPC
        M_PASSI RR_XR,WR_YR
        M_GTOPF ALU_MNZC    ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STZ ABS  [65C02]
;
        ORG     $9C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_WR0               ;write 0 
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA ABS,X
;
        ORG     $9D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_WRD   RR_ACC      ;write A
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STZ ABS,X  [65C02]
;
        ORG     $9E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_WR0               ;write 0 
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;STA ABSL,X  [65C816]
;
        ORG     $9F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSXL             ;calculate address
        M_WRD   RR_ACC      ;write A 
        M_NEXT  OE_TBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;LDY #
;
        ORG     $A0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IMM               ;calculate address
        M_LDREG WR_YR       ;set Y 
       
;----------------------------------------------------------------------------
;LDA (IND,X)
;
        ORG     $A1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDX              ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;LDX #
;
        ORG     $A2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IMM               ;calculate address
        M_LDREG WR_XR       ;set X 

;----------------------------------------------------------------------------
;LDA d,S  [65C816]
;
        ORG     $A3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_dS                ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;LDY Z
;
        ORG     $A4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_LDREG WR_YR       ;set Y 

;----------------------------------------------------------------------------
;LDA Z
;
        ORG     $A5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;LDX Z
;
        ORG     $A6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_LDREG WR_XR       ;set X 

;----------------------------------------------------------------------------
;LDA (INDL)  [65C816]
;
        ORG     $A7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDL              ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;TAY
        ORG     $A8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_TRR8  RR_ACC,WR_YR

;----------------------------------------------------------------------------
;LDA #
        ORG     $A9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IMM               ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;TAX
        ORG     $AA * 32 *4  ;*4 because DC.L has 4 Bytes
        M_TRR8  RR_ACC,WR_XR

;----------------------------------------------------------------------------
;PLB    [65C816]        
;
        ORG     $AB * 32 *4     ;*4 because DC.L has 4 Bytes
        M_PLS   WR_DBR          ;pull Data Bank Register

        ;write the Latch here.

        M_FLAGS OE_0BR,ALU_MNZC ;set Flags
        M_NEXT  OE_PBR          ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;LDY ABS
;
        ORG     $AC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_LDREG WR_YR       ;set Y 

;----------------------------------------------------------------------------
;LDA ABS
;
        ORG     $AD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;LDX ABS
;
        ORG     $AE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_LDREG WR_XR       ;set X 

;----------------------------------------------------------------------------
;LDA ABSL  [65C816]
;
        ORG     $AF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSL              ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;BCS    branch, if C=1
;
        ORG     $B0 * 32 *4 ;*4 because DC.L has 4 Bytes

  IFDEF FLAG_LO             ;Flag encoded by hardware
        M_NTBR              ;take branch
  ELSEIF
        M_TBR               ;take branch
  ENDIF

;----------------------------------------------------------------------------
;LDA (IND),Y
;
        ORG     $B1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDY              ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;LDA (IND)  [65C02]
;
        ORG     $B2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IND               ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;LDA (d,S),Y  [65C816]
;
        ORG     $B3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_dSY               ;calculate address
        M_RRD   WR_ACC      ;set A 
        M_LDREG ALU_MNZC    ;set Flags

;----------------------------------------------------------------------------
;LDY Z,X
;
        ORG     $B4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_LDREG WR_YR       ;set Y 

;----------------------------------------------------------------------------
;LDA Z,X
;
        ORG     $B5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;LDX Z,Y
;
        ORG     $B6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZY                ;calculate address
        M_LDREG WR_XR       ;set Y 

;----------------------------------------------------------------------------
;STA (INDL),Y  [65C816]
;
        ORG     $B7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDYL             ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;CLV
;
        ORG     $B8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INCPC             ;PC++
        M_GTOPF ALU_CLV     ;clear V-Flag ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;LDA ABS,Y
;
        ORG     $B9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSY              ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;TSX
        ORG     $BA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_TRR8  RR_SP,WR_XR

;----------------------------------------------------------------------------
;TYX  [65C816]
;
        ORG     $BB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_TRR8  RR_YR,WR_XR         

;----------------------------------------------------------------------------
;LDY ABS,X
;
        ORG     $BC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_LDREG WR_YR       ;set Y 

;----------------------------------------------------------------------------
;LDA ABS,X
;
        ORG     $BD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;LDX ABS,Y
;
        ORG     $BE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSY              ;calculate address
        M_LDREG WR_XR       ;set Y 

;----------------------------------------------------------------------------
;LDA ABSL,X  [65C816]
;
        ORG     $BF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSXL             ;calculate address
        M_LDREG WR_ACC      ;set A 

;----------------------------------------------------------------------------
;CPY #
;
        ORG     $C0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IMM               ;calculate address
        M_CMP_  RR_YR       ;cmp to Y, set Flags

;----------------------------------------------------------------------------
;CMP (IND,X)
;
        ORG     $C1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDX              ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;REP [65C816]         
;
        ORG     $C2 * 32 *4 ;*4 because DC.L has 4 Bytes
        ;get value
        M_IMM
        M_REP

;----------------------------------------------------------------------------
;CMP d,S  [65C816]
;
        ORG     $C3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_dS                ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;CPY Z
;
        ORG     $C4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_CMP_  RR_YR       ;cmp to Y, set Flags

;----------------------------------------------------------------------------
;CMP Z
;
        ORG     $C5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;DEC Z
;
        ORG     $C6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_DEC_M             ;decrement

;----------------------------------------------------------------------------
;CMP (INDL)  [65C816]
;
        ORG     $C7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDL              ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;INY
;
        ORG     $C8 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INC_R RR_YR ,WR_YR  ;inc, set Flags

;----------------------------------------------------------------------------
;CMP #
;
        ORG     $C9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IMM               ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;DEX
;
        ORG     $CA * 32 *4  ;*4 because DC.L has 4 Bytes
        M_DEC_R RR_XR ,WR_XR ;dec, set Flags

;----------------------------------------------------------------------------
;DYB   [M02]       
;
        ORG     $CB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_DBNZ  RR_YR,WR_YR ;decrement Y and branch if not zero

;----------------------------------------------------------------------------
;CPY ABS
;
        ORG     $CC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_CMP_  RR_YR       ;cmp to Y, set Flags

;----------------------------------------------------------------------------
;CMP ABS
;
        ORG     $CD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;DEC ABS
;
        ORG     $CE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_DEC_M             ;decrement

;----------------------------------------------------------------------------
;CMP ABSL  [65C816]
;
        ORG     $CF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSL              ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;BNE    branch, if Z=0
;
        ORG     $D0 * 32 *4 ;*4 because DC.L has 4 Bytes

  IFDEF FLAG_LO             ;Flag encoded by hardware
        M_TBR               ;take branch
  ELSEIF
        M_NTBR              ;take branch
  ENDIF

;----------------------------------------------------------------------------
;CMP (IND),Y
;
        ORG     $D1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDY              ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;CMP (IND)  [65C02]
;
        ORG     $D2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IND               ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;CMP (d,S),Y  [65C816]
;
        ORG     $D3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_dSY               ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;PEI  [65C816]
;
        ORG     $D4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IND               ;calculate address
        M_RRD   WR_TMP      ;read L                     

        ;TMPL,TMPH++
        DC.L    OE_TBR | RD | ALU_INC     | RR_TMPL | WR_TMPL | LD_AL
        DC.L    OE_TBR | RD | ALU_ADD0C   | RR_TMPH | WR_TMPH | LD_AH
 
        M_RRD   WR_TMPH     ;read H                                 
        M_PHS   RR_TMPH     ;push H
        M_PHS   RR_TMP      ;push L
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;CMP Z,X
;
        ORG     $D5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;DEC Z,X
;
        ORG     $D6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_DEC_M             ;decrement

;----------------------------------------------------------------------------
;CMP (INDL),Y  [65C816]
;
        ORG     $D7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDYL             ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;CLD
;
        ORG     $D8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INCPC             ;PC++
        M_GTOPF ALU_CLD     ;clear D-Flag ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;CMP ABS,Y
;
        ORG     $D9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSY              ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;PHX  [65C02]
;
        ORG     $DA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_PHS   RR_XR       ;push X
        M_NEXT  OE_0BR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;DXB   [M02]
;
        ORG     $DB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_DBNZ  RR_XR,WR_XR ;decrement X and branch if not zero
      
;----------------------------------------------------------------------------
;JML (ABS)  [65C816]
;
        ORG     $DC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_JMPIL

;----------------------------------------------------------------------------
;CMP ABS,X
;
        ORG     $DD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;DEC ABS,X
;
        ORG     $DE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_DEC_M             ;decrement

;----------------------------------------------------------------------------
;CMP ABSL,X  [65C816]
;
        ORG     $DF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSXL             ;calculate address
        M_CMP_  RR_ACC      ;cmp to A, set Flags

;----------------------------------------------------------------------------
;CPX #
;
        ORG     $E0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IMM               ;calculate address
        M_CMP_  RR_XR       ;cmp to X, set Flags

;----------------------------------------------------------------------------
;SBC (IND,X)
;
        ORG     $E1 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDX                ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;SEP  [65C816]      
;
        ORG     $E2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IMM
        M_SEP

;----------------------------------------------------------------------------
;SBC d,S  [65C816]
;
        ORG     $E3 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_dS                  ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;CPX Z
;
        ORG     $E4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_CMP_  RR_XR       ;cmp to X, set Flags

;----------------------------------------------------------------------------
;SBC Z
;
        ORG     $E5 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_Z                   ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;INC Z
;
        ORG     $E6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_Z                 ;calculate address
        M_INC_M             ;decrement

;----------------------------------------------------------------------------
;SBC (INDL)  [65C816]
;
        ORG     $E7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDL                ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;INX
;
        ORG     $E8 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INC_R RR_XR ,WR_XR  ;inc, set Flags

;----------------------------------------------------------------------------
;SBC #
;
        ORG     $E9 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IMM                 ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;NOP
;
        ORG     $EA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NEXT  OE_PBR      ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;XBA  [65C816]
;
        ORG     $EB * 32 *4     ;*4 because DC.L has 4 Bytes
        M_INCPC                 ;PC++
        M_PASSI RR_BETA,WR_TMP
        M_PASSI RR_ACC ,WR_BETA       
        M_PASSI RR_TMP ,WR_ACC        
        M_GTOPF ALU_MNZC        ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;CPX ABS
;
        ORG     $EC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_CMP_  RR_XR       ;cmp to X, set Flags

;----------------------------------------------------------------------------
;SBC ABS
;
        ORG     $ED * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABS                 ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;INC ABS
;
        ORG     $EE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABS               ;calculate address
        M_INC_M             ;decrement

;----------------------------------------------------------------------------
;SBC ABSL  [65C816]
;
        ORG     $EF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSL                ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;BEQ    branch, if Z=1
;
        ORG     $F0 * 32 *4 ;*4 because DC.L has 4 Bytes

  IFDEF FLAG_LO             ;Flag encoded by hardware
        M_NTBR              ;take branch
  ELSEIF
        M_TBR               ;take branch
  ENDIF

;----------------------------------------------------------------------------
;SBC (IND),Y
;
        ORG     $F1 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_INDY                ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;SBC (IND)  [65C02]
;
        ORG     $F2 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_IND                 ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;SBC (d,S),Y  [65C816]
;
        ORG     $F3 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_dSY                 ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;PEA  [65C816]
;
        ORG     $F4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IMM               ;calculate address
        M_RRD   WR_TMPL     ;read L                     
        M_IMM               ;calculate address
        M_RRD   WR_TMPH     ;read H                                 
        M_PHS   RR_TMPH     ;push H
        M_PHS   RR_TMPL     ;push L
        M_NEXT  OE_0BR      ;done. fetch next OpCode.


;----------------------------------------------------------------------------
;SBC Z,X
;
        ORG     $F5 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ZX                  ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;INC Z,X
;
        ORG     $F6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ZX                ;calculate address
        M_INC_M             ;decrement

;----------------------------------------------------------------------------
;SBC (INDL),Y  [65C816]
;
        ORG     $F7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INDYL               ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;SED
        ORG     $F8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_INCPC             ;PC++              
        M_GTOPF ALU_SED     ;set D-Flag ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;SBC ABS,Y
;
        ORG     $F9 * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSY                ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;PLX  [65C02]
;
        ORG     $FA * 32 *4     ;*4 because DC.L has 4 Bytes
        M_PLS   WR_XR           ;pull X
        M_FLAGS OE_0BR,ALU_MNZC           
        M_NEXT  OE_PBR          ;done. fetch next OpCode.

;----------------------------------------------------------------------------
;undefined
;
        ORG     $FB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_BRK

;----------------------------------------------------------------------------
;JSR (ABS,X)  [65C816]
;
        ORG     $FC * 32 *4 ;*4 because DC.L has 4 Bytes

        M_ABSX

        ;Bank 0
        DC.L    OE_PBR | RD | ALU_C_00    | RR_NULL | WR_NULL | LD_TBR

        ;get LO-Byte
        M_RRD   WR_TPIL

        ;TMP++
        DC.L    OE_TBR | RD | ALU_INC     | RR_TMPL | WR_NULL | LD_AL
        DC.L    OE_TBR | RD | ALU_ADD0C   | RR_TMPH | WR_NULL | LD_AH

        ;get HI-Byte
        M_RRD   WR_TPIH

        M_PHS   RR_PCH
        M_PHS   RR_PCL

        DC.L    OE_0BR | RD | ALU_PASS_ID | RR_TPIL | WR_PCL  | LD_AL
        DC.L    OE_PBR | RD | ALU_PASS_ID | RR_TPIH | WR_PCH  | LD_AH
        DC.L    OE_PBR | RD | ALU_NOP     | RR_NULL | WR_NULL | LD_CMD | AS ;OpCode


;----------------------------------------------------------------------------
;SBC ABS,X
;
        ORG     $FD * 32 *4   ;*4 because DC.L has 4 Bytes
        M_ABSX                ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------
;INC ABS,X
;
        ORG     $FE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSX              ;calculate address
        M_INC_M             ;decrement

;----------------------------------------------------------------------------
;SBC ABSL,X  [65C816]
;
        ORG     $FF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_ABSXL               ;calculate address
        M_SBC_  RR_ACC,WR_ACC ;sub to A, set Flags

;----------------------------------------------------------------------------

   ENDIF
  ENDIF
 ENDIF

;============================================================================

  IFDEF RES

    MESSAGE "[RESET active.]"

        ORG     $00 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $01 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $02 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $03 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $04 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $05 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $06 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $07 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $08 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $09 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $0A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $0B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $0C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $0D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $0E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $0F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $10 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $11 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $12 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $13 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $14 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $15 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $16 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $17 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $18 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $19 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $1A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $1B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $1C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $1D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $1E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $1F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $20 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $21 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $22 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $23 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $24 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $25 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $26 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $27 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $28 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $29 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $2A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $2B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $2C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $2D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $2E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $2F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $30 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $31 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $32 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $33 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $34 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $35 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $36 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $37 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $38 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $39 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $3A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $3B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $3C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $3D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $3E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $3F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $40 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $41 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $42 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $43 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $44 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $45 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $46 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $47 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $48 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $49 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $4A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $4B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $4C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $4D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $4E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $4F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $50 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $51 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $52 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $53 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $54 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $55 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $56 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $57 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $58 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $59 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $5A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $5B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $5C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $5D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $5E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $5F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $60 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $61 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $62 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $63 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $64 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $65 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $66 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $67 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $68 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $69 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $6A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $6B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $6C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $6D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $6E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $6F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $70 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $71 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $72 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $73 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $74 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $75 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $76 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $77 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $78 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $79 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $7A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $7B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $7C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $7D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $7E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $7F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $80 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $81 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $82 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $83 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $84 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $85 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $86 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $87 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $88 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $89 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $8A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $8B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $8C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $8D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $8E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $8F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $90 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $91 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $92 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $93 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $94 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $95 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $96 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $97 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $98 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $99 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $9A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $9B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $9C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $9D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $9E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $9F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $A0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $A1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $A2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $A3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $A4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $A5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $A6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $A7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $A8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $A9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $AA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $AB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $AC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $AD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $AE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $AF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $B0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $B1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $B2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $B3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $B4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $B5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $B6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $B7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $B8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $B9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $BA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $BB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $BC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $BD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $BE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $BF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $C0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $C1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $C2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $C3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $C4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $C5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $C6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $C7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $C8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $C9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $CA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $CB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $CC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $CD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $CE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $CF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $D0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $D1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $D2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $D3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $D4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $D5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $D6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $D7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $D8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $D9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $DA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $DB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $DC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $DD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $DE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $DF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $E0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $E1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $E2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $E3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $E4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $E5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $E6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $E7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $E8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $E9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $EA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $EB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $EC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $ED * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $EE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $EF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

        ORG     $F0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $F1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $F2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $F3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $F4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $F5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $F6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $F7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $F8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $F9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $FA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $FB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $FC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $FD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $FE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES
        ORG     $FF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_RES

  ENDIF

;----------------------------------------------------------------------------

  IFDEF NMI

    MESSAGE "[NMI   active.]"

        ORG     $00 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $01 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $02 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $03 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $04 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $05 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $06 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $07 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $08 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $09 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $0A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $0B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $0C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $0D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $0E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $0F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $10 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $11 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $12 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $13 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $14 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $15 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $16 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $17 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $18 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $19 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $1A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $1B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $1C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $1D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $1E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $1F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $20 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $21 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $22 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $23 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $24 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $25 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $26 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $27 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $28 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $29 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $2A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $2B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $2C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $2D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $2E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $2F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $30 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $31 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $32 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $33 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $34 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $35 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $36 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $37 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $38 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $39 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $3A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $3B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $3C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $3D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $3E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $3F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $40 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $41 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $42 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $43 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $44 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $45 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $46 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $47 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $48 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $49 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $4A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $4B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $4C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $4D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $4E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $4F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $50 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $51 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $52 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $53 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $54 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $55 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $56 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $57 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $58 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $59 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $5A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $5B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $5C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $5D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $5E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $5F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $60 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $61 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $62 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $63 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $64 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $65 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $66 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $67 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $68 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $69 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $6A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $6B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $6C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $6D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $6E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $6F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $70 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $71 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $72 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $73 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $74 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $75 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $76 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $77 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $78 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $79 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $7A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $7B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $7C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $7D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $7E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $7F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $80 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $81 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $82 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $83 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $84 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $85 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $86 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $87 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $88 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $89 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $8A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $8B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $8C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $8D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $8E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $8F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $90 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $91 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $92 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $93 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $94 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $95 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $96 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $97 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $98 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $99 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $9A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $9B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $9C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $9D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $9E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $9F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $A0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $A1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $A2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $A3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $A4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $A5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $A6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $A7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $A8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $A9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $AA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $AB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $AC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $AD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $AE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $AF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $B0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $B1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $B2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $B3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $B4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $B5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $B6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $B7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $B8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $B9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $BA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $BB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $BC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $BD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $BE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $BF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $C0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $C1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $C2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $C3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $C4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $C5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $C6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $C7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $C8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $C9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $CA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $CB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $CC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $CD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $CE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $CF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $D0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $D1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $D2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $D3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $D4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $D5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $D6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $D7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $D8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $D9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $DA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $DB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $DC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $DD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $DE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $DF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $E0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $E1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $E2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $E3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $E4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $E5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $E6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $E7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $E8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $E9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $EA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $EB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $EC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $ED * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $EE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $EF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

        ORG     $F0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $F1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $F2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $F3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $F4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $F5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $F6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $F7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $F8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $F9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $FA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $FB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $FC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $FD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $FE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI
        ORG     $FF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_NMI

  ENDIF


;----------------------------------------------------------------------------

  IFDEF IRQ

    MESSAGE "[IRQ   active.]"

        ORG     $00 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $01 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $02 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $03 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $04 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $05 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $06 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $07 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $08 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $09 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $0A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $0B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $0C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $0D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $0E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $0F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $10 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $11 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $12 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $13 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $14 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $15 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $16 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $17 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $18 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $19 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $1A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $1B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $1C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $1D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $1E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $1F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $20 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $21 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $22 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $23 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $24 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $25 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $26 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $27 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $28 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $29 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $2A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $2B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $2C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $2D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $2E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $2F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $30 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $31 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $32 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $33 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $34 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $35 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $36 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $37 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $38 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $39 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $3A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $3B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $3C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $3D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $3E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $3F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $40 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $41 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $42 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $43 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $44 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $45 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $46 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $47 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $48 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $49 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $4A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $4B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $4C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $4D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $4E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $4F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $50 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $51 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $52 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $53 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $54 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $55 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $56 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $57 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $58 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $59 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $5A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $5B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $5C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $5D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $5E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $5F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $60 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $61 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $62 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $63 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $64 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $65 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $66 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $67 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $68 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $69 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $6A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $6B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $6C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $6D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $6E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $6F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $70 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $71 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $72 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $73 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $74 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $75 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $76 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $77 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $78 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $79 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $7A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $7B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $7C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $7D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $7E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $7F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $80 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $81 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $82 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $83 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $84 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $85 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $86 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $87 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $88 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $89 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $8A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $8B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $8C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $8D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $8E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $8F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $90 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $91 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $92 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $93 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $94 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $95 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $96 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $97 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $98 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $99 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $9A * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $9B * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $9C * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $9D * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $9E * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $9F * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $A0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $A1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $A2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $A3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $A4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $A5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $A6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $A7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $A8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $A9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $AA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $AB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $AC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $AD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $AE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $AF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $B0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $B1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $B2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $B3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $B4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $B5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $B6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $B7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $B8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $B9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $BA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $BB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $BC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $BD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $BE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $BF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $C0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $C1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $C2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $C3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $C4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $C5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $C6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $C7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $C8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $C9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $CA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $CB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $CC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $CD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $CE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $CF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $D0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $D1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $D2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $D3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $D4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $D5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $D6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $D7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $D8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $D9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $DA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $DB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $DC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $DD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $DE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $DF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $E0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $E1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $E2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $E3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $E4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $E5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $E6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $E7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $E8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $E9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $EA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $EB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $EC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $ED * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $EE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $EF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

        ORG     $F0 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $F1 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $F2 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $F3 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $F4 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $F5 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $F6 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $F7 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $F8 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $F9 * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $FA * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $FB * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $FC * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $FD * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $FE * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ
        ORG     $FF * 32 *4 ;*4 because DC.L has 4 Bytes
        M_IRQ

  ENDIF


;============================================================================

  END


