@echo off
rem ----------------------------------------------------------------------
rem Dieter 07/2002..11/2002
rem
rem make.bat for the M1 microcode.
rem the AS assembler can only generate 32 kBytes *.bin files.
rem so we compile it 8 times with diferent switches
rem and put the result together.
rem ----------------------------------------------------------------------

echo --------------------------------------------------------------------
echo generating the ALU.
m1alu.exe
echo --------------------------------------------------------------------

echo --------------------------------------------------------------------
echo preparing files.
echo --------------------------------------------------------------------

rem  Bank 0, Flag = 0, no RES/NMI/IRQ
echo FLAG_LO equ 1 >     m1_0.asm
copy m1_0.asm+m1code.asm m1_0.asm

rem  Bank 1, Flag = 1, no RES/NMI/IRQ 
echo FLAG_HI equ 1 >     m1_1.asm
copy m1_1.asm+m1code.asm m1_1.asm

rem  Bank 2,3: IRQ
echo IRQ  equ 1 >        m1_2.asm
copy m1_2.asm+m1code.asm m1_2.asm

rem  Bank 4,5: NMI
echo NMI  equ 1 >        m1_4.asm
copy m1_4.asm+m1code.asm m1_4.asm

rem  Bank 6,7: RES
echo RES  equ 1 >        m1_6.asm
copy m1_6.asm+m1code.asm m1_6.asm

rem ----------------------------------------------------------------------
rem now we compile this stuff.
rem ----------------------------------------------------------------------

echo --------------------------------------------------------------------
echo compiling.
echo --------------------------------------------------------------------

as    m1_0.asm /xn
echo --------------------------------------------------------------------
as    m1_1.asm /xn
echo --------------------------------------------------------------------
as    m1_2.asm /xn
copy  m1_2.p   m1_3.p
echo --------------------------------------------------------------------
as    m1_4.asm /xn
copy  m1_4.p   m1_5.p
echo --------------------------------------------------------------------
as    m1_6.asm /xn
copy  m1_6.p   m1_7.p

rem ----------------------------------------------------------------------
rem now to plug it together.   
rem ----------------------------------------------------------------------

echo --------------------------------------------------------------------
echo generating binaries.
echo --------------------------------------------------------------------

p2bin m1_0.p m1_0.bin
p2bin m1_1.p m1_1.bin
p2bin m1_2.p m1_2.bin
p2bin m1_3.p m1_3.bin
p2bin m1_4.p m1_4.bin
p2bin m1_5.p m1_5.bin
p2bin m1_6.p m1_6.bin
p2bin m1_7.p m1_7.bin

echo --------------------------------------------------------------------
m1cgen

rem ----------------------------------------------------------------------
rem now to clean up.
rem ----------------------------------------------------------------------

echo --------------------------------------------------------------------
echo done. temp files will be deleted/removed.
echo --------------------------------------------------------------------

del m1_*.*
