#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>

/*------------------------------------------------------------------------*/

long do_keyboard(void);
char my_putch(char val);

void mw(long addr, long val);
long mr(long addr);

#define F12_EXIT -1

long key,key_sel,key_board[8];

int mem[8192];

/*------------------------------------------------------------------------*/

struct CPU_REGS
{
  int acc; //Akku
  int pc;  //PC

  int t0;  //Temp. 0
  int t1;  //Temp. 1

  int flag_c;
  int flag_z;
  int flag_n;

} cpu_regs;

/*------------------------------------------------------------------------*/

char my_putch(char val)
{
 char ch,tmp;

 if((char)val&0x80)
 {
   textbackground(WHITE);
   textcolor(BLUE);
 }
 else
 {
   textbackground(BLUE);
   textcolor(WHITE);
 }

 tmp=val&0x7f;

 // **
 //76543210

 switch(tmp)
 {
   case 0x00: ch='@'; break;
   case 31  : ch='_'; break;
   case 0x1e: ch='^'; break;
   case 27  : ch='['; break;
   case 29  : ch=']'; break;
   case 93  : ch='|'; break;
   case 94  : ch=''; break; //pi

   default: if(tmp <0x20) ch=tmp+0x60; else ch=tmp; break;
 }


 putch(ch);
 return(val);

// !"#$%&'()*+,-./0123456789:;<=>?
//@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_
//`abcdefghijklmnopqrstuvwxyz{|}~
}


void mw(long addr, long val)
{
 char ch;
 long x,y;

 if(addr<0x8000) mem[addr]=val;

 //Keyboard Scan
 if((addr&0x0ffff)==0x0dc00) {key_sel=val; /*gotoxy(1,1); printf("w");*/}

 if((addr&0xfc00)==0x0400)
 {
	y=1+(int)(addr-0x0400)/40;
	if(y<26)
	{
	  gotoxy(40+(int)(addr-0x0400)%40,y);
	  ch=(char)val&0x00ff;
	  my_putch(ch);
	}
 }
}

long mr(long addr)
{
 long val,i,mask;

 //Keyboard Scan
 if((addr&0x0ffff)==0xdc01)
 {
// gotoxy(1,2); printf("r");
   val=0x0ff; mask=0x01;
   for(i=0;i<8;i++)
   {
     if((long)(key_sel&mask&0x0ff)==0) val &= key_board[i];
     mask<<=1;
   }
   return(val);
 }

 if(addr<0x8000) val=mem[addr];

 return(val);
}

/*------------------------------------------------------------------------*/

long do_keyboard(void)
{
  int i;

  for(i=0;i<8;i++) key_board[i]=0x0ff;
  if(!kbhit()) {return(0);}

  if((key=getch()&0xff)==0) key=(getch()&0xff)|0x0100;
  else
  {
    if((key>='A')&&(key<='Z'))
    {
      key=tolower(key); key_board[1]=0x7f; key_board[6]=0xef; //shift
    }
  }

//gotoxy(1,1); printf("%03x",key);
  switch(key)
  {
    case 'a': key_board[1]=0x0fb; break;
    case 'b': key_board[3]=0x0ef; break;
    case 'c': key_board[2]=0x0ef; break;
    case 'd': key_board[2]=0x0fb; break;
    case 'e': key_board[1]=0x0bf; break;
    case 'f': key_board[2]=0x0df; break;
    case 'g': key_board[3]=0x0fb; break;
    case 'h': key_board[3]=0x0df; break;
    case 'i': key_board[4]=0x0fd; break;
    case 'j': key_board[4]=0x0fb; break;
    case 'k': key_board[4]=0x0df; break;
    case 'l': key_board[5]=0x0fb; break;
    case 'm': key_board[4]=0x0ef; break;
    case 'n': key_board[4]=0x07f; break;
    case 'o': key_board[4]=0x0bf; break;
    case 'p': key_board[5]=0x0fd; break;
    case 'q': key_board[7]=0x0bf; break;
    case 'r': key_board[2]=0x0fd; break;
    case 's': key_board[1]=0x0df; break;
    case 't': key_board[2]=0x0bf; break;
    case 'u': key_board[3]=0x0bf; break;
    case 'v': key_board[3]=0x07f; break;
    case 'w': key_board[1]=0x0fd; break;
    case 'x': key_board[2]=0x07f; break;
    case 'y': key_board[3]=0x0fd; break;
    case 'z': key_board[1]=0x0ef; break;
    case '0': key_board[4]=0x0f7; break;
    case '1': key_board[7]=0x0fe; break;
    case '2': key_board[7]=0x0f7; break;
    case '3': key_board[1]=0x0fe; break;
    case '4': key_board[1]=0x0f7; break;
    case '5': key_board[2]=0x0fe; break;
    case '6': key_board[2]=0x0f7; break;
    case '7': key_board[3]=0x0fe; break;
    case '8': key_board[3]=0x0f7; break;
    case '9': key_board[4]=0x0fe; break;
    case ' ': key_board[7]=0x0ef; break;
    case '+': key_board[5]=0x0fe; break;
    case '-': key_board[5]=0x0f7; break;
    case '.': key_board[5]=0x0ef; break;
    case '>': key_board[5]=0x0ef; key_board[1]=0x7f; break;
    case ':': key_board[5]=0x0df; break;
    case '[': key_board[5]=0x0df; key_board[1]=0x7f; break;
    case '@': key_board[5]=0x0bf; break;
    case '_': key_board[7]=0x0fd; break;
    case ',': key_board[5]=0x07f; break;
    case '<': key_board[5]=0x07f; key_board[1]=0x7f; break;

    case '*': key_board[6]=0x0fd; break;
    case ';': key_board[6]=0x0fb; break;
    case ']': key_board[6]=0x0fb; key_board[1]=0x7f; break;
    case '=': key_board[6]=0x0df; break;
    case '^': key_board[6]=0x0bf; break;
    case '\\': key_board[6]=0x0fe; break;
    case 0xf8: key_board[6]=0x0bf; key_board[1]=0x7f; break;//
    case '/': key_board[6]=0x07f; break;
    case '?': key_board[6]=0x07f; key_board[1]=0x7f; break;
    case '!': key_board[7]=0x0fe; key_board[1]=0x7f; break;
    case '"': key_board[7]=0x0f7; key_board[1]=0x7f; break;
    case '#': key_board[1]=0x0fe; key_board[6]=0xef; break;
    case '$': key_board[1]=0x0f7; key_board[6]=0xef; break;
    case '%': key_board[2]=0x0fe; key_board[1]=0x7f; break;
    case '&': key_board[2]=0x0f7; key_board[1]=0x7f; break;
    case 39:  key_board[3]=0x0fe; key_board[1]=0x7f; break;
    case '(': key_board[3]=0x0f7; key_board[1]=0x7f; break;
    case ')': key_board[4]=0x0fe; key_board[1]=0x7f; break;

    case 27:  key_board[7]=0x7f;  break; //run stop
    case 0x0d:key_board[0]=0x0fd; break;

    case 0x008: /*backspace*/ key_board[0]=0x0fe; break;
    case 0x153: /*del      */ key_board[0]=0x0fe; break;
    case 0x152: /*ins      */ key_board[0]=0x0fe; key_board[1]=0x7f; break;
    case 0x147: /*home     */ key_board[6]=0x0f7; break;
    case 0x177: /*cls      */ key_board[6]=0x0f7; key_board[1]=0x7f; break;
    case 0x197: /*cls      */ key_board[6]=0x0f7; key_board[1]=0x7f; break;
    case 0x14b: /*csr_left */ key_board[0]=0x0fb; key_board[1]=0x7f; break;
    case 0x14d: /*csr_right*/ key_board[0]=0x0fb; break;
    case 0x148: /*csr_up   */ key_board[0]=0x07f; key_board[1]=0x7f; break;
    case 0x150: /*csr_down */ key_board[0]=0x07f; break;

    case 0x13b: /*f1 */ key_board[0]=0x0ef; break;
    case 0x13c: /*f2 */ key_board[0]=0x0ef; key_board[1]=0x7f; break;
    case 0x13d: /*f3 */ key_board[0]=0x0df; break;
    case 0x13e: /*f4 */ key_board[0]=0x0df; key_board[1]=0x7f; break;
    case 0x13f: /*f5 */ key_board[0]=0x0bf; break;
    case 0x140: /*f6 */ key_board[0]=0x0bf; key_board[1]=0x7f; break;
    case 0x141: /*f7 */ key_board[0]=0x0f7; break;
    case 0x142: /*f8 */ key_board[0]=0x0f7; key_board[1]=0x7f; break;

    case 0x143: /*f9 */ key_board[4]=0x0fe; key_board[7]=0xfb; break;
    case 0x144: /*f10*/ key_board[4]=0x0f7; key_board[7]=0xfb; break;

    case 0x186: return(F12_EXIT); //F12 exit.
  }

  return(0);
}

/*------------------------------------------------------------------------*/

void exec(void)
{
 long opcode;
 long addr,cin;
 long val;
 long tic;

 tic=0;
 while(1)
 {
//#ifdef KB_EMU
//  tic++;
//  if(tic>1000)
//  {tic=0; if(do_keyboard()) return;} //Exit Emulator when F12 pressed.
//#endif

  opcode=mr(cpu_regs.pc)&0x0ffff; //read OpCode

  cpu_regs.pc++;

  //Emulator functions
  if(opcode==0)
  {
    val=mr(cpu_regs.pc)&0x0ffff;

    switch(val)
    {
      case 0xffff: return; //Emulator stop

      case 0xfffe: //PC getc() into ACC
                   if((cpu_regs.acc=getch())==0) cpu_regs.acc=getch()|0x0100;
                   cpu_regs.pc++;
                   if(cpu_regs.acc==0x0186) return; //F12 Exit
                   continue;

      case 0xfffd: //convert PC getch to C64 Keyboard scan
                   cpu_regs.pc++;
                   if(do_keyboard()) return; //F12 Exit
                   continue;
    }
  }

  switch((opcode>>13)&7)
  {
    case 0: break;
    case 1: break; //external Flag input. We'll check that later.
    case 2: if(cpu_regs.flag_n==0) break; else {cpu_regs.pc++; continue;}
    case 3: if(cpu_regs.flag_n!=0) break; else {cpu_regs.pc++; continue;}
    case 4: if(cpu_regs.flag_z==0) break; else {cpu_regs.pc++; continue;}
    case 5: if(cpu_regs.flag_z!=0) break; else {cpu_regs.pc++; continue;}
    case 6: if(cpu_regs.flag_c==0) break; else {cpu_regs.pc++; continue;}
    case 7: if(cpu_regs.flag_c!=0) break; else {cpu_regs.pc++; continue;}
  }

//Flag_Condition true

  switch((opcode>>11)&3) //Addressing mode
  {
    case 0: addr=cpu_regs.pc; goto EXEC1;
    case 1: addr=mr(cpu_regs.pc)+cpu_regs.pc+1; break;
    case 2: addr=mr(cpu_regs.pc)+cpu_regs.acc;  break;
    case 3: addr=mr(cpu_regs.pc);               break;
  }

  switch((opcode>>10)&1) //indirect Adressing ?
  {
    case 0: break;
    case 1: addr=mr(addr); break;
  }

EXEC1: //done with address calculation.

  switch((opcode>>9)&1) //ALU source register
  {
    case 0: val=cpu_regs.acc & 0x0ffff; break;
    case 1: val=cpu_regs.pc  & 0x0ffff; break;
  }

  switch((opcode>>4)&3) //Carry Input: ALU c_in multiplexer
  {
    case 0: cin=0; break;                 //c_in=0
    case 1: cin=cpu_regs.flag_c&1; break; //c_in=C_Flag
    case 2:                               //c_in=1
    case 3: cin=1; break;                 //c_in=1
  }

  switch(opcode&0x0f) //ALU command
  {
    case 0x0: /*and*/ val&=mr(addr) &0x0ffff;    break;
    case 0x1: /*ann*/ val&=!mr(addr)&0x0ffff;    break;
    case 0x2: /*ora*/ val|=mr(addr) &0x0ffff;    break;
    case 0x3: /*xor*/ val^=mr(addr) &0x0ffff;    break;
    case 0x4: /*mvr*/ /*val is ALU source reg*/  break;
    case 0x5: /*mvm*/ val=mr(addr)&0xffff;       break;
    case 0x6: /*dec*/ val=(mr(addr)&0xffff)-1;   break;
    case 0x7: /*set*/ val=0xffff;                break;
    case 0x8: /*clr*/ val=0;                     break;
    case 0x9: /*add*/ val+=mr(addr)&0xffff;      break;
    case 0xa: /*sub*/ val+=((~mr(addr))&0xffff); break;
    case 0xb: /*sbu*/ val=(mr(addr)&0xffff)+val^0x0ffff; break;
    case 0xc: /*srr*/ val>>=1;                   break;
    case 0xd: /*srm*/ val=mr(addr)>>1;           break;
    case 0xe: /*slr*/ val<<=1;                   break;
    case 0xf: /*slm*/ val=mr(addr)<<1;           break;
  }
  val+=cin;

  switch((opcode>>6)&1) //update Flags
  {
    case 0: break;
    case 1: if((val&0xffff)==0) cpu_regs.flag_z=-1; else cpu_regs.flag_z=0;
            if((val&0x8000)==0) cpu_regs.flag_n=0;  else cpu_regs.flag_n=-1;

    if((opcode&0x08)!=0) //modify C_Flag ?
    {
      if((val&0x000f0000)!=0) cpu_regs.flag_c=-1; else cpu_regs.flag_c=0;
    }
  }

  switch((opcode>>7)&3) //write back
  {
    case 3: mw(addr,val);     cpu_regs.pc++; break;
    case 2: cpu_regs.pc=val;                 break;
    case 1: cpu_regs.acc=val; cpu_regs.pc++; break;
    case 0:                   cpu_regs.pc++; break;
  }
 }
}

int main(void)
{
 int addr,i,j;
 char str[80];
 FILE *fin;

 clrscr();

 while(1)
 {
   scanf("%s",str);
   switch(tolower(str[0]))
   {
     case 'q': return(0);

     case 'c': clrscr(); break;

     case 'l': scanf("%s",str);
               fin=fopen(str,"rb");
               if(fin==0) break;
               for(i=0;i<8192;i++)
               {
                 mem[i]=fgetc(fin)<<8;
                 if(feof(fin)) break;
                 mem[i]|=fgetc(fin)&0xff;
                 if(feof(fin)) break;
               }
               printf("\ngeladen\n");
               break;

     case 'm': scanf("%x",&addr);
               for(i=0;i<8;i++)
               {
                 printf("%04x:",addr);
                 for(j=0;j<8;j++)
                 {
                   printf("%04X ",mem[addr]); addr++;
                 }
                 printf("\n");
               }
               break;

     case 'g': scanf("%x",&addr);
               cpu_regs.pc=addr; exec(); gotoxy(1,1);

     case 'r': printf("PC=%04X " ,cpu_regs.pc);
               printf("ACC=%04X ",cpu_regs.acc);
               printf("C=%x "    ,cpu_regs.flag_c&1);
               printf("N=%x "    ,cpu_regs.flag_n&1);
               printf("Z=%x "    ,cpu_regs.flag_z&1);
               printf("\n");
               break;

     case 'e': scanf("%x",&addr);
               while(1)
               {
                 scanf("%s",str);
                 if(!isxdigit(str[0])) break;
                 sscanf(str,"%x",&mem[addr]); addr++;
               }
               break;
   }
 }
}



/*------------------------------------------------------------------------*/


