#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#define V_HI 0
#define V_LO 0

/*-------------------------------------------------------------------------*/

int  main(void);
long get_hex(char *ptr);
int  iseol(char ch);
int  do_spi(char mod,int val); //default: mod=0xff
char get_str(char *ptr);

#define DATA_LO  0xfe
#define CLK_LO   0xfd
#define LD165_ON 0xfb
#define BOA_ON   0xf7
#define BOD_ON   0xef
#define BWE_ON   0xdf
#define RES_ON   0x7f

#define LPT1     0x378

#define MEM_SIZE 8192

/*-------------------------------------------------------------------------*/

int do_spi(char mod,int val) //default: mod=0xff
{
  int i;
  char d;

  for(i=0;i<16;i++)
  {
    //hoechstes Bit zuerst
    if((int)val&0x8000) d=-1; else d=DATA_LO;
    outp(LPT1,d&mod); outp(LPT1,d&mod);           //CLK=1
    val<<=1; if((inp(LPT1+1)&0x80)==0) val|=1; //ACHTUNG: BUSY invertiert.
    outp(LPT1,CLK_LO&d&mod);                      //CLK=0
    outp(LPT1,CLK_LO&d&mod);                      //CLK=0
    outp(LPT1,d&mod); outp(LPT1,d&mod);           //CLK=1
  }
  return(val);
}

int iseol(char ch)
{
  if(ch==0x0d) return(-1);
  if(ch==0x0a) return(-1);
  return(0);
}

long get_hex(char *ptr)
{
 long val;
 char scharf;

 val=0; scharf=0;
 while(1)
 {
   *ptr=getche();
   if(!isxdigit(*ptr)&&(*ptr!=' ')) break;
   if((*ptr==' ')&scharf) break;
   if( *ptr!=' ') scharf=-1;

   val<<=4;
   val|=(*ptr&0x0f);
   if(*ptr>'9') val+=9; //Korrektur
 }

 return(val);
}

char get_str(char *ptr)
{
  char ch,scharf;
  int i;
  i=0; scharf=0;
  while(1)
  {
    *ptr=0;
    ch=getche();
    if((ch==0x08)&&(i>0)) {i--; ptr--; continue;}
    if((ch==' ')&&!scharf) continue;
    if( ch=='"') continue;

    if(iseol(ch)) return(ch);
    if((ch==' ')&&scharf) return(ch);
    if(ch!=' ') scharf=-1;

    if(i==16) return(0);
    *ptr=ch; i++; ptr++;
  }
}

int main(void)
{
 char str[32];
 int mem[MEM_SIZE];
 int i;
 long start,end;
 char ch;
 FILE *stream;

 //delay(1);

 clrscr();
 printf("MT15 memory interface V%02d.%02d\n",V_HI,V_LO);
 outp(LPT1,RES_ON); //default: RESET ein

 while(1)
 {
   ch=getche();
   if(ch==27) break; //ESCAPE

   switch(tolower(ch))
   {
     case 'h': printf("\n m xxxx yyyy //print memory from xxxx to yyyy");
               printf("\n e xxxx yyyy //write yyyy to address xxxx");
               printf("\n");
               break;

     case 'm': start=get_hex(&ch);
               if(iseol(ch)) end=start+0x07; else end=get_hex(&ch);
               while(1)
               {
                 printf("\n%04X:",start);
                 for(i=0;i<0x08;i++)
                 {
                   printf("%04X ",mem[start]); start++;
                 }
                 if(start > end) break;
                 if(start >= MEM_SIZE) break;
               }
               printf("\n");
               break;

     case 'e': start=get_hex(&ch);
               while(1)
               {
                 if(ch!=' ') break;
                 mem[start]=get_hex(&ch);
                 start++;
               }
               printf("\n");
               break;

     case 'l': get_str(str); start=get_hex(&ch);
               stream=fopen(str,"rb");
               if(stream==NULL)
               {printf("\n'%s' File open Error.\n",str); continue;}
               while(1)
               {
                 mem[start] =fgetc(stream) <<8;
                 mem[start]|=fgetc(stream) & 0x00ff;
                 if(feof(stream)) break;
                 start++;
                 if(start>=MEM_SIZE) break;
               }
               fclose(stream);
               printf("\nEND=%04x\n",start-1);
               break;

     case 's': get_str(str); start=get_hex(&ch);
               if(iseol(ch)) end=start+0x07; else end=get_hex(&ch);
               stream=fopen(str,"wb");
               if(stream==NULL)
               {printf("\n'%s' File open Error.\n",str); continue;}
               while(1)
               {
                 fputc(mem[start]>>8,stream);
                 fputc(mem[start]&0x00ff,stream);
                 start++;
                 if(start>=MEM_SIZE) break;
                 if(start > end) break;
               }
               fclose(stream);
               printf("\n");
               break;

     case 'g': for(start=0;start<MEM_SIZE;start++)
               {
                 do_spi(RES_ON&BOA_ON&BOD_ON,mem[start]); //Daten
                 do_spi(RES_ON&BOA_ON&BOD_ON,start     ); //Adresse
                 outp(LPT1,RES_ON&BOA_ON&BOD_ON);
                 outp(LPT1,RES_ON&BOA_ON&BOD_ON&BWE_ON);
                 outp(LPT1,RES_ON&BOA_ON&BOD_ON&BWE_ON);
                 outp(LPT1,RES_ON&BOA_ON&BOD_ON);
               }
               delay(1);
               outp(LPT1,0xff); //Prozessor anwerfen
               printf("\nok.\n");
               break;

     case 't': outp(LPT1,RES_ON); delay(1);
               for(start=0;start<MEM_SIZE;start++)
               {
                 do_spi(RES_ON&BOA_ON,start); //Adresse
                 outp(LPT1,RES_ON&BOA_ON);
                 outp(LPT1,RES_ON&BOA_ON&LD165_ON);
                 outp(LPT1,RES_ON&BOA_ON&LD165_ON);
                 outp(LPT1,RES_ON&BOA_ON);
                 mem[start]=do_spi(RES_ON&BOA_ON,0);
               }
               printf("\nok.\n");
               outp(LPT1,RES_ON); //default: RESET aktiv.
               break;
   }
 }

 return(0);
}

