
        CPU     68000
        PADDING OFF

;-------------------------------------------------------------------------
;Funktionen

ladr    function val, val>>1 ;Assembler zaehlt Bytes, Prozessor zaehlt Worte

;-------------------------------------------------------------------------

;Flag test
if_i    equ     $2000
if_nn   equ     $4000
if_n    equ     $6000
if_nz   equ     $8000
if_z    equ     $A000
if_nc   equ     $C000
if_c    equ     $E000

;rreg: read register 
;
ra      equ $0000
rpc     equ $0200

;wreg: write register
;
wa      equ $0080
wpc     equ $0100
wm      equ $0180
null    equ $0000

;addr: addressing mode   
;
imm     equ $0000
abs     equ $1800
absa    equ $1000
abspc   equ $0800
ind     equ $1c00
inda    equ $1400
indpc   equ $0c00

;modify flags
fmod    equ $0040

;carry input mux
cin_c   equ $0010
cin_1   equ $0030

;-------------------------------------------------------------------------

;Basic ALU ops, don't modify fags
;
_aand   equ     $0000
_aann   equ     $0001
_aora   equ     $0002
_axor   equ     $0003
_amvr   equ     $0004
_amvm   equ     $0005
_ainc   equ     $0005 | $30 ;mov mem, add 1
_adec   equ     $0006       
_aset   equ     $0007       
_aclr   equ     $0008
_aadd   equ     $0009
_asub   equ     $000a
_asbu   equ     $000b
_asrr   equ     $000c
_asrm   equ     $000d
_aslr   equ     $000e
_aslm   equ     $000f 

mvr     equ     _amvr | fmod
mvm     equ     _amvm | fmod
srr     equ     _asrr | fmod
slr     equ     _aslr | fmod

and     equ     _aand | fmod | wa
ann     equ     _aann | fmod | wa
ora     equ     _aora | fmod | wa
xor     equ     _axor | fmod | wa
inc     equ     _ainc | fmod | wm | cin_1 ;mov mem, add 1
dec     equ     _adec | fmod | wm 
set     equ     _aset |        wm
clr     equ     _aclr |        wm 
add     equ     _aadd | fmod | wa
adc     equ     _aadd | fmod | wa | cin_c
sub     equ     _asub | fmod | wa | cin_1
sbc     equ     _asub | fmod | wa | cin_c
sbu     equ     _asbu | fmod | wa
srm     equ     _asrm | fmod | wm
slm     equ     _aslm | fmod | wm

shl     equ     _aslm | fmod | wm 
shr     equ     _asrm | fmod | wm
rol     equ     _aslm | fmod | wm | cin_c
ror     equ     _asrm | fmod | wm | cin_c

lda     equ     _amvm | fmod | wa
sta     equ     _amvr |        wm
cmp     equ     _asub | fmod      | cin_1
tst     equ     _amvm | fmod

;-------------------------------------------------------------------------

sla     macro
        dc.w    _aslr | fmod | wa
        dc.w    0
        endm

sra     macro
        dc.w    _asrr | fmod | wa
        dc.w    0
        endm

rla     macro
        dc.w    _aslr | fmod | wa | cin_c
        dc.w    0
        endm

rra     macro
        dc.w    _asrr | fmod | wa | cin_c
        dc.w    0
        endm

;-------------------------------------------------------------------------

pha     macro
        ;
        dc.w    _adec | abs | wm        ;SP--
        dc.w    SP
        ;
        dc.w    _amvr | ind | wm        ;sta@ SP
        dc.w    SP
        endm

pla     macro
        ;
        dc.w    _amvm | ind | fmod | wa ;lda@ SP
        dc.w    SP
        ;
        dc.w    _ainc | abs | wm        ;SP++
        dc.w    SP
        endm

;WARNING:
;
;when ALU_src = PC, PC points to argument.
;for JSR re_entry adress calculation, add 1.

jsr#    macro   addr
        ;
        dc.w    _adec | abs | wm        ;SP--
        dc.w    SP
        ;
        dc.w    _aclr | cin_1 | ind | wm ;*SP = $0001
        dc.w    SP
        ;
        dc.w    _aslm | ind | wm        ;*SP = $0001*2 = $0002
        dc.w    SP
        ;
        dc.w    _aadd | rpc | ind | wm | cin_1 ;*SP += pc +1
        dc.w    SP              
        ;
        dc.w    _amvm | imm | wpc       ;jmp# addr
        dc.w    addr
        ;
        ;<- point of re_entry
        ;
        dc.w    _ainc | abs | wm        ;SP++
        dc.w    SP
        endm

jsr&    macro   addr
        ;
        dc.w    _adec | abs | wm        ;SP--
        dc.w    SP
        ;
        dc.w    _aclr | cin_1 | ind | wm ;*SP = $0001
        dc.w    SP
        ;
        dc.w    _aslm | ind | wm        ;*SP = $0001*2 = $0002
        dc.w    SP
        ;
        dc.w    _aadd | rpc | ind | wm | cin_1 ;*SP += pc +1
        dc.w    SP              
        ;
        dc.w    _amvm | abs | wpc       ;jmp& addr
        dc.w    addr
        ;
        ;<- point of re_entry
        ;
        dc.w    _ainc | abs | wm        ;SP++
        dc.w    SP
        endm

jsra&   macro   addr
        ;
        dc.w    _adec | abs | wm        ;SP--
        dc.w    SP
        ;
        dc.w    _aclr | cin_1 | ind | wm ;*SP = $0001
        dc.w    SP
        ;
        dc.w    _aslm | ind | wm        ;*SP = $0001*2 = $0002
        dc.w    SP
        ;
        dc.w    _aadd | rpc | ind | wm | cin_1 ;*SP += pc +1
        dc.w    SP              
        ;
        dc.w    _amvm | absa | wpc       ;jmpa& addr
        dc.w    addr
        ;
        ;<- point of re_entry
        ;
        dc.w    _ainc | abs | wm        ;SP++
        dc.w    SP
        endm

rts     macro
        ;
        dc.w    _amvm | ind | wpc       ;jmp@ SP
        dc.w    SP
        endm

;=========================================================================

jmpa@   macro   addr
        dc.w    _amvm | inda | wpc      ;jmp@ SP
        dc.w    addr
        endm

jmp@    macro   addr
        dc.w    _amvm | ind | wpc 
        dc.w    addr
        endm

jmp&    macro   addr
        dc.w    _amvm | abs | wpc
        dc.w    addr
        endm

jmpa&   macro   addr
        dc.w    _amvm | absa | wpc
        dc.w    addr
        endm

jmp#    macro   addr
        dc.w    _amvm | imm | wpc
        dc.w    addr
        endm

jnn#    macro   addr
        dc.w    $4000 | _amvm | imm | wpc
        dc.w    addr
        endm

jn#     macro   addr
        dc.w    $6000 | _amvm | imm | wpc
        dc.w    addr
        endm

jnz#    macro   addr
        dc.w    $8000 | _amvm | imm | wpc
        dc.w    addr
        endm

jz#     macro   addr
        dc.w    $A000 | _amvm | imm | wpc
        dc.w    addr
        endm

jnc#    macro   addr
        dc.w    $C000 | _amvm | imm | wpc
        dc.w    addr
        endm

jc#     macro   addr
        dc.w    $E000 | _amvm | imm | wpc
        dc.w    addr
        endm

;.........................................................................

retnn   macro
        dc.w    if_nn | _amvm | ind | wpc       ;jmp@ SP
        dc.w    SP
        endm

retn    macro
        dc.w    if_n  | _amvm | ind | wpc       ;jmp@ SP
        dc.w    SP
        endm

retnz   macro
        dc.w    if_nz | _amvm | ind | wpc       ;jmp@ SP
        dc.w    SP
        endm

retz    macro
        dc.w    if_z  | _amvm | ind | wpc       ;jmp@ SP
        dc.w    SP
        endm

retnc   macro
        dc.w    if_nc | _amvm | ind | wpc       ;jmp@ SP
        dc.w    SP
        endm

retc    macro
        dc.w    if_c  | _amvm | ind | wpc       ;jmp@ SP
        dc.w    SP
        endm


;-------------------------------------------------------------------------
