        ;PC ASCII
        ;
        ;  0123456789ABCDEF
        ;
        ;2  !"#$%&'()*+,-./
        ;3 0123456789:;<=>?
        ;4 @ABCDEFGHIJKLMNO
        ;5 PQRSTUVWXYZ[\]^_
        ;6 `abcdefghijklmno
        ;7 pqrstuvwxyz{|}~

        ;C64 screen code
        ;
        ;  0123456789ABCDEF
        ;
        ;0 @abcdefghijklmno
        ;1 pqrstuvwxyz[]^<
        ;2  !"#$%&'()*+,-./
        ;3 0123456789:;<=>?
        ;4 _ABCDEFGHIJKLMNO
        ;5 PQRSTUVWXYZ

;$0000,$xxxx NOP
;$0000,$ffff Emulator Stop
;$0000,$fffe PC getc() into ACC
;$0000,$fffd PC getc() to C64 Keyboard emulation


;Dieter 10/2005
;Test: clear screen
;display keyboard status on screen
;
;
;CSR_PUTC print character
;CSR_R    cursor right
;CSR_L    cursor left
;CSR_U    cursor up
;CSR_D    cursor down
;CSR_RET  Return
;CSR_H    cursor home
;CSR_INS  Insert
;CSR_BAK  Backspace
;CSR_DEL  Delete
;CSR_CLS  clear screen
;CSR_CLL  clear line
;CSR_CLE  clear from cursor to end of line
;CSR_GXY  set cursor to XY
;CSR_SAV  save cursor position          
;CSR_RET  restore saved cursor position 
;CSR_EIN  turn cursor on                
;CSR_AUS  turn cursor off               
;
;SCROLL   scroll screen

;Dieter: ACHTUNG: evtl. SCROLL veraendern fuer CONLOOP Anfang/Ende_Markierung

;---------------------------------------------------------------------------
        CPU     68000
;        MACEXP  OFF

        org     $0200

SP      ds.b    1       ;Stackpointer, used in pha/pla/jsr/rts macros

        LISTING OFF
        include "mt15.inc"
        LISTING ON

COUNT   ds.b    1    
PTR     ds.b    1     
PTR2    ds.b    1    

CSR_X   ds.b    1    
CSR_Y   ds.b    1     
CSR_ADR ds.b    1      
CSR_0   ds.b    1               ;Screen Address

CSR_ANS ds.b    1               ;ANSI status
CSR_X1  ds.b    1               ;saved cursor: x
CSR_Y1  ds.b    1               ;saved cursor: y
CSR_AD1 ds.b    1               ;saved cursor: address
CSR_AV1 ds.b    1    
CSR_AV2 ds.b    1    
CSR_ON  ds.b    1    

KB_STAT ds.b    1
KB_KEY  ds.b    1
kb_WAIT ds.b    1

CON_AD1 ds.b    1
CON_AD2 ds.b    1
CON_WHL ds.b    1       ;<>0: Zeile von Begin an lesen

MON_PTR ds.b    1
MON_TMP ds.b    1
MON_FLG ds.b    1
MON_ACC ds.b    1
MON_T2  ds.b    1       ;TMP2
MON_PT1 ds.b    1
MON_PT2 ds.b    1

IP      ds.b    1
DSP     ds.b    1
RSP     ds.b    1
WREG    ds.b    1
NREG    ds.b    $10

SCREEN  equ     $0400
PORTA   equ     $dc00
PORTB   equ     $dc01

;===========================================================================

        org     $0000
        jmp#    ladr(MAIN)
        jmp#    ladr(FLASH)
        jmp#    ladr(MFLASH)

TZURG
        add#    1
        jnz#    ladr(TZURG)
        inc&    $0400
        jmp#    ladr(TZURG)

        rts
;
;---------------------------------------------------------------------------

FLASH
        lda#    $0400
        sta&    PTR
        lda#    25*40
        sta&    COUNT
FLASH1
        lda@    PTR
        xor#    $0080
        sta@    PTR

        inc&    PTR
        dec&    COUNT
        jnz#    ladr(FLASH1)
        rts

;---------------------------------------------------------------------------

MFLASH
        lda#    1000
        sta&    PTR2
MFLASH1
        jsr#    ladr(FLASH)
        dec&    PTR2
        jnz#    ladr(MFLASH1)
        rts

;---------------------------------------------------------------------------


        org     $0800 *2
MAIN
        lda#    $0400-2
        sta&    SP              ;init StackPointer

        jsr#    ladr(INIT_CRT)
;
;        lda#    $0400
;        sta&    $0040

        ;done with Init/Reset.
MAIN0
;        jsr#    ladr(CONLOOP)
;        
;        sta@    $0040
;        inc&    $0040
;
;        jmp#    ladr(MAIN0)

;---------------------------------------------------------------------------

MONCOLD
        lda#    ladr(MON_PRA)
        jsr#    ladr(MONMSG)
        lda&    MON_ACC
        jsr#    ladr(MON_PUTW)

        jsr#    ladr(MON_PUTSPC)

        lda&    MON_FLG
        sta&    MON_TMP

        lda#    'C'
        jsr#    ladr(MON_PFLG)
        lda#    'N'
        jsr#    ladr(MON_PFLG)
        lda#    'Z'
        jsr#    ladr(MON_PFLG)

        jsr#    ladr(MON_PUTRET)

MONWARM
        jsr#    ladr(CONFLUSH)

        jsr#    ladr(CONLOOP)
        jz#     ladr(MONWARM)
        cmp#    ' '
        jz#     ladr(MONWARM)

        sta&    MON_PTR
        clr&    MON_T2
MONW1
        lda&    MON_T2
        ldaa&   ladr(MONWC)
        jz#     ladr(MONWE)
        cmp&    MON_PTR
        jnz#    ladr(MONW2)

        lda&    MON_T2
        jsra&   ladr(MONWA)
        jmp#    ladr(MONWARM)
MONW2
        inc&    MON_T2
        jmp#    ladr(MONW1)
;
MONWE   ;Error: unknown command.

        jsr#    ladr(MONERR)
        jmp#    ladr(MONWARM)
;
MONERR
;        jsr#    ladr(CONFLUSH)
        lda#    ladr(MON_ERR)

MONMSG
        sta&    MON_PTR
MONMS1
        lda@    MON_PTR
        sra
        sra
        sra
        sra
        sra
        sra
        sra
        sra
        retz
        jsr#    ladr(PUTC)

        lda@    MON_PTR
        and#    $00ff
        retz
        jsr#    ladr(PUTC)

        inc&    MON_PTR
        jmp#    ladr(MONMS1)

;
;
MONWC   dc.w    'm','M','.','g','G'
        dc.w    0
MONWA
        dc.w    ladr(MON_MEM)
        dc.w    ladr(MON_MEM)
        dc.w    ladr(MON_SET)
        dc.w    ladr(MON_GO)
        dc.w    ladr(MON_GO)

montest
        inc&    $0427
;        jsr#    ladr(CONFLUSH)
        rts

;---------------------------------------------------------------------------

MON_PFLG
        jsr#    ladr(PUTC)

        lda#    '='
        jsr#    ladr(PUTC)

        lda#    '0'
        shl&    MON_TMP
        adc#    0
        jsr#    ladr(PUTC)
MON_PUTSPC
        lda#    ' '
        jmp#    ladr(PUTC)

;---------------------------------------------------------------------------

MON_GO
        jsr#    ladr(MON_GETHEX); get address

        lda&    MON_ACC

        dc.w    _aslm | abs | fmod
        dc.w    MON_FLG

        jsr&    MON_TMP         ; execute
        sta&    MON_ACC

        dc.w    _aclr | imm | wa
        dc.w    0
        ;
        dc.w    if_c | _aora | imm | wa
        dc.w    $8000
        ;
        dc.w    if_n | _aora | imm | wa
        dc.w    $4000
        ;
        dc.w    if_z | _aora | imm | wa
        dc.w    $2000
        ;
        sta&    MON_FLG

        inc&    SP
        jmp#    ladr(MONCOLD)

;---------------------------------------------------------------------------

MON_SET
        jsr#    ladr(MON_GETHEX); get address
        jz#     ladr(MONERR)

        cmp#    ':'
        jnz#    ladr(MONERR)

        lda&    MON_TMP
        sta&    MON_PT1
MON_SET1

        jsr#    ladr(MON_GETHEX)
        pha

        lda&    MON_TMP
        sta@    MON_PT1
        inc&    MON_PT1

        pla
        cmp#    $0d
        jnz#    ladr(MON_SET1)
        rts

;---------------------------------------------------------------------------

MON_MEM

        jsr#    ladr(MON_GETHEX)
        jz#     ladr(MON_MEM1)

        lda&    MON_TMP
        sta&    MON_PT1         ;start address

        jsr#    ladr(MON_GETHEX)
        lda&    MON_TMP
        jmp#    ladr(MON_MEM2)
;
MON_MEM1 ;no end address specified

        lda&    MON_TMP
        sta&    MON_PT1
        add#    $10
MON_MEM2
        sta&    MON_PT2         ;end address
;        jsr#    ladr(CONFLUSH)

MON_MM20 ;print address

        lda#    '.'
        jsr#    ladr(PUTC)

        lda&    MON_PT1
        jsr#    ladr(MON_PUTW)

        lda#    ':'
        jsr#    ladr(PUTC)

        lda#    4
        sta&    MON_T2

MON_MM21 ;print one word of memory

        lda@    MON_PT1
        jsr#    ladr(MON_PUTW)
        lda#    ' '
        jsr#    ladr(PUTC)

        lda&    MON_PT1
        cmp&    MON_PT2
        jz#     ladr(MON_PUTRET)
        inc&    MON_PT1
        jc#     ladr(MON_PUTRET)

        dec&    MON_T2
        jnz#    ladr(MON_MM21)

        jsr#    ladr(MON_PUTRET)
        jmp#    ladr(MON_MM20)

;---------------------------------------------------------------------------

MON_PUTRET

        lda#    $0d
        jmp#    ladr(PUTC)

;---------------------------------------------------------------------------

MON_PUTW
        pha
        sra
        sra
        sra
        sra
        sra
        sra
        sra
        sra
        jsr#    ladr(MON_PUTB)  ;print HEX Byte

        pla

MON_PUTB
        pha
        sra
        sra
        sra
        sra
        jsr#    ladr(MON_PUTN)  ;print HEX Nibble

        pla

MON_PUTN
        and#    $0f
        cmp#    $0a
        jnc#    ladr(MON_PUTN1)
        add#    7
MON_PUTN1
        add#    '0'
        jmp#    ladr(PUTC)


;---------------------------------------------------------------------------

MON_GETHEX

        clr&    MON_T2
        clr&    MON_TMP
MON_GH1
        jsr#    ladr(CONLOOP)
        cmp#    ' '             ;space ?
        jnz#    ladr(MON_GH3)   ;continue, if yes.

        tst&    MON_T2          ;scharf ?
        jnz#    ladr(MON_GH0)   ;exit, if yes.
        jmp#    ladr(MON_GH1)   ;get next CHR
;
MON_GH3 ;no space

        set&    MON_T2          ;scharf !
        cmp#    '0'             ;<'0' ?
        jnc#    ladr(MON_GH0)   ;exit, if yes.

        cmp#    '9'+1           ;<='9' ?
        jnc#    ladr(MON_GETH31);continue, if no.

        cmp#    'A'             ;<'A' ?
        jnc#    ladr(MON_GH0)   ;continue, if no.

MON_GETH31
        shl&    MON_TMP
        shl&    MON_TMP
        shl&    MON_TMP
        shl&    MON_TMP

        cmp#    '9'+1           ;<='9' ?
        jnc#    ladr(MON_GH2)   ;continue, if yes.
        sub#    7
MON_GH2
        and#    $0f
        ora&    MON_TMP
        sta&    MON_TMP

        jmp#    ladr(MON_GH1)   ;get next CHR
;
MON_GH0
        cmp#    $0d             ;end of line ? Z=1: yes. Z=0: no.
        rts                     ;last CHR received is in ACC.

;---------------------------------------------------------------------------

        ;
        PADDING ON
        ;

MON_ERR dc.b    $1b,"[1A?",$0d,0
MON_PRA dc.b    $0d,"ACC=",0
        ;
        PADDING OFF
        ;

;---------------------------------------------------------------------------


;===========================================================================

CONFLUSH                        ;Flush
        lda&    CON_AD1
        retz

        jsr#    ladr(CONLOOP)
        cmp#    $0d
        jnz#    ladr(CONFLUSH)
        rts

;---------------------------------------------------------------------------

CONLOOP
        lda&    CON_AD1
        jnz#    ladr(CONL4)

        jsr#    ladr(CONGET)

        lda&    CSR_ADR
        sta&    CON_AD2
        sub#    40
        sta&    CON_AD1

CONL3
        lda&    CON_AD2
        cmp&    CON_AD1
        jnc#    ladr(CONL40)    ;if start > end, exit.

        dec&    CON_AD2
        lda@    CON_AD2
        cmp#    ' '
        jz#     ladr(CONL3) 
CONL4
        lda&    CON_AD2
        cmp&    CON_AD1
        jc#     ladr(CONL31)
CONL40
        clr&    CON_AD1
        lda#    $0d
        rts
CONL31
        lda@    CON_AD1
        inc&    CON_AD1

        ;Umrechnung C64 screen code -> ASCII

        cmp#    $20             ;<$20 ?
        jc#     ladr(CONL50)    ;continue, if yes.

        add#    $60             ;$00..$20 -> $60..$7f
        cmp#    $60
        jnz#    ladr(CONL32)
        xor#    $20
CONL32
        jmp#    ladr(CONL0)
;
CONL50
        cmp#    $40
        jnz#    ladr(CONL0)
        xor#    $20
CONL0
        ora#    0               ;set flags
        rts

;---------------------------------------------------------------------------

CONGET

CONGET1
     dc.w    $0000,$fffd        ;Emulator: C64 Keyboard

        jsr#    ladr(KSCAN)
        jz#     ladr(CONGET1)

        cmp#    $0100           ;>=$0100 ?
        jnc#    ladr(CONG3)     ;continue, if yes.

        ;ANSI sequence
        pha

        lda#    $1b             ;ESC
        jsr#    ladr(PUTC)
        lda#    '['
        jsr#    ladr(PUTC)

        lda@    SP
        sra
        sra
        sra
        sra
        sra
        sra
        sra
        sra
        jsr#    ladr(PUTC)

        pla
        and#    $00ff     
CONG3
        jsr#    ladr(PUTC)
        cmp#    $0d
        jnz#    ladr(CONGET)

        rts

;===========================================================================

KBHIT   ;key pressed ?

        clr&    PORTA
        lda&    PORTB
        cmp&    PORTB
        jnz#    ladr(KBHIT)

        cmp#    0
        jz#     ladr(KBHIT0)
        lda#    $ffff
KBHIT0
        rts     ;return -1, if yes.

;---------------------------------------------------------------------------

KSCAN

;Warning: removed those wait cycles for the emulator.
;         better turn them active when running the program on MT15 hardware !
;
;        inc&    KB_WAIT
;        lda&    KB_WAIT
;        and#    $01ff
;        jz#     ladr(KSC1)
;        lda#    0
;        rts

KSC1    ;Shift ?
        clr&    KB_STAT

        lda#    %11111101
        sta&    PORTA
    
        lda&    PORTB
        and#    %10000000
        jz#     ladr(KSC20)
KSC2
        lda#    %10111111
        sta&    PORTA

        lda&    PORTB
        and#    %00010000
        jnz#    ladr(KSC3)
KSC20 
        lda#    %01000000
        sta&    KB_STAT

KSC3    ;CTRL ?

        lda#    %01111111
        sta&    PORTA

        lda&    PORTB
        and#    %00000100
        jnz#    ladr(KSC4)

        lda#    %10000000       ;CTRL
        sta&    KB_STAT

KSC4    ;we scanned Shift and CTRL.

        clr&    COUNT
KSC40
        lda&    COUNT
        sra
        sra
        sra
 
        ldaa&   ladr(KEYTAB)
        sta&    PORTA
        dec&    SP              ;prepare to push
KSC41
        lda&    PORTB
        sta@    SP
        lda&    PORTB
        xor@    SP
        and#    $ff
        jnz#    ladr(KSC41)

        lda&    PORTB
        xor@    SP
        and#    $ff
        jnz#    ladr(KSC41)

KSC42
        lda&    COUNT
        and#    7
        ldaa&   ladr(KEYTAB)
        xor#    $ff

        and@    SP
        jnz#    ladr(KSC43)     ;key pressed ? continue, if no.

        ;key pressed

        lda&    COUNT
        ora&    KB_STAT

        ldaa&   ladr(KEYVAL)
        jz#     ladr(KSC43)     ;ignore ? continue, if no.

        cmp&    KB_KEY
        jz#     ladr(KSC43)

        inc&    SP
        jmp#    ladr(KSC50)
KSC43
        inc&    COUNT
        lda&    COUNT
        and#    7
        jnz#    ladr(KSC42)

        inc&    SP
        lda&    COUNT
        and#    %11000000       ;64 keys scanned ?
        jz#     ladr(KSC40)     ;continue, if yes.

        lda#    0               ;no key.
KSC50
        sta&    KB_KEY
KSC51
        ora#    0               ;set flags
        rts
;

KEYTAB
        dc.w    %11111110
        dc.w    %11111101
        dc.w    %11111011
        dc.w    %11110111
        dc.w    %11101111
        dc.w    %11011111
        dc.w    %10111111
        dc.w    %01111111

;---------------------------------------------------------------------------

;CSR=cursor right
;CSD=cursor down
;HOM=cursor home
;SPC=Space
;STP=RunStop
;SFT=Shift
;PFD=Pfund
;CTL=Control
;
;   r PB0 PB1 PB2 PB3 PB4 PB5 PB6 PB7
;w
;PA0  DEL RET CSR F7  F1  F2  F5  CSD
;PA1  3   W   A   4   Z   S   E   SFT
;PA2  5   R   D   6   C   F   T   X
;PA3  7   Y   G   8   B   H   U   Y
;PA4  9   I   J   Q   M   K   O   N
;PA5  +   P   L   -   .   :   @   ,
;PA6  PFD *   ;   HOM SFT =   ^   /
;PA7  1   <-  CTL 2   SPC C=  Q   STP
;

KDL     equ     $3100|'L'       ;delete
KIN     equ     $3100|'I'       ;insert
KCR     equ     $3100|'C'       ;csr right
KCL     equ     $3100|'D'       ;csr left
KCD     equ     $3100|'B'       ;csr down
KCU     equ     $3100|'A'       ;csr up
KHM     equ     $0100|'H'       ;csr home
KCS     equ     $3200|'J'       ;csr clear
KF1     equ     $08             ;Backspace
KF2     equ     0
KF5     equ     0
KF7     equ     0

KEYVAL

        ;normal
        ;
        dc.w   KDL,$0d,KCR,KF7,KF1,KF2,KF5,KCD
        dc.w   '3','w','a','4','z','s','e',0
        dc.w   '5','r','d','6','c','f','t','x'
        dc.w   '7','y','g','8','b','h','u','y'
        dc.w   '9','i','j','0','m','k','o','n'
        dc.w   '+','p','l','-','.',':','@',','
        dc.w   '\','*',';',KHM,0  ,'=','^','/'
        dc.w   '1','_',0  ,'2',' ',0  ,'q',$04

        ;shift active
        ;
        dc.w   KIN,$0d,KCL,KF7,KF1,KF2,KF5,KCU
        dc.w   '#','W','A','$','Z','S','E',0
        dc.w   '%','R','D','&','C','F','T','X'
        dc.w   $96,'Y','G','(','B','H','U','Y' 
        dc.w   ')','I','J','0','M','K','O','N'
        dc.w   '+','P','L','-','>',':','@','<'
        dc.w   '\','*',';',KCS,0  ,'=','^','?'
        dc.w   '!','_',0  ,'"',' ',0  ,'Q',$04

        ;CTRL active
        ;
        dc.w    0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  
        dc.w    $1c,$17,$01,$9f,$1a,$13,$05,0  
        dc.w    $9c,$12,$04,$1e,$03,$06,$14,$18
        dc.w    $1f,$19,$07,$9e,$02,$18,$15,$16
        dc.w    $12,$09,$0a,$92,$0d,$0b,$0f,$0e
        dc.w    0  ,$10,$0c,0  ,0  ,$1b,$00,0  
        dc.w    $1c,0  ,$1d,0  ,0  ,$1f,$1e,0  
        dc.w    $90,$06,0  ,$05,0  ,0  ,$11,0  

;===========================================================================
;ANSI:
;
;ESC [2J   clear screen
;
;ESC [#;#H wenn kein #,# cursor home. ansonsten wie [#;#f
;ESC [#;#f goto xy, line/column
;
;ESC [#A   move cursor # up
;ESC [#B   move cursor # down
;ESC [#C   move cursor # right
;ESC [#D   move cursor # left
;
;ESC [s    save    cursor position
;ESC [u    restore cursor position
;
;ESC [e    erase line
;ESC [K    erase from cursor to end of line
;ESC [a    turn cursor off
;ESC [b    turn cursor on

;ESC [#l delete
;ESC [#i insert


;===========================================================================

INIT_CRT
        pha                     ;save CHR

        clr&    KB_KEY
        clr&    CON_AD1

        lda#    SCREEN          ;init cursor address
        sta&    CSR_0

        jsr#    ladr(CSR_CLS)   ;clear screen, cursor home

        jsr#    ladr(CSR_SAV)   ;save cursor
        jsr#    ladr(CSR_EIN)   ;turn cursor on

        jmp#    ladr(PUTC_0)

;---------------------------------------------------------------------------

PUTC
        pha                     ;save CHR

        cmp#    2
        jnc#    ladr(PUTC_1)

        lda@    CSR_ADR         ;unmark cursor position
        and#    $7f
        sta@    CSR_ADR

        lda@    SP              ;restore CHR
        jsr&    CSR_ANS         ;execute

PUTC_0  ;PUTC exit point.

        lda#    ladr(PUTC_A0)   ;reset ANSI state
        sta&    CSR_ANS

        lda&    CSR_ON          ;cursor is on ?
        jz#     ladr(PUTC_1)    ;continue, if yes.

        lda@    CSR_ADR         ;mark cursor position
        ora#    $80
        sta@    CSR_ADR
PUTC_1
        pla                     ;restore CHR
        rts                     ;done.

;---------------------------------------------------------------------------

PUTC_A0 ;default: scan for ESC, print CHR if no ESC.

        cmp#    $1b             ;ESC ?
        jnz#    ladr(CSR_PUTC)  ;continue, if yes.
        lda#    ladr(PUTC_A1)   ;scan for '['
PUTC_AK
        sta&    CSR_ANS

        inc&    SP              ;remove return_address from stack
        jmp#    ladr(PUTC_1)    ;keep current ANSI state and cursor

;...........................................................................
CSR_PUTC ;no ANSI sequence. print CHR.

        cmp#    $0d             ;Return?
        jz#     ladr(CSR_RET)

        cmp#    $08
        jz#     ladr(CSR_BAK)

        cmp#    $20             ;<$20 ?
        retnc                   ;exit, if yes.

CSR_PT5
        ;convert ASCII to C64 screen code

        inc&    SP
        lda@    SP
        dec&    SP

        cmp#    $40             ;<$40 ?
        jnc#    ladr(CSR_PT2)   ;print, if yes.

        cmp#    $60             ;<$60 ?
        jnc#    ladr(CSR_PT9)
        sub#    $60             ;subtract $40, if no.
CSR_PT9
        cmp#    $00
        jz#     ladr(CSR_PT1)
        cmp#    $20
        jnz#    ladr(CSR_PT2)
CSR_PT1
        xor#    $20
CSR_PT2
        ;done with conversion

        sta@    CSR_ADR         ;write CHR to screen

CSR_R   ;Cursor right

        inc&    CSR_ADR         ;increment Pointer
        inc&    CSR_X           ;increment X
    
        lda&    CSR_X
        cmp#    40              ;End of line ?
        retnc                   ;continue, if yes.

        clr&    CSR_X           ;start of next Line
        jmp#    ladr(CSR_D1)    ;and one line down.

;---------------------------------------------------------------------------

PUTC_A1 ;scan for '['

        clr&    CSR_AV1         ;clear ANSI value //default

        cmp#    '['             ;valid sequence ?
        jnz#    ladr(CSR_PUTC)  ;reset ANSI state, if no. 

        lda#    ladr(PUTC_A2)   ;set ANSI status to 2: letter or number ?
        jmp#    ladr(PUTC_AK)

;---------------------------------------------------------------------------

PUTC_A2 ;we had ESC[ ;scan for letter or number 

        cmp#    '0'             ;<'0' ?
        jnc#    ladr(PUTC_A2N)  ;continue, if no.
        cmp#    '9'+1           ;>'9'?
        jnc#    ladr(PUTC_A2D)  ;continue, if yes.
        
PUTC_A2N ;CHR is no digit.

        pha
        set&    COUNT
PUTC_A21
        inc&    COUNT
        lda&    COUNT
        ldaa&   ladr(PUTCCT2)
        jnz#    ladr(PUTC_A22)

        pla
        jmp#    ladr(CSR_PUTC)
;
PUTC_A22
        cmp@    SP
        jnz#    ladr(PUTC_A21)

        inc&    SP
        lda&    COUNT
        jmpa&   ladr(PUTCAT2)      
;
PUTCCT2 dc.w    'H','K','E','S','U','A','B'
        dc.w    'h','k','e','s','u','a','b'
        dc.w    0
;
PUTCAT2
        dc.w    ladr(CSR_H)
        dc.w    ladr(CSR_CLE)
        dc.w    ladr(CSR_CLL)
        dc.w    ladr(CSR_SAV)
        dc.w    ladr(CSR_RST)
        dc.w    ladr(CSR_EIN)
        dc.w    ladr(CSR_AUS)
;
        dc.w    ladr(CSR_H)
        dc.w    ladr(CSR_CLE)
        dc.w    ladr(CSR_CLL)
        dc.w    ladr(CSR_SAV)
        dc.w    ladr(CSR_RST)
        dc.w    ladr(CSR_EIN)
        dc.w    ladr(CSR_AUS)

;---------------------------------------------------------------------------

PUTC_A3 ;scan number

        cmp#    '0'             ;<'0' ?
        jnc#    ladr(PUTC_A3N)  ;continue, if no.
        cmp#    '9'+1           ;>'9'?
        jc#     ladr(PUTC_A3N)  ;continue, if no. 

PUTC_A2D

        and#    $0f             ;push digit on stack
        pha

        lda&    CSR_AV1         ;ACC = CSR_AV1 *10
        sla
        sla
        add&    CSR_AV1
        sla

        add@    SP              ;add digit from stack
        sta&    CSR_AV1
        inc&    SP
PUTC_A31
        lda#    ladr(PUTC_A3)   ;keep on scanning a number
        jmp#    ladr(PUTC_AK)

;...........................................................................

PUTC_A3N ; done with number.

        cmp#    ';'             ;separator ?
        jnz#    ladr(PUTC_A32)  ;continue, if yes.

        lda&    CSR_AV1
        sta&    CSR_AV2
        clr&    CSR_AV1
        jmp#    ladr(PUTC_A31)  ;prepare to fetch next number.
;
PUTC_A32

        pha
        set&    COUNT
PUTC_A41
        inc&    COUNT
        lda&    COUNT
        ldaa&   ladr(PUTCCT3)
        jnz#    ladr(PUTC_A42)

        pla
        jmp#    ladr(CSR_PUTC)
;
PUTC_A42
        cmp@    SP
        jnz#    ladr(PUTC_A41)
        inc&    SP

        lda&    COUNT
        jmpa&   ladr(PUTCAT3)      
;
PUTCCT3 dc.w    'H','F','J','A','B','C','D','I','L'
        dc.w    'h','f','j','a','b','c','d','i','l'
        dc.w    0
;
PUTCAT3
        dc.w    ladr(PUTC_XY)
        dc.w    ladr(PUTC_XY)
        dc.w    ladr(PUTC_2J)
        dc.w    ladr(PUTC_A)
        dc.w    ladr(PUTC_B)
        dc.w    ladr(PUTC_C)
        dc.w    ladr(PUTC_D)
        dc.w    ladr(PUTC_I)
        dc.w    ladr(PUTC_L)
;
        dc.w    ladr(PUTC_XY)
        dc.w    ladr(PUTC_XY)
        dc.w    ladr(PUTC_2J)
        dc.w    ladr(PUTC_A)
        dc.w    ladr(PUTC_B)
        dc.w    ladr(PUTC_C)
        dc.w    ladr(PUTC_D)
        dc.w    ladr(PUTC_I)
        dc.w    ladr(PUTC_L)
;
PUTC_2J
        lda&    CSR_AV1
        cmp#    2
        jz#     ladr(CSR_CLS)
        rts
;
PUTC_XY
        lda&    CSR_AV1         ;X
        cmp#    40
        retc
        sub#    1
        sta&    CSR_X

        lda&    CSR_AV2         ;Y
        cmp#    25
        retc
        sub#    1
        sta&    CSR_Y

        jmp#    ladr(CSR_GXY)
;
PUTC_A
        jsr#    ladr(CSR_U)
        dec&    CSR_AV1
        jnz#    ladr(PUTC_A)
        rts
;
PUTC_B
        jsr#    ladr(CSR_D)
        dec&    CSR_AV1
        jnz#    ladr(PUTC_B)
        rts
;
PUTC_C
        jsr#    ladr(CSR_R)
        dec&    CSR_AV1
        jnz#    ladr(PUTC_C)
        rts
;
PUTC_D
        jsr#    ladr(CSR_L)
        dec&    CSR_AV1
        jnz#    ladr(PUTC_D)
        rts
;
PUTC_I
        jsr#    ladr(CSR_INS)
        dec&    CSR_AV1
        jnz#    ladr(PUTC_I)
        rts
;
PUTC_L
        jsr#    ladr(CSR_DEL)
        dec&    CSR_AV1
        jnz#    ladr(PUTC_L)
        rts

;---------------------------------------------------------------------------

CSR_SAV ;save cursor position

        lda&    CSR_X
        sta&    CSR_X1
        lda&    CSR_Y
        sta&    CSR_Y1
        lda&    CSR_ADR
        sta&    CSR_AD1
        rts
;
CSR_RST ;restore saved cursor position

        lda&    CSR_X1
        sta&    CSR_X
        lda&    CSR_Y1
        sta&    CSR_Y
        lda&    CSR_AD1
        sta&    CSR_ADR
        rts
;
CSR_EIN ;turn cursor on

        set&    CSR_ON
        rts
;
CSR_AUS ;turn cursor off

        clr&    CSR_ON
        rts

;---------------------------------------------------------------------------

CSR_INS ;Insert

        lda#    40-1
        sub&    CSR_X
        add&    CSR_ADR
        sta&    PTR
        sub#    1
        sta&    PTR2

        lda&    CSR_X
        sta&    COUNT
CSR_IN1
        lda&    COUNT
        cmp#    40-1
        jc#     ladr(CSR_DE2)

        lda@    PTR2
        sta@    PTR

        dec&    PTR
        dec&    PTR2
        inc&    COUNT
        jmp#    ladr(CSR_IN1)

;---------------------------------------------------------------------------

CSR_BAK ;Backspace

        jsr#    ladr(CSR_L)

CSR_DEL ;Delete

        lda&    CSR_ADR
        sta&    PTR
        add#    1
        sta&    PTR2

        lda&    CSR_X
        sta&    COUNT
CSR_DE1
        lda&    COUNT
        cmp#    40-1
        jc#     ladr(CSR_DE2)

        lda@    PTR2
        sta@    PTR

        inc&    PTR2
        inc&    PTR
        inc&    COUNT

        jmp#    ladr(CSR_DE1)
CSR_DE2
        lda#    ' '
        sta@    PTR
        rts

;---------------------------------------------------------------------------

CSR_RET ;return

        jsr#    ladr(CSR_BEG)
;...........................................................................

CSR_D   ;Cursor down

        lda&    CSR_ADR         ;next line
        add#    40
        sta&    CSR_ADR
CSR_D1
        inc&    CSR_Y
        lda&    CSR_Y
        cmp#    25              ;last line exceeded ?
        retnc                   ;continue, if yes.

        dec&    CSR_Y
        lda&    CSR_ADR
        sub#    40
        sta&    CSR_ADR

        jsr#    ladr(SCROLL)

        lda&    CON_AD1
        sub#    40
        sta&    CON_AD1

        lda&    CON_AD2
        sub#    40
        sta&    CON_AD2

;...........................................................................

CSR_CLL ;clear line

        jsr#    ladr(CSR_BEG)

CSR_CLE ;clear from Cursor to end of line

        lda&    CSR_X
        sta&    COUNT

        lda&    CSR_ADR
        sta&    PTR
CSR_CE1
        lda&    COUNT
        cmp#    40
        retc

        lda#    ' '
        sta@    PTR       
        inc&    PTR     
        inc&    COUNT
        jmp#    ladr(CSR_CE1)

;---------------------------------------------------------------------------

CSR_BEG ;set Cursor to begin of line

        lda&    CSR_ADR         ;set Cursor to begin of line
        sub&    CSR_X
        sta&    CSR_ADR
        clr&    CSR_X
        rts

;---------------------------------------------------------------------------

SCROLL  ;scroll screen

        lda#    24*40
        sta&    COUNT

        lda#    $0400
        sta&    PTR
        add#    40
        sta&    PTR2
SCROL1
        lda@    PTR2
        sta@    PTR

        inc&    PTR
        inc&    PTR2
        dec&    COUNT
        jnz#    ladr(SCROL1)
        rts

;---------------------------------------------------------------------------

CSR_L   ;Cursor left

        lda&    CSR_X
        ora&    CSR_Y           ;is Cursor home ?
        retz                    ;exit, if yes.

        dec&    CSR_ADR
        dec&    CSR_X
        retnn                   ;begin of line ? continue, if yes.

        lda#    40-1
        sta&    CSR_X
        dec&    CSR_Y

        rts

;---------------------------------------------------------------------------

CSR_U   ;Cursor up

        lda&    CSR_Y
        retz                    

        lda&    CSR_ADR
        sub#    40
        sta&    CSR_ADR
        dec&    CSR_Y

        rts

;---------------------------------------------------------------------------

CSR_CLS ;clear screen

        lda#    25*40           ;1000 CHRs
        sta&    COUNT

        lda&    CSR_0           ;screen Startadress
        sta&    PTR

        lda#    ' '
CSR_CS1
        sta@    PTR             ;clear CHR
        inc&    PTR             ;increment pointer
        dec&    COUNT           ;all CHRs done ?
        jnz#    ladr(CSR_CS1)
;...........................................................................

CSR_H   ;Cursor home

        clr&    CSR_X           ;set Cursor to 0/0
        clr&    CSR_Y
        lda&    CSR_0 
        sta&    CSR_ADR

        rts

;---------------------------------------------------------------------------

CSR_GXY ;Cursor goto XY, calculate display address

        lda&    CSR_Y           ;Y * 40

        sla
        sla
        sla

        dec&    SP              
        sta@    SP              ;push ACC<<3

        sla
        sla

        add@    SP              ;(ACC<<5) + (ACC<<3) = ACC*$28 = ACC*40
        inc&    SP
        
        add&    CSR_X           ;add X
        add&    CSR_0           ;add display start address
        sta&    CSR_ADR         ;done.

        rts

;===========================================================================

        END

