#define PARANOID yes
#define BORLAND yes
//no unistd.h with Borland

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef BORLAND
#include <dos.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef BORLAND
#include <unistd.h>
#endif
#include <errno.h>

//DOS Borland C 2.0

#define nDATA   0xfe
#define nCMD    0xfd
#define nEXT    0xfb
#define PCTRG   0xf7
#define nPCSTOP 0xef
#define nRES    0xdf
#define CLK_LO  0xbf
#define DATA_LO 0x7f

#define  DONE   0x80
#define nSTOP   0x40
#define STAT0   0x20
#define STAT1   0x10
#define SDI     0x08

#define LPT1    0x378
#define TRGWAIT 100

//#define SR_BUG  "SR_BUG"

#define VERSION 0.0

int error;

#ifndef BORLAND
void outp(int device, char value)
{
}

char inp(int device)
{
    return(0);
}
#endif

long do_spi(char len, char mod, long val)
{
  char i;
  char d;

  for(i=0;i<len;i++)
  { //uppermost Bit first
    if((long)val&0x80000000) d=-1; else d=DATA_LO;
    outp(LPT1,d&mod);                          //CLK=1
    val<<=1; if((char)(inp(LPT1+1)&SDI)!=0) val|=1;
    outp(LPT1,CLK_LO&d&mod);                   //CLK=0
    outp(LPT1,CLK_LO&d&mod);                   //CLK=0
    outp(LPT1,d&mod);                          //CLK=1
  }
  return(val);
}

void st_out(char mod, char mask, char *true, char *false)
{
  if((mod&mask)==0) printf("%s",false); else printf("%s",true);
}

void print_cmd(int val)
{
  int i;

  for(i=0;i<10;i++)
  {
    (int)val & 0x200 ? printf("1") : printf("0");
    val <<=1;
  }
}
void print_bin(char val)
{
  int i;

  for(i=0;i<8;i++)
  {
    (char)val & 0x80 ? printf("1") : printf("0");
    val <<=1;
  }
}

void str2bin_cmd(char *str, unsigned long *val)
{
  int i;

  i=0;
  while(1)
  {
    if(str[i]==0) return;
    if(isdigit(str[i])) break;
    i++;
  }

  *val=0;

  while(1)
  {
    if(str[i]==0) return;
    *val<<=1;
    if(str[i]=='1') *val+=1;
    i++;
  }
}

char errlev;

void do_exec(char mode, int instr)
{
  unsigned long tmp;
  int j;
  char t;

error=0; //test

  mode &= nCMD; outp(LPT1,mode);
  mode &= nEXT; outp(LPT1,mode);
  tmp=(unsigned long)instr<<22;
  do_spi(10, mode, tmp);
  mode |= ~nCMD; outp(LPT1,mode);

bogaboga:;

  outp(LPT1,mode&PCTRG); //PCTRG=0 -> DONE =1
  outp(LPT1,mode);       //PCTRG=1 rising edge triggers CPU

  //now wait a bit until the instruction is completed.
  for(j=0;j<TRGWAIT;j++) {outp(LPT1,mode);}

  t=inp(LPT1+1);
  if((char)(t&DONE)!=0)
  {
//     putch('#');
     error=-1;
     outp(LPT1+2,errlev);
     if(errlev==0) errlev=-1; else errlev=0;

     goto bogaboga;
  }// break;
  // printf("\n  b %02x",t);


}

unsigned long get_reg(char mod, int reg)
{
  char mod1;
  int j;
  unsigned long tmp,val;

  mod1=mod;
  do_exec(mod,(unsigned long)reg|reg<<3);

  mod &= nDATA; outp(LPT1,mod);
  val=do_spi(32, mod, 0);

  mod |= ~nDATA; outp(LPT1,mod);

  mod=mod1; outp(LPT1,mod);

  return val;
}

void set_reg(char mod, int reg, unsigned long val)
{
  char mod1;
  unsigned long tmp;
  int i,j;

  mod1=mod;
  mod&=nEXT; outp(LPT1,mod); //take over

  mod &= nDATA; outp(LPT1,mod);
  do_spi(32, mod, val);
  mod |= ~nDATA; outp(LPT1,mod);

  outp(LPT1,mod);

  do_exec(mod,(unsigned long)0x040|(reg<<3));

  mod=mod1; outp(LPT1,mod);
}

void print_regs(char mode, int regfirst, int reglast)
{
  int i;
  unsigned long tmp,val;

  for(i=regfirst; i<=reglast; i++)
  {
    printf("R%c ",'0'+i);

#ifdef SR_BUG

    val=0;
    if(i) val=get_reg(mode,i);

#else

    val=get_reg(mode,i);

#endif

    printf("%08lX\n",val);
  }
}

void print_help(void)
{
   printf("\n q       //quit                            ");
   printf("\n ?       //print this help again           ");
   printf("\n @       //reset CPU                       ");
   printf("\n #       //halt  CPU                       ");
   printf("\n c       //clear screen                    ");
   printf("\n l file 0     //load file at 0x0            ");
   printf("\n s file 0 10  //save memory from 0x00 to 0x10");
   printf("\n x 1111111111 //execute single 10 Bit instruction");
   printf("\n g 12    //start program at 0x12           ");
   printf("\n r       //print all registers             ");
   printf("\n r1      //print register R1               ");
   printf("\n r1 12   //set register R1 to 0x12         ");
   printf("\n m 12 34 //print memory from 0x12 to 0x34  ");
   printf("\n .12 34  //set memory [0x12] to 0x34       ");
   printf("\n\n");
}


void cmd_m(char mode, unsigned long memstart, unsigned long memend)
{
  unsigned long tmp,r1,r2;

  long i;
  char ch;

  r1=get_reg(mode,1);
  r2=get_reg(mode,2);

  while(1)
  {
    printf(".%08lX:",memstart);
    for(ch=0;ch<4;ch++)
    {
      set_reg(mode,1,memstart);
      do_exec(mode,0x1d1); //0111010001 R2=[R1]
      tmp=get_reg(mode,2);
      printf("%08lX ",tmp);

      if(memstart==memend)
      {
        set_reg(mode,1,r1);
        set_reg(mode,2,r2);
        printf("\n");
        return;
      }

      memstart++;
    }
    printf("\n");
  }
}

void stop_onoff(char *mode, char onoff)
{
  if(onoff) *mode &=  nPCSTOP;
  else      *mode |= ~nPCSTOP;

  outp(LPT1,*mode);
}

void do_reset(char mode)
{
  int i;

  for(i=0;i<1000; i++) outp(LPT1,mode & nRES); //trigger the TL7705

  outp(LPT1,mode);
}

int main(void)
{
  int i;
  char *ptr,*filename;
  unsigned long tmp,tmp1,memstart,memend,r1,r2,adr1,adr2,j,oldcmd;
  char cmd;
  char mode,mode1;

  FILE *stream;

  char buf[80];
  printf("\033[2JTTAP debugger V%f",VERSION);
  printf("\n(c) Dieter Mueller, Tom Uban 2007");
  printf("\nCPU stopped.");

#ifdef SR_BUG
  printf(" SR_BUG ");
#endif

  printf("\n");
  print_help();

  memstart=0; oldcmd=0;
  mode=-1&nPCSTOP&nEXT;

  while(1)
  {
    for(i=0;i<80;i++) buf[i]=0;
    gets(buf); ptr=buf;

    ptr=strtok(buf," :"); //get instruction
    if(ptr)
    {
      cmd=tolower(*ptr);
      switch(cmd)
      {
        default:  printf("?syntax error.\n"); break;

        case '?': print_help();
                  break;

 case'+': printf("\n[LPT1+1]=%02x\n",inp(LPT1+1)); break;

        case ';': //comment: skip the rest of the line
                  break;


        case 'i': //default
                  for(i=0;i<8;i++) {set_reg(mode,i,i);}
                  break;

        case 'j': //test
                  for(i=0;i<8;i++) {set_reg(mode,i,7-i);}
                  break;

        case 'q': //exit
                  return(0);

        case 'c': //clear screen
                  printf("\033[2J"); break;

        case '@': //reset CPU
                  do_reset(mode);
                  printf("CPU reset triggered.\n");
                  break;

        case 'm': //print memory
                  ptr+=strlen(ptr)+1; ptr=strtok(ptr," ,");
                  memend=memstart+0x80;
                  if(ptr)
                  {
                    sscanf(ptr,"%lx",&memstart);
                    ptr+=strlen(ptr)+1;
                    if(*ptr) {sscanf(ptr,"%lx",&memend); }
                    else     {memend=memstart+0x80;     }
                  }

                  cmd_m(mode,memstart,memend);
                  memstart=memend;

                  break;

        case '.': //set memory
                  ptr=strtok(ptr+1," :");
                  if(ptr==0) break;
                  sscanf(ptr,"%lx",&tmp); //get address
                  // printf(".%08lx ",tmp);
                  r1=get_reg(mode,1);
                  r2=get_reg(mode,2);
                  while(1)
                  {
                    set_reg(mode,1,tmp); tmp++;
                    ptr=strtok((ptr+strlen(ptr)+1)," ");
                    if(ptr==0) break;
                    sscanf(ptr,"%lx",&tmp1);
                    set_reg(mode,2,tmp1); //set value
                    do_exec(mode,0x191); //0110010001 [R1]=R2
                  }
                  set_reg(mode,1,r1);
                  set_reg(mode,2,r2);
                  break;



 case 'z': //while(1){print_regs(mode,0,7);}
           while(1)
           {
             for(i=1;i<8;i++) {if(get_reg(mode,i)==0xffffffff) if(error==0) putch('.');}

             for(i=1;i<8;i++) {set_reg(mode,i,i);}

             for(i=1;i<8;i++)
             {
               tmp=(long)get_reg(mode,i);

               if(error==0)
               if(tmp!=0xffffffff)
               {
                 if(tmp!=i) {printf("\n"); putch('0'+i); printf(" %08lx\n",tmp);}
               }
             }

           }

        case 'r': //print or set registers
                  ptr++;
                  if(isdigit(*ptr))
                  {
                    i=*ptr&0x0f;
                    ptr=strtok(ptr+2," ");
                    if(ptr)
                    {
                      //set register
                      sscanf(ptr,"%lx",&tmp);
                      set_reg(mode,i,tmp); //printf("ok.\n");
                    }
                    else
                    {
                      //no value: print single register.
                      print_regs(mode,i,i);
                    }
                  }
                  else
                  {
                    //no parameters: print all registers
                    print_regs(mode,0,7);
                  }

                  break;

        case 'g': ptr+=strlen(ptr)+1; ptr=strtok(ptr," ");
                  if(ptr)
                  {
                    sscanf(ptr,"%08lx",&tmp);
                    printf(";[%08lx] ",tmp);
                    set_reg(mode,7,tmp);
                  }

               //tmp=get_reg(mode,7); printf("(%08x)",tmp);

                  mode |= ~nEXT;    for(j=0;j<TRGWAIT;j++) {outp(LPT1,mode);}
                  mode |= ~nPCSTOP; for(j=0;j<TRGWAIT;j++) {outp(LPT1,mode);}

                  for(j=0;j<TRGWAIT;j++) {outp(LPT1,mode&PCTRG);}
                  for(j=0;j<TRGWAIT;j++) {outp(LPT1,mode      );}

                  printf(";program started. press any key to stop.\n");
                  while(!kbhit()); getch();
                  mode &= nPCSTOP; for(j=0;j<TRGWAIT;j++) outp(LPT1,mode);

                  tmp=get_reg(mode,7);
                  printf(";program stopped at %08lX.\n",tmp);

                  break;

        case 'x': ptr=strtok(ptr+2," ");
                  if(ptr)
                  {
                    str2bin_cmd(ptr,&oldcmd);
                  }
                  else
                  {
                    printf("\nexecuting "); print_cmd(oldcmd); printf("\n");
                  }

                  do_exec(mode,oldcmd);
                  break;

        case 'v': //verify
                  ptr=strtok(ptr+2," ");
                  if(ptr==0) break;
                  filename=ptr;
                  ptr+=strlen(ptr)+1;
                  ptr=strtok(ptr," ");
                  if(ptr==0) break;
                  sscanf(ptr,"%lx",&adr1); //get address
                  printf("'%s' [%08lx] ",filename,adr1);
                  stream=fopen(filename,"rb");
                  if(stream==0) printf("file open error.");
                  else
                  {
                    r1=get_reg(mode,1);
                    r2=get_reg(mode,2);
                    j=0; printf("\n");
                    while(1)
                    {
                      for(i=0;i<4;i++)
                      {
                        if(feof(stream)) break;
                        tmp1 <<=8;
                        tmp1 |= (unsigned long)fgetc(stream)&0xff;
                      }
                      if(feof(stream)) break;

                      set_reg(mode,1,adr1);
                      do_exec(mode,0x1d1); //0111010001 R2=[R1]
                      tmp=get_reg(mode,2);

                      if(tmp!=tmp1)
                      {
                        printf("%08lX ",adr1);
                        j++;
                      }

                      adr1++;
                    }

                    fclose(stream);
                    set_reg(mode,1,r1);
                    set_reg(mode,2,r2);
                  }
                  printf("\nErrors: %ld. \n",j);
                  break;


        case 'l': //load file into memory
                  ptr=strtok(ptr+2," ");
                  if(ptr==0) break;
                  filename=ptr;
                  ptr+=strlen(ptr)+1;
                  ptr=strtok(ptr," ");
                  if(ptr==0) break;
                  sscanf(ptr,"%lx",&tmp); //get address
                  printf("'%s' [%08lx] ",filename,tmp);
                  stream=fopen(filename,"rb");
                  if(stream==0) printf("file open error.");
                  else
                  {
                    r1=get_reg(mode,1);
                    r2=get_reg(mode,2);
#ifdef PARANOID
                    while(1)
                    {
                      for(i=0;i<4;i++)
                      {
                        if(feof(stream)) break;
                        tmp1 <<=8;
                        tmp1 |= (unsigned long)fgetc(stream)&0xff;
                      }
                      if(feof(stream)) break;

                      set_reg(mode,1,tmp ); tmp++;
                      set_reg(mode,2,tmp1);
                      do_exec(mode,0x191); //0110010001 [R1]=R2
                    }
#else
                    set_reg(mode,1,tmp);
                    while(1)
                    {
                      for(i=0;i<4;i++)
                      {
                        if(feof(stream)) break;
                        tmp1 <<=8;
                        tmp1 |= (unsigned long)fgetc(stream)&0xff;
                      }
                      if(feof(stream)) break;

                      set_reg(mode,2,tmp1);
                      do_exec(mode,0x191); //0110010001 [R1]=R2
                      do_exec(mode,0x38f); //1110001111 R1++
                    }
#endif
                    fclose(stream);
                    printf(" ok. End=%08lx",tmp-1);
                    set_reg(mode,1,r1);
                    set_reg(mode,2,r2);
                  }
                  printf("\n");
                  break;

        case 's': //save memory into file
                  ptr=strtok(ptr+2," "); if(ptr==0) break;
                  filename=ptr; ptr+=strlen(ptr)+1;
                  ptr=strtok(ptr," "); if(ptr==0) break;
                  sscanf(ptr,"%lx",&adr1); //get address

                  ptr+=strlen(ptr)+1;
                  ptr=strtok(ptr," "); if(ptr==0) break;
                  sscanf(ptr,"%lx",&adr2); //get address

                  printf("'%s' [%08lx][%08lx] ",filename,adr1,adr2);

                  stream=fopen(filename,"wb");
                  if(stream==0) printf("file open error.");
                  else
                  {
                    r1=get_reg(mode,1);
                    r2=get_reg(mode,2);
                    j=0;
                    while(1)
                    {
                      set_reg(mode,1,adr1);
                      do_exec(mode,0x1d1); //0111010001 R2=[R1]
                      tmp1=get_reg(mode,2);

                      for(i=0;i<4;i++)
                      {
                        tmp=tmp1>>24;
                        fputc((char)tmp,stream);
                        tmp1<<=8;
                      }
                      if(adr1==adr2)  break;
                      if(j>=0x1000000) break; //limit output files to 16 MB
                      adr1++; j++;
                    }

                    fclose(stream);
                    printf(" ok.");
                    set_reg(mode,1,r1);
                    set_reg(mode,2,r2);
                  }

                  printf("\n");
                  break;

      }
    }
  }
}
