/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampDeserializer
implements ObjectDeserializer {
    public static final TimestampDeserializer instance = new TimestampDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Object val = parser.parse();
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return (T)new Timestamp(((Date)val).getTime());
        }
        if (val instanceof Number) {
            return (T)new Timestamp(((Number)val).longValue());
        }
        if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 0) {
                return null;
            }
            long longVal = Long.parseLong(strVal);
            return (T)new Timestamp(longVal);
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

