/*
 * Decompiled with CFR 0.152.
 */
package net.fs.cap;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.fs.cap.PacketUtils;
import net.fs.cap.TCPTun;
import net.fs.cap.TunManager;
import net.fs.cap.VDatagramSocket;
import net.fs.rudp.Route;
import net.fs.utils.ByteShortConvert;
import net.fs.utils.MLog;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.PcapStat;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.util.MacAddress;

public class CapEnv {
    public MacAddress gateway_mac;
    public MacAddress local_mac;
    Inet4Address local_ipv4;
    public PcapHandle sendHandle;
    VDatagramSocket vDatagramSocket;
    String testIp_tcp = "";
    String testIp_udp = "5.5.5.5";
    String selectedInterfaceName = null;
    String selectedInterfaceDes = "";
    PcapNetworkInterface nif;
    private final int COUNT = -1;
    private final int READ_TIMEOUT = 1;
    private final int SNAPLEN = 10240;
    HashMap<Integer, TCPTun> tunTable = new HashMap();
    Random random = new Random();
    boolean client = false;
    short listenPort;
    TunManager tcpManager = null;
    CapEnv capEnv = this;
    Thread versinMonThread;
    boolean detect_by_tcp = true;
    public boolean tcpEnable = false;
    public boolean fwSuccess = true;
    boolean ppp = false;

    public CapEnv(boolean isClient, boolean fwSuccess) {
        this.client = isClient;
        this.fwSuccess = fwSuccess;
        this.tcpManager = new TunManager(this);
    }

    public void init() throws Exception {
        this.initInterface();
        Thread systemSleepScanThread = new Thread(){

            @Override
            public void run() {
                long t = System.currentTimeMillis();
                while (true) {
                    if (System.currentTimeMillis() - t > 5000L) {
                        int i = 0;
                        while (i < 10) {
                            MLog.info("\u4f11\u7720\u6062\u590d... " + (i + 1));
                            try {
                                boolean success = CapEnv.this.initInterface();
                                if (success) {
                                    MLog.info("\u4f11\u7720\u6062\u590d\u6210\u529f " + (i + 1));
                                    break;
                                }
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            ++i;
                        }
                    }
                    t = System.currentTimeMillis();
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        systemSleepScanThread.start();
    }

    void processPacket(Packet packet) throws Exception {
        EthernetPacket packet_eth = (EthernetPacket)packet;
        EthernetPacket.EthernetHeader head_eth = packet_eth.getHeader();
        IpV4Packet ipV4Packet = null;
        if (this.ppp) {
            ipV4Packet = this.getIpV4Packet_pppoe(packet_eth);
        } else if (packet_eth.getPayload() instanceof IpV4Packet) {
            ipV4Packet = (IpV4Packet)packet_eth.getPayload();
        }
        if (ipV4Packet != null) {
            IpV4Packet.IpV4Header ipV4Header = ipV4Packet.getHeader();
            if (ipV4Packet.getPayload() instanceof TcpPacket) {
                TcpPacket tcpPacket = (TcpPacket)ipV4Packet.getPayload();
                TcpPacket.TcpHeader tcpHeader = tcpPacket.getHeader();
                if (this.client) {
                    TCPTun conn = this.tcpManager.getTcpConnection_Client(ipV4Header.getSrcAddr().getHostAddress(), (Short)tcpHeader.getSrcPort().value(), (Short)tcpHeader.getDstPort().value());
                    if (conn != null) {
                        conn.process_client(this.capEnv, packet, head_eth, ipV4Header, tcpPacket, false);
                    }
                } else {
                    TCPTun conn = null;
                    conn = this.tcpManager.getTcpConnection_Server(ipV4Header.getSrcAddr().getHostAddress(), (Short)tcpHeader.getSrcPort().value());
                    if ((Short)tcpHeader.getDstPort().value() == this.listenPort) {
                        if (tcpHeader.getSyn() && !tcpHeader.getAck() && conn == null) {
                            conn = new TCPTun(this.capEnv, ipV4Header.getSrcAddr(), (Short)tcpHeader.getSrcPort().value());
                            this.tcpManager.addConnection_Server(conn);
                        }
                        if ((conn = this.tcpManager.getTcpConnection_Server(ipV4Header.getSrcAddr().getHostAddress(), (Short)tcpHeader.getSrcPort().value())) != null) {
                            conn.process_server(packet, head_eth, ipV4Header, tcpPacket, true);
                        }
                    }
                }
            } else if (packet_eth.getPayload() instanceof IllegalPacket) {
                MLog.println("IllegalPacket!!!");
            }
        }
    }

    PcapNetworkInterface.PromiscuousMode getMode(PcapNetworkInterface pi) {
        PcapNetworkInterface.PromiscuousMode mode = null;
        String string = (String.valueOf(pi.getDescription()) + ":" + pi.getName()).toLowerCase();
        mode = string.contains("wireless") ? PcapNetworkInterface.PromiscuousMode.NONPROMISCUOUS : PcapNetworkInterface.PromiscuousMode.PROMISCUOUS;
        return mode;
    }

    boolean initInterface() throws Exception {
        boolean success = false;
        this.detectInterface();
        List<PcapNetworkInterface> allDevs = Pcaps.findAllDevs();
        MLog.println("Network Interface List: ");
        for (PcapNetworkInterface pi : allDevs) {
            String desString = "";
            if (pi.getDescription() != null) {
                desString = pi.getDescription();
            }
            MLog.info("  " + desString + "   " + pi.getName());
            if (!pi.getName().equals(this.selectedInterfaceName) || !desString.equals(this.selectedInterfaceDes)) continue;
            this.nif = pi;
        }
        if (this.nif != null) {
            String desString = "";
            if (this.nif.getDescription() != null) {
                desString = this.nif.getDescription();
            }
            success = true;
            MLog.info("Selected Network Interface:\n  " + desString + "   " + this.nif.getName());
            if (this.fwSuccess) {
                this.tcpEnable = true;
            }
        } else {
            this.tcpEnable = false;
            MLog.info("Select Network Interface failed,can't use TCP protocal!\n");
        }
        if (this.tcpEnable) {
            this.sendHandle = this.nif.openLive(10240, this.getMode(this.nif), 1);
            String filter = "";
            filter = !this.client ? "tcp dst port " + CapEnv.toUnsigned(this.listenPort) : "tcp";
            this.sendHandle.setFilter(filter, BpfProgram.BpfCompileMode.OPTIMIZE);
            final PacketListener listener = new PacketListener(){

                @Override
                public void gotPacket(Packet packet) {
                    try {
                        if (packet instanceof EthernetPacket) {
                            CapEnv.this.processPacket(packet);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        CapEnv.this.sendHandle.loop(-1, listener);
                        PcapStat ps = CapEnv.this.sendHandle.getStats();
                        CapEnv.this.sendHandle.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        }
        if (!this.client) {
            MLog.info("FinalSpeed server start success.");
        }
        return success;
    }

    void detectInterface() {
        PcapHandle handle2;
        List<PcapNetworkInterface> allDevs = null;
        HashMap<PcapNetworkInterface, PcapHandle> handleTable = new HashMap<PcapNetworkInterface, PcapHandle>();
        try {
            allDevs = Pcaps.findAllDevs();
        }
        catch (PcapNativeException e1) {
            e1.printStackTrace();
            return;
        }
        for (final PcapNetworkInterface pi : allDevs) {
            try {
                handle2 = pi.openLive(10240, this.getMode(pi), 1);
                handleTable.put(pi, handle2);
                final PacketListener listener = new PacketListener(){

                    @Override
                    public void gotPacket(Packet packet) {
                        try {
                            if (packet instanceof EthernetPacket) {
                                EthernetPacket packet_eth = (EthernetPacket)packet;
                                EthernetPacket.EthernetHeader head_eth = packet_eth.getHeader();
                                if ((Short)head_eth.getType().value() == -30620) {
                                    PacketUtils.ppp = CapEnv.this.ppp = true;
                                }
                                IpV4Packet ipV4Packet = null;
                                IpV4Packet.IpV4Header ipV4Header = null;
                                if (CapEnv.this.ppp) {
                                    ipV4Packet = CapEnv.this.getIpV4Packet_pppoe(packet_eth);
                                } else if (packet_eth.getPayload() instanceof IpV4Packet) {
                                    ipV4Packet = (IpV4Packet)packet_eth.getPayload();
                                }
                                if (ipV4Packet != null) {
                                    ipV4Header = ipV4Packet.getHeader();
                                    if (ipV4Header.getSrcAddr().getHostAddress().equals(CapEnv.this.testIp_tcp)) {
                                        CapEnv.this.local_mac = head_eth.getDstAddr();
                                        CapEnv.this.gateway_mac = head_eth.getSrcAddr();
                                        CapEnv.this.local_ipv4 = ipV4Header.getDstAddr();
                                        CapEnv.this.selectedInterfaceName = pi.getName();
                                        if (pi.getDescription() != null) {
                                            CapEnv.this.selectedInterfaceDes = pi.getDescription();
                                        }
                                    }
                                    if (ipV4Header.getDstAddr().getHostAddress().equals(CapEnv.this.testIp_tcp)) {
                                        CapEnv.this.local_mac = head_eth.getSrcAddr();
                                        CapEnv.this.gateway_mac = head_eth.getDstAddr();
                                        CapEnv.this.local_ipv4 = ipV4Header.getSrcAddr();
                                        CapEnv.this.selectedInterfaceName = pi.getName();
                                        if (pi.getDescription() != null) {
                                            CapEnv.this.selectedInterfaceDes = pi.getDescription();
                                        }
                                    }
                                    if (ipV4Header.getDstAddr().getHostAddress().equals(CapEnv.this.testIp_udp)) {
                                        CapEnv.this.local_mac = head_eth.getSrcAddr();
                                        CapEnv.this.gateway_mac = head_eth.getDstAddr();
                                        CapEnv.this.local_ipv4 = ipV4Header.getSrcAddr();
                                        CapEnv.this.selectedInterfaceName = pi.getName();
                                        if (pi.getDescription() != null) {
                                            CapEnv.this.selectedInterfaceDes = pi.getDescription();
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            handle2.loop(-1, listener);
                            PcapStat ps = handle2.getStats();
                            handle2.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
            }
            catch (PcapNativeException handle2) {
                // empty catch block
            }
        }
        this.detectMac_tcp();
        for (PcapNetworkInterface pi : handleTable.keySet()) {
            handle2 = (PcapHandle)handleTable.get(pi);
            try {
                handle2.breakLoop();
            }
            catch (NotOpenException e) {
                e.printStackTrace();
            }
        }
    }

    IpV4Packet getIpV4Packet_pppoe(EthernetPacket packet_eth) throws IllegalRawDataException {
        IpV4Packet ipV4Packet = null;
        byte[] pppData = packet_eth.getPayload().getRawData();
        if (pppData.length > 8 && pppData[8] == 69) {
            byte[] b2 = new byte[2];
            System.arraycopy(pppData, 4, b2, 0, 2);
            short len = ByteShortConvert.toShort(b2, 0);
            int ipLength = CapEnv.toUnsigned(len) - 2;
            byte[] ipData = new byte[ipLength];
            PacketUtils.pppHead_static[2] = pppData[2];
            PacketUtils.pppHead_static[3] = pppData[3];
            if (ipLength == pppData.length - 8) {
                System.arraycopy(pppData, 8, ipData, 0, ipLength);
                ipV4Packet = IpV4Packet.newPacket(ipData, 0, ipData.length);
            } else {
                MLog.println("\u957f\u5ea6\u4e0d\u7b26!");
            }
        }
        return ipV4Packet;
    }

    public static String printHexString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if ((hex = hex.replaceAll(":", " ")).length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(String.valueOf(hex) + " ");
            ++i;
        }
        return sb.toString();
    }

    public void createTcpTun_Client(String dstAddress, short dstPort) throws Exception {
        Inet4Address serverAddress = (Inet4Address)Inet4Address.getByName(dstAddress);
        TCPTun conn = new TCPTun(this, serverAddress, dstPort, this.local_mac, this.gateway_mac);
        this.tcpManager.addConnection_Client(conn);
        boolean success = false;
        int i = 0;
        while (i < 6) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (conn.preDataReady) {
                success = true;
                break;
            }
            ++i;
        }
        if (!success) {
            this.tcpManager.removeTun(conn);
            this.tcpManager.setDefaultTcpTun(null);
            throw new Exception("\u521b\u5efa\u96a7\u9053\u5931\u8d25!");
        }
        this.tcpManager.setDefaultTcpTun(conn);
    }

    private void detectMac_tcp() {
        InetAddress address = null;
        try {
            address = InetAddress.getByName("bing.com");
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
            try {
                address = InetAddress.getByName("163.com");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                try {
                    address = InetAddress.getByName("apple.com");
                }
                catch (UnknownHostException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (address == null) {
            MLog.println("\u57df\u540d\u89e3\u6790\u5931\u8d25,\u8bf7\u68c0\u67e5DNS\u8bbe\u7f6e!");
        }
        int por = 80;
        this.testIp_tcp = address.getHostAddress();
        int i = 0;
        while (i < 5) {
            try {
                Route.es.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Socket socket = new Socket(CapEnv.this.testIp_tcp, 80);
                            socket.close();
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                Thread.sleep(500L);
                if (this.local_mac != null) {
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void detectMac_udp() {
        int i = 0;
        while (i < 10) {
            try {
                DatagramSocket ds = new DatagramSocket();
                DatagramPacket dp = new DatagramPacket(new byte[1000], 1000);
                dp.setAddress(InetAddress.getByName(this.testIp_udp));
                dp.setPort(5555);
                ds.send(dp);
                ds.close();
                Thread.sleep(500L);
                if (this.local_mac != null) {
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            ++i;
        }
    }

    public short getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(short listenPort) {
        this.listenPort = listenPort;
        if (!this.client) {
            MLog.info("Listen tcp port: " + CapEnv.toUnsigned(listenPort));
        }
    }

    public static int toUnsigned(short s) {
        return s & 0xFFFF;
    }
}

