/*
 * Decompiled with CFR 0.152.
 */
package net.fs.client;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import net.fs.client.ClientUI;
import net.fs.utils.LogListener;
import net.fs.utils.LogOutputStream;
import net.miginfocom.swing.MigLayout;

public class LogFrame
extends JFrame
implements LogListener {
    private static final long serialVersionUID = 8642892909397273483L;
    ClientUI ui;
    JTextArea logArea;
    JScrollPane scroll;
    boolean autoScroll = true;
    final int SCROLL_BUFFER_SIZE = 1000;

    LogFrame(ClientUI ui) {
        super("\u65e5\u5fd7");
        this.ui = ui;
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new MigLayout("insets 5 5 5 5"));
        this.logArea = new JTextArea();
        this.scroll = new JScrollPane(this.logArea);
        panel.add((Component)this.scroll, "width :10240:,height :10240: ,wrap");
        JPanel p3 = new JPanel();
        panel.add((Component)p3, "align center,wrap");
        p3.setLayout(new MigLayout("inset 5 5 5 5"));
        final JCheckBox cb_lock = new JCheckBox("\u81ea\u52a8\u6eda\u52a8", this.autoScroll);
        p3.add((Component)cb_lock, "align center");
        cb_lock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFrame.this.autoScroll = cb_lock.isSelected();
            }
        });
        JButton button_clear = this.createButton("\u6e05\u7a7a");
        p3.add(button_clear);
        button_clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFrame.this.logArea.setText("");
            }
        });
    }

    public void trunkTextArea(JTextArea txtWin) {
        int numLinesToTrunk = txtWin.getLineCount() - 1000;
        if (numLinesToTrunk > 0) {
            try {
                int posOfLastLineToTrunk = txtWin.getLineEndOffset(numLinesToTrunk - 1);
                txtWin.replaceRange("", 0, posOfLastLineToTrunk);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    void showText(String text) {
        this.logArea.append(text);
        this.trunkTextArea(this.logArea);
        if (this.autoScroll) {
            JScrollBar vertical = this.scroll.getVerticalScrollBar();
            vertical.setValue(vertical.getMaximum());
        }
    }

    @Override
    public void onAppendContent(LogOutputStream los, final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogFrame.this.logArea.append(text);
                LogFrame.this.trunkTextArea(LogFrame.this.logArea);
                if (LogFrame.this.autoScroll) {
                    LogFrame.this.logArea.setCaretPosition(LogFrame.this.logArea.getDocument().getLength());
                }
            }
        });
    }

    JButton createButton(String name) {
        JButton button = new JButton(name);
        button.setMargin(new Insets(0, 5, 0, 5));
        button.setFocusPainted(false);
        return button;
    }
}

