/*
 * Decompiled with CFR 0.152.
 */
package net.fs.client;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class TextComponentPopupMenu
extends JPopupMenu
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 117096441855319758L;
    private static TextComponentPopupMenu sharedInstance = null;
    JMenuItem cutItem = new JMenuItem("\u526a\u5207");
    JMenuItem copyItem;
    JMenuItem pasteItem;
    JMenuItem deleteItem;
    JMenuItem selectAllItem;

    public static void installToComponent(JComponent c) {
        if (c instanceof JTextField && !(c instanceof JPasswordField)) {
            c.addMouseListener(TextComponentPopupMenu.getSharedInstance());
        }
    }

    public static void uninstallFromComponent(JComponent c) {
        if (c instanceof JTextField && !(c instanceof JPasswordField)) {
            c.removeMouseListener(TextComponentPopupMenu.getSharedInstance());
        }
    }

    public TextComponentPopupMenu() {
        this.add(this.cutItem);
        this.copyItem = new JMenuItem("\u590d\u5236");
        this.add(this.copyItem);
        this.pasteItem = new JMenuItem("\u7c98\u8d34");
        this.add(this.pasteItem);
        this.deleteItem = new JMenuItem("\u5220\u9664");
        this.add(this.deleteItem);
        this.addSeparator();
        this.selectAllItem = new JMenuItem("\u5168\u9009");
        this.add(this.selectAllItem);
        this.cutItem.setMnemonic('T');
        this.copyItem.setMnemonic('C');
        this.pasteItem.setMnemonic('P');
        this.deleteItem.setMnemonic('D');
        this.selectAllItem.setMnemonic('A');
        this.cutItem.addActionListener(this);
        this.copyItem.addActionListener(this);
        this.pasteItem.addActionListener(this);
        this.deleteItem.addActionListener(this);
        this.selectAllItem.addActionListener(this);
    }

    static TextComponentPopupMenu getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new TextComponentPopupMenu();
        }
        return sharedInstance;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && e.getSource() instanceof JTextField) {
            JTextField textfield = (JTextField)e.getSource();
            if (Boolean.TRUE.equals(textfield.getClientProperty("DisablePopupMenu"))) {
                return;
            }
            textfield.requestFocusInWindow();
            this.show(textfield, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void show(Component invoker, int x, int y) {
        JTextComponent tc = (JTextComponent)invoker;
        String sel = tc.getSelectedText();
        boolean selected = sel != null && !sel.equals("");
        boolean enableAndEditable = tc.isEnabled() && tc.isEditable();
        this.cutItem.setEnabled(selected && enableAndEditable);
        this.copyItem.setEnabled(selected && tc.isEnabled());
        this.deleteItem.setEnabled(selected && enableAndEditable);
        this.pasteItem.setEnabled(enableAndEditable);
        this.selectAllItem.setEnabled(tc.isEnabled());
        super.show(invoker, x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent tc = (JTextComponent)this.getInvoker();
        String sel = tc.getSelectedText();
        if (e.getSource() == this.cutItem) {
            tc.cut();
        } else if (e.getSource() == this.copyItem) {
            tc.copy();
        } else if (e.getSource() == this.pasteItem) {
            tc.paste();
        } else if (e.getSource() == this.selectAllItem) {
            tc.selectAll();
        } else if (e.getSource() == this.deleteItem) {
            Document doc = tc.getDocument();
            int start = tc.getSelectionStart();
            int end = tc.getSelectionEnd();
            try {
                Position p0 = doc.createPosition(start);
                Position p1 = doc.createPosition(end);
                if (p0 != null && p1 != null && p0.getOffset() != p1.getOffset()) {
                    doc.remove(p0.getOffset(), p1.getOffset() - p0.getOffset());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

