/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalIpV6RoutingData;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.packet.IpV6RoutingSourceRouteData;
import org.pcap4j.packet.UnknownIpV6RoutingData;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpV6RoutingType;

public final class StaticIpV6RoutingDataFactory
implements PacketFactory<IpV6ExtRoutingPacket.IpV6RoutingData, IpV6RoutingType> {
    private static final StaticIpV6RoutingDataFactory INSTANCE = new StaticIpV6RoutingDataFactory();
    private final Map<IpV6RoutingType, Instantiater> instantiaters = new HashMap<IpV6RoutingType, Instantiater>();

    private StaticIpV6RoutingDataFactory() {
        this.instantiaters.put(IpV6RoutingType.SOURCE_ROUTE, new Instantiater(){

            @Override
            public IpV6ExtRoutingPacket.IpV6RoutingData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6RoutingSourceRouteData.newInstance(rawData, offset, length);
            }

            public Class<IpV6RoutingSourceRouteData> getTargetClass() {
                return IpV6RoutingSourceRouteData.class;
            }
        });
    }

    public static StaticIpV6RoutingDataFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public IpV6ExtRoutingPacket.IpV6RoutingData newInstance(byte[] rawData, int offset, int length, IpV6RoutingType number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData, offset, length);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV6RoutingData.newInstance(rawData, offset, length);
        }
        return this.newInstance(rawData, offset, length);
    }

    @Override
    public IpV6ExtRoutingPacket.IpV6RoutingData newInstance(byte[] rawData, int offset, int length) {
        try {
            return UnknownIpV6RoutingData.newInstance(rawData, offset, length);
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV6RoutingData.newInstance(rawData, offset, length);
        }
    }

    @Override
    public Class<? extends IpV6ExtRoutingPacket.IpV6RoutingData> getTargetClass(IpV6RoutingType number) {
        if (number == null) {
            throw new NullPointerException("number must not be null.");
        }
        Instantiater instantiater = this.instantiaters.get(number);
        return instantiater != null ? instantiater.getTargetClass() : this.getTargetClass();
    }

    @Override
    public Class<? extends IpV6ExtRoutingPacket.IpV6RoutingData> getTargetClass() {
        return UnknownIpV6RoutingData.class;
    }

    private static interface Instantiater {
        public IpV6ExtRoutingPacket.IpV6RoutingData newInstance(byte[] var1, int var2, int var3) throws IllegalRawDataException;

        public Class<? extends IpV6ExtRoutingPacket.IpV6RoutingData> getTargetClass();
    }
}

