/*
 * Decompiled with CFR 0.152.
 */
package net.fs.cap;

import java.util.HashMap;
import java.util.Iterator;
import net.fs.cap.CapEnv;
import net.fs.cap.TCPTun;
import net.fs.rudp.CopiedIterator;
import net.fs.utils.MLog;

public class TunManager {
    HashMap<String, TCPTun> connTable = new HashMap();
    static TunManager tunManager;
    TCPTun defaultTcpTun;
    Thread scanThread;
    Object syn_scan;
    CapEnv capEnv;

    TunManager(CapEnv capEnv) {
        tunManager = this;
        this.syn_scan = new Object();
        this.scanThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    TunManager.this.scan();
                }
            }
        };
        this.scanThread.start();
        this.capEnv = capEnv;
    }

    void scan() {
        Iterator<String> it = this.getConnTableIterator();
        while (it.hasNext()) {
            String key = it.next();
            TCPTun tun = this.connTable.get(key);
            if (tun == null) continue;
            if (tun.preDataReady) {
                long t = System.currentTimeMillis() - tun.lastReceiveDataTime;
                if (t <= 6000L) continue;
                this.connTable.remove(key);
                if (!this.capEnv.client) continue;
                this.defaultTcpTun = null;
                MLog.println("tcp\u96a7\u9053\u8d85\u65f6");
                continue;
            }
            if (System.currentTimeMillis() - tun.createTime <= 5000L) continue;
            this.connTable.remove(key);
        }
    }

    public void removeTun(TCPTun tun) {
        this.connTable.remove(tun.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<String> getConnTableIterator() {
        CopiedIterator it = null;
        Object object = this.syn_scan;
        synchronized (object) {
            it = new CopiedIterator(this.connTable.keySet().iterator());
        }
        return it;
    }

    public static TunManager get() {
        return tunManager;
    }

    public TCPTun getTcpConnection_Client(String remoteAddress, short remotePort, short localPort) {
        return this.connTable.get(String.valueOf(remoteAddress) + ":" + remotePort + ":" + localPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection_Client(TCPTun conn) {
        Object object = this.syn_scan;
        synchronized (object) {
            String key = String.valueOf(conn.remoteAddress.getHostAddress()) + ":" + conn.remotePort + ":" + conn.localPort;
            conn.setKey(key);
            this.connTable.put(key, conn);
        }
    }

    public TCPTun getTcpConnection_Server(String remoteAddress, short remotePort) {
        return this.connTable.get(String.valueOf(remoteAddress) + ":" + remotePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection_Server(TCPTun conn) {
        Object object = this.syn_scan;
        synchronized (object) {
            String key = String.valueOf(conn.remoteAddress.getHostAddress()) + ":" + conn.remotePort;
            conn.setKey(key);
            this.connTable.put(key, conn);
        }
    }

    public TCPTun getDefaultTcpTun() {
        return this.defaultTcpTun;
    }

    public void setDefaultTcpTun(TCPTun defaultTcpTun) {
        this.defaultTcpTun = defaultTcpTun;
    }
}

