/*
 * Decompiled with CFR 0.152.
 */
package net.fs.client;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import net.fs.client.AddMapFrame;
import net.fs.client.AddressCellRenderer;
import net.fs.client.ClientConfig;
import net.fs.client.ClientUII;
import net.fs.client.LogFrame;
import net.fs.client.MapClient;
import net.fs.client.MapRule;
import net.fs.client.MapRuleListModel;
import net.fs.client.MapRuleListTable;
import net.fs.client.SpeedSetFrame;
import net.fs.client.TextComponentPopupMenu;
import net.fs.rudp.Route;
import net.fs.utils.LogOutputStream;
import net.fs.utils.MLog;
import net.fs.utils.Tools;
import net.miginfocom.swing.MigLayout;
import org.pcap4j.core.Pcaps;

public class ClientUI
implements ClientUII,
WindowListener {
    JFrame mainFrame;
    JComponent mainPanel;
    JComboBox text_serverAddress;
    MapClient mapClient;
    JLabel uploadSpeedField;
    JLabel downloadSpeedField;
    JLabel stateText;
    ClientConfig config = null;
    String configFilePath = "client_config.json";
    String logoImg = "img/offline.png";
    String offlineImg = "img/offline.png";
    String name = "FinalSpeed";
    private TrayIcon trayIcon;
    private SystemTray tray;
    int serverVersion = -1;
    int localVersion = 5;
    boolean checkingUpdate = false;
    String domain = "ip4a.com";
    String homeUrl = "http://www.ip4a.com/?client_fs";
    public static ClientUI ui;
    JTextField text_ds;
    JTextField text_us;
    boolean ky = true;
    String errorMsg = "\u4fdd\u5b58\u5931\u8d25\u8bf7\u68c0\u67e5\u8f93\u5165\u4fe1\u606f!";
    JButton button_site;
    MapRuleListModel model;
    public MapRuleListTable tcpMapRuleListTable;
    boolean capSuccess = false;
    Exception capException = null;
    boolean b1 = false;
    boolean success_firewall_windows = true;
    boolean success_firewall_osx = true;
    String systemName = null;
    public boolean osx_fw_pf = false;
    public boolean osx_fw_ipfw = false;
    public boolean isVisible = true;
    JRadioButton r_tcp;
    JRadioButton r_udp;
    String updateUrl = "http://fs.d1sm.net/finalspeed/update.properties";
    boolean min = false;
    LogFrame logFrame;
    LogOutputStream los;
    boolean tcpEnable = true;

    ClientUI(final boolean isVisible, boolean min) {
        this.min = min;
        this.setVisible(isVisible);
        if (isVisible) {
            this.los = new LogOutputStream(System.out);
            System.setOut(this.los);
            System.setErr(this.los);
        }
        this.systemName = System.getProperty("os.name").toLowerCase();
        MLog.info("System: " + this.systemName + " " + System.getProperty("os.version"));
        ui = this;
        this.mainFrame = new JFrame();
        this.mainFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.logoImg));
        this.initUI();
        this.checkQuanxian();
        this.loadConfig();
        this.mainFrame.setTitle("FinalSpeed 1.2");
        this.mainPanel = (JPanel)this.mainFrame.getContentPane();
        this.mainPanel.setLayout(new MigLayout("align center , insets 10 10 10 10"));
        this.mainPanel.setBorder(null);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                ClientUI.this.text_ds.requestFocus();
            }
        });
        JPanel centerPanel = new JPanel();
        this.mainPanel.add((Component)centerPanel, "wrap");
        centerPanel.setLayout(new MigLayout("insets 0 0 0 0"));
        JPanel loginPanel = new JPanel();
        centerPanel.add((Component)loginPanel, "");
        loginPanel.setLayout(new MigLayout("insets 0 0 0 0"));
        JLabel label_msg = new JLabel();
        label_msg.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new MigLayout("insets 10 0 10 0"));
        centerPanel.add((Component)rightPanel, "width :: ,top");
        JPanel mapPanel = new JPanel();
        mapPanel.setLayout(new MigLayout("insets 0 0 0 0"));
        mapPanel.setBorder(BorderFactory.createTitledBorder("\u52a0\u901f\u5217\u8868"));
        rightPanel.add(mapPanel);
        this.model = new MapRuleListModel();
        this.tcpMapRuleListTable = new MapRuleListTable(this, this.model);
        JScrollPane tablePanel = new JScrollPane();
        tablePanel.setViewportView(this.tcpMapRuleListTable);
        mapPanel.add((Component)tablePanel, "height 50:160:1024 ,growy,width :250:,wrap");
        tablePanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ClientUI.this.tcpMapRuleListTable.clearSelection();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JPanel p9 = new JPanel();
        p9.setLayout(new MigLayout("insets 1 0 3 0 "));
        mapPanel.add((Component)p9, "align center,wrap");
        JButton button_add = this.createButton("\u6dfb\u52a0");
        p9.add(button_add);
        button_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMapFrame sf = new AddMapFrame(ui, ClientUI.this.mainFrame, null, false);
            }
        });
        JButton button_edit = this.createButton("\u4fee\u6539");
        p9.add(button_edit);
        button_edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ClientUI.this.tcpMapRuleListTable.getSelectedRow();
                if (index > -1) {
                    MapRule mapRule = ClientUI.this.model.getMapRuleAt(index);
                    AddMapFrame addMapFrame = new AddMapFrame(ui, ClientUI.this.mainFrame, mapRule, true);
                }
            }
        });
        JButton button_remove = this.createButton("\u5220\u9664");
        p9.add(button_remove);
        button_remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ClientUI.this.tcpMapRuleListTable.getSelectedRow();
                if (index > -1) {
                    MapRule mapRule = ClientUI.this.model.getMapRuleAt(index);
                    ClientUI.this.mapClient.portMapManager.removeMapRule(mapRule.getName());
                    ClientUI.this.loadMapRule();
                }
            }
        });
        JPanel pa = new JPanel();
        pa.setBorder(BorderFactory.createTitledBorder("\u670d\u52a1\u5668"));
        pa.setLayout(new MigLayout("insets 0 0 0 0"));
        loginPanel.add((Component)pa, "growx,wrap");
        JPanel p1 = new JPanel();
        p1.setLayout(new MigLayout("insets 0 0 0 0"));
        pa.add((Component)p1, "wrap");
        p1.add((Component)new JLabel("\u5730\u5740:"), "width 50::");
        this.text_serverAddress = new JComboBox();
        this.text_serverAddress.setToolTipText("\u4e3b\u673a:\u7aef\u53e3\u53f7");
        p1.add((Component)this.text_serverAddress, "width 150::");
        this.text_serverAddress.setEditable(true);
        TextComponentPopupMenu.installToComponent(this.text_serverAddress);
        AddressCellRenderer renderer = new AddressCellRenderer();
        this.text_serverAddress.setRenderer(renderer);
        this.text_serverAddress.setEditable(true);
        this.text_serverAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        int n = 0;
        while (n < this.config.getRecentAddressList().size()) {
            this.text_serverAddress.addItem(this.config.getRecentAddressList().get(n));
            ++n;
        }
        if (this.config.getRecentAddressList().size() == 0) {
            this.text_serverAddress.setSelectedItem("");
        }
        JButton button_removeAddress = this.createButton("\u5220\u9664");
        p1.add((Component)button_removeAddress, "");
        button_removeAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                String address = ClientUI.this.text_serverAddress.getSelectedItem().toString();
                if (!address.equals("") && (result = JOptionPane.showConfirmDialog(ClientUI.this.mainFrame, "\u786e\u5b9a\u5220\u9664\u5417?", "\u6d88\u606f", 0)) == 0) {
                    ClientUI.this.text_serverAddress.removeItem(address);
                    String selectText = "";
                    if (ClientUI.this.text_serverAddress.getModel().getSize() > 0) {
                        selectText = ClientUI.this.text_serverAddress.getModel().getElementAt(0).toString();
                    }
                    ClientUI.this.text_serverAddress.setSelectedItem(selectText);
                }
            }
        });
        JPanel panelr = new JPanel();
        pa.add((Component)panelr, "wrap");
        panelr.setLayout(new MigLayout("insets 0 0 0 0"));
        panelr.add(new JLabel("\u4f20\u8f93\u534f\u8bae:"));
        this.r_tcp = new JRadioButton("TCP");
        this.r_tcp.setFocusPainted(false);
        panelr.add(this.r_tcp);
        this.r_udp = new JRadioButton("UDP");
        this.r_udp.setFocusPainted(false);
        panelr.add(this.r_udp);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.r_tcp);
        bg.add(this.r_udp);
        if (this.config.getProtocal().equals("udp")) {
            this.r_udp.setSelected(true);
        } else {
            this.r_tcp.setSelected(true);
        }
        JPanel sp = new JPanel();
        sp.setBorder(BorderFactory.createTitledBorder("\u7269\u7406\u5e26\u5bbd"));
        sp.setLayout(new MigLayout("insets 5 5 5 5"));
        JPanel pa1 = new JPanel();
        sp.add((Component)pa1, "wrap");
        pa1.setLayout(new MigLayout("insets 0 0 0 0"));
        loginPanel.add((Component)sp, "wrap");
        pa1.add((Component)new JLabel("\u4e0b\u8f7d:"), "width ::");
        this.text_ds = new JTextField("0");
        pa1.add((Component)this.text_ds, "width 80::");
        this.text_ds.setHorizontalAlignment(4);
        this.text_ds.setEditable(false);
        JButton button_set_speed = this.createButton("\u8bbe\u7f6e\u5e26\u5bbd");
        pa1.add(button_set_speed);
        button_set_speed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedSetFrame sf = new SpeedSetFrame(ui, ClientUI.this.mainFrame);
            }
        });
        JPanel pa2 = new JPanel();
        sp.add((Component)pa2, "wrap");
        pa2.setLayout(new MigLayout("insets 0 0 0 0"));
        loginPanel.add((Component)sp, "wrap");
        pa2.add((Component)new JLabel("\u4e0a\u4f20:"), "width ::");
        this.text_us = new JTextField("0");
        pa2.add((Component)this.text_us, "width 80::");
        this.text_us.setHorizontalAlignment(4);
        this.text_us.setEditable(false);
        JPanel sp2 = new JPanel();
        sp2.setLayout(new MigLayout("insets 0 0 0 0"));
        loginPanel.add((Component)sp2, "align center,  wrap");
        final JCheckBox cb = new JCheckBox("\u5f00\u673a\u542f\u52a8", this.config.isAutoStart());
        sp2.add((Component)cb, "align center");
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientUI.this.config.setAutoStart(cb.isSelected());
                ClientUI.this.saveConfig();
                ClientUI.setAutoRun(ClientUI.this.config.isAutoStart());
            }
        });
        JButton button_show_log = this.createButton("\u663e\u793a\u65e5\u5fd7");
        sp2.add((Component)button_show_log, "wrap");
        button_show_log.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClientUI.this.logFrame == null) {
                    ClientUI.this.logFrame = new LogFrame(ui);
                    ClientUI.this.logFrame.setSize(700, 400);
                    ClientUI.this.logFrame.setLocationRelativeTo(null);
                    ClientUI.this.los.addListener(ClientUI.this.logFrame);
                    if (ClientUI.this.los.getBuffer() != null) {
                        ClientUI.this.logFrame.showText(ClientUI.this.los.getBuffer().toString());
                        ClientUI.this.los.setBuffer(null);
                    }
                }
                ClientUI.this.logFrame.setVisible(true);
            }
        });
        JPanel p4 = new JPanel();
        p4.setLayout(new MigLayout("insets 5 0 0 0 "));
        loginPanel.add((Component)p4, "align center,wrap");
        JButton button_save = this.createButton("\u786e\u5b9a");
        p4.add(button_save);
        this.button_site = this.createButton("\u7f51\u7ad9");
        p4.add(this.button_site);
        this.button_site.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientUI.this.openUrl(ClientUI.this.homeUrl);
            }
        });
        JButton button_exit = this.createButton("\u9000\u51fa");
        p4.add(button_exit);
        button_exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        button_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClientUI.this.config.getDownloadSpeed() == 0 || ClientUI.this.config.getUploadSpeed() == 0) {
                    SpeedSetFrame speedSetFrame = new SpeedSetFrame(ui, ClientUI.this.mainFrame);
                }
                ClientUI.this.setMessage("");
                ClientUI.this.saveConfig();
            }
        });
        this.stateText = new JLabel("");
        this.mainPanel.add((Component)this.stateText, "align right ,wrap");
        JPanel p5 = new JPanel();
        p5.setLayout(new MigLayout("insets 5 0 0 0 "));
        this.mainPanel.add((Component)p5, "align right");
        JButton button_fsa = this.createButton_Link("FS\u9ad8\u7ea7\u7248", "http://www.xsocks.me/?fsc");
        p5.add(button_fsa);
        JButton button_wlt = this.createButton_Link("\u7f51\u7edc\u901a\u5185\u7f51\u7a7f\u900f", "http://www.youtusoft.com/?fsc");
        p5.add(button_wlt);
        this.downloadSpeedField = new JLabel();
        this.downloadSpeedField.setHorizontalAlignment(4);
        p5.add((Component)this.downloadSpeedField, "width 130:: ,align right ");
        this.updateUISpeed(0, 0, 0);
        this.setMessage(" ");
        this.text_serverAddress.setSelectedItem(this.getServerAddressFromConfig());
        if (this.config.getRemoteAddress() != null && !this.config.getRemoteAddress().equals("") && this.config.getRemotePort() > 0) {
            String string = String.valueOf(this.config.getRemoteAddress()) + ":" + this.config.getRemotePort();
        }
        int width = 500;
        if (this.systemName.contains("os x")) {
            width = 600;
        }
        this.mainFrame.pack();
        this.mainFrame.setLocationRelativeTo(null);
        PopupMenu trayMenu = new PopupMenu();
        if (SystemTray.isSupported()) {
            this.mainFrame.addWindowListener(this);
            this.tray = SystemTray.getSystemTray();
            this.trayIcon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(this.offlineImg), this.name, trayMenu);
            this.trayIcon.setImageAutoSize(true);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientUI.this.mainFrame.toFront();
                    ClientUI.this.setVisible(true);
                    ClientUI.this.mainFrame.setVisible(true);
                }
            };
            this.trayIcon.addActionListener(listener);
            this.trayIcon.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                }

                @Override
                public void mouseEntered(MouseEvent arg0) {
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                }

                @Override
                public void mouseReleased(MouseEvent arg0) {
                }
            });
            try {
                this.tray.add(this.trayIcon);
            }
            catch (AWTException e1) {
                e1.printStackTrace();
            }
            try {
                MenuItem item3 = new MenuItem("Exit");
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClientUI.this.exit();
                    }
                };
                item3.addActionListener(al);
                trayMenu.add(item3);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            this.mainFrame.setDefaultCloseOperation(0);
        }
        boolean tcpEnvSuccess = true;
        this.checkFireWallOn();
        if (!this.success_firewall_windows) {
            tcpEnvSuccess = false;
            if (isVisible) {
                this.mainFrame.setVisible(true);
                JOptionPane.showMessageDialog(this.mainFrame, "\u542f\u52a8windows\u9632\u706b\u5899\u5931\u8d25,\u8bf7\u5148\u8fd0\u884c\u9632\u706b\u5899\u670d\u52a1.");
            }
            MLog.println("\u542f\u52a8windows\u9632\u706b\u5899\u5931\u8d25,\u8bf7\u5148\u8fd0\u884c\u9632\u706b\u5899\u670d\u52a1.");
        }
        if (!this.success_firewall_osx) {
            tcpEnvSuccess = false;
            if (isVisible) {
                this.mainFrame.setVisible(true);
                JOptionPane.showMessageDialog(this.mainFrame, "\u542f\u52a8ipfw/pfctl\u9632\u706b\u5899\u5931\u8d25,\u8bf7\u5148\u5b89\u88c5.");
            }
            MLog.println("\u542f\u52a8ipfw/pfctl\u9632\u706b\u5899\u5931\u8d25,\u8bf7\u5148\u5b89\u88c5.");
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Pcaps.findAllDevs();
                    ClientUI.this.b1 = true;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (!this.b1) {
            tcpEnvSuccess = false;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String msg = "\u542f\u52a8\u5931\u8d25,\u8bf7\u5148\u5b89\u88c5libpcap,\u5426\u5219\u65e0\u6cd5\u4f7f\u7528tcp\u534f\u8bae";
                        if (ClientUI.this.systemName.contains("windows")) {
                            msg = "\u542f\u52a8\u5931\u8d25,\u8bf7\u5148\u5b89\u88c5winpcap,\u5426\u5219\u65e0\u6cd5\u4f7f\u7528tcp\u534f\u8bae";
                        }
                        if (isVisible) {
                            ClientUI.this.mainFrame.setVisible(true);
                            JOptionPane.showMessageDialog(ClientUI.this.mainFrame, msg);
                        }
                        MLog.println(msg);
                        if (ClientUI.this.systemName.contains("windows")) {
                            try {
                                Process process = Runtime.getRuntime().exec("winpcap_install.exe", null);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            ClientUI.this.tcpEnable = false;
                        }
                    }
                });
            }
            catch (InvocationTargetException e2) {
                e2.printStackTrace();
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        try {
            this.mapClient = new MapClient(this, tcpEnvSuccess);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.capException = e1;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!ClientUI.this.mapClient.route_tcp.capEnv.tcpEnable) {
                        if (isVisible) {
                            ClientUI.this.mainFrame.setVisible(true);
                        }
                        ClientUI.this.r_tcp.setEnabled(false);
                        ClientUI.this.r_udp.setSelected(true);
                    }
                }
            });
        }
        catch (InvocationTargetException e2) {
            e2.printStackTrace();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        this.mapClient.setUi(this);
        this.mapClient.setMapServer(this.config.getServerAddress(), this.config.getServerPort(), this.config.getRemotePort(), null, null, this.config.isDirect_cn(), this.config.getProtocal().equals("tcp"), null);
        Route.es.execute(new Runnable(){

            @Override
            public void run() {
                ClientUI.this.checkUpdate();
            }
        });
        this.setSpeed(this.config.getDownloadSpeed(), this.config.getUploadSpeed());
        if (isVisible & !min) {
            this.mainFrame.setVisible(true);
        }
        this.loadMapRule();
        if (this.config.getDownloadSpeed() == 0 || this.config.getUploadSpeed() == 0) {
            SpeedSetFrame speedSetFrame = new SpeedSetFrame(ui, this.mainFrame);
        }
    }

    String getServerAddressFromConfig() {
        String server_addressTxt = this.config.getServerAddress();
        if (this.config.getServerAddress() != null && !this.config.getServerAddress().equals("") && this.config.getServerPort() != 150 && this.config.getServerPort() != 0) {
            server_addressTxt = String.valueOf(server_addressTxt) + ":" + this.config.getServerPort();
        }
        return server_addressTxt;
    }

    void checkFireWallOn() {
        if (this.systemName.contains("os x")) {
            Process p2;
            String runFirewall = "ipfw";
            try {
                p2 = Runtime.getRuntime().exec(runFirewall, null);
                this.osx_fw_ipfw = true;
            }
            catch (IOException p2) {
                // empty catch block
            }
            runFirewall = "pfctl";
            try {
                p2 = Runtime.getRuntime().exec(runFirewall, null);
                this.osx_fw_pf = true;
            }
            catch (IOException p3) {
                // empty catch block
            }
            this.success_firewall_osx = this.osx_fw_ipfw | this.osx_fw_pf;
        } else if (this.systemName.contains("linux")) {
            String runFirewall = "service iptables start";
        } else if (this.systemName.contains("windows")) {
            String runFirewall = "netsh advfirewall set allprofiles state on";
            Thread standReadThread = null;
            Thread errorReadThread = null;
            try {
                final Process p = Runtime.getRuntime().exec(runFirewall, null);
                standReadThread = new Thread(){

                    @Override
                    public void run() {
                        InputStream is = p.getInputStream();
                        BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                        try {
                            String line;
                            while ((line = localBufferedReader.readLine()) != null) {
                                if (!line.contains("Windows")) continue;
                                ClientUI.this.success_firewall_windows = false;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            ClientUI.this.exit();
                        }
                    }
                };
                standReadThread.start();
                errorReadThread = new Thread(){

                    @Override
                    public void run() {
                        InputStream is = p.getErrorStream();
                        BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                        try {
                            String line;
                            while ((line = localBufferedReader.readLine()) != null) {
                                System.out.println("error" + line);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            ClientUI.this.exit();
                        }
                    }
                };
                errorReadThread.start();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.success_firewall_windows = false;
            }
            if (standReadThread != null) {
                try {
                    standReadThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (errorReadThread != null) {
                try {
                    errorReadThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void checkQuanxian() {
        if (this.systemName.contains("windows")) {
            boolean b = false;
            File file = new File(String.valueOf(System.getenv("WINDIR")) + "\\test.file");
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            b = file.exists();
            file.delete();
            if (!b) {
                if (this.isVisible) {
                    JOptionPane.showMessageDialog(null, "\u8bf7\u4ee5\u7ba1\u7406\u5458\u8eab\u4efd\u8fd0\u884c! ");
                }
                MLog.println("\u8bf7\u4ee5\u7ba1\u7406\u5458\u8eab\u4efd\u8fd0\u884c,\u5426\u5219\u53ef\u80fd\u65e0\u6cd5\u6b63\u5e38\u5de5\u4f5c! ");
            }
        }
    }

    void loadMapRule() {
        this.tcpMapRuleListTable.setMapRuleList(this.mapClient.portMapManager.getMapList());
    }

    void select(String name) {
        int index = this.model.getMapRuleIndex(name);
        if (index > -1) {
            this.tcpMapRuleListTable.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    void setSpeed(int downloadSpeed, int uploadSpeed) {
        this.config.setDownloadSpeed(downloadSpeed);
        this.config.setUploadSpeed(uploadSpeed);
        int s1 = (int)((float)downloadSpeed * 1.1f);
        this.text_ds.setText(" " + Tools.getSizeStringKB(s1) + "/s ");
        int s2 = (int)((float)uploadSpeed * 1.1f);
        this.text_us.setText(" " + Tools.getSizeStringKB(s2) + "/s ");
        Route.localDownloadSpeed = downloadSpeed;
        Route.localUploadSpeed = this.config.uploadSpeed;
        this.saveConfig();
    }

    void exit() {
        this.mainFrame.setVisible(false);
        System.exit(0);
    }

    void openUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void setMessage(String message) {
        this.stateText.setText("\u72b6\u6001: " + message);
    }

    ClientConfig loadConfig() {
        ClientConfig cfg = new ClientConfig();
        if (!new File(this.configFilePath).exists()) {
            JSONObject json = new JSONObject();
            try {
                this.saveFile(json.toJSONString().getBytes(), this.configFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String content = ClientUI.readFileUtf8(this.configFilePath);
            JSONObject json = JSONObject.parseObject(content);
            cfg.setServerAddress(json.getString("server_address"));
            cfg.setServerPort(json.getIntValue("server_port"));
            cfg.setRemotePort(json.getIntValue("remote_port"));
            cfg.setRemoteAddress(json.getString("remote_address"));
            if (json.containsKey("direct_cn")) {
                cfg.setDirect_cn(json.getBooleanValue("direct_cn"));
            }
            cfg.setDownloadSpeed(json.getIntValue("download_speed"));
            cfg.setUploadSpeed(json.getIntValue("upload_speed"));
            if (json.containsKey("socks5_port")) {
                cfg.setSocks5Port(json.getIntValue("socks5_port"));
            }
            if (json.containsKey("protocal")) {
                cfg.setProtocal(json.getString("protocal"));
            }
            if (json.containsKey("auto_start")) {
                cfg.setAutoStart(json.getBooleanValue("auto_start"));
            }
            if (json.containsKey("recent_address_list")) {
                JSONArray list = json.getJSONArray("recent_address_list");
                int i = 0;
                while (i < list.size()) {
                    cfg.getRecentAddressList().add(list.get(i).toString());
                    ++i;
                }
            }
            this.config = cfg;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cfg;
    }

    void saveConfig() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                block18: {
                    boolean success = false;
                    try {
                        try {
                            String ports;
                            int index;
                            int serverPort = 150;
                            String addressTxt = "";
                            if (ClientUI.this.text_serverAddress.getSelectedItem() != null) {
                                addressTxt = ClientUI.this.text_serverAddress.getSelectedItem().toString();
                            }
                            String serverAddress = addressTxt = addressTxt.trim().replaceAll(" ", "");
                            if (addressTxt.startsWith("[")) {
                                index = addressTxt.lastIndexOf("]:");
                                if (index > 0) {
                                    serverAddress = addressTxt.substring(0, index + 1);
                                    ports = addressTxt.substring(index + 2);
                                    serverPort = Integer.parseInt(ports);
                                }
                            } else {
                                index = addressTxt.lastIndexOf(":");
                                if (index > 0) {
                                    serverAddress = addressTxt.substring(0, index);
                                    ports = addressTxt.substring(index + 1);
                                    serverPort = Integer.parseInt(ports);
                                }
                            }
                            String protocal = "tcp";
                            if (ClientUI.this.r_udp.isSelected()) {
                                protocal = "udp";
                            }
                            JSONObject json = new JSONObject();
                            json.put("server_address", (Object)serverAddress);
                            json.put("server_port", (Object)serverPort);
                            json.put("download_speed", (Object)ClientUI.this.config.getDownloadSpeed());
                            json.put("upload_speed", (Object)ClientUI.this.config.getUploadSpeed());
                            json.put("socks5_port", (Object)ClientUI.this.config.getSocks5Port());
                            json.put("protocal", (Object)protocal);
                            json.put("auto_start", (Object)ClientUI.this.config.isAutoStart());
                            if (ClientUI.this.text_serverAddress.getModel().getSize() > 0) {
                                ClientUI.this.text_serverAddress.removeItem(addressTxt);
                            }
                            ClientUI.this.text_serverAddress.insertItemAt(addressTxt, 0);
                            ClientUI.this.text_serverAddress.setSelectedItem(addressTxt);
                            JSONArray recentAddressList = new JSONArray();
                            int size = ClientUI.this.text_serverAddress.getModel().getSize();
                            int n = 0;
                            while (n < size) {
                                String address = ClientUI.this.text_serverAddress.getModel().getElementAt(n).toString();
                                if (!address.equals("")) {
                                    recentAddressList.add(address);
                                }
                                ++n;
                            }
                            json.put("recent_address_list", (Object)recentAddressList);
                            ClientUI.this.saveFile(json.toJSONString().getBytes("utf-8"), ClientUI.this.configFilePath);
                            ClientUI.this.config.setServerAddress(serverAddress);
                            ClientUI.this.config.setServerPort(serverPort);
                            ClientUI.this.config.setProtocal(protocal);
                            success = true;
                            String realAddress = serverAddress;
                            if (realAddress != null) {
                                realAddress = realAddress.replace("[", "");
                                realAddress = realAddress.replace("]", "");
                            }
                            boolean tcp = protocal.equals("tcp");
                            ClientUI.this.mapClient.setMapServer(realAddress, serverPort, 0, null, null, ClientUI.this.config.isDirect_cn(), tcp, null);
                            ClientUI.this.mapClient.closeAndTryConnect();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!success) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog((this).ClientUI.this.mainFrame, (this).ClientUI.this.errorMsg, "\u9519\u8bef", 0);
                                    }
                                });
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        throw throwable;
                    }
                    if (!success) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String readFileUtf8(String path) throws Exception {
        String str = null;
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            try {
                File file = new File(path);
                int length = (int)file.length();
                byte[] data = new byte[length];
                fis = new FileInputStream(file);
                dis = new DataInputStream(fis);
                ((DataInputStream)dis).readFully(data);
                str = new String(data, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return str;
    }

    void saveFile(byte[] data, String path) throws Exception {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(path);
                fos.write(data);
            }
            catch (Exception e) {
                if (this.systemName.contains("windows")) {
                    JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25,\u8bf7\u5c1d\u8bd5\u4ee5\u7ba1\u7406\u5458\u8eab\u4efd\u8fd0\u884c! " + path);
                    System.exit(0);
                }
                throw e;
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    @Override
    public void updateUISpeed(int conn, int downloadSpeed, int uploadSpeed) {
        String string = " \u4e0b\u8f7d:" + Tools.getSizeStringKB(downloadSpeed) + "/s" + " \u4e0a\u4f20:" + Tools.getSizeStringKB(uploadSpeed) + "/s";
        if (this.downloadSpeedField != null) {
            this.downloadSpeedField.setText(string);
        }
    }

    JButton createButton(String name) {
        JButton button = new JButton(name);
        button.setMargin(new Insets(0, 5, 0, 5));
        button.setFocusPainted(false);
        return button;
    }

    JButton createButton_Link(String name, final String url) {
        JButton button = new JButton(name);
        Color c = new Color(0, 0, 255);
        button.setBackground(c);
        button.setForeground(new Color(100, 100, 255));
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setMargin(new Insets(0, 2, 0, 2));
        button.setFocusPainted(false);
        button.setCursor(new Cursor(12));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientUI.this.openUrl(url);
            }
        });
        return button;
    }

    boolean haveNewVersion() {
        return this.serverVersion > this.localVersion;
    }

    public void checkUpdate() {
        int option;
        int i = 0;
        while (i < 3) {
            this.checkingUpdate = true;
            try {
                Properties propServer = new Properties();
                HttpURLConnection uc = Tools.getConnection(this.updateUrl);
                uc.setUseCaches(false);
                InputStream in = uc.getInputStream();
                propServer.load(in);
                this.serverVersion = Integer.parseInt(propServer.getProperty("version"));
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                this.checkingUpdate = false;
            }
            ++i;
        }
        if (this.haveNewVersion() && (option = JOptionPane.showConfirmDialog(this.mainFrame, "\u53d1\u73b0\u65b0\u7248\u672c,\u7acb\u5373\u66f4\u65b0\u5417?", "\u63d0\u9192", 2)) == 0) {
            this.openUrl(this.homeUrl);
        }
    }

    void initUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Font font = new Font("\u5b8b\u4f53", 0, 12);
                UIManager.put("ToolTip.font", font);
                UIManager.put("Table.font", font);
                UIManager.put("TableHeader.font", font);
                UIManager.put("TextField.font", font);
                UIManager.put("ComboBox.font", font);
                UIManager.put("TextField.font", font);
                UIManager.put("PasswordField.font", font);
                UIManager.put("TextArea.font,font", font);
                UIManager.put("TextPane.font", font);
                UIManager.put("EditorPane.font", font);
                UIManager.put("FormattedTextField.font", font);
                UIManager.put("Button.font", font);
                UIManager.put("CheckBox.font", font);
                UIManager.put("RadioButton.font", font);
                UIManager.put("ToggleButton.font", font);
                UIManager.put("ProgressBar.font", font);
                UIManager.put("DesktopIcon.font", font);
                UIManager.put("TitledBorder.font", font);
                UIManager.put("Label.font", font);
                UIManager.put("List.font", font);
                UIManager.put("TabbedPane.font", font);
                UIManager.put("MenuBar.font", font);
                UIManager.put("Menu.font", font);
                UIManager.put("MenuItem.font", font);
                UIManager.put("PopupMenu.font", font);
                UIManager.put("CheckBoxMenuItem.font", font);
                UIManager.put("RadioButtonMenuItem.font", font);
                UIManager.put("Spinner.font", font);
                UIManager.put("Tree.font", font);
                UIManager.put("ToolBar.font", font);
                UIManager.put("OptionPane.messageFont", font);
                UIManager.put("OptionPane.buttonFont", font);
                ToolTipManager.sharedInstance().setInitialDelay(130);
            }
        });
    }

    public static void setAutoRun(boolean run) {
        String s = new File(".").getAbsolutePath();
        String currentPaht = s.substring(0, s.length() - 1);
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(currentPaht, "\\");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append("\\\\");
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("Windows Registry Editor Version 5.00");
        String name = "fsclient";
        if (run) {
            list.add("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run]");
            list.add("\"" + name + "\"=\"" + sb.toString() + "finalspeedclient.exe -min" + "\"");
        } else {
            list.add("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run]");
            list.add("\"" + name + "\"=-");
        }
        File file = null;
        try {
            try {
                file = new File("import.reg");
                FileWriter fw = new FileWriter(file);
                PrintWriter pw = new PrintWriter(fw);
                int i = 0;
                while (i < list.size()) {
                    String ss = (String)list.get(i);
                    if (!ss.equals("")) {
                        pw.println(ss);
                    }
                    ++i;
                }
                pw.flush();
                pw.close();
                Process p = Runtime.getRuntime().exec("regedit /s import.reg");
                p.waitFor();
            }
            catch (Exception exception) {
                if (file != null) {
                    file.delete();
                }
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.mainFrame.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public boolean login() {
        return false;
    }

    @Override
    public boolean updateNode(boolean testSpeed) {
        return true;
    }

    @Override
    public boolean isOsx_fw_pf() {
        return this.osx_fw_pf;
    }

    public void setOsx_fw_pf(boolean osx_fw_pf) {
        this.osx_fw_pf = osx_fw_pf;
    }

    @Override
    public boolean isOsx_fw_ipfw() {
        return this.osx_fw_ipfw;
    }

    public void setOsx_fw_ipfw(boolean osx_fw_ipfw) {
        this.osx_fw_ipfw = osx_fw_ipfw;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }
}

