/*
 * Decompiled with CFR 0.152.
 */
package net.fs.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Random;
import net.fs.client.ClientUI;
import net.fs.client.ClientUII;
import net.fs.client.PortMapManager;
import net.fs.rudp.ClientProcessorInterface;
import net.fs.rudp.ConnectionProcessor;
import net.fs.rudp.Route;
import net.fs.rudp.TrafficEvent;
import net.fs.rudp.Trafficlistener;
import net.fs.utils.NetStatus;

public class MapClient
implements Trafficlistener {
    ConnectionProcessor imTunnelProcessor;
    Route route_udp;
    Route route_tcp;
    short routePort = (short)45;
    ClientUII ui;
    String serverAddress = "";
    InetAddress address = null;
    int serverPort = 130;
    NetStatus netStatus;
    long lastTrafficTime;
    int downloadSum = 0;
    int uploadSum = 0;
    Thread clientUISpeedUpdateThread;
    int connNum = 0;
    HashSet<ClientProcessorInterface> processTable = new HashSet();
    Object syn_process = new Object();
    static MapClient mapClient;
    PortMapManager portMapManager;
    public String mapdstAddress;
    public int mapdstPort;
    static int monPort;
    String systemName = System.getProperty("os.name").toLowerCase();
    boolean useTcp = true;
    long clientId;
    Random ran = new Random();
    boolean tcpEnable;

    static {
        monPort = 25874;
    }

    MapClient(ClientUI ui, boolean tcpEnvSuccess) throws Exception {
        this.ui = ui;
        mapClient = this;
        try {
            final ServerSocket socket = new ServerSocket(monPort);
            new Thread(){

                @Override
                public void run() {
                    try {
                        socket.accept();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(0);
                    }
                }
            }.start();
        }
        catch (Exception e) {
            System.exit(0);
        }
        this.route_tcp = new Route(null, this.routePort, Route.mode_client, true, tcpEnvSuccess);
        this.route_udp = new Route(null, this.routePort, Route.mode_client, false, tcpEnvSuccess);
        this.netStatus = new NetStatus();
        this.portMapManager = new PortMapManager(this);
        this.clientUISpeedUpdateThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    MapClient.this.updateUISpeed();
                }
            }
        };
        this.clientUISpeedUpdateThread.start();
        Route.addTrafficlistener(this);
    }

    public static MapClient get() {
        return mapClient;
    }

    private void updateUISpeed() {
        if (this.ui != null) {
            this.ui.updateUISpeed(this.connNum, this.netStatus.getDownSpeed(), this.netStatus.getUpSpeed());
        }
    }

    public void setMapServer(String serverAddress, int serverPort, int remotePort, String passwordMd5, String password_proxy_Md5, boolean direct_cn, boolean tcp, String password) {
        if (this.serverAddress == null || !this.serverAddress.equals(serverAddress) || this.serverPort != serverPort) {
            if (this.route_tcp.lastClientControl != null) {
                this.route_tcp.lastClientControl.close();
            }
            if (this.route_udp.lastClientControl != null) {
                this.route_udp.lastClientControl.close();
            }
            this.cleanRule();
            if (serverAddress != null && !serverAddress.equals("")) {
                this.setFireWallRule(serverAddress, serverPort);
            }
        }
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.address = null;
        this.useTcp = tcp;
        this.resetConnection();
    }

    void setFireWallRule(String serverAddress, int serverPort) {
        block12: {
            try {
                String ip = InetAddress.getByName(serverAddress).getHostAddress();
                if (this.systemName.contains("mac os")) {
                    if (this.ui.isOsx_fw_pf()) {
                        String tempPath = "./pf.conf";
                        File f = new File(tempPath);
                        File d = f.getParentFile();
                        if (!d.exists()) {
                            d.mkdirs();
                        }
                        if (f.exists()) {
                            f.delete();
                        }
                        String content = "block drop quick proto tcp from any to " + ip + " port = " + serverPort + "\n";
                        this.saveFile(content.getBytes(), tempPath);
                        String cmd1 = "pfctl -d";
                        MapClient.runCommand(cmd1);
                        String cmd2 = "pfctl -Rf " + f.getAbsolutePath();
                        MapClient.runCommand(cmd2);
                        String cmd3 = "pfctl -e";
                        MapClient.runCommand(cmd3);
                    } else if (this.ui.isOsx_fw_ipfw()) {
                        String cmd2 = "sudo ipfw add 5050 deny tcp from any to " + ip + " " + serverAddress + " out";
                        MapClient.runCommand(cmd2);
                    }
                    break block12;
                }
                if (this.systemName.contains("linux")) {
                    String cmd2 = "iptables -t filter -A OUTPUT -d " + ip + " -p tcp --dport " + serverPort + " -j DROP -m comment --comment tcptun_fs ";
                    MapClient.runCommand(cmd2);
                    break block12;
                }
                if (!this.systemName.contains("windows")) break block12;
                try {
                    if (this.systemName.contains("xp") || this.systemName.contains("2003")) {
                        String cmd_add1 = "ipseccmd -w REG -p \"tcptun_fs\" -r \"Block TCP/" + serverPort + "\" -f 0/255.255.255.255=" + ip + "/255.255.255.255:" + serverPort + ":tcp -n BLOCK -x ";
                        Process p2 = Runtime.getRuntime().exec(cmd_add1, null);
                        p2.waitFor();
                        break block12;
                    }
                    String cmd_add1 = "netsh advfirewall firewall add rule name=tcptun_fs protocol=TCP dir=out remoteport=" + serverPort + " remoteip=" + ip + " action=block ";
                    Process p2 = Runtime.getRuntime().exec(cmd_add1, null);
                    p2.waitFor();
                    String cmd_add2 = "netsh advfirewall firewall add rule name=tcptun_fs protocol=TCP dir=in remoteport=" + serverPort + " remoteip=" + ip + " action=block ";
                    Process p3 = Runtime.getRuntime().exec(cmd_add2, null);
                    p3.waitFor();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void saveFile(byte[] data, String path) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(data);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    void cleanRule() {
        if (this.systemName.contains("mac os")) {
            this.cleanTcpTunRule_osx();
        } else if (this.systemName.contains("linux")) {
            this.cleanTcpTunRule_linux();
        } else {
            try {
                if (this.systemName.contains("xp") || this.systemName.contains("2003")) {
                    String cmd_delete = "ipseccmd -p \"tcptun_fs\" -w reg -y";
                    Process p1 = Runtime.getRuntime().exec(cmd_delete, null);
                    p1.waitFor();
                } else {
                    String cmd_delete = "netsh advfirewall firewall delete rule name=tcptun_fs ";
                    Process p1 = Runtime.getRuntime().exec(cmd_delete, null);
                    p1.waitFor();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void cleanTcpTunRule_osx() {
        String cmd2 = "sudo ipfw delete 5050";
        MapClient.runCommand(cmd2);
    }

    void cleanTcpTunRule_linux() {
        int row;
        while ((row = this.getRow_linux()) > 0) {
            String cmd = "iptables -D OUTPUT " + row;
            MapClient.runCommand(cmd);
        }
    }

    int getRow_linux() {
        int row_delect = -1;
        String cme_list_rule = "iptables -L -n --line-number";
        Thread errorReadThread = null;
        try {
            final Process p = Runtime.getRuntime().exec(cme_list_rule, null);
            errorReadThread = new Thread(){

                @Override
                public void run() {
                    InputStream is = p.getErrorStream();
                    BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                    try {
                        String line;
                        while ((line = localBufferedReader.readLine()) != null) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            errorReadThread.start();
            InputStream is = p.getInputStream();
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
            try {
                String line;
                while ((line = localBufferedReader.readLine()) != null) {
                    int index;
                    if (!line.contains("tcptun_fs") || (index = line.indexOf("   ")) <= 0) continue;
                    String n = line.substring(0, index);
                    try {
                        if (row_delect >= 0) continue;
                        row_delect = Integer.parseInt(n);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            errorReadThread.join();
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row_delect;
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void resetConnection() {
        Object object = this.syn_process;
        // MONITORENTER : object
        // MONITOREXIT : object
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProcessClose(ClientProcessorInterface process) {
        Object object = this.syn_process;
        synchronized (object) {
            this.processTable.remove(process);
        }
    }

    public synchronized void closeAndTryConnect_Login(boolean testSpeed) {
        this.close();
        boolean loginOK = this.ui.login();
        if (loginOK) {
            this.ui.updateNode(testSpeed);
        }
    }

    public synchronized void closeAndTryConnect() {
        this.close();
    }

    public void close() {
    }

    @Override
    public void trafficDownload(TrafficEvent event) {
        this.netStatus.addDownload(event.getTraffic());
        this.lastTrafficTime = System.currentTimeMillis();
        this.downloadSum += event.getTraffic();
    }

    @Override
    public void trafficUpload(TrafficEvent event) {
        this.netStatus.addUpload(event.getTraffic());
        this.lastTrafficTime = System.currentTimeMillis();
        this.uploadSum += event.getTraffic();
    }

    static void runCommand(String command) {
        Thread standReadThread = null;
        Thread errorReadThread = null;
        try {
            final Process p = Runtime.getRuntime().exec(command, null);
            standReadThread = new Thread(){

                @Override
                public void run() {
                    InputStream is = p.getInputStream();
                    BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                    try {
                        String line;
                        while ((line = localBufferedReader.readLine()) != null) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            standReadThread.start();
            errorReadThread = new Thread(){

                @Override
                public void run() {
                    InputStream is = p.getErrorStream();
                    BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(is));
                    try {
                        String line;
                        while ((line = localBufferedReader.readLine()) != null) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            errorReadThread.start();
            standReadThread.join();
            errorReadThread.join();
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isUseTcp() {
        return this.useTcp;
    }

    public void setUseTcp(boolean useTcp) {
        this.useTcp = useTcp;
    }

    public ClientUII getUi() {
        return this.ui;
    }

    public void setUi(ClientUII ui) {
        this.ui = ui;
    }
}

