/*
 * Decompiled with CFR 0.152.
 */
package net.fs.rudp;

import java.util.HashMap;
import net.fs.rudp.AckListTask;
import net.fs.rudp.ConnectionUDP;
import net.fs.rudp.RUDPConfig;

public class AckListManage
implements Runnable {
    Thread mainThread;
    HashMap<Integer, AckListTask> taskTable = new HashMap();

    public AckListManage() {
        this.mainThread = new Thread(this);
        this.mainThread.start();
    }

    synchronized void addAck(ConnectionUDP conn, int sequence) {
        AckListTask at;
        if (!this.taskTable.containsKey(conn.connectId)) {
            at = new AckListTask(conn);
            this.taskTable.put(conn.connectId, at);
        }
        at = this.taskTable.get(conn.connectId);
        at.addAck(sequence);
    }

    synchronized void addLastRead(ConnectionUDP conn) {
        if (!this.taskTable.containsKey(conn.connectId)) {
            AckListTask at = new AckListTask(conn);
            this.taskTable.put(conn.connectId, at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            AckListManage ackListManage = this;
            synchronized (ackListManage) {
                for (int id : this.taskTable.keySet()) {
                    AckListTask at = this.taskTable.get(id);
                    at.run();
                }
                this.taskTable.clear();
                this.taskTable = null;
                this.taskTable = new HashMap();
            }
            try {
                Thread.sleep(RUDPConfig.ackListDelay);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

