/*
 * Decompiled with CFR 0.152.
 */
package net.fs.rudp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.fs.rudp.ConnectionUDP;
import net.fs.rudp.CopiedIterator;
import net.fs.rudp.ResendManage;
import net.fs.rudp.Route;
import net.fs.rudp.SendRecord;
import net.fs.rudp.message.MessageType;
import net.fs.rudp.message.PingMessage;
import net.fs.rudp.message.PingMessage2;
import net.fs.utils.ByteIntConvert;
import net.fs.utils.MLog;
import net.fs.utils.MessageCheck;

public class ClientControl {
    int clientId;
    Thread sendThread;
    Object synlock = new Object();
    private HashMap<Integer, SendRecord> sendRecordTable = new HashMap();
    HashMap<Integer, SendRecord> sendRecordTable_remote = new HashMap();
    long startSendTime = 0L;
    int maxSpeed;
    int initSpeed;
    int currentSpeed = this.initSpeed = (this.maxSpeed = 0x100000);
    int lastTime = -1;
    Object syn_timeid = new Object();
    long sended = 0L;
    long markTime = 0L;
    long lastSendPingTime;
    long lastReceivePingTime = System.currentTimeMillis();
    Random ran = new Random();
    HashMap<Integer, Long> pingTable = new HashMap();
    public int pingDelay = 250;
    int clientId_real = -1;
    long needSleep_All;
    long trueSleep_All;
    int maxAcked = 0;
    long lastLockTime;
    Route route;
    InetAddress dstIp;
    int dstPort;
    public HashMap<Integer, ConnectionUDP> connTable = new HashMap();
    Object syn_connTable = new Object();
    Object syn_tunTable = new Object();
    String password;
    public ResendManage resendMange = new ResendManage();
    boolean closed = false;

    ClientControl(Route route, int clientId, InetAddress dstIp, int dstPort) {
        this.clientId = clientId;
        this.route = route;
        this.dstIp = dstIp;
        this.dstPort = dstPort;
    }

    public void onReceivePacket(DatagramPacket dp) {
        byte[] dpData = dp.getData();
        int sType = 0;
        sType = MessageCheck.checkSType(dp);
        int remote_clientId = ByteIntConvert.toInt(dpData, 8);
        if (sType == MessageType.sType_PingMessage) {
            PingMessage pm = new PingMessage(dp);
            this.sendPingMessage2(pm.getPingId(), dp.getAddress(), dp.getPort());
            this.currentSpeed = pm.getDownloadSpeed() * 1024;
        } else if (sType == MessageType.sType_PingMessage2) {
            PingMessage2 pm = new PingMessage2(dp);
            this.lastReceivePingTime = System.currentTimeMillis();
            Long t = this.pingTable.get(pm.getPingId());
            if (t != null) {
                this.pingDelay = (int)(System.currentTimeMillis() - t);
                String protocal = "";
                protocal = this.route.isUseTcpTun() ? "tcp" : "udp";
                MLog.println("delay_" + protocal + " " + this.pingDelay + "ms " + dp.getAddress().getHostAddress() + ":" + dp.getPort());
            }
        }
    }

    public void sendPacket(DatagramPacket dp) throws IOException {
        this.route.sendPacket(dp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(ConnectionUDP conn) {
        Object object = this.syn_connTable;
        synchronized (object) {
            this.connTable.put(conn.connectId, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(ConnectionUDP conn) {
        Object object = this.syn_connTable;
        synchronized (object) {
            this.connTable.remove(conn.connectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        this.route.clientManager.removeClient(this.clientId);
        Object object = this.syn_connTable;
        synchronized (object) {
            Iterator<Integer> it = this.getConnTableIterator();
            while (it.hasNext()) {
                final ConnectionUDP conn = this.connTable.get(it.next());
                if (conn == null) continue;
                Route.es.execute(new Runnable(){

                    @Override
                    public void run() {
                        conn.stopnow = true;
                        conn.destroy(true);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<Integer> getConnTableIterator() {
        CopiedIterator it = null;
        Object object = this.syn_connTable;
        synchronized (object) {
            it = new CopiedIterator(this.connTable.keySet().iterator());
        }
        return it;
    }

    public void updateClientId(int newClientId) {
        this.clientId_real = newClientId;
        this.sendRecordTable.clear();
        this.sendRecordTable_remote.clear();
    }

    public void onSendDataPacket(ConnectionUDP conn) {
    }

    public void sendPingMessage() {
        int pingid = Math.abs(this.ran.nextInt());
        long pingTime = System.currentTimeMillis();
        this.pingTable.put(pingid, pingTime);
        this.lastSendPingTime = System.currentTimeMillis();
        PingMessage lm = new PingMessage(0, this.route.localclientId, pingid, Route.localDownloadSpeed, Route.localUploadSpeed);
        lm.setDstAddress(this.dstIp);
        lm.setDstPort(this.dstPort);
        try {
            this.sendPacket(lm.getDatagramPacket());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendPingMessage2(int pingId, InetAddress dstIp, int dstPort) {
        PingMessage2 lm = new PingMessage2(0, this.route.localclientId, pingId);
        lm.setDstAddress(dstIp);
        lm.setDstPort(dstPort);
        try {
            this.sendPacket(lm.getDatagramPacket());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onReceivePing(PingMessage pm) {
        if (this.route.mode == 2) {
            this.currentSpeed = pm.getDownloadSpeed() * 1024;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SendRecord getSendRecord(int timeId) {
        SendRecord record = null;
        Object object = this.syn_timeid;
        synchronized (object) {
            record = this.sendRecordTable.get(timeId);
            if (record == null) {
                record = new SendRecord();
                record.setTimeId(timeId);
                this.sendRecordTable.put(timeId, record);
            }
        }
        return record;
    }

    public int getCurrentTimeId() {
        long current = System.currentTimeMillis();
        if (this.startSendTime == 0L) {
            this.startSendTime = current;
        }
        int timeId = (int)((current - this.startSendTime) / 1000L);
        return timeId;
    }

    public int getTimeId(long time) {
        int timeId = (int)((time - this.startSendTime) / 1000L);
        return timeId;
    }

    public synchronized void sendSleep(long startTime, int length) {
        if (this.route.mode == 1) {
            this.currentSpeed = Route.localUploadSpeed;
        }
        if (this.sended == 0L) {
            this.markTime = startTime;
        }
        this.sended += (long)length;
        if (this.sended > 10240L) {
            long needTime = (long)(1.0E9f * (float)this.sended / (float)this.currentSpeed);
            long usedTime = System.nanoTime() - this.markTime;
            if (usedTime < needTime) {
                long sleepTime = needTime - usedTime;
                this.needSleep_All += sleepTime;
                long moreTime = this.trueSleep_All - this.needSleep_All;
                if (moreTime > 0L && sleepTime <= moreTime) {
                    sleepTime = 0L;
                    this.trueSleep_All -= sleepTime;
                }
                long s = needTime / 1000000L;
                int n = (int)(needTime % 1000000L);
                long t1 = System.nanoTime();
                if (sleepTime > 0L) {
                    try {
                        Thread.sleep(s, n);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.trueSleep_All += System.nanoTime() - t1;
                }
            }
            this.sended = 0L;
        }
    }

    public Object getSynlock() {
        return this.synlock;
    }

    public void setSynlock(Object synlock) {
        this.synlock = synlock;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public int getClientId_real() {
        return this.clientId_real;
    }

    public void setClientId_real(int clientId_real) {
        this.clientId_real = clientId_real;
        this.lastReceivePingTime = System.currentTimeMillis();
    }

    public long getLastSendPingTime() {
        return this.lastSendPingTime;
    }

    public void setLastSendPingTime(long lastSendPingTime) {
        this.lastSendPingTime = lastSendPingTime;
    }

    public long getLastReceivePingTime() {
        return this.lastReceivePingTime;
    }

    public void setLastReceivePingTime(long lastReceivePingTime) {
        this.lastReceivePingTime = lastReceivePingTime;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

