/*
 * Decompiled with CFR 0.152.
 */
package net.fs.rudp;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import net.fs.rudp.ClientControl;
import net.fs.rudp.CopiedIterator;
import net.fs.rudp.Route;
import net.fs.utils.MLog;

public class ClientManager {
    HashMap<Integer, ClientControl> clientTable = new HashMap();
    Thread mainThread;
    Route route;
    int receivePingTimeout = 8000;
    int sendPingInterval = 1000;
    Object syn_clientTable = new Object();

    ClientManager(Route route) {
        this.route = route;
        this.mainThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ClientManager.this.scanClientControl();
                }
            }
        };
        this.mainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scanClientControl() {
        Iterator<Integer> it = this.getClientTableIterator();
        long current = System.currentTimeMillis();
        while (it.hasNext()) {
            ClientControl cc = this.clientTable.get(it.next());
            if (cc == null) continue;
            if (current - cc.getLastReceivePingTime() < (long)this.receivePingTimeout) {
                if (current - cc.getLastSendPingTime() <= (long)this.sendPingInterval) continue;
                cc.sendPingMessage();
                continue;
            }
            MLog.println("\u8d85\u65f6\u5173\u95edclient " + cc.dstIp.getHostAddress() + ":" + cc.dstPort + " " + new Date());
            Object object = this.syn_clientTable;
            synchronized (object) {
                cc.close();
            }
        }
    }

    void removeClient(int clientId) {
        this.clientTable.remove(clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<Integer> getClientTableIterator() {
        CopiedIterator it = null;
        Object object = this.syn_clientTable;
        synchronized (object) {
            it = new CopiedIterator(this.clientTable.keySet().iterator());
        }
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientControl getClientControl(int clientId, InetAddress dstIp, int dstPort) {
        ClientControl c = this.clientTable.get(clientId);
        if (c == null) {
            c = new ClientControl(this.route, clientId, dstIp, dstPort);
            Object object = this.syn_clientTable;
            synchronized (object) {
                this.clientTable.put(clientId, c);
            }
        }
        return c;
    }
}

