/*
 * Decompiled with CFR 0.152.
 */
package net.fs.server;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.fs.client.Pipe;
import net.fs.rudp.ConnectionProcessor;
import net.fs.rudp.ConnectionUDP;
import net.fs.rudp.Constant;
import net.fs.rudp.Route;
import net.fs.rudp.UDPInputStream;
import net.fs.rudp.UDPOutputStream;
import net.fs.utils.MLog;

public class MapTunnelProcessor
implements ConnectionProcessor {
    Socket dstSocket = null;
    boolean closed = false;
    MapTunnelProcessor pc;
    ConnectionUDP conn;
    UDPInputStream tis;
    UDPOutputStream tos;
    InputStream sis;
    OutputStream sos;

    @Override
    public void process(ConnectionUDP conn) {
        this.conn = conn;
        this.pc = this;
        Route.es.execute(new Runnable(){

            @Override
            public void run() {
                MapTunnelProcessor.this.process();
            }
        });
    }

    void process() {
        this.tis = this.conn.uis;
        this.tos = this.conn.uos;
        try {
            byte[] headData = this.tis.read2();
            String hs = new String(headData, "utf-8");
            JSONObject requestJSon = JSONObject.parseObject(hs);
            final int dstPort = requestJSon.getIntValue("dst_port");
            String message = "";
            JSONObject responeJSon = new JSONObject();
            int code = Constant.code_failed;
            code = Constant.code_success;
            responeJSon.put("code", (Object)code);
            responeJSon.put("message", (Object)message);
            byte[] responeData = responeJSon.toJSONString().getBytes("utf-8");
            this.tos.write(responeData, 0, responeData.length);
            if (code != Constant.code_success) {
                this.close();
                return;
            }
            this.dstSocket = new Socket("127.0.0.1", dstPort);
            this.dstSocket.setTcpNoDelay(true);
            this.sis = this.dstSocket.getInputStream();
            this.sos = this.dstSocket.getOutputStream();
            final Pipe p1 = new Pipe();
            final Pipe p2 = new Pipe();
            Route.es.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            p1.pipe(MapTunnelProcessor.this.sis, MapTunnelProcessor.this.tos, 102400, p2);
                        }
                        catch (Exception exception) {
                            MapTunnelProcessor.this.close();
                            if (p1.getReadedLength() == 0) {
                                MLog.println("\u7aef\u53e3" + dstPort + "\u65e0\u8fd4\u56de\u6570\u636e");
                            }
                        }
                    }
                    finally {
                        MapTunnelProcessor.this.close();
                        if (p1.getReadedLength() == 0) {
                            MLog.println("\u7aef\u53e3" + dstPort + "\u65e0\u8fd4\u56de\u6570\u636e");
                        }
                    }
                }
            });
            Route.es.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            p2.pipe(MapTunnelProcessor.this.tis, MapTunnelProcessor.this.sos, 0x6400000, MapTunnelProcessor.this.conn);
                        }
                        catch (Exception exception) {
                            MapTunnelProcessor.this.close();
                        }
                    }
                    finally {
                        MapTunnelProcessor.this.close();
                    }
                }
            });
        }
        catch (Exception e2) {
            this.close();
        }
    }

    void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.sis != null) {
                try {
                    this.sis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.sos != null) {
                try {
                    this.sos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.tos != null) {
                this.tos.closeStream_Local();
            }
            if (this.tis != null) {
                this.tis.closeStream_Local();
            }
            if (this.conn != null) {
                this.conn.close_local();
            }
            if (this.dstSocket != null) {
                try {
                    this.dstSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

