/*
 * Decompiled with CFR 0.152.
 */
package net.fs.utils;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import net.fs.utils.LogListener;

public class LogOutputStream
extends PrintStream {
    HashSet<LogListener> listeners = new HashSet();
    StringBuffer buffer = new StringBuffer();

    public LogOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        super.write(buf, off, len);
        this.fireEvent(new String(buf, off, len));
    }

    private void fireEvent(String text) {
        if (this.buffer != null && this.buffer.length() < 10000) {
            this.buffer.append(text);
        }
        for (LogListener listener : this.listeners) {
            listener.onAppendContent(this, text);
        }
    }

    public void addListener(LogListener listener) {
        this.listeners.add(listener);
    }

    public void remvoeListener(LogListener listener) {
        this.listeners.remove(listener);
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }
}

