/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.Dot1qVlanTagPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.EtherType;

public final class StaticEtherTypePacketFactory
extends AbstractStaticPacketFactory<EtherType> {
    private static final StaticEtherTypePacketFactory INSTANCE = new StaticEtherTypePacketFactory();

    private StaticEtherTypePacketFactory() {
        this.instantiaters.put(EtherType.IPV4, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV4Packet.newPacket(rawData, offset, length);
            }

            public Class<IpV4Packet> getTargetClass() {
                return IpV4Packet.class;
            }
        });
        this.instantiaters.put(EtherType.ARP, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return ArpPacket.newPacket(rawData, offset, length);
            }

            public Class<ArpPacket> getTargetClass() {
                return ArpPacket.class;
            }
        });
        this.instantiaters.put(EtherType.DOT1Q_VLAN_TAGGED_FRAMES, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return Dot1qVlanTagPacket.newPacket(rawData, offset, length);
            }

            public Class<Dot1qVlanTagPacket> getTargetClass() {
                return Dot1qVlanTagPacket.class;
            }
        });
        this.instantiaters.put(EtherType.IPV6, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6Packet.newPacket(rawData, offset, length);
            }

            public Class<IpV6Packet> getTargetClass() {
                return IpV6Packet.class;
            }
        });
    }

    public static StaticEtherTypePacketFactory getInstance() {
        return INSTANCE;
    }
}

