<?php

/**
 * upgrade
 * @package EMLOG
 * @link https://www.emlog.net
 */

/**
 * @var string $action
 * @var object $CACHE
 */

require_once 'globals.php';

if ($action === 'check_update') {
    $emcurl = new EmCurl();
    $emcurl->setPost([
        'emkey'     => Option::get('emkey'),
        'version'   => Option::EMLOG_VERSION,
        'timestamp' => Option::EMLOG_VERSION_TIMESTAMP,
    ]);

    $emcurl->request('https://store.emlog.net/service/upgrade');
    $retStatus = $emcurl->getHttpStatus();
    $response = $emcurl->getRespone();
    header('Content-Type: application/json; charset=UTF-8');
    if ($retStatus !== 200) {
        exit('{"result":"fail"}');
    }
    $r = json_decode($response);
    if ($r->code === 1001) {
        Register::clean();
    }
    exit($response);
}

if ($action === 'update' && User::isAdmin()) {
    $source = Input::getStrVar('source', '');
    $upsql = Input::getStrVar('upsql', '');

    if (empty($source) || empty($upsql)) {
        exit('error');
    }

    // update database
    $temp_sql_file = emFetchFile($upsql);
    if (!$temp_sql_file) {
        exit('error_down');
    }
    $DB = Database::getInstance();
    $setchar = "ALTER DATABASE `" . DB_NAME . "` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;";
    $sql = file($temp_sql_file);
    array_unshift($sql, $setchar);
    $query = '';
    foreach ($sql as $value) {
        // 只执行当前版本需要的更新
        if (!empty($value) && $value[0] == '#') {
            preg_match("/#\s(pro\s[\.\d]+)/i", $value, $v);
            $ver = isset($v[1]) ? trim($v[1]) : '';
            if (version_compare(Option::EMLOG_VERSION, $ver) > 0) {
                break;
            }
        }
        if (!$value || $value[0] == '#') {
            continue;
        }
        $value = str_replace("{db_prefix}", DB_PREFIX, trim($value));
        $query .= $value;
        if (preg_match("/\;$/i", $value)) {
            $DB->query($query, 1);
            $query = '';
        }
    }
    $CACHE->updateCache();
    @unlink($temp_sql_file);

    // update files
    $temp_zip_file = emFetchFile($source);
    if (!$temp_zip_file) {
        exit('error_down');
    }
    $ret = emUnZip($temp_zip_file, '../', 'update');
    switch ($ret) {
        case 1:
            exit('error_dir');
        case 2:
            exit('error_down');
        case 3:
            exit('error_zip');
    }
    @unlink($temp_zip_file);

    exit('succ');
}
