# ReminderApp (Připomínky) - Uživatelská příručka

S ReminderApp (Reminder) už žádné zapomínání!    
Ujišťujeme vás, že tento program existuje, aby vám připomněl vše důležité díky připomínkám, jako jsou (např.: vzít si léky, nezapomenout na schůzku nebo návštěvu někoho, s chůvou, pokojskou, zdravotní sestrou atd.).    
Dokonce i připomenutí narozenin!    
Všichni jsme alespoň jednou v životě prožili tento trapný okamžik: zapomněli jsme na narozeniny někoho blízkého! Nutno říci, že ne vždy je snadné vzpomenout si na narozeniny všech, které jste zvyklí potkávat (zvláště když pocházíte z velké rodiny nebo jste součástí velké skupiny přátel).    
Zadejte narozeniny celé rodiny a program je každý rok připomene budíkem včetně připomenutí narozenin!    
Tento program také obsahuje adresář a mnoho dalšího k objevování!    

Chcete-li se dozvědět více a nakonfigurovat tento program, přečtěte si celou tuto dokumentaci. Díky.    

# Uživatelská příručka

* Autor: [Adriano Barbieri] (mailto: adrianobarb@yahoo.it)
* Poslední úprava: listopad 2024

## Index

* [1.\Úvod](#toc1)
* [2.\ Konfigurace programu](#toc2)
* [3.\ Nabídky](#toc3)
* [4.\ Další informace pro hlavní okno "Připomenutí pro vybraný den:"](#toc4)
* [5.\ Jak funguje adresář?](#toc5)
* [6.\ Jak otevřít program ze systémové lišty?](#toc6)


---


# 1.\ Úvod <a name="toc1"></a>
Tento program, který je kombinací mnou vyvinuté agendy a adresáře, jsem nazval ReminderApp (interní název), ale ve skutečnosti se okno programu a systém stavového řádku zobrazují s názvem „Reminder“.    

Program ReminderApp je přenosný a lze jej nakonfigurovat tak, aby se automaticky minimalizoval a spouštěl při spuštění systému Windows.    

Tento program je velmi intuitivní a nevyžaduje mnoho vysvětlování, ale dám vám několik pokynů, kterými se řídit.    

# 2.\ Nakonfigurujte program <a name="toc2"></a>
Pokud jste získali soubor ReminderApp.zip, rozbalte jej například do cesty:    
`C:\program files\ReminderApp`    

Můžete jej také extrahovat do kořenového adresáře disku `C:\`, příklad:    

`C:\ReminderApp`    

nebo jej můžete umístit kamkoli chcete.    

Po rozbalení tento soubor obsahuje následující prvky:    

* Složka "Doc" obsahující soubory dokumentace pro aktuálně používaný jazyk (pokud je k dispozici).    
* Složka "locale", která obsahuje soubory překladu jazykového rozhraní dostupné pro program.    
* Složka "Sounds", která obsahuje zvukové soubory budíku, můžete je přidat přímo do této složky, pokud jsou ve formátu "wav" a jejich trvání je kratší než 2 sekundy, ReminderApp automaticky načte názvy a seřadí je jejich zadáním do možnosti nastavení „Nastavit upozornění“, což znamená, že pokud přidáte budíky,Počet nastavených budíků se může změnit a budete jej muset resetovat v podnabídce Nastavení Alt + s a poté v dialogovém okně „Nastavit upozornění“ v rozevíracím seznamu s názvem: Použít budík: následovaný názvem alarm.    
Ve složce "Sounds" je také složka "Samples", tyto zvuky program používá.    
* Soubor "ReminderApp.exe" (spustitelný soubor ke spuštění programu kdykoli).    
* Soubor ReminderApp.ico (formát souboru ICO je spravován operačním systémem Microsoft Windows, tento formát je také široce používán pro favicony. Tato ikona je viditelná na hlavním panelu, jakmile je program minimalizován a je odstraněn, když je program zavřen aplikace).    

# Upozornění

Soubor ReminderApp.zip bude po rozbalení obsahovat svůj spustitelný soubor s názvem ReminderApp.exe, který bude vaším antivirem při prvním spuštění prohlášen za falešně pozitivní!    

To se děje například s antivirem Windows Defender.    

Jak povolím programu Windows Defender Antivirus spouštět program?    

Chcete-li programu povolit práci s programem Windows Defender, musíte kliknout na „Další informace“. Objeví se tlačítko „Run Anyway“, stačí na něj kliknout a spustit program ve Windows.    

To je třeba provést pokaždé, když je do složky ReminderApp nainstalován nový spustitelný soubor ReminderApp.exe.    

# 3. \ Nabídky <a name="toc3"></a>
V hlavním okně spouštěcího programu najdeme následujících pět nabídek s příslušnými příkazy.    

# Nabídka Soubor Podnabídka Alt+f

V této první nabídce budeme mít následující možnosti:    

# Kontakty podmenu:
* Export kontaktů z adresáře... Ctrl+Shift+e    
Stiskněte Enter, objeví se dialogové okno s názvem:    
"Exportovat kontakty".    
Vyberte umístění a název exportu ze seznamu v poli úprav:    
`Název souboru`    
Poté v typu dokumentu uveďte txt nebo json.    
`Typ: textové soubory (*.txt)`    
Šipkou dolů vyhledejte:    
"Soubory JSON (*.json)".    
Nakonec uložte soubor stisknutím tlačítka:    
'Uložit'    
Pokud vše půjde dobře, zobrazí se následující zpráva:    
'Poznámka! Kontakty byly úspěšně exportovány!`    
* Import kontaktů do adresáře... Ctrl+Shift+i    
Stiskněte Enter, objeví se dialogové okno s názvem:    
`Vyberte soubor k importu`    
`Název souboru`    
Poté v typu dokumentu uveďte txt nebo json.    
`Typy souborů: soubory JSON (*.json)`    
Šipkou dolů vyhledejte:    
Typy souborů: textové soubory (*.txt)    
Vyberte dříve exportovaný soubor txt nebo json a otevřete jej stisknutím tlačítka:    
'Otevřít'    
Pokud vše půjde dobře, zobrazí se následující zpráva:    
'Poznámka! Import úspěšně dokončen!`    
Stiskněte tlačítko "OK", objeví se nové dialogové okno s názvem:"Vyberte, jak pokračovat".    
`Když zvolíte Ano, kontakty budou nahrazeny.`    
`Pokud zvolíte Ne, budou přidány pouze k existujícím.`    
Stiskněte tlačítko Ano nebo Ne v závislosti na vaší volbě.
PRO VAŠI INFORMACE    
`Soubory JSON jsou v případě tohoto programu strukturovány jako seznam dat, například: ["..."", "..."", "..."] a je pro program pohodlnější pro správu , zatímco JSON soubory text, jsou strukturovány s novou značku řádku, například řádek\nřádek\nřádek atd., které jsou lépe čitelné pro člověka.    
# Konfigurace podmenu:
* Exportovat složku konfigurace... Ctrl+E    
Stiskněte Enter, zobrazí se dialogové okno s názvem:    
`Vyberte cílovou složku`    
Vyberte umístění pro export složky ReminderApp_config v poli pro úpravy:    
Šipka dolů pro nalezení:    
Vyberte složku    
Pokud vše proběhlo správně, zobrazí se následující zpráva:    
`Upozornění! Konfigurace byla úspěšně exportována!`    

* Importovat složku konfigurace... Ctrl+I    
Stiskněte Enter, zobrazí se dialogové okno s názvem:    
`Vyberte zdrojovou složku`    
Vyberte umístění složky ReminderApp_config v poli pro úpravy:    
Šipka dolů pro nalezení:    
Vyberte složku    
Pokud vše proběhlo správně, zobrazí se následující zpráva:    
`Upozornění! Konfigurace byla úspěšně importována!`
* Ukončete Alt+f4    
Tato možnost ukončí program až do dalšího restartu prostřednictvím spustitelného souboru (ReminderApp.exe), pokud jste jej nenakonfigurovali při startu Windows.    

# Podnabídka nabídky Úpravy Alt+ a

V této druhé nabídce budeme mít následující možnosti:    

* Přidat připomenutí... Ctrl+n    
* Upravit připomínku... F2    
* Přesunout připomínku... Ctrl+F2    
* Smazat připomenutí...Del    
* Další připomenutí (podnabídka) se 3 položkami:    
* Přidat... Ctrl+Shift+1    
* Upravit Ctrl+Shift+2    
* Smazat Ctrl+Shift+3    
Pokud k připomenutí přidáte poznámku, uloží se do složky ReminderApp_config /ReminderApp_notes.    
Poznámky mají například jedinečné číslo v názvu souboru. "Notes_xxxx.txt", program je tedy dokáže najít a spravovat.    
Poznámka: V dialogu při přidávání výročí nebo narozenin můžete také vybrat melodii a přehrát/zastavit ji pomocí rozbalovacího seznamu a tlačítka.    
Melodie jsou uloženy ve složce Sounds, Samples, Melodies a jsou ve formátu .wav.    
Můžete přidat další, pokud mají stejný formát a mají krátké trvání.    
Pokud je ve stejný den více výročí/narozenin, budou tato seskupena do jednoho oznámení, proto bude použita první melodie v seznamu.

Pokračujte v nabídce Úpravy:    
* Smazat předchozí schůzky... Ctrl+Shift+a    
* Smazat minulé léky... Ctrl+Shift+m    
* Adresář... F4    
Otevře se dialogové okno pro popsané možnosti, postupujte podle pokynů na obrazovce.    
* Nastavit aktuální datum Ctrl+Shift+h    
Tím se obnoví výběr data na aktuální datum.    
* Zastavit aktuální oznámení Ctrl+Shift+F1    

# Zobrazit podnabídku nabídky Alt+v

V této třetí nabídce budeme mít následující možnosti:    

* Zobrazit narozeniny F5    
* Viz plány F6    
* Zobrazení opakujících se schůzek Shift+F6    
* Viz opakování připomenutí Ctrl+F6    
*Viz F7 narozeniny    
*Viz léky F8    
* Viz opakující se léky Shift+F8    

Pozorování:    
Při vytváření/úpravě připomenutí si také všimnete 2 opakujících se typů: (Opakující se schůzka a Opakující se léky)    
Tyto dva typy připomenutí lze konfigurovat s opakováním: (Denně, Týdně, Ročně), v závislosti na týdnu pro Týdně, výběr dne a výběr měsíce bude aktivován pro Roční.    
Můžete si to nastavit od 5 do 60 minut, budete včas upozorněni a budete mít možnost, já nevím, změnit, připravit se, a když upozornění vyprší, spustí se skutečný alarm.    
Opakovaná připomenutí jsou chytrá, protože se po vypršení jejich platnosti přesunou na další ekvivalentní datum.    
Například opakující se denní upomínku, vždy ji najdete i další den a podobně.    
Možnost smazat opakující se upomínky jsem nepřidal (z pochopitelných důvodů), ale můžete je vidět v nabídce zobrazení. Pokud chcete jednu smazat,stačí nastavit datum, které vidíte jeho aktivací v Pohled, Zobrazit první sloupec "Datum" v zobrazených seznamech, (Kromě schůzek a léků) Poté si zobrazte typ opakovaného připomenutí, které chcete smazat prostřednictvím stejnojmenné položky nabídky v v nabídce "Zobrazit" a všimněte si, že datum zadání je nyní viditelné v prvním sloupci vlevo. Nakonec nastavte toto datum v hlavním voliči, abyste jej mohli vidět a smazat.    

Stisknutím klávesy Enter na požadované možnosti ji zobrazíte v seznamu.    
Stisknutím klávesy aplikací nebo Shift+f10 zobrazíte dostupné možnosti.    
Stiskněte Tab a klikněte na tlačítko Zavřít nebo stiskněte klávesu Escape nebo Enter pro zavření tohoto dialogového okna a návrat do hlavního okna programu.    
Pokračovat v nabídce Zobrazit:
* Zobrazit první sloupec "Datum" v seznamech (kromě schůzek a léků) (ve výchozím nastavení nezaškrtnuto)    
Zobrazení těchto dat je užitečné pro snadné vyhledání připomenutí k jejich změně nebo odstranění nastavením data v hlavním voliči.    

# Nabídka Nastavení Podnabídka Alt+ s

V této čtvrté nabídce budeme mít následující možnosti:    

* Nastavení upozornění Ctrl+Shift+n    
Stiskněte enter, objeví se dialogové okno, pohybem pomocí "Tab" a "Shift+Tab" se pohybujete mezi ovládacími prvky, šipkami nahoru a dolů měníte hodnotu parametru.    
"Počet opakování: 3".    
`Interval mezi opakováními (v sekundách): 8`    
`Použít budík: Alarm 01`    
`Umožňuje čtení času ve 24hodinovém formátu`    
Toto je zaškrtávací políčko pro výběr, zda chcete nastavit formát na 24 hodin nebo 12 hodin, výchozí nastavení je 24 hodin.    
Stisknutím mezerníku nastavíte 12hodinový formát.    
`Povolit čtení data v evropském formátu`    
Toto je zaškrtávací políčko pro nastavení formátu data na americký nebo evropský, výchozí je evropský.    
Stisknutím mezerníku nastavte americký formát.    
This dialog also contains these checkboxes:    
* Automatické spuštění při spuštění Windows (ve výchozím nastavení nezaškrtnuto)    
Výběrem této možnosti umožníte automatickému spuštění programu při spuštění systému Windows.    
* Minimalizovat program při spuštění (ve výchozím nastavení nezaškrtnuto)    
Pokud zvolíte minimalizaci programu při startu, program se sám skryje, na hlavním panelu, aby vás neobtěžoval, byste měli vidět jeho ikonu, určitě ve skrytých ikonách můžete s kontextovou nabídkou pracovat, kdykoli budete chtít. ale program bude nadále sledovat všechna připomenutí pro daný den.    
Pokud chcete, aby byla ikona vždy vidět na hlavním panelu, můžete tak učinit, jakmile je skrytá, konfigurací v Nastavení systému Windows, Personalizace, Hlavní panel, Zobrazit všechny aplikace a Povolit ReminderApp.    
* Zobrazit náhled připomenutí při spuštění, pokud je program minimalizován (ve výchozím nastavení zaškrtnuto)    
Když se program při spuštění minimalizuje na systémovou lištu, otevře náhled připomenutí dne.    
* Check for updates (selected by default)    
If this option is enabled, check for program updates at startup.    
Po dokončení konfigurace potvrďte změny stisknutím klávesy Enter nebo tlačítka "OK". Pro zrušení změn stiskněte Escape nebo tlačítko "Storno".    

Pokračovat v nabídce Nastavení:

* Nastavte kombinaci kláves Ctrl+Shift+K    
Kombinace klávesových zkratek, které zabraňují aktuálnímu oznámení ve spuštění alarmu a zobrazují připomenutí (i když nejsou v popředí), jsou navrženy tak, aby fungovaly mimo grafické uživatelské rozhraní ReminderApp.    
To znamená, že v případě konfliktů s jinými aplikacemi je můžete individuálně přizpůsobit.    
Pokud vytvoříte kombinaci, která se již v programu používá, budete upozorněni chybovým zvukem a nebude přijata.    
Pokud je vaše nová kombinace platná, objeví se v záhlaví, můžete kliknout na tlačítko „Použít tuto kombinaci“ a bude se používat, dokud se nerozhodnete ji znovu změnit.    
* Nastavit jazyk Ctrl+Shift+L    
Když na této položce stisknete Enter, otevře se dialogové okno s některými jazyky, které bude povoleno, pokud je překlad dostupný v místní složce).    
Jazyk rozhraní si můžete vybrat výběrem z aktuálně dostupných jazyků zobrazených v tomto dialogu.    
Zobrazí se dialogové okno, které vás informuje, že jazyk byl změněn a že je třeba program restartovat, aby se tyto změny projevily.

# Nabídka Nápověda Podnabídka Alt+h

V této pátý a poslední nabídce budeme mít následující možnosti:    

* Informace o programu... F1    
Když na této položce stisknete Enter, otevře se dialogové okno, kde se zobrazí informace o programu v editačním dokumentu pouze pro čtení ve vašem příslušném jazyce, pokud je k dispozici.    
K procházení textu použijte klávesy se šipkami.    
Po dokončení stiskněte klávesu Tab a klepněte na tlačítko OK nebo stiskněte klávesu Enter nebo Escape, abyste toto dialogové okno zavřeli a vraťte se do hlavního okna programu.    
* Uživatelská příručka... Shift+F1    
Když na této položce stisknete Enter, otevře se okno s nápovědou k programu v editačním dokumentu HTML pouze pro čtení ve výchozím prohlížeči ve vašem příslušném jazyce, pokud je k dispozici, jinak se zobrazí upozornění.    
Stisknutím Alt+F4 jej zavřete.    
* Hlavní klávesové zkratky... F9    
Když na této položce stisknete Enter, otevře se dialogové okno, ve kterém se zobrazí klávesové zkratky programu v seznamu úprav pouze pro čtení, v seznamu se pohybujte pomocí kláves se šipkami.    
* Check for updates... Ctrl+Shift+U    
When you press Enter on this item, you will be notified if there are updates for the program, if so, follow the instructions on the screen.
Stiskněte Tab a klikněte na tlačítko Zavřít nebo stiskněte klávesu Escape nebo Enter pro zavření tohoto dialogového okna a návrat do hlavního okna programu.    

# 4. \ Další informace pro hlavní okno možnosti "Připomenutí pro vybraný den:" <a name="toc4"></a>
Když změníte datum, ve voliči hlavního okna, pokud se vybrané datum shoduje s připomínkou, zazní zvuk sonaru.    
Fokus se však může přesunout na seznam, pokud bylo dříve vybráno připomenutí.    
Chcete-li se této nepříjemnosti vyhnout, můžete před pokračováním zrušit zaškrtnutí upomínky nebo zadat datum přímo za den, měsíc, rok nebo měsíc, den, rok,v závislosti na nastavení jazyka systému (nikoli programu).    
Ve selektoru se můžete pohybovat pomocí vodorovných šipek.    
Pro uživatele programů pro čtení z obrazovky, jako je NVDA, je důležité poznamenat, že NVDA nezobrazuje aktuální pozici v selektoru. Doporučujeme stisknout svislou šipku: NVDA sdělí vámi nastavené datum a poskytne aktualizace, jakmile zadáte celý den, měsíc nebo rok.    
Zvuková signalizace řeší problém s nastavením data zahájení, místo předání fokusu na seznam upomínek, když na tom datu nějaká je, slyšíte zvuk, který vás varuje a můžete si s partnerem bez problémů hrát :)    

#5.\ Jak funguje adresář? <a name="toc5"></a>
Přístup k:    
`Podnabídka Upravit Alt + e`    
pak:    
`Adresář...F4`    
Když u této možnosti stisknete Enter, otevře se dialogové okno s názvem:    
"Adresář".    
Toto dialogové okno bude obsahovat seznam vašich kontaktů, pokud jste nějaký přidali, jinak bude tento seznam prázdný.    
Když v tomto dialogovém okně otevřete místní nabídku, stiskněte na většině klávesnic klávesu Aplikace umístěnou vedle pravé ovládací klávesy. Na klávesnici bez aplikační klávesy stiskněte Shift+f10.    
Všimněte si, že některé možnosti nejsou dostupné v seznamu kontaktů v závislosti na kontextu. Můžete stisknout Enter na požadované možnosti, takže zde jsou možnosti:    

* Přidat kontakt... Ctrl+N    
* Upravit kontakt... F2    
* Smazat kontakt...Del    
* Najít kontakt... Ctrl+F3    
Otevře se dialogové okno pro popsané možnosti nabídky, postupujte podle pokynů na obrazovce.    
* Najděte další F3    
* Najít předchozí Shift + F3     
Obě možnosti jsou založeny na jménu kontaktu zadaném v dialogovém okně "Najít kontakt", takže vyhledávání se provádí s další nebo předchozí shodou stejného jména nalezeného v seznamu adresáře.    
* Odeslat email kontaktu... Ctrl+e    
Otevře se dialogové okno pro tuto možnost, postupujte podle pokynů na obrazovce.    

Všimněte si, že můžete kontaktu odeslat e-mail, pokud byl e-mail kontaktu zadán do editačního pole odděleného mezerou na začátku (a v případě potřeby na konci), například při úpravě jména kontaktu. V opačném případě, pokud v tomto poli není žádný e-mail, nebude tato možnost k odeslání k dispozici.    
Pokud jste nenastavili výchozí e-mailový program, systém automaticky zobrazí dialogové okno, které vám umožní vybrat aplikaci, kterou chcete použít k odeslání e-mailu.    

#6.\ Jak otevřít program ze systémové lišty? <a name="toc6"></a>

* Otevřete systémovou lištu stisknutím Windows+b, šipkou dolů na ikonu „Připomenutí“ a otevřete kontextovou nabídku stisknutím klávesy aplikací umístěné vedle pravé ovládací klávesy na většině klávesnic. Na klávesnici bez aplikační klávesy stiskněte Shift+f10.* Klikněte pravým tlačítkem na ikonu "Připomenutí" umístěnou na systémové liště Windows.    

Když se zobrazí kontextová nabídka, můžete se v nabídce pohybovat pomocí kláves se šipkami a pomocí klávesy Enter aktivovat kteroukoli z položek uvedených níže.    

*/ Zobrazit připomenutí    
Stisknutím klávesy Enter na této možnosti zobrazíte program.    
* Zastavit aktuální oznámení    
Stisknutím klávesy Enter na této možnosti zastavíte aktuální oznámení.    
* Adresář...    
Stisknutím klávesy Enter na této možnosti se otevře dialogové okno "Adresář".    
* Připomenutí ukončení    
Stisknutím klávesy Enter na této možnosti ukončíte program.    

---

Děkujeme, že jste si přečetli tuto dokumentaci!    

Přeji vám dobré používání programu ReminderApp (Reminder) 😉    
Rád bych upřímně poděkoval [Pavel Partyka] (mailto:ppartyka@email.cz) přeložil tuto dokumentaci a aplikaci ReminderApp do češtiny.    
Rád bych upřímně poděkoval [Rémymu Ruizovi] (mailto:remyruiz@gmail.com) za napsání této dokumentace a překlad ReminderApp do francouzštiny, angličtiny, italštiny a španělštiny a za jeho zpětnou vazbu a návrhy.
